// defines for DPMI interrupt
#define DPMI_INT                0x31 // DPMI-Interrupt
#define DPMI_ALLOC_SELECTOR     0x00 // AX: allocate a selector
#define DPMI_FREE_SELECTOR      0x01 // AX: free selector
#define DPMI_SET_SELECTOR_BASE  0x07 // AX: set selector base
#define DPMI_SET_SELECTOR_LIMIT 0x08 // AX: set selector limit
#define DPMI_ALLOC_DOS_MEM      0x100  // Alloc DOS memory in first mb
#define DPMI_FREE_DOS_MEM       0x101  // Free DOS memory in first mb
#define DPMI_GET_VECT           0x204  // Get handler to int
#define DPMI_SET_VECT           0x205  // Set handler to int
#define DPMI_RM_PROC_RETF       0x301  // Call realmode procedure
#define DPMI_MAP_FIZ            0x0800 // BX:CX map adress
#define DPMI_FREE_MAP           0x0801 // Free map addres

typedef struct
{
    unsigned long edi;
    unsigned long esi;
    unsigned long ebp;
    unsigned long res;
    unsigned long ebx;
    unsigned long edx;
    unsigned long ecx;
    unsigned long eax;
    unsigned short flags;
    unsigned short es;
    unsigned short ds;
    unsigned short fs;
    unsigned short gs;
    unsigned short ip;
    unsigned short cs;
    unsigned short sp;
    unsigned short ss;
} __dpmi_regs;

typedef struct
{
  unsigned long  offset32;
  unsigned short selector;
} _dpmi_paddr;


extern int dpmi_map_physical(unsigned long physical_address, unsigned long limit, unsigned long *mapp_address);
extern int dpmi_free_map_physical(unsigned long physical_address);
extern int dpmi_dos_allc(unsigned short bufsize, unsigned short *selector, unsigned short *real_segm);
extern int dpmi_dos_free(unsigned short selector);
extern int dpmi_setvect(char irq,_dpmi_paddr *addr);
extern int dpmi_getvect(char irq,_dpmi_paddr *addr);
extern int dpmi_RM_proc_retf(__dpmi_regs *_regs);


