//          p  110

#include  "complex.h"
#include  "screen.h"

#define  N_AB_IN_BLK    7     // .    

typedef struct            // pp p  R110
  {
         word_s      acp [64];               // ᨢ 祭 
         word_s      dcp [8];                // ᨢ 祭 
         word_s      var [64];               // p.  1- ..
         word_s      set [64];               //  
         word_s      out [64];               // .室 
         word_s      dif [64];               // pᮣᮢ. 
         byte     mode[64];               // p 
         byte     dout[64];               // p.室 
} imR110;

rec_koeff st_kfR110[15] =
{
 { " =","%7.2f",  5, 36,-32767.0,32767.0, 89,14, 9 ,0.0},
 { " =","%7.2f",  6, 36,     0.0,32767.0, 89,14, 10,0.0},
 { " =","%7.2f",  7, 36,     0.0,32767.0, 89,14, 11,0.0},
 { " =","%7.2f",  8, 36,     0.0,32767.0, 89,14, 12,0.0},
 { "1 =","%7.2f",  9, 36, -2047.0, 2047.0, 89,14, 4 ,0.0},
 { "2 =","%7.2f", 10, 36, -2047.0, 2047.0, 89,14, 5 ,0.0},
 { "H3 =","%7.2f",  5, 50, -2047.0, 2047.0, 89,14, 6 ,0.0},
 { "2 =","%7.2f",  6, 50,-32767.0,32767.0, 89,14, 0 ,0.0},
 { "3 =","%7.2f",  7, 50,-32767.0,32767.0, 89,14, 1 ,0.0},
 { "4 =","%7.2f",  8, 50,-32767.0,32767.0, 89,14, 2 ,0.0},
 { "5 =","%7.2f",  9, 50,-32767.0,32767.0, 89,14, 3 ,0.0},
 { "4 =","%7.2f", 10, 50, -2047.0, 2047.0, 89,14, 7 ,0.0},
 { "5 =","%7.2f",  5, 64, -2047.0, 2047.0, 89,14, 8 ,0.0},
 { " =","%7.2f",  6, 64,     0.0,32767.0, 89,14, 13,0.0},
 { " =","%7.2f",  7, 64,     0.0,32767.0, 89,14, 14,0.0}
};

byte algorR110 [54][4] =
  {
       "   ", "", "", "", "", "   ", "", "", "", "   ",
       "   ", "", "", "", "", "", "", "", "", "",
       "", "", "", "", "", "", "", "", "", "",
       "", "", "", "", "", "   ", "   ", "   ", "   ", "   ",
       "", "", "", "", "", "", "", "", "", "",
       "", "", "", ""
  };

byte mas_mod[15] = { 16, 2, 1, 2, 1, 73, 1, 0, 6, 0, 16, 23, 16, 3, 0 };
byte mas_so[17] = { 16, 2, 1, 2, 1, 73, 1 };
byte mas_ans[64];

word_s form_ask_acp(byte *gracp, word_s ind, word_s num, byte *ask);
word_s form_ask_abl(byte *grabl, word_s ind, word_s num, byte *ask);
word_s form_ask_dcp(byte *grdcp, word_s num, byte *ask);
word_s form_acp(byte *ans, word_s num, imR110 *imr);
word_s form_abl(byte *ans, word_s num, imR110 *imr);
word_s form_dcp(byte *ans, word_s num, imR110 *imr);
word_s scanR110(controller *ptr_c,byte *masask,word_s lask,byte *answ,word_s mlansw);
word_s mode_R110(controller *p_c, analog *p_a, word_s mode);

extern word_s cur_kf[],pos_kf[],x_kf[],y_kf[];
extern char t_sc[],mas_cur_kf[][180], descr[];
extern void init_Serial(int tip_C, char len_b, char len_can);
extern void v24_sendask(sioptr port,byte *masask,word_s lask);
extern void kz_com(word_s kz, controller *pc);
extern float valtec(analog *pt, word_s cod);

extern word_s endrun;
char no_mem_taskr110[] = "TASKR110.C -  ";
//-------------------------------------------------------------------

void taskR110(controller *ptr_c)
{
  word_s i, n, val, begin, kz, *pi;
  analog *ptr_a;
  digit *ptr_d;
  byte gr_acp [8];                          //  p㯯  
  word_s n_acp1, n_acp2;
  byte gr_dcp [8];                          //  p㯯  
  word_s n_dcp;
  byte gr_abl [64];                         // ᨢ p .
  word_s n_blk_ab, n_abl;
  word_s lask;
  byte masask[64] = { 0x10, 0x02, 0x01, 0x02 };
  byte *answ;
  imR110 *R;

// ---   p p訢 , p㯯     ---

  for(i = 0; i < 8; i++) gr_acp[i] = 0x00;
  for(i = 0; i < 8; i++) gr_dcp[i] = 0x00;
  for(i = 0; i < 64; i++) gr_abl[i] = 0x00;

  for(i=0, ptr_a=ptr_c->a_ptr; i < ptr_c->num_ap; i++, ptr_a++) {
    if(ptr_a->mod_cod==M_INP) continue;
    if(ptr_a->nomin_var < 0x7f) {       // ᫨ 室  
      n = ptr_a->nomin_var/8 + 1;        // p p㯯 
      gr_acp[n-1] = n;                   //  ᨢ p㯯
    }

    if(ptr_a->type_mech == PULS && ptr_a->nomin_pos < 0x7f) {
      n = ptr_a->nomin_pos/8 + 1;        // p p㯯 
      gr_acp[n-1] = n;                   //  ᨢ p㯯
    }

    if(ptr_a->nom_ab < 0x7f)            // ᫨ .- ᨢ
      gr_abl[ptr_a->nom_ab] = (ptr_a->nom_ab/8+1)*16 + ptr_a->nom_ab%8+1;
  }

  for(i=0, ptr_d=ptr_c->d_ptr; i < ptr_c->num_dp; i++, ptr_d++) {

    if(ptr_d->nom_ab < 0x7f)            // ᫨   1
      gr_abl[ptr_d->nom_ab] = (ptr_d->nom_ab/8+1)*16 + ptr_d->nom_ab%8+1;
      if(ptr_d->nom_a2 < 0x7f)            // ᫨   2
       gr_abl[ptr_d->nom_a2] = (ptr_d->nom_a2/8+1)*16 + ptr_d->nom_a2%8+1;
      if(ptr_d->nom_a3 < 0x7f)            // ᫨   3
       gr_abl[ptr_d->nom_a3] = (ptr_d->nom_a3/8+1)*16 + ptr_d->nom_a3%8+1;

      if(ptr_d->nom_var != -1)
       gr_dcp[ptr_d->nom_var/16] = ptr_d->nom_var/16 + 1;  // .p. 
      if(ptr_d->nom_vr2 != -1)
       gr_dcp[ptr_d->nom_vr2/16] = ptr_d->nom_vr2/16 + 1;  // .p. 
      if(ptr_d->nom_vr3 != -1)
       gr_dcp[ptr_d->nom_vr3/16] = ptr_d->nom_vr3/16 + 1;  // .p. 
      if(ptr_d->nom_vr4 != -1)
       gr_dcp[ptr_d->nom_vr4/16] = ptr_d->nom_vr4/16 + 1;  // .p. 
  }

  n_acp1 = n_acp2 = 0;
  for(i=0; i < 8; i++) if(gr_acp[i] != 0) n_acp1++;
  if(n_acp1 > 4) { n_acp2 = n_acp1 - 4; n_acp1 = 4; }
  n_dcp = 0;
  for(i=0; i < 8; i++) if(gr_dcp[i] != 0) n_dcp++;
  n_blk_ab = n_abl = 0;
  for(i=0; i < 64; i++) if(gr_abl[i] != 0) n_abl++;
  n_blk_ab = n_abl/N_AB_IN_BLK; n_abl = n_abl%N_AB_IN_BLK;

  answ = (byte *)calloc(1,130);
  R = (imR110 *)calloc(1,sizeof(imR110));
  if(answ == NULL || R == NULL) {
    eprintf(RED_,no_mem_taskr110);
    return;
  }

  begin = 1;
//------------           p   110       -----------

  while(!endrun) {
    wait_flag_set(ptr_c->flag, 0L);
    clear_flag(ptr_c->flag);

    for(i=0, pi=(word_s *)R; i < sizeof(imR110)/2; i++, pi++) *pi = 0x7f7f;

// ---            p  p㯯       ---

    if(n_acp1) {
      n = form_ask_acp(gr_acp, 0, n_acp1, masask);
      lask = n_acp1 * 8 + 7;
      kz = scanR110(ptr_c,masask,lask,answ,128);
      if(!kz) if(kz = form_acp(answ,n_acp1,R)) kz_com(kz,ptr_c);
    }

    if(n_acp2) {
      form_ask_acp(gr_acp, n, n_acp2, masask);
      lask = n_acp2 * 8 + 7;
      kz = scanR110(ptr_c,masask,lask,answ,128);
      if(!kz) if(kz = form_acp(answ,n_acp2,R)) kz_com(kz,ptr_c);
    }

// -------       p  p㯯        ------

    if(n_dcp) {
      lask = form_ask_dcp(gr_dcp, n_dcp, masask);
      kz = scanR110(ptr_c,masask,lask,answ,128);
      if(!kz) if(kz = form_dcp(answ,n_dcp,R)) kz_com(kz,ptr_c);
    }

// --------       p      -----------

    n = 0;
    if(n_blk_ab) {
      lask = N_AB_IN_BLK * 6 + 7;
      for(i=0; i < n_blk_ab; i++) {
       n = form_ask_abl(gr_abl, n, N_AB_IN_BLK, masask);
       kz = scanR110(ptr_c,masask,lask,answ,128);
       if(!kz) if(kz = form_abl(answ,N_AB_IN_BLK,R)) kz_com(kz,ptr_c);
      }
    }

    if(n_abl) {
      form_ask_abl(gr_abl, n, n_abl, masask);
      lask = n_abl * 6 + 7;
      kz = scanR110(ptr_c,masask,lask,answ,128);
      if(!kz) if(kz = form_abl(answ,n_abl,R)) kz_com(kz,ptr_c);
    }

// ---                               ----

    for(i=0, ptr_a=ptr_c->a_ptr; i < ptr_c->num_ap; i++, ptr_a++) {
      if(ptr_a->mod_cod==M_INP) continue;
      if(ptr_a->nolog) continue;    // ᫨ . p p.

      if(ptr_a->nomin_var < 0x7f) {              // ᫨ 室  
       if(R->acp[ptr_a->nomin_var]==0x7f7f) { ptr_a->novalid=1;  continue; }
       else { ptr_a->novalid=0; val=R->acp[ptr_a->nomin_var]*K_R110; }
      }
      else if(ptr_a->nom_ab < 0x7f) {            // ᫨ .
       if(ptr_a->type_mech) {                   // ᫨ ॣ㫨㥬
         if(R->var[ptr_a->nom_ab] == 0x7f7f) { ptr_a->novalid=1;  continue; }
         else { ptr_a->novalid=0; val=R->var[ptr_a->nom_ab]*K_R110; }
       }
       else {                        // ᫨ ⮩  . 
         if(R->out[ptr_a->nom_ab] == 0x7f7f) { ptr_a->novalid=1;  continue; }
         else { ptr_a->novalid=0; val=R->out[ptr_a->nom_ab]*K_R110; }
       }
      }
      else continue;                // ᫨  .  p.p.

      if(val < -(ADC_SC>>3)) ptr_a->novalid=1;
      if(val < 0) val=0; else if(val > ADC_SC) val=ADC_SC;
      if(ptr_a->var_cod == val && !begin) ptr_a->dif_var = 0;
      else {
       ptr_a->dif_var = 1;
       ptr_a->var_cod = val;
       ptr_a->var_tech = valtec(ptr_a,ptr_a->var_cod);
       if(ptr_a->min_reg && val < ptr_a->min_reg) ptr_a->bound_reg = 1;
       else if(ptr_a->max_reg && val > ptr_a->max_reg) ptr_a->bound_reg = 2;
       else ptr_a->bound_reg = 0;
       if(ptr_a->min_al && val < ptr_a->min_al) ptr_a->bound_al = 1;
       else if(ptr_a->max_al && val > ptr_a->max_al) ptr_a->bound_al = 2;
       else ptr_a->bound_al = 0;
      }

//    if(ptr_a->var_cod < ADC_SC/100 || ptr_a->var_cod > ADC_SC-ADC_SC/100) ptr_a->novalid=1;

      if(ptr_a->type_mech && ptr_a->nom_ab < 0x7f) {

       if(ptr_a->set_din) ptr_a->set_din = 0;
       else {
         val = R->set[ptr_a->nom_ab]*K_R110;
         if(ptr_a->set_cod == val && !begin) ptr_a->dif_set = 0;
         else {
           ptr_a->dif_set = 1;
           if(val >= 0 && val <= ADC_SC) ptr_a->set_cod = val;
         }
       }

       if(ptr_a->out_din) ptr_a->out_din = 0;
       else {
         val = R->out[ptr_a->nom_ab]*K_R110;
         if(ptr_a->out_cod == val && !begin) ptr_a->dif_out = 0;
         else {
           ptr_a->dif_out = 1;
           if(val >= 0 && val <= ADC_SC) ptr_a->out_cod = val;
         }
       }

       val = R->dif[ptr_a->nom_ab]*K_R110;
       if(ptr_a->dif_cod == val && !begin) ptr_a->dif_dif = 0;
       else { ptr_a->dif_dif = 1;  ptr_a->dif_cod = val; }

       if(ptr_a->mod_din) ptr_a->mod_din = 0;
       else {
         if(R->mode[ptr_a->nom_ab] == 0) val = R_MAN;
         else if(R->mode[ptr_a->nom_ab] == 1) val = R_PULT;
         else if(R->mode[ptr_a->nom_ab] == 2) val = R_CAS;
         else if(R->mode[ptr_a->nom_ab] == 3) val = R_AUTO;
         if(ptr_a->mod_cod == val && !begin) ptr_a->dif_mod = 0;
         else { ptr_a->dif_mod = 1; ptr_a->mod_cod = val; }
       }

       if(ptr_a->type_mech == PULS) {

         val = R->acp[ptr_a->nomin_pos]*K_R110;
         if(ptr_a->pos_cod == val && !begin) ptr_a->dif_pos = 0;
         else {
           ptr_a->dif_pos = 1;
           if(val >= 0 && val <= ADC_SC) ptr_a->pos_cod = val;
         }
       }
      }
    }

    for(i=0, ptr_d=ptr_c->d_ptr; i < ptr_c->num_dp; i++, ptr_d++) {

      if(ptr_d->nolog) continue;

      if(ptr_d->nom_var !=-1) {                  // ᫨ 室  
       if(R->dcp[ptr_d->nom_var/16]==0x7f7f) { ptr_d->novalid=1; continue; }
       ptr_d->novalid = 0;
       val = (R->dcp[ptr_d->nom_var/16]  >> ptr_d->nom_var%16) & 1;
       if(ptr_d->val_par == val && !begin) ptr_d->dif_par = 0;
       else { ptr_d->dif_par = 1;  ptr_d->val_par = val; }
#if (COUNT)
       if(ptr_d->reg_tim) {
         if(ptr_d->val_par) ptr_d->count_tim+=ptr_c->period;
         else ptr_d->count_stop+=ptr_c->period;
       }
#endif
      }
      if(ptr_d->nom_vr2 !=-1) {                  // ᫨ 室  
       if(R->dcp[ptr_d->nom_vr2/16]==0x7f7f) { ptr_d->novalid=1; continue; }
       ptr_d->novalid = 0;
       val = (R->dcp[ptr_d->nom_vr2/16]  >> ptr_d->nom_vr2%16) & 1;
       if(ptr_d->val_pr2 == val && !begin) ptr_d->dif_pr2 = 0;
       else { ptr_d->dif_pr2 = 1;  ptr_d->val_pr2 = val; }
      }
      if(ptr_d->nom_vr3 !=-1) {                  // ᫨ 室  
       if(R->dcp[ptr_d->nom_vr3/16]==0x7f7f) { ptr_d->novalid=1; continue; }
       ptr_d->novalid = 0;
       val = (R->dcp[ptr_d->nom_vr3/16]  >> ptr_d->nom_vr3%16) & 1;
       if(ptr_d->val_pr3 == val && !begin) ptr_d->dif_pr3 = 0;
       else { ptr_d->dif_pr3 = 1;  ptr_d->val_pr3 = val; }
      }
      if(ptr_d->nom_vr4 !=-1) {                  // ᫨ 室  
       if(R->dcp[ptr_d->nom_vr4/16]==0x7f7f) { ptr_d->novalid=1; continue; }
       ptr_d->novalid = 0;
       val = (R->dcp[ptr_d->nom_vr4/16]  >> ptr_d->nom_vr4%16) & 1;
       if(ptr_d->val_pr4 == val && !begin) ptr_d->dif_pr4 = 0;
       else { ptr_d->dif_pr4 = 1;  ptr_d->val_pr4 = val; }
      }

#if (PROTOC)
      if(ptr_d->archive) {
       if(ptr_d->dif_par) {
         val=ptr_d->val_par;
         val<<=6; val |=ptr_c->nom_ord; val<<=9; val |=i; val |=0x1000;
         if(!begin) c_write_wpipe(event_chn, val);
       }
       if(ptr_d->dif_pr2) {
         val=ptr_d->val_pr2;
         val<<=6; val |=ptr_c->nom_ord; val<<=9; val |=i; val |=0x2000;
         if(!begin) c_write_wpipe(event_chn, val);
       }
       if(ptr_d->dif_pr3) {
         val=ptr_d->val_pr3;
         val<<=6; val |=ptr_c->nom_ord; val<<=9; val |=i; val |=0x3000;
         if(!begin) c_write_wpipe(event_chn, val);
       }
       if(ptr_d->dif_pr4) {
         val=ptr_d->val_pr4;
         val<<=6; val |=ptr_c->nom_ord; val<<=9; val |=i; val |=0x4000;
         if(!begin) c_write_wpipe(event_chn, val);
       }
      }
#endif

      if(ptr_d->nom_ab < 0x7f) {
       if(R->dout[ptr_d->nom_ab]==0x7f) { ptr_d->novalid=1; continue; }
       ptr_d->novalid = 0;
       val = (R->dout[ptr_d->nom_ab] >> ptr_d->nom_dout) & 1;
       if(ptr_d->val_out == val && !begin) ptr_d->dif_out = 0;
       else  { ptr_d->dif_out = 1;  ptr_d->val_out = val; }
      }
      if(ptr_d->nom_a2 < 0x7f) {
       if(R->dout[ptr_d->nom_a2]==0x7f) { ptr_d->novalid=1; continue; }
       ptr_d->novalid = 0;
       val = (R->dout[ptr_d->nom_a2] >> ptr_d->nom_dot2) & 1;
       if(ptr_d->val_ot2 == val && !begin) ptr_d->dif_ot2 = 0;
       else  { ptr_d->dif_ot2 = 1;  ptr_d->val_ot2 = val; }
      }
      if(ptr_d->nom_a3 < 0x7f) {
       if(R->dout[ptr_d->nom_a3]==0x7f) { ptr_d->novalid=1; continue; }
       ptr_d->novalid = 0;
       val = (R->dout[ptr_d->nom_a3] >> ptr_d->nom_dot3) & 1;
       if(ptr_d->val_ot3 == val && !begin) ptr_d->dif_ot3 = 0;
       else  { ptr_d->dif_ot3 = 1;  ptr_d->val_ot3 = val; }
      }
    }
    if(!kz) begin = 0;
  }
}
//-----------------------------------------------------------------

word_s scanR110(controller *ptr_c,byte *masask,word_s lask,byte *answ,word_s mlansw)
{
  word_s rept, c0, c1, ci;
  word_s i, kz, staff, KS;
  funcptr send;
  fptr receive;

  if(ptr_c->nomport < 0x80) { send = ad8_send;    receive = ad8_receive; }
  else                      { send = v24_sendask; receive = v24_receive; }

  while(request_resource(ptr_c->port_rsc,0L));     // 墠 p-p

  rept=2;
  BEGIN:
       rept--;
       ptr_c->port->flags=0;
       send(ptr_c->port, masask, (byte)lask);       // p
       //t_delay(8L);                               //  㤠 !

       c0 = 256;
  ASK0:
       if((kz = --c0)==-1) goto END;
       answ[0] = (kz = receive(ptr_c->port, 24L)); if(kz == -1) goto END;
       if(kz != 0x10) goto ASK0;

       c1 = 256;
  ASK1:
       if((kz = --c1)==-1) goto END;
       answ[1] = (kz = receive(ptr_c->port, 2L));  if(kz == -1)  goto  END;
       if(kz == 0x10) { answ[0] = kz; goto ASK1; }
       if(kz != 0x02) goto ASK0;
       KS = 0x12;  staff = 1; i = 2;

       ci = 256;
  ASKI:
       if((kz = --ci)==-1) goto END;
       answ[i] = (kz = receive(ptr_c->port, 2L));  if(kz == -1)  goto  END;
       KS += kz;  if(KS > 255) KS -= 255;
       if(answ[i-1]==0x10 && answ[i]==0x10 && staff) { staff = 0; goto ASKI; }
       staff = 1;
       if(++i >= mlansw) { kz=-1; goto END;}
       if(answ[i-4] != 0x10 || answ[i-3] != 0x17 ||
          answ[i-2] != 0x10 || answ[i-1] != 0x03) goto ASKI;

  ASKN:
       answ[i++] = (kz = receive(ptr_c->port, 2L));  if(kz == -1)  goto  END;
       if(KS != kz) goto ASKI;
       if(answ[4]==0x50) goto BEGIN;  //  砫 ᮮ.
       if(answ[5]==0x50) {       // .    .  
         kz=answ[6];
         if(kz || masask[5]==0x49) goto FIN;  // ᫨ kz  
         kz=-1; goto END;   //   . .  
       }
       if(masask[6] != answ[6] || masask[7] != answ[7]) kz=-1;
       else kz = 0;
  END:
       if(ptr_c->port->flags) kz=-1;
       if(kz && rept) goto BEGIN;
  FIN:
       release_resource(ptr_c->port_rsc);       // ᢮.p-pp
       ptr_c->kz=kz;
       return kz;
}
//-------------------------------------------------------------------

word_s form_ask_acp(byte *gracp, word_s ind, word_s num, byte *ask)
{
  word_s i, j, n, KS;

  for(n=ind, i=0; i < num; n++, i++) {
    while(gracp[n] == 0) n++;
    j = i*8+4;
    ask[j++]=i+1;      ask[j++]=0x4e; ask[j++]=0xf0;  ask[j++]=0x04;
    ask[j++]=gracp[n]; ask[j++]=0xff; ask[j++]=0x10; ask[j++]=0x17;
  }
  j = i*8+4;
  ask[j++] = 0x10;
  ask[j++] = 0x03;

  KS=0;
  for(i=0; i < j; i++) { KS += ask[i]; if(KS > 255) KS -= 255; }
  ask[j] = KS;

  return n;
}
//--------------------------------------------------------------------

word_s form_ask_abl(byte *grabl, word_s ind, word_s num, byte *ask)
{
  word_s i, j, n, KS;

  for(n=ind, i=0; i < num; n++, i++) {
    while(grabl[n] == 0) n++;
    j = i*6+4;
    ask[j++]=i+1; ask[j++]=0x4e; ask[j++]=grabl[n]; ask[j++]=0x09;
    ask[j++]=0x10; ask[j++]=0x17;
  }
  j = i*6+4;
  ask[j++] = 0x10;
  ask[j++] = 0x03;

  KS=0;
  for(i=0; i < j; i++) { KS += ask[i]; if(KS > 255) KS -= 255; }
  ask[j] = KS;

  return n;
}
//--------------------------------------------------------------------

word_s form_ask_dcp(byte *grdcp, word_s num, byte *ask)
{
  word_s i, j, n, KS;

  for(n=0, i=0; i < num; n++, i++) {
    while(grdcp[n] == 0) n++;
    j = i*7+4;
    ask[j++]=i+1;        ask[j++]=0x4e; ask[j++]=0xf0;  ask[j++]=0x05;
    if(grdcp[n]==2) ask[j]=5;      // p  訡 
    else ask[j]=grdcp[n];
    j++;
    ask[j++]=0x10; ask[j++]=0x17;
  }
  j = i*7+4;
  ask[j++] = 0x10;
  ask[j++] = 0x03;

  KS=0;                                  // ⮢ KS 
  for(i=0; i < j; i++) { KS += ask[i]; if(KS > 255) KS -= 255; }
  ask[j++] = KS;

  return j;
}
//-------------------------------------------------------------------

word_s form_acp(byte *ans, word_s num, imR110 *imr)
{
  word_s i, j, k, m, *pi;

  for(i=0; i < num; i++) {
    m = i*24+4;
    k = ans[m+4]-1;
    if(ans[m+1] == 0x50) return ans[m+2];
    if(ans[m+1] == 0x52 && k >= 0 && k < 8)
    for(j=0, k*=8, pi=(word_s *)(ans+m+6); j<8; j++, k++, pi++)
    if(*pi >= 0) imr->acp[k] = *pi & 0x07ff;
    else         imr->acp[k] = *pi | 0xf800;
  }
  return 0;
}
//-------------------------------------------------------------------

word_s form_abl(byte *ans, word_s num, imR110 *imr)
{
  word_s i, k, m, *pi;

  for(i=0; i < num; i++) {
    m = i*15+4;
    k = (ans[m+2]/16-1)*8 + ans[m+2]%16-1;
    if(ans[m+1] == 0x50) return ans[m+2];
    if(ans[m+1] == 0x52 && k >= 0 && k < 64) {

      pi=(word_s *)(ans+m+4);  if(*pi >= 0) imr->var[k] = *pi & 0x07ff;
                           else         imr->var[k] = *pi | 0xf800;
      pi++;                 if(*pi >= 0) imr->set[k] = *pi & 0x07ff;
                           else         imr->set[k] = *pi | 0xf800;
      pi++;                 if(*pi >= 0) imr->out[k] = *pi & 0x07ff;
                           else         imr->out[k] = *pi | 0xf800;
      pi++;                 if(*pi >= 0) imr->dif[k] = *pi & 0x07ff;
                           else         imr->dif[k] = *pi | 0xf800;

      imr->mode[k] = (ans[m+12] & 0xc0) >> 6;
      imr->dout[k] = (ans[m+9] & 0x60) >> 5;
    }
  }
  return 0;
}
//-------------------------------------------------------------------

word_s form_dcp(byte *ans, word_s num, imR110 *imr)
{
  word_s i, k, m;

  for(i=0; i < num; i++) {
    m = i*9+4;
    if(ans[m+1] == 0x50) return ans[m+2];
    if(ans[m+1] == 0x52) {
      if(ans[m+4]==5) ans[m+4]=2;       // p  訡 
      k = ans[m+4]-1;
      if(k >= 0 && k < 8) imr->dcp[k] = *(word_s *)(ans+m+5);
    }
  }
  return 0;
}
//--------------- 뤠 ᮮ饭  訡  -----------------
word_s kz_mesage_R110(controller *pc,word_s kz,word_s chn,word_s kz_old)
{
 word_s n_ch;
 char *ps;

 if(pc->nomport < 0x80) n_ch=((pc->basaddr&0x0f)/2)+1;   // 8
 else n_ch=pc->nomcontr;                                 //COM

 if(n_ch!=chn || kz_old!= kz)
 {
  switch(kz)
  {
   case   -1 :
   case  255 : ps = "      ";  break;
   case 0x26 :
   case    5 : ps = " ..";  break;
   case   10 : ps = " . .";  break;
   case    7 : ps = "  ";  break;
   case 0x12 : ps = ". .";  break;
   case 0x13 : ps = ". ";  break;
   case 0xfe : ps = "  ";  break;
   case 0x40 : ps = ". ";  break;
   case 0x20 : ps = "  ";  break;
   default   : ps = "     ";
  }
  fgtext(RED_,280,337,"pp %d, .%1X: %s",pc->nomcontr,n_ch,ps);
 }
 return(n_ch);
}

//--------- 祭 ⮢ ॣ  ஫ ---
int get_kfR110(word_s nscr,void **koef)
{
 int i,n;
 n=sizeof(st_kfR110)/sizeof(rec_koeff);
 for(i=0; i < n; i++)
  if(p_a[nscr]->nomin_var>=0) st_kfR110[i].znach = 0.;
  else st_kfR110[i].znach = 0.;
 *koef=st_kfR110;
 return(n);
}
//------------------ ⠭ ⮢ ॣ --------------
void set_kfR110(controller *p_c, analog *p_a, word_s nom_kf, float valk)
{
}
//*******************  ࠦ ॣ ****************************
void stat_koefR110(word_s nscr)
{
 int i;

 _settextcolor(CYAN_);
 gprintf(4,46,"");
 for(i=0; i < sizeof(st_kfR110)/sizeof(rec_koeff); i++) gprintf(st_kfR110[i].str,st_kfR110[i].col-4,st_kfR110[i].nam);
 cur_kf[nscr] = 0;
 pos_kf[nscr] = 0;

 if(p_a[nscr]->type_sc==SC_SQRT) t_sc[nscr] = ''; else t_sc[nscr] = '';
 _settextcolor(CYAN_);
// gprintf(4,2," %1x.%1x  p %s",
//     p_a[nscr]->nom_ab/8+1,p_a[nscr]->nom_ab%8+1,algorR110[al_n[nscr]]);
 _settextcolor(WHITE_);
 gprintf(6,2," %d   %d",
     p_c[nscr]->nomcontr,(p_c[nscr]->basaddr&0x1f)/2+1);
 gprintf(8,2,"   %c%8.1f %8.1f",t_sc[nscr],p_a[nscr]->min_sc,p_a[nscr]->max_sc);
 gprintf(9,2,"p %8.1f %8.1f",
     valtec(p_a[nscr],p_a[nscr]->min_reg)+0.049,valtec(p_a[nscr],p_a[nscr]->max_reg)+0.049);
 gprintf(10,2,"p %8.1f %8.1f",
     valtec(p_a[nscr],p_a[nscr]->min_al)+0.049,valtec(p_a[nscr],p_a[nscr]->max_al)+0.049);
 _setcolor(WHITE_);
 li(0,Y0-LSC-20,565,Y0-LSC-20);
}
//--------------------- 砫 ⠭ --------------------------
void enable_R110(void)
{
 init_Serial(R110,8,256);
}
//--------------------- 몫祭 ஫ ----------------------
void disable_R110(void)
{

}
//-----------------------------------------------------------------
void insert_A_R110(analog * a_ptr,char *Basa)
{
}
//-------------------------------------------------------------------
void insert_D_R110(digit * d_ptr,char *Basa)
{

}
//----------- ⥫쭠  ---------------------------------
void ext_help_R110(byte tip,word_s nscr)
{
 gprintf(HELP_L,9,"-K%d",(p_c[nscr]->basaddr & 0x1f)/2+1);
 if(p_a[nscr]->nomin_var < 0x7f)        // ᫨ 室  
 gprintf(HELP_L,60," %1x.%1x",p_a[nscr]->nomin_var/8+1,p_a[nscr]->nomin_var%8+1);
 if(p_a[nscr]->nom_ab < 0x7f)           // ᫨  
 gprintf(HELP_L,67," %1x.%1x",p_a[nscr]->nom_ab/8+1,p_a[nscr]->nom_ab%8+1);
 if(p_a[nscr]->nomin_pos < 0x7f)        // ᫨  
 gprintf(HELP_L,74," %1x.%1x",p_a[nscr]->nomin_pos/8+1,p_a[nscr]->nomin_pos%8+1);
}

//-------------------------------------------------------------------
int so_R110(controller *p_c, analog *p_a, word_s cur_so)
{
  int i, j, KS, kz;

  mas_so[7] = (p_a->nom_ab/8+1)*16+p_a->nom_ab%8+1;
  j = 9;
  switch(cur_so)
  {
   case CUR_S : mas_so[8] = 3; i=p_a->set_cod; break;
   case CUR_O : mas_so[8] = 5; i=p_a->out_cod; break;
  }

  if(i) i++;
  i=i/K_R110; mas_so[j++]=i;
  if(mas_so[9]==16) mas_so[j++]=16;
  mas_so[j++] = i >> 8;

  mas_so[j++] = 16; mas_so[j++] = 23; mas_so[j++] = 16; mas_so[j++] = 3;

  KS=0;
  for(i=0; i<j; i++)  { KS += mas_so[i];  if(KS > 255) KS -= 255; }
  mas_so[j++] = KS;

  if(cur_so==CUR_S && p_a->mod_cod==MAN) mode_R110(p_c,p_a,R_AUTO);
  kz = scanR110(p_c,mas_so,j,mas_ans,sizeof(mas_ans));
  if(cur_so==CUR_S && p_a->mod_cod==MAN) mode_R110(p_c,p_a,R_MAN);

  if(!kz && mas_ans[6]) { kz = mas_ans[6]; kz_com(kz, p_c); }
  return kz;
}

/*-------------------------------------------------------------------*/

word_s mode_R110(controller *p_c, analog *p_a, word_s mode)
{
  word_s i, KS, kz;

  mas_mod[7] = (p_a->nom_ab/8+1)*16+p_a->nom_ab%8+1;
  switch(mode)
  {
   case R_MAN    : mas_mod[9] = 0;  break;
   case R_AUTO   : mas_mod[9] = 3;  break;
   case R_CAS    : mas_mod[9] = 2;  break;
  }

  KS=0;
  for(i=0; i<14; i++) { KS += mas_mod[i]; if(KS > 255) KS -= 255; }
  mas_mod[14] = KS;

  kz = scanR110(p_c,mas_mod,15,mas_ans,sizeof(mas_ans));
  p_a->mod_din = 1;
  if(!kz && mas_ans[6]) { kz = mas_ans[6]; kz_com(kz, p_c); }
  return kz;
}
/*-------------------------------------------------------------------*/
