;
;       TCtask - Keyboard handler module.
;
;       V1.1    T.Wagner
;       V1.2    TECON Ltd.
;
;       This module traps the keyboard interrupts to allow task switching
;       on waiting for a character.
;       All characters are put into a (word)pipe, and can either be
;       read directly from the pipe, or through the normal INT 16 channels.
;
        name    tckbd
;        .model  large
;
        public  _key_avail
        public  tsk_install_kbd_
        public  tsk_remove_kbd_
;
        public  t_read_key_
        public  t_wait_key_
        public  t_keyhit_
;
        include tsk.mac
;
BUFSIZE =       2       ; max. number of chars in pipe

hwd=09h
kbd=16h
;----------------------------------------------------------------------------
;
;       Variables
;
        IF      TSK_NAMEPAR
        .data
kbd_name        db      "KBDBUF",0
        ENDIF
;
        .data
;
_key_avail      wpipe <>
;
buffer          db      BUFSIZE dup(?)
;
;        .code
;
kbd_flag        db      0
;
;       Original Interrupt-Entries
;
savhwd          label   dword           ; original hardware int entry
savhwdoff       dd      ?
savhwdseg       dw      ?
;
savkbd          label   dword           ; original keyboard I/O entry
savkbdoff       dd      ?
savkbdseg       dw      ?
;
;
;---------------------------------------------------------------------------
;
;        .code
;
        extrn   create_wpipe_:near
        extrn   delete_wpipe_:near
        extrn   read_wpipe_:near
        extrn   check_wpipe_:near
        extrn   c_write_wpipe_:near
;        extrn   _test:near
;
        .code

;
;       void tsk_install_kbd (void)
;
;               Install keyboard handler
;
tsk_install_kbd_        proc
;
        IF      TSK_NAMEPAR
        mov     ecx,offset kbd_name
        ENDIF
        xor     ebx,ebx
        mov     bx,BUFSIZE
        mov     edx,offset buffer
        mov     eax,offset _key_avail
        call    create_wpipe_

        mov     bl,kbd
        mov     ax,204h                  ;⥭  뢠 16 = es:ebx
        int     31h
        mov     savkbdoff,edx
        mov     savkbdseg,cx

        mov     bl,hwd
        mov     ax,204h                  ;⥭  뢠 9 = es:ebx
        int     31h
        mov     savhwdoff,edx
        mov     savhwdseg,cx
;
;       Enter new Interrupt-Entries
;
        cli
        mov     bl,kbd
        mov     ax,205h                  ;⠭  16  DS:EDX
        mov     edx,offset kbdentry
        mov     cx,cs
        int     31h

        mov     bl,hwd
        mov     ax,205h                  ;⠭  9  DS:EDX
        mov     edx,offset hwdentry
        mov     cx,cs
        int     31h

        sti
        ret
;
;        assume  es:nothing
;
tsk_install_kbd_        endp
;
;
;       void tsk_remove_kbd (void)
;
;               Un-install keyboard handler
;
tsk_remove_kbd_ proc
;
;       Delete pipe
;
        mov     eax,offset _key_avail
        call    delete_wpipe_
;
        cli

        mov     bl,kbd
        mov     ax,205h                  ;⠭  8  DS:EDX
        mov     edx, savkbdoff
        mov     cx, savkbdseg
        int     31h

        mov     bl,hwd
        mov     ax,205h                  ;⠭  8  DS:EDX
        mov     edx, savhwdoff
        mov     cx, savhwdseg
        int     31h

        sti
;
        ret
;
tsk_remove_kbd_ endp
;
;
;---------------------------------------------------------------------------
;
;       int t_read_key (void)
;
;       Waits for key from keyboard. Returns char in lower byte,
;       Scan-Code in upper byte.
;
t_read_key_     proc
;
        push    edx
        xor     edx,edx           ; no timeout
        mov     eax,offset _key_avail
        call    read_wpipe_
        pop     edx
        ret
;
t_read_key_     endp
;
;
;       int t_wait_key (dword timeout)
;
;       Waits for key from keyboard. Returns char in lower byte,
;       Scan-Code in upper byte.
;
t_wait_key_     proc
;
        mov     edx,eax                 ; timeout
        mov     eax,offset _key_avail
        call    read_wpipe_
        ret
;
t_wait_key_     endp
;
;
;       int t_keyhit (void)
;
;       Checks if char is available. Returns -1 if not, else the
;       character value. The character remains in the buffer.
;
t_keyhit_       proc
;
        mov     eax,offset _key_avail
        call    check_wpipe_
        ret
;
t_keyhit_       endp
;
;---------------------------------------------------------------------------
;
;       INT 9 - Keyboard hardware interrupt
;
hwdentry        proc
;
        push    eax
        pushfd
        call    fword ptr cs:[savhwd]       ; process key
        cli
;
        mov     ah,1
        pushfd
        call    fword ptr cs:[savkbd]       ; check if char available
        cli
        jz      hwd_ret                     ; return if not
;
        xor     ah,ah
        pushfd
        call    fword ptr cs:[savkbd]       ; get the key
        cli
;
        push    ds
        push    edx
        mov     edx,eax

        mov     ax,seg _key_avail
        mov     ds,ax

        mov     eax,offset _key_avail
        call    c_write_wpipe_
        pop     edx
        pop     ds
;
hwd_ret:
        pop     eax
        iretd
;
hwdentry        endp
;
;---------------------------------------------------------------------------
;
;       INT 16 - Keyboard I/O
;
kbdentry        proc
;

;        iretd

        push    ds
        push    eax
        mov     ax,seg _key_avail
        mov     ds,ax
        mov     eax,0b8C80h
        mov     word ptr ds:[eax],1234h
        pop     eax
        pop     ds

        cmp     ah,2
        jb      kbd_funcs
        jmp     fword ptr cs:savkbd        ; pass on functions >= 2
;
kbd_funcs:
;
        push    ds
        push    ebx
        mov     bx, seg _key_avail
        mov     ds,bx

        cmp     ah,1
        jb      kbd_read
;
        mov     eax,offset _key_avail
        call    check_wpipe_
        cli
        cmp     ax,0ffffh
        jne     kbd_gotone
        xor     ax,ax
kbd_gotone:
        pop     ebx
        pop     ds
        retf    4
;
kbd_read:
        push    edx
        xor     edx,edx
        mov     eax,offset _key_avail
        call    read_wpipe_
        pop     edx
        pop     ebx
        pop     ds
        iretd
;
kbdentry        endp
;
        end

