#include "model.h"
#include "complex.h"
#include "screen.h"

void (_interrupt _far *old_int24)();
void _interrupt _far new_int24( unsigned _es, unsigned _ds,
                                                                unsigned _di, unsigned _si,
                                                                unsigned _bp, unsigned _sp,
                                                                unsigned _bx, unsigned _dx,
                                                                unsigned _cx, unsigned _ax,
                                                                unsigned _ip, unsigned _cs,
                                                                unsigned flags );

void set_new_int24(void);
void set_old_int24(void);

word_s fl_err_d = 0;


void set_new_int24(void)
{
        old_int24 = _dos_getvect(0x24);
        _dos_setvect(0x24,new_int24);
}
/*-------------------------------------------------------------------*/

void set_old_int24(void)
{
        _dos_setvect(0x24,old_int24);
}
/*----------------------------------------------------------------*/

void _interrupt _far new_int24( unsigned _es, unsigned _ds,
                                unsigned _di, unsigned _si,
                                unsigned _bp, unsigned _sp,
                                unsigned _bx, unsigned _dx,
                                unsigned _cx, unsigned _ax,
                                unsigned _ip, unsigned _cs,
                                unsigned flags )
{
  char *dev;

  _asm {
       push ax
       mov  ax,_si
       add  ax,0ah
       mov  word ptr dev,ax
       mov  ax,_bp
       mov  word ptr dev+2,ax
       pop ax
  }

  if(*dev=='N') dev="";
  else if(_ax & 0x8000) dev="PRN";
  else {
        dev="A: ";
        *dev = 'A' + (_ax & 0x000f);
  }
  eprintf(RED_,"訡 p⢠ %s %04x",dev,_ax);
  fl_err_d++;
  _ax=3;
  tsk_sti();
}
/*------------------------------------------------------------------*/
