#include  "complex.h"
#include  "screen.h"

//    prn_as(func,symb,lpt_port);
//extern byte prn_as(byte,byte,word_s);
//#pragma aux prn_as  = "int  17h "\
//                      parm [ah] [al] [dx] \
//                      value [ah]          ;

void copy_scr(void);           /* ஢ ࠭ 0  ࠭ 1 */
#pragma aux copy_scr = "mov  ax,0105h           "\
                       "mov  dx,3ceh            "\
                       "out  dx,ax              "\
                       "mov  edi,0a8000h        "\
                       "mov  esi,0a0000h        "\
                       "mov  ecx,28000          "\
               "cont:   mov  al,[esi]           "\
                       "mov  byte ptr [edi],0ffh"\
                       "inc  edi                "\
                       "inc  esi                "\
                       "loop short cont         "\
                       "mov  ax,0005h           "\
                       "out  dx,ax              "\
                        modify [ax dx edi esi ecx]  ;

#if (PRINTER == 1)             /* ᫨ 梥⭮ */
word_s getpix(word_s x,word_s y);
#pragma aux getpix = "mov  bh,1     "\
                     "mov  ah,0dh   "\
                     "int  10h      "\
                     "xor  ah,ah    "\
                      modify [ax bx] \
                      parm [cx] [dx] \
                      value [ax]          ;
#endif

byte ror_as(byte);
#pragma aux ror_as = "ror al,1"    \
                      parm [al]    \
                      value [al]   ;

word ror_as1(word);
#pragma aux ror_as1 = "ror ax,1"   \
                      parm [ax]    \
                      value [ax]   ;

word_s prt_byte(byte c);
word_s inst_printer();
word_s take_printer(long tpr);
void   printer(word_s *p_lpt);
void PRINT_SCREEN(void);
void prnt_scr(void);

extern word_s PRI_OFF;
extern word_s c_fonT;

word_s LPT = 1;                 /* 1 = LPT1, 2 = LPT2 */
word_s port_status_LPT;         /*   ਭ */
resourceptr prt_res;         /* 㪠.  pp  */
pipeptr prt_chn;             /* 㪠⥫    */
tcbptr prt_task;             /* 㪠.    */
word_s fl_prt = 0;              /* p  뤠   */
word_s flag_print_screen = 0;   /* ਧ  ன ࠭ ࠭ */
word_s fon_screen = 0;          /* 祭 梥 䮭 ࠭ */
tcbptr task_print_screen;    /* 㪠⥫    ࠭ */
word_s screen_copy;             /*  ࠭,  */
/*-------------------------------------------------------------------*/

word_s prt_byte(byte c)
{
  while(fl_prt && c_write_pipe(prt_chn,c))
  {
   while(check_pipe(prt_chn)!=-1) t_delay(3L);
  }
  if(fl_prt)  return 0;  else return 1;
}
/*-------------------------------------------------------------------*/

word_s inst_printer()
{
  if(LPT==1) port_status_LPT=0x379; else port_status_LPT=0x279;
  fl_prt = 0;
  prt_res = create_resource(NULL,"PRT_RES");
  prt_chn = create_pipe(NULL, NULL, 1536, "PRT");  /*   */
  prt_task = create_task(NULL,(funcptr)printer,NULL,1500,PRI_STD-PRI_OFF,&LPT,"PR");

  if(prt_chn==NULL || prt_task==NULL || prt_res==NULL) {
        eprintf(RED_,"PRINTER.C -  ");
        return 1;
  }

//  *(word_s *)0x00000478=(word_s)0x0101;          /* ⠩ ਭ */
  start_task(prt_task);                    /*    */
  return 0;
}
/*-------------------------------------------------------------------*/

word_s take_printer(long tpr)
{
  word_s kz;

  kz=tsk_inp(port_status_LPT);                         /*  ਭ */
  if((kz&0x78)==0x78 || !(kz&0x10)) kz = 1;  /* ᫨ ⪫.  몫. */
  else kz = request_resource(prt_res, tpr);  /*  墠 ਭ */
  if(!kz) fl_prt=1;
  return kz;
}
/*-------------------------------------------------------------------*/

void free_printer()
{
  release_resource(prt_res);
}
/*-------------------------------------------------------------------*/

void   printer(word_s *p_lpt)
{
  word lpt,i;
  byte stat,c;

  if(*p_lpt==1) lpt=0x378; else lpt=0x278;

READ_CHN:
  if(endrun) {
        if(flag_print_screen) {
          kill_task(task_print_screen);
         _bios_printer(1,lpt,0);
        }
        return;
  }

  c=read_pipe(prt_chn,0L);
  if(!fl_prt) goto READ_CHN;   /* ᫨ 襭 䫠 ࠧ. */
  i=0x30;
  tsk_outp(lpt,c);       pause(10);

OUT_CHR:
  stat=tsk_inp(lpt+1);   pause(10);
  if(!(stat & 0x80)) {if (i--) {schedule(); goto OUT_CHR;} goto err; }

  tsk_outp(lpt+2,0x0D);  pause(10);
  tsk_outp(lpt+2,0x0C);  pause(10);

  goto READ_CHN;

err:;
  if(1)
  {    /* ᫨  ⮢   . */
    eprintf(WHITE_BR_,"%X",stat);
//    eprintf(15,"   ");
    t_delay(3*HZ);
    eprintf(BLACK_,"");
    goto OUT_CHR;
  }

  fl_prt=0;                       /* ᫨ 몫祭   祭 */
  goto READ_CHN;
}
/*-------------------------------------------------------------------*/

void prnt_scr(void)             /*    ࠭ */
{
  if(flag_print_screen) {
    eprintf(YELLOW_,"  :  ");
    return;
  }

  screen_copy=screen;
  copy_scr();
  fon_screen = c_fonT;
  task_print_screen = create_task(NULL,(funcptr)PRINT_SCREEN,NULL,1500,PRI_STD-PRI_OFF+1,NULL,"PRNTSCR");
  start_task(task_print_screen);
}
/*-------------------------------------------------------------------*/

void PRINT_SCREEN(void)        /* a  ࠭ */
{
#if (PRINTER == 2)             /* ᫨ 梥⭮ */
  word_s i,j,k,n,mbit;
  char cl,wc,ic,px,mask,uscl,ms;
  char *pv,*pp,*bm,*p0,*p1,*p2,*p3,*pc,*ps;
  unsigned char ox,om;
  word w0,w1;
  word_s *pb;

  if(take_printer(0L)) return;
  flag_print_screen = 1;

  pv=(char *)0xa8000L;          /*  ன ࠭ */
  pb=(word_s *)calloc(350*2,2);      /* .ନ.  ਭ */
  pp=(char *)calloc(350,8);       /* .ନ.梥⮢ 8- 祪  */
  bm=(char *)calloc(350,4);       /* . .  4- .. */

  prt_byte(27); prt_byte('r'); prt_byte(4);
  for(i=0; i<12; i++) prt_byte('\n');

  ms=8;
  ox=om=0xff;

  for(i=0; i<80 && fl_prt; i++,pv++) {   /*  .8-⮢  */

    if(screen!=screen_copy)set_screen(screen_copy);

    ps=bm;
    for(ic=0; ic<4; ic++)
    {                     /*  ⮢ ᪮ */
     outpw(0x3CE,(ic<<8)|4);
     for(j=0,pc=pv; j<350; j++,pc+=80) *ps++ = *pc;     /*  ப */
    }

    if(screen!=screen_copy) set_screen(screen);

        uscl=0;
        mask=0x01;
        pc=pp;
        for(k=0; k<8; k++) {                         /*  8 ⠬  */
        mask=ror_as(mask);
//          _asm ror mask,1
          p0=bm;  p1=p0+350;  p2=p1+350;  p3=p2+350;
          for(j=0; j<350; j++) {                      /*  ப */
                px=0;
                if(*p0++ & mask) px |= 1;               /*  ⮢ ᪮ */
                if(*p1++ & mask) px |= 2;
                if(*p2++ & mask) px |= 4;
                if(*p3++ & mask) px |= 8;
                if(px==fon_screen) px=0;
                if(px != ox) {
                  ox=px;
                  switch(px) {                 /* ᮮ. 梥⮢  .  ਭ. */
                        case  0 : cl=0x00; break;
                        case  2 :
                        case 10 : cl=0x0c; break;
                        case 15 : cl=0x01; break;
                        case  4 :
                        case  6 :
                        case 12 : cl=0x0a; break;
                        case 14 : cl=0x08; break;
                        case  7 :
                        case  8 : cl=0x21; break;
                        case  5 :
                        case 13 : cl=0x02; break;
                        case  3 :
                        case 11 : cl=0x04; break;
                        case  1 :
                        case  9 : cl=0x06; break;
                  }
                  uscl |= cl;                     /*  ᯮ.梥⮢ */
                }
                *pc++ = cl;
          }
        }

        prt_byte(27); prt_byte(43); prt_byte(0);   /* '\n'=0 */
        for(ic=0; ic<4; ic++) {                    /*   梥⠬ ਭ. */
          if(uscl & ms) {                        /* ᫨ 梥 ms    */
                for(j=0,n=0,pc=pp; j<350; j++,pc++) {    /*  ப */
                  w0=w1=0;
                  mbit=0x0003;
                  for(k=0,ps=pc; k<8; k++,ps+=350) {     /*  ⠬  */
                  mbit=ror_as1(mbit);
                  mbit=ror_as1(mbit);
//                        _asm {  ror mbit,1
//                                        ror mbit,1
//                                 }
                        wc=*ps;
                        if(wc&ms) {           /* ᫨  梥 窨 wc  梥 ms */
                          w0 |= mbit;
                          if(!(wc&0x20)) w1 |= mbit;    /* ᫨ 梥  "" */
                        }
                  }
                  if(ms==1) {
                        if(j==0 || j==349) w0=w1=0xffff;
                        else if(i==0) { w0 |= 0xc000; w1 |= 0xc000; }
                        else if(i==79) { w0 |= 0x0003; w1 |= 0x0003; }
                  }
                  pb[n++]=w0;
                  pb[n++]=w1;
                }

                if(ms != om) {
                  om=ms;
                  prt_byte(27); prt_byte('r'); prt_byte((byte)(ms>>1)); /* .梥 */
                }

                for(j=0; j<12; j++) prt_byte(' ');
                prt_byte(27); prt_byte('*'); prt_byte(33);    /* . . */
                prt_byte((byte)188);  prt_byte(2);

                for(j=1399,pc=(byte *)pb+1399; j>=0; j--,j--) {
                  prt_byte(*pc--);
                  prt_byte(*pc--);
                  prt_byte(0);
                }
                prt_byte('\n');
          }
          if(ic < 3) switch(ms) {
                                   case 8: ms=2; break;
                                   case 2: ms=4; break;
                                   case 4: ms=1; break;
                                   case 1: ms=8;
                                 }
        }
        prt_byte(27); prt_byte(43); prt_byte(32);
        prt_byte('\n');
  }

  if(!fl_prt) eprintf(YELLOW_,"    ");

  prt_byte(27); prt_byte('@');
  prt_byte(12);
  fon_screen = 0;
  flag_print_screen = 0;
  free(bm);
  free(pp);
  free(pb);
  free_printer();
//}
#endif
#if (PRINTER == 1)
//{
  word_s a,i,s,l,c,k;
  unsigned char column[4],bit[4];
  char instr[]={27,'*',3,120,5};  /*350 祪  4=1400->1400/256=5  120*/
  char inst[] ={27,'A',8};

  if(take_printer(0L)) return;
  flag_print_screen = 1;

  for(i=0;i<2;i++)  prt_byte('\n');           /* 4 */
  for(i=0;i<3;i++)  prt_byte(inst[i]);

  for(k=0,i=0;i<80;i++) {
        for(l=0; l<12; l++) prt_byte(' ');
        for(l=0;l<5;l++) prt_byte(instr[l]);
        for(c=0;c<=349;c++) {
          column[0]=column[1]=column[2]=column[3]=0;

          if(screen!=screen_copy) set_screen(screen_copy);

          for(s=0;s<8;s++) {
                a=getpix(k+s,349-c);  if(a==fon_screen) a=0;
                bit[0] = (a)? 1 : 0;
                switch(a) {
                  case 1:  case 9: case 4: case 12:
                                  bit[1]=bit[2]=bit[3]=1; break;    /*-ᨭ  */
                  case 2:  case 10: case 8: case 0:
                                  bit[1]=bit[2]=bit[3]=0; break;    /*-  */
                  case 3:  case 11:
                                  bit[1]=bit[3]=1; bit[2]=0; break; /*-  */
                  case 5:  case 13: case 7: case 15:
                                  bit[1]=0; bit[2]=bit[3]=1; break; /*-       */
                  case 6:  case 14:
                                  bit[1]=1; bit[2]=bit[3]=0; break; /*-       */
                }
                column[0]=(column[0]<<1)+bit[0];
                column[1]=(column[1]<<1)+bit[1];
                column[2]=(column[2]<<1)+bit[2];
                column[3]=(column[3]<<1)+bit[3];
          }

          if(screen!=screen_copy) set_screen(screen);

          prt_byte(column[0]); prt_byte(column[1]);
          prt_byte(column[2]); prt_byte(column[3]);
        }
        a=prt_byte('\n'); k+=8;
        if(a) break;
  }

  if(!fl_prt) eprintf(YELLOW_,"    ");

  prt_byte((char)27); prt_byte('@');
  prt_byte(12);
  free_printer();
  fon_screen = 0;
  flag_print_screen = 0;

#endif
}


/*-------------------------------------------------------------------*/

