
#include  "complex.h"
#include  "defkey.h"
#include  "screen.h"

int mode_R110(controller *p_c, analog *p_a, int mode);
int so_R110(controller *p_c, analog *p_a, int cur_so);
int set_kf_R110(controller *p_c, byte nom_ab, byte com, int kf);
int read_koeff_R110(controller *p_c, analog *p_a,
                                       float *t0, int *al, int *koeffs);

extern int scanR110(controller *ptr_c,byte *masask,int lask,
                                     byte *answ,int mlansw);
extern void far kz_com(int kz, controller *pc);

byte mas_mod[15] = { 16, 2, 1, 2, 1, 73, 1, 0, 6, 0, 16, 23, 16, 3, 0 };
byte mas_so[17] = { 16, 2, 1, 2, 1, 73, 1 };
byte mas_sw[17] = { 16, 2, 1, 2, 1, 73, 1, 0, 2, 0, 0, 0, 16, 23, 16, 3, 0 };
byte mas_set_k[19] = { 16, 2, 1, 2, 1, 73, 1, 0, 2 };
byte mas_kf[27] = { 16, 2, 1, 2, 1, 78, 240, 2, 16, 23,
                   2, 78, 0, 2, 255, 16, 23,
                   3, 78, 0, 1, 9, 16, 23, 16, 3, 0 };
byte mas_ans[64];
/*-------------------------------------------------------------------*/

int mode_R110(controller *p_c, analog *p_a, int mode)
{
  int i, KS, kz;

  mas_mod[7] = (p_a->nom_ab/8+1)*16+p_a->nom_ab%8+1;

  switch(mode) {
       case MAN    : mas_mod[9] = 0;  break;
       case AUTO   : mas_mod[9] = 3;  break;
       case CAS    : mas_mod[9] = 2;  break;
  }

  KS=0;
  for(i=0; i<14; i++) { KS += mas_mod[i]; if(KS > 255) KS -= 255; }
  mas_mod[14] = KS;

  kz = scanR110(p_c,mas_mod,15,mas_ans,sizeof(mas_ans));
  p_a->mod_din = 1;
  if(!kz && mas_ans[6]) { kz = mas_ans[6]; kz_com(kz, p_c); }
  return kz;
}
/*-------------------------------------------------------------------*/

int so_R110(controller *p_c, analog *p_a, int cur_so)
{
  int i, j, KS, kz;

  mas_so[7] = (p_a->nom_ab/8+1)*16+p_a->nom_ab%8+1;
  j = 9;

  switch(cur_so) {

       case CUR_S : mas_so[8] = 3;
                    i=p_a->set_cod;
                    break;

       case CUR_O : mas_so[8] = 5;
                    i=p_a->out_cod;
                    break;
  }

  if(i) i++;
  i=i/K_R110;
  mas_so[j++]=i; if(mas_so[9]==16) mas_so[j++]=16;
  mas_so[j++] = i >> 8;

  mas_so[j++] = 16; mas_so[j++] = 23; mas_so[j++] = 16; mas_so[j++] = 3;

  KS=0;
  for(i=0; i<j; i++)  { KS += mas_so[i];  if(KS > 255) KS -= 255; }
  mas_so[j++] = KS;

  if(cur_so==CUR_S && p_a->mod_cod==MAN) mode_R110(p_c,p_a,AUTO);
  kz = scanR110(p_c,mas_so,j,mas_ans,sizeof(mas_ans));
  if(cur_so==CUR_S && p_a->mod_cod==MAN) mode_R110(p_c,p_a,MAN);

  if(!kz && mas_ans[6]) { kz = mas_ans[6]; kz_com(kz, p_c); }
  return kz;
}
/*-------------------------------------------------------------------*/

int read_koeff_R110(controller *p_c, analog *p_a, float *t0, int *al, int *koeffs)
{
  int i, KS, kz;

  mas_kf[12] = mas_kf[19] = (p_a->nom_ab/8+1)*16+p_a->nom_ab%8+1;

  KS=0;
  for(i=0; i<26; i++) { KS += mas_kf[i]; if(KS > 255) KS -= 255; }
  mas_kf[26] = KS;

  kz = scanR110(p_c,mas_kf,27,mas_ans,sizeof(mas_ans));

  if(mas_ans[5]==0x50) kz = mas_ans[6];
  else if(mas_ans[13]==0x50) kz = mas_ans[14];
  else if(mas_ans[50]==0x50) kz = mas_ans[51];
  if(!kz && mas_ans[5]==0x52 && mas_ans[13]==0x52 && mas_ans[50]==0x52) {
       *t0 = (float)60/(0.25*(1 << mas_ans[8]));
       for(i=0; i < 15; i++) koeffs[i] = *(int *)(mas_ans+17+i*2);
       *al = (int)mas_ans[54];
  }
  else {
       for(i=0; i < 15; i++) koeffs[i] = -32768;
       *al = 0;
       kz = -1;
  }
  return kz;
}
/*-------------------------------------------------------------------*/

int set_kf_R110(controller *p_c, byte nom_ab, byte com, int kf)
{
  int i, j, KS, kz;

  mas_set_k[7] = (nom_ab/8+1)*16+nom_ab%8+1;
  mas_set_k[9] = com;
  j = 10;

  mas_set_k[j++] = kf; if(mas_set_k[10]==16) mas_set_k[j++]=16;
  mas_set_k[j++] = kf >> 8;

  mas_set_k[j++]=16; mas_set_k[j++]=23; mas_set_k[j++]=16; mas_set_k[j++]=3;

  KS=0;
  for(i=0; i<j; i++)  { KS += mas_set_k[i];  if(KS > 255) KS -= 255; }
  mas_set_k[j++] = KS;

  kz = scanR110(p_c,mas_set_k,j,mas_ans,sizeof(mas_ans));

  if(!kz && mas_ans[6]) { kz = mas_ans[6]; kz_com(kz, p_c); }
  return kz;
}
/*-------------------------------------------------------------------*/
word_s switch_d_R110(controller *contr, digit *dig,byte stat,byte dop)
{
 byte algb;
 word_s kf;

 if (dop==0)algb=dig->nom_ab;
 if (dop==1)algb=dig->nom_a2;
 if (dop==2)algb=dig->nom_a3;

 if(stat)
 {
  if (dop==0) if(dig->nom_dout) kf=4096;  else kf=-4096;
  if (dop==1) if(dig->nom_dot2) kf=4096;  else kf=-4096;
  if (dop==2) if(dig->nom_dot3) kf=4096;  else kf=-4096;
 }
 else kf=0;                            /* CL */

 return(set_kf_R110(contr, algb, 3, kf));
}
