/*--------------------------------------------------------------------
    Copyright (C) Siemens AG 1995  All Rights Reserved.
----------------------------------------------------------------------
 version: @(#1)SAPI_S7.H    V 1.00

 This header file contains all defines, typedefinitions and prototypings
 for using the S7 library of Siemens AG. It is the only file that must
 be included in all source files of user applications that use S7
 calls.

 For standard calling convention use define S732STD_DLL.
---------------------------------------------------------------------*/

#ifndef SAPI_S7_H
#define SAPI_S7_H

/*-------------------------------------------------------------------
  returncodes for S7 calls
---------------------------------------------------------------------*/

/***  Important messages  ***/
#define  S7_OK                                0
#define  S7_ERR_RETRY                      (-1)
#define  S7_ERR                            (-2)

#define  S7_NO_MSG                            0
#define  S7_UNKNOWN_MSG                       1

/*-------------------------------------------------------------------
  IEC errors
---------------------------------------------------------------------*/

#define  S7_ERR_IEC_NO                        0
#define  S7_ERR_IEC_LOWER_LAYER               1
#define  S7_ERR_IEC_NEG_RESPONSE              2
#define  S7_ERR_IEC_INVALID_REF               3
#define  S7_ERR_IEC_DATA_TYPE_MISMATCH        4
#define  S7_ERR_IEC_RESET_RECEIVED            5
#define  S7_ERR_IEC_RECEIVER_DISABLED         6
#define  S7_ERR_IEC_PARTNER_WRONG_STATE       7
#define  S7_ERR_IEC_NO_ACCESS_TO_REM_OBJ      8
#define  S7_ERR_IEC_RECEIVER_OVERRUN          9

/*-------------------------------------------------------------------
  detailed errors
---------------------------------------------------------------------*/

/***  general errors  ***/
#define  S7_ERR_NO_ERROR                      0
#define  S7_ERR_UNKNOWN_ERROR                 1
#define  S7_ERR_WRONG_CP_DESCR                2
#define  S7_ERR_NO_RESOURCE                   3
#define  S7_ERR_INVALID_PARAMETER             7
#define  S7_ERR_TOO_LONG_DATA                 8
#define  S7_ERR_TOO_MANY_DLL_USERS            9

/***  invalid service  ***/
#define  S7_ERR_WRONG_IND_CNF                10
#define  S7_ERR_SERVICE_NOT_SUPPORTED        11

/***  invalid communication reference (cref) or connection name  ***/
#define  S7_ERR_INVALID_CREF                 20
#define  S7_ERR_CONN_NAME_NOT_FOUND          23

/***  invalid order_id  ***/
#define  S7_ERR_INVALID_ORDERID              30
#define  S7_ERR_ORDERID_USED                 31

/***  invalid object  ***/
#define  S7_ERR_OBJ_UNDEFINED                50
#define  S7_ERR_OBJ_ATTR_INCONSISTENT        51
#define  S7_ERR_OBJ_ACCESS_DENIED            53

/***  invalid data transfer  ***/
#define  S7_ERR_INVALID_DATA_SIZE            80
#define  S7_ERR_RECEIVE_BUFFER_FULL          81

/***  controller or CMI or FW problems  ***/
#define  S7_ERR_FW_ERROR                     90

/***  s7_mini_db_set() / s7_mini_db_get() errors  ***/
#define  S7_ERR_MINI_DB_TYPE                 100
#define  S7_ERR_MINI_DB_VALUE                101

/***  multi user errors  ***/
#define  S7_ERR_SERVICE_VFD_ALREADY_USED     112
#define  S7_ERR_SERVICE_CONN_ALREADY_USD     113

/***  connection handling  ***/
#define  S7_ERR_CONN_ABORTED                 120
#define  S7_ERR_INVALID_CONN_STATE           121
#define  S7_ERR_MAX_REQ                      122
#define  S7_ERR_CONN_CNF                     123

/***  state of cyclic read  ***/
#define  S7_ERR_INVALID_CYCL_READ_STATE      130

/***  SINEC problems  ***/
#define  S7_ERR_INSTALL                      140
#define  S7_ERR_INTERNAL_ERROR               141
#define  S7_ERR_NO_SIN_SERV                  142
#define  S7_ERR_NO_LICENCE                   143

/***  symbolic address problems  ***/
#define  S7_ERR_SYMB_ADDRESS                 150
#define  S7_ERR_SYMB_ADDRESS_INCONSIST       151

/*-------------------------------------------------------------------
  defines for s7_mini_db_set, s7_mini_db_get
---------------------------------------------------------------------*/

/***  for trace target (type and values)  ***/
#define  S7_MINI_DB_TRACE_TARGET          0         /* type  */
#define  S7_TRACE_TARGET_BUFFER           "0"       /* value */
#define  S7_TRACE_TARGET_NEW_FILE         "1"       /* value */
#define  S7_TRACE_TARGET_OLD_FILE         "2"       /* value */
#define  S7_TRACE_TARGET_CONSOLE          "3"       /* value */

/***  for trace select (type and values)  ***/
#define  S7_MINI_DB_TRACE_SELECT            1       /* type  */
#define  S7_TRACE_SELECT_ADMIN_SERVICES     "1"     /* value */
#define  S7_TRACE_SELECT_CONN_SERVICES      "2"     /* value */
#define  S7_TRACE_SELECT_CRL_SERVICES       "4"     /* value */
#define  S7_TRACE_SELECT_OD_SERVICES        "8"     /* value */
#define  S7_TRACE_SELECT_VAR_SERVICES       "16"    /* value */
#define  S7_TRACE_SELECT_VFD_SERVICES       "32"    /* value */
#define  S7_TRACE_SELECT_DE2_SERVICES       "64"    /* value */
#define  S7_TRACE_SELECT_CYCL_VAR_SERV      "128"   /* value */
#define  S7_TRACE_SELECT_RECEIVE_SERV       "256"   /* value */
#define  S7_TRACE_SELECT_OTHER_SERVICES     "512"   /* value */
#define  S7_TRACE_SELECT_ALL                "65535" /* value */

/***  for trace depth (type and values)  ***/
#define  S7_MINI_DB_TRACE_DEPTH           2         /* type  */
#define  S7_TRACE_DEPTH_OFF               "0"       /* value */
#define  S7_TRACE_DEPTH_USER              "1"       /* range "1" to "99"  */
#define  S7_TRACE_DEPTH_EXCEPT            "100"     /* value */
#define  S7_TRACE_DEPTH_INTERFACE         "101"     /* value */
#define  S7_TRACE_DEPTH_OTHER             "102"     /* value */
#define  S7_TRACE_DEPTH_LIB0              "103"     /* val for intern.use */
#define  S7_TRACE_DEPTH_LIB0_PDU          "104"     /* val for intern.use */

/***  for trace filename (type only)  ***/
#define  S7_MINI_DB_TRACE_FILENAME        3         /* type  */

/***  for number of trace lines (type only)  ***/
#define  S7_MINI_DB_TRACE_NO_LINES        4         /* type  */

/***  for initiate request (type only)  ***/
#define  S7_MINI_DB_INIT_REQ_AMQ_CALLING    10    /* only set value */
#define  S7_MINI_DB_INIT_REQ_AMQ_CALLED     11    /* only set value */
#define  S7_MINI_DB_INIT_REQ_PDU_SIZE       12    /* only set value */

/***  for initiate response (type only)  ***/
#define  S7_MINI_DB_INIT_RSP_AMQ_CALLING    20    /* only set value */
#define  S7_MINI_DB_INIT_RSP_AMQ_CALLED     21    /* only set value */
#define  S7_MINI_DB_INIT_RSP_PDU_SIZE       22    /* only set value */

/***  for initiate indication (type only)  ***/
#define  S7_MINI_DB_INIT_IND_AMQ_CALLING    50    /* only get value */
#define  S7_MINI_DB_INIT_IND_AMQ_CALLED     51    /* only get value */
#define  S7_MINI_DB_INIT_IND_PDU_SIZE       52    /* only get value */

/***  for initiate confirmation (type only)  ***/
#define  S7_MINI_DB_INIT_CNF_AMQ_CALLING    30    /* only get value */
#define  S7_MINI_DB_INIT_CNF_AMQ_CALLED     31    /* only get value */
#define  S7_MINI_DB_INIT_CNF_PDU_SIZE       32    /* only get value */

/***  for any message  ***/
#define  S7_MINI_DB_RESPONSE_CODE           40    /* only get value */
#define  S7_MINI_DB_ERROR_CLASS             41    /* only get value */
#define  S7_MINI_DB_ERROR_CODE              42    /* only get value */

/***  for connection establishment  ***/
#define  S7_MINI_DB_NEGOTIATION_OPTIONS     60    /* only set value */
#define  S7_MINI_DB_PERSISTANCE_COUNT       61    /* only set value */
#define  S7_MINI_DB_ABORT_TIMEOUT           62    /* only set value */

/***  for reading library version (type only)  ***/
#define  S7_MINI_DB_VERSION                 70    /* only get value */

/*-------------------------------------------------------------------
  general defines
---------------------------------------------------------------------*/

/***  max. length of names  ***/
#define  S7_MAX_NAMLEN                    32
#define  S7_MAX_DEVICELEN                128

/***  max. length of address  ***/
#define  S7_MAX_ADDRESSLEN                32

/***  max. length of buffer  ***/
#define  S7_MAX_BUFLEN                    256

/***  defines for access  ***/
#define  S7_ACCESS_NAME                   1
#define  S7_ACCESS_SYMB_ADDRESS           2
#define  S7_ACCESS_ADDRESS                3

/***  defines for storage_mode  ***/
#define  S7_MEMORY                        0
#define  S7_FILE                          1

/***  defines for logical states  ***/
#define  S7_STATE_CHANGES_ALLOWED         0

/***  defines for physical states  ***/
#define  S7_OPERATIONAL                   0x10
#define  S7_NEEDS_COMMISSIONING           0x13

/***  defines for initiate_rsp  ***/
#define  S7_ACCEPT                        1
#define  S7_NON_ACCEPT                    0

/***  defines for result  ***/
#define  S7_RESULT_OK                     0x00ff
#define  S7_RESULT_HW_ERROR               0x0001
#define  S7_RESULT_OBJ_ACCESS_DENIED      0x0003
#define  S7_RESULT_OBJ_ADDRESS_INVALID    0x0005
#define  S7_RESULT_OBJ_TYPE_NOT_SUPPORT   0x0006
#define  S7_RESULT_OBJ_TYPE_INCONSISTENT  0x0007
#define  S7_RESULT_OBJ_NOT_EXISTS         0x000a

/*-------------------------------------------------------------------
  defines for services
---------------------------------------------------------------------*/

/***  initiate, abort  ***/
#define  S7_INITIATE_CNF                  0x0101
#define  S7_INITIATE_IND                  0x0102
#define  S7_ABORT_IND                     0x0103
#define  S7_AWAIT_INITIATE_CNF            0x0104

/***  VFD  ***/
#define  S7_VFD_STATE_CNF                 0x0201
#define  S7_VFD_USTATE_IND                0x0202

/***  variables  ***/
#define  S7_READ_CNF                      0x0301
#define  S7_WRITE_CNF                     0x0302
#define  S7_MULTIPLE_READ_CNF             0x0303
#define  S7_MULTIPLE_WRITE_CNF            0x0304

/***  cyclic variables  ***/
#define  S7_CYCL_READ_ABORT_IND           0x0401
#define  S7_CYCL_READ_DELETE_CNF          0x0402
#define  S7_CYCL_READ_IND                 0x0403
#define  S7_CYCL_READ_INIT_CNF            0x0404
#define  S7_CYCL_READ_START_CNF           0x0405
#define  S7_CYCL_READ_STOP_CNF            0x0406

/*-------------------------------------------------------------------
  typedefinitions
---------------------------------------------------------------------

 The following typedefinitions are necessary for using S7 library.
 Including other header files in user applications using the same
 typedefinitions results in compiler errors or warnings. To avoid
 these warnings or errors the basic typedefinitions of the S7
 library can be switched off.
---------------------------------------------------------------------*/

#ifndef S7_BASIC_TYPES

/***  basic types  ***/
typedef char int8;                  /* signed char                 */
typedef unsigned char ord8;         /* unsigned char               */
typedef short int int16;            /* signed short integer        */
typedef unsigned short int ord16;   /* unsigned short integer      */
typedef long int32;                 /* signed long integer         */
typedef unsigned long ord32;        /* unsigned long integer       */

#endif

struct S7_READ_PARA
{
   ord16 access;
   char  var_name[S7_MAX_NAMLEN+2];
   ord16 index;
   ord16 subindex;
   ord16 address_len;
   ord8  address[S7_MAX_ADDRESSLEN];
};
typedef  struct S7_READ_PARA  ST_RD;

struct S7_WRITE_PARA
{
   ord16 access;
   char  var_name[S7_MAX_NAMLEN+2];
   ord16 index;
   ord16 subindex;
   ord16 address_len;
   ord8  address[S7_MAX_ADDRESSLEN];
   ord16 var_length;
   ord8  value[S7_MAX_BUFLEN];
};
typedef  struct S7_WRITE_PARA  ST_WR;

/*-------------------------------------------------------------------
  Prototypings for S7 calls
---------------------------------------------------------------------*/

/***  define for using DLL (only for Windows 3.xx)  ***/
#ifdef S732STD_DLL
#define S7_FAR_PASCAL    _stdcall
#define S7_FAR_DATA
#else
#ifdef S7_DLL
#define S7_FAR_PASCAL    far pascal
#define S7_FAR_DATA      far
#else
#define S7_FAR_PASCAL
#define S7_FAR_DATA
#endif
#endif

#ifdef __cplusplus
extern "C"
{
#endif

int32 S7_FAR_PASCAL s7_abort(ord32 cp_descr,ord16 cref);
int32 S7_FAR_PASCAL s7_await_initiate_req(ord32 cp_descr,ord16 cref);
int32 S7_FAR_PASCAL s7_cycl_read(ord32 cp_descr,ord16 cref,ord16 orderid,
                           ord16 cycl_time,ord16 number,
                           struct S7_READ_PARA S7_FAR_DATA *read_para_array);
int32 S7_FAR_PASCAL s7_cycl_read_delete_req(ord32 cp_descr,ord16 cref,
                           ord16 orderid);
int32 S7_FAR_PASCAL s7_cycl_read_init_req(ord32 cp_descr,ord16 cref,
                           ord16 orderid,ord16 cycl_time,ord16 number,
                           struct S7_READ_PARA S7_FAR_DATA *read_para_array);
int32 S7_FAR_PASCAL s7_cycl_read_start_req(ord32 cp_descr,ord16 cref,
                           ord16 orderid);
int32 S7_FAR_PASCAL s7_cycl_read_stop_req(ord32 cp_descr,ord16 cref,
                           ord16 orderid);
void  S7_FAR_PASCAL s7_discard_msg(void);
int32 S7_FAR_PASCAL s7_get_abort_ind(void);
int32 S7_FAR_PASCAL s7_get_await_initiate_cnf(void);
int32 S7_FAR_PASCAL s7_get_conn(ord32 cp_descr,ord16 index,
                           ord16 S7_FAR_DATA *number_ptr,
                           ord16 S7_FAR_DATA *cref_ptr,
                           char S7_FAR_DATA *conn_name);
int32 S7_FAR_PASCAL s7_get_cref(ord32 cp_descr,
                           char S7_FAR_DATA *conn_name,
                           ord16 S7_FAR_DATA *cref_ptr);
int32 S7_FAR_PASCAL s7_get_cycl_read_abort_ind(void);
int32 S7_FAR_PASCAL s7_get_cycl_read_delete_cnf(void);
int32 S7_FAR_PASCAL s7_get_cycl_read_ind(void S7_FAR_DATA *od_ptr,
                           ord16 S7_FAR_DATA *result_array,
                           ord16 S7_FAR_DATA *var_length_array,
                           void S7_FAR_DATA *value_array);
int32 S7_FAR_PASCAL s7_get_cycl_read_init_cnf(void);
int32 S7_FAR_PASCAL s7_get_cycl_read_start_cnf(void);
int32 S7_FAR_PASCAL s7_get_cycl_read_stop_cnf(void);
int32 S7_FAR_PASCAL s7_get_device(ord16 index,ord16 S7_FAR_DATA *number_ptr,
                           char S7_FAR_DATA *dev_name);
int32 S7_FAR_PASCAL s7_get_initiate_cnf(void);
int32 S7_FAR_PASCAL s7_get_initiate_ind(void);
int32 S7_FAR_PASCAL s7_get_multiple_read_cnf(void S7_FAR_DATA *od_ptr,
                           ord16 S7_FAR_DATA *result_array,
                           ord16 S7_FAR_DATA *var_length_array,
                           void S7_FAR_DATA *value_array);
int32 S7_FAR_PASCAL s7_get_multiple_write_cnf(
                           ord16 S7_FAR_DATA *result_array);
int32 S7_FAR_PASCAL s7_get_read_cnf(void S7_FAR_DATA *od_ptr,
                           ord16 S7_FAR_DATA *var_length_ptr,
                           void S7_FAR_DATA *value_ptr);
int32 S7_FAR_PASCAL s7_get_vfd(char S7_FAR_DATA *dev_name,ord16 index,
                           ord16 S7_FAR_DATA *number_ptr,
                           char S7_FAR_DATA *vfd_name);
int32 S7_FAR_PASCAL s7_get_vfd_state_cnf(ord16 S7_FAR_DATA *log_state_ptr,
                           ord16 S7_FAR_DATA *phy_state_ptr,
                           ord8 S7_FAR_DATA *local_detail_ptr);
int32 S7_FAR_PASCAL s7_get_vfd_ustate_ind(ord16 S7_FAR_DATA *log_state_ptr,
                           ord16 S7_FAR_DATA *phy_state_ptr,
                           ord8 S7_FAR_DATA *local_detail_ptr);
int32 S7_FAR_PASCAL s7_get_write_cnf(void);
int32 S7_FAR_PASCAL s7_init(char S7_FAR_DATA *cp_name,
                           char S7_FAR_DATA *vfd_name,
                           ord32 S7_FAR_DATA *cp_descr_ptr);
int32 S7_FAR_PASCAL s7_initiate_req(ord32 cp_descr,ord16 cref);
int32 S7_FAR_PASCAL s7_initiate_rsp(ord32 cp_descr,ord16 cref,ord16 accept);
const char S7_FAR_DATA * S7_FAR_PASCAL s7_last_iec_err_msg(void);
ord16 S7_FAR_PASCAL s7_last_iec_err_no(void);
const char S7_FAR_DATA * S7_FAR_PASCAL s7_last_detailed_err_msg(void);
ord16 S7_FAR_PASCAL s7_last_detailed_err_no(void);
const char S7_FAR_DATA * S7_FAR_PASCAL s7_mini_db_get(ord16 type);
int32 S7_FAR_PASCAL s7_mini_db_set(ord16 type, char S7_FAR_DATA *value);
int32 S7_FAR_PASCAL s7_multiple_read_req(ord32 cp_descr,ord16 cref,
                           ord16 orderid,ord16 number,
                           struct S7_READ_PARA S7_FAR_DATA *read_para_array);
int32 S7_FAR_PASCAL s7_multiple_write_req(ord32 cp_descr,ord16 cref,
                           ord16 orderid,ord16 number,
                           struct S7_WRITE_PARA S7_FAR_DATA *write_para_array,
                           void S7_FAR_DATA *od_ptr);
int32 S7_FAR_PASCAL s7_read_req(ord32 cp_descr,ord16 cref,ord16 orderid,
                           struct S7_READ_PARA S7_FAR_DATA *read_para_ptr);
int32 S7_FAR_PASCAL s7_receive(ord32 cp_descr, ord16 S7_FAR_DATA *cref_ptr,
                           ord16 S7_FAR_DATA *orderid_ptr);
int32 S7_FAR_PASCAL s7_set_window_handle_msg(ord32 cp_descr,ord32 hWnd,
                           ord32 msgID);

#define s7_set_window_handle_msg(a,b,c) s7_set_window_handle_msg(         \
                                                              a,          \
                                                              (ord32)(b), \
                                                              c           \
                                                                )
int32 S7_FAR_PASCAL s7_shut(ord32 cp_descr);
void  S7_FAR_PASCAL s7_trace(char S7_FAR_DATA *msg);
int32 S7_FAR_PASCAL s7_vfd_state_req(ord32 cp_descr,ord16 cref,ord16 orderid);
int32 S7_FAR_PASCAL s7_write_req(ord32 cp_descr,ord16 cref,ord16 orderid,
                           struct S7_WRITE_PARA S7_FAR_DATA *write_para_ptr,
                           void S7_FAR_DATA *od_ptr);
void  S7_FAR_PASCAL s7_write_trace_buffer(char S7_FAR_DATA *filename);

#ifdef __cplusplus
}
#endif

#endif

/****************************************************************************/
/*     Copyright (C) Siemens AG 1995  All Rights Reserved.                  */
/****************************************************************************/
