
#define VERSION "1.0pre1"

#include <fcntl.h>
#ifdef __DOS32__
 #include <io.h>
 #include <share.h>
#endif

//---------------------------------------------
//---------------------------------------------
class TFileWindow1 : public TWindow
{
public:
    TFileWindow1( const char *fileName );
    virtual void handleEvent( TEvent& event );
};

class TFileViewer1 : public TScroller
{

public:

    char *fileName;
    TCollection *fileLines;
    Boolean isValid;
    TFileViewer1( const TRect& bounds,
                 TScrollBar *aHScrollBar,
                 TScrollBar *aVScrollBar,
                 const char *aFileName
               );
    ~TFileViewer1();
    TFileViewer1( StreamableInit ) : TScroller(streamableInit) { };
    void draw();
    void readFile( const char *fName );
    void setState( ushort aState, Boolean enable );
    void scrollDraw();
    Boolean valid( ushort command );

private:

    virtual const char *streamableName() const
        { return name; }

protected:

    virtual void write( opstream& );
    virtual void *read( ipstream& );

public:

    static const char * const name;
    static TStreamable *build();

};

//=======================================================
class TLineCollection : public TCollection
{

public:

    TLineCollection(short lim, short delta) : TCollection(lim, delta) {}
    virtual void  freeItem(void *p) { delete p; }

private:

    virtual void *readItem( ipstream& ) { return 0; }
    virtual void writeItem( void *, opstream& ) {}

};

//=======================================================

class TNewDeskTop : public TDeskTop
{
public:
 TNewDeskTop( const TRect& r ) : TDeskTop( r ), TDeskInit( &initBackground ) {  };
 static TBackground* initBackground( TRect r );
};

//------------------------------------------------------------------------
class TNewBackground : public TBackground
{
public:
    TNewBackground( const TRect& r, char pattern ) : TBackground( r, pattern ){ };
    void draw();
};

//--------------------  롮   ------------------
class TEdit;
class TMyLabel;
class TMyTListBox;
class TAlgCollection;

class TSelDialog : public TDialog
{
public:
  TSelDialog(char *Path,char par,char *StrSrch);
//  TSelDialog(controller **contr,char contr_am,TAlgCollection *My);
  ~TSelDialog();
  virtual void handleEvent ( TEvent& event );

  char param, *PathDir;
  char tip;

  TCompCollect *AlgColect;
  TCompCollect *FormColect;
  controller **contr_ptr;
  char contr_amount;

  void Chenge_contr(int Item,int filtr);
  void SearchNm();
  void SearchNxtNm();
  void SearchChifr(int *contr, int *tip, int *pos);

  TMyTListBox* ListBox1;
  TMyTListBox* ListBox2;

  static int SrchEdit(void* source,TEvent& event);
  static int ListController(void* source,TEvent& event);

  TScrollBar* ScrollBar1;
  TScrollBar* ScrollBar2;

  TCompCollect *Colect1;
  TCompCollect *Colect2;

  TMyLabel *Label1;
  TMyLabel *Label2;
  TMyLabel *Label3;

  TEdit *Line1;

  TButton *Button1;
  TButton *Button2;

  int old_s_contr;
  int old_s_tip;
  int old_s_pos;
};

//------------------------- TMyApp -----------------------------

class TClockView;
class THeapView;
class TAlgDialog;
class TAlgCollection;
class TCompCollect;
class TFormulsDialog;
class TBasaDBF;

class TMyApp : public TApplication
{
 public:
  TMyApp();

  static  TMenuBar *initMenuBar (TRect r);
  static  TStatusLine *initStatusLine (TRect r);
  static  TDeskTop *initDeskTop (TRect r);
  virtual void handleEvent ( TEvent& event );
  virtual void getEvent(TEvent& event);

  TClockView *clock;                // Clock view
  THeapView *heap;                  // Heap view
  TSelDialog *SelDialog;

  int  LoadAlgAll(char* NameFile,TCompCollect *AlgColect,TCompCollect *FormColect);
  void FreeAlgAll(TCompCollect *AlgColect,TCompCollect *FormColect);
  void SaveAlgAllHdd(char* NameFile,TCompCollect *AlgColect,TCompCollect *FormColect);
  void LoadMsh(char *Path, TCompCollect **DomColect);
  void FreeMsh(TCompCollect *DomColect);
  void SaveMnHdd(char *Path,TCompCollect *Colect);
  void LoadGrc(char* Name, TBasaDBF **BasaDBF);
  void LoadGrg(char* Name, TBasaDBF **BasaDBF);
  void LoadView(char* Name, TBasaDBF **BasaDBF);
  void LoadCompt(char* Name, TBasaDBF **BasaDBF);
  void LoadSpk(char* Name, TBasaDBF **BasaDBF);
  void LoadSignal(char *Path,TCompCollect *Colect);// object ***os_ptr,char *os_amount);
  void SaveSignalHdd(char* Path,TCompCollect *Colect);
  void FreeSignal(TCompCollect *Colect);
  void ChekSignal(char *PathDir,char *str,int opt,char *str_new);
  void LoadLib(char* NamePCX,char* NameWAV, TCompCollect *ColectPCX, TCompCollect *ColectWAV);
  void LoadCnt(char* Name, TBasaDBF **BasaDBF);
  int  LoadTipContr(char *PathDir,tip_contr ***Contr,int *ContrTipAm);
//  void CreateTipContr(TGroup *group,int opt,tip_contr **ContrTip,int ContrTipAm,funcptr *EnterNumb,char *x_max,char *x_min,char *y_max,char *y_min);
  void FreeTipContr(tip_contr **Contr,int ContrTipAm);

  void FreeColect(TAlgCollection *Colect);
  void FreeColect(TCompCollect *Colect);
  void LoadControllers(char* PathFile,controller ***contr_ptr,char *contr_amount);
  void FreeControllers(controller **contr_ptr,char *contr_amount);
//  void SaveAlgobloksHdd(char* NameFile, TAlgCollection *MyColect);
//  void SaveFormulsHdd(char* NameFile, TAlgCollection *FormColect);
  int OperList(TDialog *Dial,TView *View,TCompCollect *TempColect,char Napr,char Len);

  word_s scanAll(char *NameOld,char *NameNew,char *Path,char opt);

  word_s ChekNamePasport(controller **c_ptr,char amount,char *str,word_s *nc,word_s *nz);
  int ConvertFormul(int ind,char *str,TAlgCollection *FormColect);
  int ConvertFormul1(char *str_src,char *str_dest);
  int ChekWin(char *str);
  void chek_tab(char *str);
  void ProtocolView();              // 뢮  ⮪
//  void AlgoblView();
//  void FormulsView();
  void AlgoblView1();
  void ChengeDir();
  void FormulsView1();
  void MshView();
  void GrcView();
  void GrgView();
  void Signal();
  void View();
  void Comt();
  void Lib();
  void Speak();
  void Controller();
  void PasportA();
  void PasportD();
  void AllControl();
  virtual void idle();              // Updates heap and clock views
};

