#include "alg.h"
#include "alg_cfg.h"
#include "mylib.h"
#include "ed_frm1.h"
#include "demohelp.h"

const ushort
      frmDefault    = 0,
      frmDelInChek  = 1,
      frmDelIn      = 2,
      frmDelKfChek  = 3,
      frmDelKf      = 4,
      frmInsIn      = 5,
      frmInsKf      = 6,
      frmMovIn      = 7,
      frmMovKf      = 8;


char            tipBuf=0;
TCompCollect *FormBuf;
TCompCollect *AlgBuf;

struct TMemoData1
{
 size_t length;
 char buffer[65537];
};

struct View_str
{
 char name[257];
 word numb;
};

TFormulsDialog1::TFormulsDialog1( ) :
               TDialog( TRect( 0, 0, 80, 25 ),""),
               TWindowInit( TFormulsDialog1::initFrame )
{
 char str[256],*str1;
 int x1,x2,x_pr;

 getcwd(PathDir,sizeof(PathDir));

 sprintf(str,Text_msg[31],PathDir);
 title=newStr(str);

 options |= ofCentered;

 TView *Monosel = new TView(TRect(2,14,78,21)); Monosel->options |= ofFramed; insert(Monosel);
 Monosel = new TView(TRect(1,8,39,13)); Monosel->options |= ofFramed; insert(Monosel);
 Monosel = new TView(TRect(40,8,79,13)); Monosel->options |= ofFramed; insert(Monosel);

 FreeColect = new TCompCollect(10,10);
 AlgColect = new TCompCollect(10,10); FormColect = new TCompCollect(10,10);
 myApp->LoadAlgAll(AlgConf,AlgColect,FormColect);
 ViewColect = new TCompCollect(10,10);

 TipColect = new TCompCollect(10,10);
 TipColect->insert((char *)"Free"); TipColect->insert((char *)"Fix");

 ComboLine1 = new TEdit( TRect( 68, 1, 73, 2 ),5,NoEdit); insert(ComboLine1);
 TipForm1 = new TMyLabel(TRect(50, 1, 68, 2), "Tip view formuls:",ComboLine1,0); insert(TipForm1);
 ComboBox1 = new TComboBox(TRect( 73, 1, 74, 2 ), ComboLine1,TipColect,SelectFormuls); insert(ComboBox1);
 ComboLine1->setData((char *)TipColect->at(ComboBox1->posit));

 ComboLine1->setState(sfVisible,False); ComboBox1->setState(sfVisible,False);
 TipForm1->setState(sfVisible,False);

 TipForm = new TMyLabel(TRect(75, 1, 78, 2),"",NULL,0); insert(TipForm);
 TipForm->setState(sfVisible,False);

 ScrollBar = new TScrollBar( TRect( 78, 2, 79, 7) ); insert(ScrollBar);
 MyTListBox = new TMyTListBox(TRect( 1, 2, 78, 7), 1, ScrollBar,NULL); insert(MyTListBox);
 MyTListBox->newList(ViewColect);
 MyTListBox->helpCtx=hcMax;
 TMyLabel *Label = new TMyLabel(TRect(2, 1, 20, 2),"F~o~rmuls",MyTListBox,1); insert(Label);

 ScrollBarIn = new TScrollBar( TRect( 38, 8, 39, 13) ); insert(ScrollBarIn);
 ListBoxIn = new TMyTListBox(TRect( 1, 8, 38, 13), 1, ScrollBarIn,NULL); insert(ListBoxIn);
 x1=1; x2=39; str1=Text_msg[97]; x_pr=(x2-x1-strlen(str1)+2)/2;
 Label = new TMyLabel(TRect(x1+x_pr, 7, x2-x_pr, 8), str1,ListBoxIn,1); insert(Label);
 L_N_In = new TMyLabel(TRect(x2-8, 7, x2, 8),"",NULL,1); insert(L_N_In);
 ListBoxIn->helpCtx=hcMax;

 ScrollBarKf = new TScrollBar( TRect( 78, 8, 79, 13) ); insert(ScrollBarKf);
 ListBoxKf = new TMyTListBox(TRect( 40, 8, 78, 13), 1, ScrollBarKf,NULL); insert(ListBoxKf);
 x1=40; x2=79; str1=Text_msg[98]; x_pr=(x2-x1-strlen(str1)+2)/2;
 Label = new TMyLabel(TRect(x1+x_pr, 7, x2-x_pr, 8), str1,ListBoxKf,1); insert(Label);
 L_N_Kf = new TMyLabel(TRect(x2-8, 7, x2, 8),"",NULL,1); insert(L_N_Kf);
 ListBoxKf->helpCtx=hcMax;

 ScrollBarEdV = new TScrollBar( TRect( 78, 14, 79, 21) ); insert(ScrollBarEdV);
 ScrollBarEdH = new TScrollBar( TRect( 20, 21, 77, 22) ); insert(ScrollBarEdH);
 Indicator = new TIndicator( TRect( 4, 21, 20, 22 ) );    insert(Indicator);
 MemoFrm = new TMemo( TRect(2, 14, 78, 21), ScrollBarEdH, ScrollBarEdV, Indicator,65535);
 MemoFrm->helpCtx=hcEdit;
 insert(MemoFrm);
 x1=1; x2=79; str1=Text_msg[99]; x_pr=(x2-x1-strlen(str1)+2)/2;
 Label = new TMyLabel(TRect(x1+x_pr, 13, x2-x_pr, 14), str1,MemoFrm,1); insert(Label);

 TEditor *clip = new TEditor(TRect(1,1,5,5),NULL,NULL,NULL,16000);
 clip->hide(); myApp->insert( clip );
 if( clip != 0 ){ MemoFrm->clipboard = clip; MemoFrm->clipboard->canUndo = False; }

 TButton *Button = new TButton( TRect( 55,22, 65, 24),Text_msg[115], cmOK, bfDefault ); insert(Button);
 Button = new TButton( TRect( 67,22, 77, 24),Text_msg[114], cmCancel, bfNormal ); insert(Button);

 ViewFixFree();
 ViewFormul(OldIndChek=OldIndChekKf=OldIndChekIn=0);

 Modifs=False;
 MyTListBox->select();
}

TFormulsDialog1::~TFormulsDialog1()
{
 myApp->FreeAlgAll(AlgColect,FormColect);
}

void TFormulsDialog1::handleEvent ( TEvent& event )
{
 char str[257],*str2,*str3,*str4;
 int control,i,k1,n_form,tip,ii,iii,len;
 Boolean flg1;
 frm_str *formuls;
 TCompCollect *col1;

 if( event.what == evCommand && event.message.command == cmClose)
 {
  if(MemoFrm->modified || Modifs)
  {
   control = messageBox(Text_msg[26],mfWarning | mfOKCancel);
   if(control==cmOK)
   {
    if(MemoFrm->modified) SaveFrm(MyTListBox->focused);
    sprintf(str,Text_msg[109],PathDir,AlgConf);
    myApp->SaveAlgAllHdd(str,AlgColect,FormColect);
   }
  }
 }

 TDialog::handleEvent(event);

 if( event.what == evBroadcast && event.message.command == cmScrollBarChanged) //List ListBox
 {
  if(MyTListBox->state & sfFocused)    // ListBox1
  {
#ifdef __DOS32__
   if(getShiftState() & (kbLeftShift|kbRightShift))
   {
    n_form=((View_str *)MyTListBox->list()->at(MyTListBox->focused))->numb;
    k1=((View_str *)MyTListBox->list()->at(OldIndChek))->numb;
//--------------------------------------------------------------------------------------
    for(i=0;i<AlgColect->getCount();i++)
    {
     if(((alg_str *)AlgColect->at(i))->form==n_form){ ((alg_str *)AlgColect->at(i))->form=k1;     continue;}
     if(((alg_str *)AlgColect->at(i))->form==k1)    { ((alg_str *)AlgColect->at(i))->form=n_form; continue;}
    }
//--------------------------------------------------------------------------------------
    str3=(char *)FormColect->at(k1);
    str4=(char *)FormColect->at(n_form);
    FormColect->atRemove(k1);
    FormColect->atInsert(k1,str4);
    FormColect->atRemove(n_form);
    FormColect->atInsert(n_form,str3);
    ViewFixFree();
    ViewFormul(MyTListBox->focused);
    Modifs=True;
   }
#endif
   if(MemoFrm->modified)
   {
    control = messageBox(mfWarning | mfOKCancel,"㫠 . ࠭ ?");
    if(control==cmOK) { SaveFrm(OldIndChek); Modifs=True; }
    MemoFrm->modified=False;
   }
   ViewFormul(MyTListBox->focused);
   OldIndChek=MyTListBox->focused;
  }
  if(ListBoxIn->state & sfFocused)    // ListBox1
  {
#ifdef __DOS32__
   if(getShiftState() & (kbLeftShift|kbRightShift))
   {
    str3=(char *)ListBoxIn->list()->at(OldIndChekIn);
    str4=(char *)ListBoxIn->list()->at(ListBoxIn->focused);
    ListBoxIn->list()->atRemove(OldIndChekIn);
    ListBoxIn->list()->atInsert(OldIndChekIn,str4);
    ListBoxIn->list()->atRemove(ListBoxIn->focused);
    ListBoxIn->list()->atInsert(ListBoxIn->focused,str3);
//--------------------------------------------------------------------------------
    if(!ComboBox1->posit)
    {
     CheckFormuls(frmMovIn,OldIndChekIn+1,ListBoxIn->focused+1);
     SaveFrm(MyTListBox->focused);
    }

    n_form=((View_str *)MyTListBox->list()->at(MyTListBox->focused))->numb;
    for(i=0;i<AlgColect->getCount();i++)
     if(((alg_str *)AlgColect->at(i))->form==n_form)
     {
      col1=((alg_str *)AlgColect->at(i))->inp;
      str3=(char *)col1->at(OldIndChekIn);
      str4=(char *)col1->at(ListBoxIn->focused);
      col1->atRemove(OldIndChekIn);
      col1->atInsert(OldIndChekIn,str4);
      col1->atRemove(ListBoxIn->focused);
      col1->atInsert(ListBoxIn->focused,str3);
     }
//--------------------------------------------------------------------------------
    ListBoxIn->drawView();
    Modifs=True;
   }
#endif
   sprintf(str,"%d(%d)",ListBoxIn->focused+1,ListBoxIn->list()->getCount()); L_N_In->SetText(str);
   OldIndChekIn=ListBoxIn->focused;
  }
  if(ListBoxKf->state & sfFocused)    // ListBox1
  {
#ifdef __DOS32__
   if(getShiftState() & (kbLeftShift|kbRightShift))
   {
    str3=(char *)ListBoxKf->list()->at(OldIndChekKf);
    str4=(char *)ListBoxKf->list()->at(ListBoxKf->focused);
    ListBoxKf->list()->atRemove(OldIndChekKf);
    ListBoxKf->list()->atInsert(OldIndChekKf,str4);
    ListBoxKf->list()->atRemove(ListBoxKf->focused);
    ListBoxKf->list()->atInsert(ListBoxKf->focused,str3);
//--------------------------------------------------------------------------------
    if(!ComboBox1->posit)
    {
     CheckFormuls(frmMovKf,OldIndChekKf+1,ListBoxKf->focused+1);
     SaveFrm(MyTListBox->focused);
    }

    n_form=((View_str *)MyTListBox->list()->at(MyTListBox->focused))->numb;
    for(i=0;i<AlgColect->getCount();i++)
     if(((alg_str *)AlgColect->at(i))->form==n_form)
     {
      col1=((alg_str *)AlgColect->at(i))->koef;
      str3=(char *)col1->at(OldIndChekKf);
      str4=(char *)col1->at(ListBoxKf->focused);
      col1->atRemove(OldIndChekKf);
      col1->atInsert(OldIndChekKf,str4);
      col1->atRemove(ListBoxKf->focused);
      col1->atInsert(ListBoxKf->focused,str3);
     }
//--------------------------------------------------------------------------------
    ListBoxKf->drawView();
    Modifs=True;
   }
#endif
   sprintf(str,"%d(%d)",ListBoxKf->focused+1,ListBoxKf->list()->getCount()); L_N_Kf->SetText(str);
   OldIndChekKf=ListBoxKf->focused;
  }
 }

 if(event.what == evKeyboard && MyTListBox->state & sfFocused)    // ListBox1
 {
  switch(event.keyDown.keyCode)
  {
   case kbCtrlF10:
     ComboLine1->setState(sfVisible,True);
     ComboBox1->setState(sfVisible,True);
     TipForm1->setState(sfVisible,True);
     break;
   case kbCtrlIns:
     if(tipBuf) myApp->FreeAlgAll(AlgBuf,FormBuf); tipBuf=1;
     AlgBuf=new TCompCollect(5,5);
     FormBuf=new TCompCollect(5,5);
     for(k1=0,i=0;i<ViewColect->getCount();i++) if(ViewColect->GetOptItem(i)) k1++;
     if(!k1) ViewColect->SetOptItem(MyTListBox->focused,1);
     for(i=0;i<ViewColect->getCount();i++)
     {
      if(!ViewColect->GetOptItem(i)) continue;
      k1=((View_str *)MyTListBox->list()->at(i))->numb;
      formuls = (frm_str *)calloc(1,sizeof(frm_str));
      len=strlen(((frm_str *)FormColect->at(k1))->name);
      strncpy(formuls->name,((frm_str *)FormColect->at(k1))->name,len);
      formuls->tip=((frm_str *)FormColect->at(k1))->tip;
      formuls->inp=new TCompCollect(5,5);
      for(ii=0;ii<((frm_str *)FormColect->at(k1))->inp->getCount();ii++)
      {
       len=strlen((char *)((frm_str *)FormColect->at(k1))->inp->at(ii));
       str2 = new char[len+1]; str2[len]=0;
       strcpy(str2,(char *)((frm_str *)FormColect->at(k1))->inp->at(ii));
       formuls->inp->insert(str2);
      }
      formuls->koef=new TCompCollect(5,5);
      for(ii=0;ii<((frm_str *)FormColect->at(k1))->koef->getCount();ii++)
      {
       len=strlen((char *)((frm_str *)FormColect->at(k1))->koef->at(ii));
       str2 = new char[len+1]; str2[len]=0;
       strcpy(str2,(char *)((frm_str *)FormColect->at(k1))->koef->at(ii));
       formuls->koef->insert(str2);
      }
      len=strlen(((frm_str *)FormColect->at(k1))->formul);
      formuls->formul = new char[len+1]; formuls->formul[len]=0;
      strcpy(formuls->formul,((frm_str *)FormColect->at(k1))->formul);
      FormBuf->insert(formuls);
     }
     break;
   case kbShiftIns:
     if(tipBuf==1)
     {
      for(i=0;i<FormBuf->getCount();i++,flg1=False)
      {
       if(((frm_str *)FormBuf->at(i))->tip!=5)
       {
        for(k1=0;k1<FormColect->getCount();k1++)
         if(((frm_str *)FormColect->at(k1))->tip==((frm_str *)FormBuf->at(i))->tip) break;
        if(k1<FormColect->getCount())
        {
         control = messageBox(mfWarning | mfOKCancel,
                   "஢ 㫠 ' %.30s ' ⨯ %d 㦥 . Ok-/Cancel-?",
                   ((frm_str *)FormBuf->at(i))->name,((frm_str *)FormBuf->at(i))->tip);

         if(control==cmOK && ( ((frm_str *)FormBuf->at(i))->inp->getCount() != ((frm_str *)FormColect->at(k1))->inp->getCount()
                              || ((frm_str *)FormBuf->at(i))->koef->getCount() != ((frm_str *)FormColect->at(k1))->koef->getCount() ))
         {DispFixErr(0,"⢮ 室  業⮢  ᮢ!!"); continue;}
         if(control==cmOK)
         {
          ((frm_str *)FormColect->at(k1))->inp->freeAll();
          delete ((frm_str *)FormColect->at(k1))->inp;
          ((frm_str *)FormColect->at(k1))->koef->freeAll();
          delete ((frm_str *)FormColect->at(k1))->koef;
          free(((frm_str *)FormColect->at(k1))->formul);
          FormColect->atFree(k1); flg1=True;
         }
         else
         {
          k1=-1;
          col1 = new TCompCollect(10,10);
          for(iii=0;iii<256;iii++)
          {
           for(ii=0;ii<FormColect->getCount();ii++)
            if(((frm_str *)FormColect->at(ii))->tip==iii){ ii= -1; break;}
           if(ii!= -1){str2 =(char *)calloc(1,4); sprintf(str2,"%d",iii); col1->insert(str2);}
          }
          tip=myApp->OperList(this,MyTListBox,col1,1,6);
          if(tip== -1) {myApp->FreeColect(col1); continue;}
          tip=atoi((char *)col1->at(tip));
          myApp->FreeColect(col1);
          ((frm_str *)FormBuf->at(i))->tip=tip;
         }
        }else k1=-1;
       }
       if(((frm_str *)FormBuf->at(i))->tip!=5)
       {
        if(k1<0)
         for(k1=0;k1<FormColect->getCount();k1++)
          if(((frm_str *)FormColect->at(k1))->tip==5) break;
       }
       else k1 = FormColect->getCount();
       formuls = (frm_str *)calloc(1,sizeof(frm_str));
       len=strlen(((frm_str *)FormBuf->at(i))->name);
       strncpy(formuls->name,((frm_str *)FormBuf->at(i))->name,len);
       formuls->tip=((frm_str *)FormBuf->at(i))->tip;
       formuls->inp=new TCompCollect(5,5);
       for(ii=0;ii<((frm_str *)FormBuf->at(i))->inp->getCount();ii++)
       {
        len=strlen((char *)((frm_str *)FormBuf->at(i))->inp->at(ii));
        str2 = new char[len+1]; str2[len]=0;
        strcpy(str2,(char *)((frm_str *)FormBuf->at(i))->inp->at(ii));
        formuls->inp->insert(str2);
       }
       formuls->koef=new TCompCollect(5,5);
       for(ii=0;ii<((frm_str *)FormBuf->at(i))->koef->getCount();ii++)
       {
        len=strlen((char *)((frm_str *)FormBuf->at(i))->koef->at(ii));
        str2 = new char[len+1]; str2[len]=0;
        strcpy(str2,(char *)((frm_str *)FormBuf->at(i))->koef->at(ii));
        formuls->koef->insert(str2);
       }
       len=strlen(((frm_str *)FormBuf->at(i))->formul);
       formuls->formul = new char[len+1]; formuls->formul[len]=0;
       strcpy(formuls->formul,((frm_str *)FormBuf->at(i))->formul);
       FormColect->atInsert(k1,formuls);

       Modifs=True;
       if(flg1) continue;
       for(i=0;i<AlgColect->getCount();i++)
        if(((alg_str *)AlgColect->at(i))->form>=k1)((alg_str *)AlgColect->at(i))->form++;
      }
     }
  }
  ViewFixFree();
  ViewFormul(MyTListBox->focused);
 }

 if( event.what == evCommand )
  switch( event.message.command )
  {
   case cmOK:
        SaveFrm(MyTListBox->focused);
        Modifs=True; MemoFrm->modified=False;
//        ViewFormul(MyTListBox->focused);
        clearEvent(event);
        break;
   case cmCancel:
        ViewFormul(MyTListBox->focused);
        MemoFrm->modified=False;
        clearEvent(event);
        break;
   case cmSave1:
        control = messageBox(mfWarning | mfOKCancel,Text_msg[37]);
        if(control!=cmOK) break;
        SaveFrm(MyTListBox->focused);
        sprintf(str,Text_msg[109],PathDir,AlgConf);
        myApp->SaveAlgAllHdd(str,AlgColect,FormColect);
        MemoFrm->modified=Modifs=False;
        break;
   case cmReLoad:
        control = messageBox(mfWarning | mfOKCancel,Text_msg[38]);
        if(control!=cmOK) break;
        myApp->FreeAlgAll(AlgColect,FormColect);
        AlgColect = new TCompCollect(10,10); FormColect = new TCompCollect(10,10);
        sprintf(str,Text_msg[109],PathDir,AlgConf);
        myApp->LoadAlgAll(str,AlgColect,FormColect);
        ViewFormul(OldIndChek=OldIndChekKf=OldIndChekIn=0);
        MyTListBox->select();
        MemoFrm->modified=Modifs=False;
        break;
   case cmInsert:
   case cmAdd:
   case cmRename:
        if(MyTListBox->state & sfFocused)    // ListBox1
        {
         str[0]=0;
         if(MyTListBox->list()->getCount()) n_form=((View_str *)MyTListBox->list()->at(MyTListBox->focused))->numb;
         else if(ComboBox1->posit) n_form=0; else n_form=FormColect->getCount();
         if(event.message.command==cmRename)
          if(!MyTListBox->list()->getCount()) break;
          else strncpy(str,((frm_str *)FormColect->at(n_form))->name,256);
         control = inputBox(" ", "㫠:",str, 256);
         if(control==cmOK)
         {
          for(i=0;i<FormColect->getCount();i++)
           if(!strncmp(str,((frm_str *)FormColect->at(i))->name,256)){ i= -1; break;}
          if(i== -1){ DispFixErr(0,Text_msg[15],str); break; }
          if(ComboBox1->posit)
          {
           col1 = new TCompCollect(10,10);
           for(i=0;i<256;i++)
           {
            for(ii=0;ii<FormColect->getCount();ii++)
             if(!(i==((frm_str *)FormColect->at(n_form))->tip && event.message.command==cmRename))
              if(((frm_str *)FormColect->at(ii))->tip==i){ ii= -1; break;}
            if(ii!= -1){str2 =(char *)calloc(1,4); sprintf(str2,"%d",i); col1->insert(str2);}
           }
           tip=myApp->OperList(this,MyTListBox,col1,1,6);
           if(tip== -1) break;
           tip=atoi((char *)col1->at(tip));
           myApp->FreeColect(col1);
          }
          else tip=5;
          if(event.message.command==cmInsert || event.message.command==cmRename) k1 = n_form;
          if(event.message.command==cmAdd)
           if(MyTListBox->list()->getCount()) k1 = ((View_str *)MyTListBox->list()->at(MyTListBox->list()->getCount()-1))->numb+1;
           else if(ComboBox1->posit) k1 = n_form; else k1 = FormColect->getCount();
          if(event.message.command==cmRename);
          else
          {
//------------------------------------------------------------------------
           for(i=0;i<AlgColect->getCount();i++)
            if(((alg_str *)AlgColect->at(i))->form>=k1)((alg_str *)AlgColect->at(i))->form++;
//------------------------------------------------------------------------
           formuls = new frm_str;
           formuls->inp  = new TCompCollect(10,10);
           formuls->koef = new TCompCollect(10,10);
           formuls->formul = new char[3]; strcpy(formuls->formul," ");
           FormColect->atInsert(k1,formuls);
          }
          strncpy(((frm_str *)FormColect->at(k1))->name,str,256);
          ((frm_str *)FormColect->at(k1))->tip=tip;
          ViewFixFree();
          ViewFormul(MyTListBox->focused);
          Modifs=True;
         }
        }
        if(ListBoxIn->state & sfFocused)    // ListBox1
        {
         str[0]=0;
         n_form=((View_str *)MyTListBox->list()->at(MyTListBox->focused))->numb;
         col1=((frm_str *)FormColect->at(n_form))->inp;
         if(event.message.command==cmRename)
          if(!col1->getCount()) break; else strncpy(str,(char *)col1->at(ListBoxIn->focused),256);
         control = inputBox(" ", "室:",str, 256);
         if(control==cmOK)
         {
          for(i=0;i<col1->getCount();i++)
           if(!strncmp(str,(char *)col1->at(i),256)){ i= -1; break;}
          if(i== -1) DispFixErr(0,Text_msg[15],str);
          if(event.message.command==cmInsert || event.message.command==cmRename) k1 = ListBoxIn->focused;
          if(event.message.command==cmAdd)    k1 = col1->getCount();
          if(event.message.command==cmRename)
          {
           col1->atFree(k1); str2 = new char[strlen(str)+1];
           col1->atInsert(k1,str2);
          }
          else
          {
//------------------------------------------------------------------------
           if(event.message.command==cmInsert && !ComboBox1->posit) CheckFormuls(frmInsIn,k1+1,0);
           for(i=0;i<AlgColect->getCount();i++)
            if(((alg_str *)AlgColect->at(i))->form==n_form)
            {
             str3 = (char *)calloc(10,1); strcpy(str3,Text_msg[49]);
             ((alg_str *)AlgColect->at(i))->inp->atInsert(k1,str3);
            }
//------------------------------------------------------------------------
           str2 = new char[strlen(str)+1];
           col1->atInsert(k1,str2);
          }
          strcpy((char *)col1->at(k1),str);

          ListBoxIn->setRange( ListBoxIn->list()->getCount() );
          ListBoxIn->drawView();

          if(event.message.command==cmInsert && !ComboBox1->posit) SaveFrm(MyTListBox->focused);

          Modifs=True;
         }
        }
        if(ListBoxKf->state & sfFocused)    // ListBox1
        {
         str[0]=0;
         n_form=((View_str *)MyTListBox->list()->at(MyTListBox->focused))->numb;
         col1=((frm_str *)FormColect->at(n_form))->koef;
         if(event.message.command==cmRename)
          if(!col1->getCount()) break; else strncpy(str,(char *)col1->at(ListBoxKf->focused),256);
         control = inputBox(" ", ":",str, 256);
         if(control==cmOK)
         {
          for(i=0;i<col1->getCount();i++)
           if(!strncmp(str,(char *)col1->at(i),256)){ i= -1; break;}
          if(i== -1) DispFixErr(0,Text_msg[15],str);
          if(event.message.command==cmInsert || event.message.command==cmRename) k1 = ListBoxKf->focused;
          if(event.message.command==cmAdd)    k1 = col1->getCount();
          if(event.message.command==cmRename)
          {
           col1->atFree(k1); str2 = new char[strlen(str)+1];
           col1->atInsert(k1,str2);
          }
          else
          {
//------------------------------------------------------------------------
           if(event.message.command==cmInsert && !ComboBox1->posit) CheckFormuls(frmInsKf,k1+1,0);
           for(i=0;i<AlgColect->getCount();i++)
            if(((alg_str *)AlgColect->at(i))->form==n_form)
            {
             str3 = (char *)calloc(4,1); *(float *)str3=0.0;
             ((alg_str *)AlgColect->at(i))->koef->atInsert(k1,str3);
            }
//------------------------------------------------------------------------
           str2 = new char[strlen(str)+1];
           col1->atInsert(k1,str2);
          }
          strcpy((char *)col1->at(k1),str);

          ListBoxKf->setRange( ListBoxKf->list()->getCount() );
          ListBoxKf->drawView();

          if(event.message.command==cmInsert && !ComboBox1->posit) SaveFrm(MyTListBox->focused);

          Modifs=True;
         }
        }
        break;
   case cmDelete:
        if(MyTListBox->state & sfFocused)    // ListBox1
        {
         if(!MyTListBox->list()->getCount())break;

         for(k1=0,i=0;i<MyTListBox->list()->getCount();i++) if(MyTListBox->list()->GetOptItem(i)) k1++;
         if(k1) control = messageBox(mfWarning | mfOKCancel,Text_msg[46],k1);
         else{ MyTListBox->list()->SetOptItem(MyTListBox->focused,1); control=cmOK;}
         if(control==cmOK)
         {
          for(ii=0;ii<MyTListBox->list()->getCount();ii++)
           if(MyTListBox->list()->GetOptItem(ii))
           {
            n_form=((View_str *)MyTListBox->list()->at(ii))->numb;
//------------------------------------------------------------------------
            for(k1=0,i=0;i<AlgColect->getCount();i++) if(((alg_str *)AlgColect->at(i))->form==n_form) k1++;
            if(k1){DispFixErr(0,Text_msg[11],k1);continue;}  //"Error: Use %d delete formuls."
            for(i=0;i<AlgColect->getCount();i++)
             if(((alg_str *)AlgColect->at(i))->form>n_form)((alg_str *)AlgColect->at(i))->form--;
//------------------------------------------------------------------------
            ((frm_str *)FormColect->at(n_form))->inp->freeAll();
            delete ((frm_str *)FormColect->at(n_form))->inp;
            ((frm_str *)FormColect->at(n_form))->koef->freeAll();
            delete ((frm_str *)FormColect->at(n_form))->koef;
            free(((frm_str *)FormColect->at(n_form))->formul);
            FormColect->atFree(n_form);
           }
          ViewFixFree();
          ViewFormul(MyTListBox->focused);
          Modifs=True;
         }
        }
        if(ListBoxIn->state & sfFocused)
        {
         if(!ListBoxIn->list()->getCount())break;
//------------------------------------------------------------------------
         n_form=((View_str *)MyTListBox->list()->at(MyTListBox->focused))->numb;
         if(!ComboBox1->posit)
         {
          if(CheckFormuls(frmDelInChek,ListBoxIn->focused+1,0)<0) break;
          CheckFormuls(frmDelIn,ListBoxIn->focused+1,0); SaveFrm(MyTListBox->focused);
         }
         for(i=0;i<AlgColect->getCount();i++)
          if(((alg_str *)AlgColect->at(i))->form==n_form)((alg_str *)AlgColect->at(i))->inp->atFree(ListBoxIn->focused);
//------------------------------------------------------------------------
         ListBoxIn->list()->atFree(ListBoxIn->focused);
         ListBoxIn->setRange( ListBoxIn->list()->getCount() );
         ListBoxIn->drawView();
         sprintf(str,"%d(%d)",ListBoxIn->focused+1,ListBoxIn->list()->getCount()); L_N_In->SetText(str);
         Modifs=True;
        }
        if(ListBoxKf->state & sfFocused)    // 奬
        {
         if(!ListBoxKf->list()->getCount())break;
//------------------------------------------------------------------------
         n_form=((View_str *)MyTListBox->list()->at(MyTListBox->focused))->numb;
         if(!ComboBox1->posit)
         {
          if(CheckFormuls(frmDelKfChek,ListBoxKf->focused+1,0)<0) break;
          CheckFormuls(frmDelKf,ListBoxKf->focused+1,0); SaveFrm(MyTListBox->focused);
         }
         for(i=0;i<AlgColect->getCount();i++)
          if(((alg_str *)AlgColect->at(i))->form==n_form)((alg_str *)AlgColect->at(i))->koef->atFree(ListBoxKf->focused);
//------------------------------------------------------------------------
         ListBoxKf->list()->atFree(ListBoxKf->focused);
         ListBoxKf->setRange( ListBoxKf->list()->getCount() );
         ListBoxKf->drawView();
         sprintf(str,"%d(%d)",ListBoxKf->focused+1,ListBoxKf->list()->getCount()); L_N_Kf->SetText(str);
         Modifs=True;
        }
        clearEvent(event);
        break;
   default: ;
  }
}

void TFormulsDialog1::ViewFormul(int item)
{
 int n_form;
 char str[20];
 TMemoData1 *MemData;

 if(!MyTListBox->list()->getCount())
 {
  ListBoxIn->setState(sfDisabled,True); ListBoxKf->setState(sfDisabled,True);
  MemoFrm->setState(sfDisabled,True);
  ListBoxIn->newList(FreeColect,0); ListBoxKf->newList(FreeColect,0);
  MemData = new TMemoData1;
  MemData->length=0; MemoFrm->setData(MemData);
  delete MemData;
  return;
 }
 ListBoxIn->setState(sfDisabled,False); ListBoxKf->setState(sfDisabled,False);
 MemoFrm->setState(sfDisabled,False);

 n_form=((View_str *)MyTListBox->list()->at(item))->numb;

 sprintf(str,"%d",((frm_str *)FormColect->at(n_form))->tip); TipForm->SetText(str);

 ListBoxIn->newList(((frm_str *)FormColect->at(n_form))->inp,0);
 ListBoxKf->newList(((frm_str *)FormColect->at(n_form))->koef,0);
 MemData = new TMemoData1;
 MemData->length=strlen((char *)((frm_str *)FormColect->at(n_form))->formul);
 strcpy(MemData->buffer,(char *)((frm_str *)FormColect->at(n_form))->formul);
 MemoFrm->setData(MemData);
 delete MemData;

 sprintf(str,"%d(%d)",ListBoxIn->focused+1,ListBoxIn->list()->getCount()); L_N_In->SetText(str);
 sprintf(str,"%d(%d)",ListBoxKf->focused+1,ListBoxKf->list()->getCount()); L_N_Kf->SetText(str);
}

void TFormulsDialog1::SaveFrm(int item)
{
 int n_form;
 TMemoData1 *MemData;

 n_form=((View_str *)MyTListBox->list()->at(item))->numb;

 MemData = new TMemoData1;
 MemoFrm->getData(MemData);
 if(((frm_str *)FormColect->at(n_form))->tip==5 && CheckFormuls(frmDefault,0,0));
 else
 {
  char *str = new char[strlen(MemData->buffer)+1];
  strcpy(str,MemData->buffer);
  free(((frm_str *)FormColect->at(n_form))->formul);
  ((frm_str *)FormColect->at(n_form))->formul=str;
  Modifs=True; MemoFrm->modified=False; MemoFrm->setCurPtr(MemoFrm->nextChar(MemoFrm->curPtr), 0);
 }
 delete MemData;
}

typedef struct
{
 char   name[5];
 int    tip;
}sfunc_alg;

int TFormulsDialog1::CheckFormuls(ushort opt,int nmb,int nmb1)
{
  enum {on_scob=1, op,numb,off_scob,p_koef,p_inp,p_outp};
//  unsigned long oper;
  char b,str1[10],str2[10],*str;
  int len,len1,ind=0,scob=0,last=0,zap_n=0,loc_count,i,x=1,y=1,kz=0,tmp1;
  TMemoData1 *MemData;
  sfunc_alg func_alg[] =
  {
   {"exp(",on_scob}, {"abs(",on_scob}, {"cos(",on_scob}, {"sin(",on_scob},
   {"rnd(",on_scob}, {"max(",on_scob}, {"min(",on_scob}, {"ln(",on_scob},
   {"if(",on_scob},  {"sig(",on_scob}, {"msg(",on_scob},
   {"frq",numb},     {"pi",numb}, {"brk",numb},
  };

  MemData = new TMemoData1;
  MemoFrm->getData(MemData);
  str=MemData->buffer;

  len=strlen(str);
  if(!len){kz=-1; goto end1;}
homf:
  if(ind==len)
  {
   if(zap_n) {SetCur(x,y);DispFixErr(0,Text_msg[101]); kz=-1; goto end1;}
   if(scob)  {SetCur(x,y);DispFixErr(0,Text_msg[102]); kz=-1; goto end1;}
   for(len=0;len<FormColect->getCount();len++)
   {
    if(!strcmp((char *)FormColect->at(len),str))
    { DispFixErr(0,Text_msg[1]); kz=-1; goto end1; }                 //"Formuls already exist.";
   }
//   DispFixErr(0,Text_msg[2]);                                  //"Formuls OK and add";
   kz=0; goto end1;
  }

  if(ind>len) {DispFixErr(0,Text_msg[3]); kz=-1; goto end1;}         //"Formuls no ending";
  b=str[ind];
  if(b=='(')
  {
   if(last==numb) {SetCur(x,y);DispFixErr(0,Text_msg[4],ind);kz=-1; goto end1;}// "। ᪮   ; pos %d"
   ind++;x++;scob++;last=on_scob;goto homf;
  }
  if(b=='=')
  {
   if(zap_n) {SetCur(x,y);DispFixErr(0,Text_msg[101]); kz=-1; goto end1;}
//   if(scob)  {SetCur(x,y);DispFixErr(0,Text_msg[102]); kz=-1; goto end1;}
   if(last!=p_koef&&last!=p_inp&&last!=p_outp) {SetCur(x,y);DispFixErr(0,Text_msg[103]); kz=-1; goto end1;}
   zap_n++;x++;ind++;last=0; goto homf;
  }
  if(b==';')
  {
   if(scob)  {SetCur(x,y);DispFixErr(0,Text_msg[102]); kz=-1; goto end1;}
    zap_n--;x++;ind++;last=0;goto homf;
  }
  if(b==')')
  {ind++;x++;scob--;last=off_scob; goto homf;}
  if(b==',')
  {ind++;x++;last=0; goto homf;}
  if(*(word *)(str+ind) =='//')
  {
//   for(;(ind<len && str[ind]!='\n');ind++,x++); //DispFixErr(1,"Char %X",str[ind]);
   for(;(ind<len && str[ind]!=0x0D);ind++,x++); //DispFixErr(1,"Char %X",str[ind]);
   goto homf;
  }
  if(b=='"') { while(ind<len) {ind++,x++; if(str[ind]=='"') {ind++,x++;break;} } goto homf; }
  if(b=='+' || b=='-' || b=='*' || b=='/' || b=='^' || b=='>' || b=='<' || b=='~' || b=='&' || b=='|')
  {
   if(last==op){SetCur(x,y);DispFixErr(0,Text_msg[5],ind);kz=-1; goto end1;}//"Wrong, two operators; pos %d"
   ind++;x++;last=op;goto homf;
  }
  if(b=='X')
  {
   if(last==p_koef || last==off_scob || last==p_inp || last==p_outp|| last==numb)
   {SetCur(x,y);DispFixErr(0,Text_msg[6],ind);kz=-1; goto end1;}            //"Wrong, two numbers; pos %d"
   for(i=0,x++,++ind;(i+ind)<len;i++) if(str[ind+i]<'0' || str[ind+i]>'9') break;
   if(i>0 && i<4)
   {
    strncpy(str1,&str[ind],i); str1[i]=0;
    if(opt==frmDelInChek && atoi(str1)==nmb) {SetCur(x,y); DispFixErr(0,"Input %d used",nmb); kz=-2; goto end1;}
    if(((opt==frmDelIn||opt==frmInsIn) && atoi(str1)>=nmb)||(opt==frmMovIn&&(atoi(str1)==nmb||atoi(str1)==nmb1)))
    {
     if(opt==frmDelIn) tmp1=atoi(str1)-1; if(opt==frmInsIn) tmp1=atoi(str1)+1;
     if(opt==frmMovIn&&atoi(str1)==nmb) tmp1=nmb1; if(opt==frmMovIn&&atoi(str1)==nmb1) tmp1=nmb;
     sprintf(str2,"%d",tmp1);   //     itoa(tmp1,str2,10);
     tmp1=strlen(str2)-strlen(str1);
     if(tmp1) memmove(&str[ind+strlen(str2)],&str[ind+strlen(str1)],len-ind+strlen(str1));
     strncpy(&str[ind],str2,strlen(str2));
     len+=tmp1; ind+=tmp1; x+=tmp1;
    }
    if(atoi(str1)<=ListBoxIn->list()->getCount()) {ind+=i;x+=i;last=p_koef; goto homf;}
   }
   SetCur(x,y);
   DispFixErr(0,Text_msg[7],ListBoxIn->list()->getCount(),--ind);    //"Koefficient don't The Range 1-15; pos %d"
   kz=-1; goto end1;
  }
  if(b=='Y')
  {
   if(last==p_koef || last==off_scob || last==p_inp || last==p_outp || last==numb)
   {SetCur(x,y);DispFixErr(0,Text_msg[6],ind);kz=-1; goto end1;}            //"Wrong, two numbers; pos %d"
   last=p_outp;ind++;x++; goto homf;
  }
  if(b=='K')
  {
   if(last==p_koef || last==off_scob || last==p_inp || last==p_outp || last==numb)
   {SetCur(x,y);DispFixErr(0,Text_msg[6],ind);kz=-1; goto end1;}//"Wrong, two numbers; pos %d"
   for(i=0,x++,++ind;(i+ind)<len;i++) if(str[ind+i]<'0' || str[ind+i]>'9') break;
   if(i>0 && i<4)
   {
    strncpy(str1,&str[ind],i); str1[i]=0;
    if(opt==frmDelKfChek && atoi(str1)==nmb) {SetCur(x,y); DispFixErr(0,"Koeff. %d used",nmb); kz=-2; goto end1;}
    if(((opt==frmDelKf||opt==frmInsKf) && atoi(str1)>=nmb)||(opt==frmMovKf&&(atoi(str1)==nmb||atoi(str1)==nmb1)))
    {
     if(opt==frmDelKf) tmp1=atoi(str1)-1; if(opt==frmInsKf) tmp1=atoi(str1)+1;
     if(opt==frmMovKf&&atoi(str1)==nmb) tmp1=nmb1; if(opt==frmMovKf&&atoi(str1)==nmb1) tmp1=nmb;
     sprintf(str2,"%d",tmp1);   //     itoa(tmp1,str2,10);
     tmp1=strlen(str2)-strlen(str1);
     if(tmp1) memmove(&str[ind+strlen(str2)],&str[ind+strlen(str1)],len-ind+strlen(str1));
     strncpy(&str[ind],str2,strlen(str2));
     len+=tmp1; ind+=tmp1; x+=tmp1;
    }
    if(atoi(str1)<=ListBoxKf->list()->getCount()) {ind+=i;x+=i;last=p_koef;goto homf;}
   }
   SetCur(x,y);
   DispFixErr(0,Text_msg[8],ListBoxKf->list()->getCount(),--ind);    //"Koefficient don't The Range 1-15; pos %d"
   kz=-1; goto end1;
  }
  if((b>='0' && b<='9')|| b=='.')
  {
   if(last==p_koef || last==off_scob || last==p_inp || last==p_outp || last==numb)
   {SetCur(x,y);DispFixErr(0,Text_msg[6],ind);kz=-1; goto end1;}   //"Wrong, two numbers; pos %d"
   loc_count=0;
   while((b>='0' && b<='9')|| b=='.')
   {
    if(b=='.')loc_count++;
    if(loc_count>1){SetCur(x,y);DispFixErr(0,Text_msg[9],ind);kz=-1; goto end1;}//"The point in the numbers must by one; pos %d"
    b=str[++ind];x++;
   }
   last=numb;goto homf;
  }
  if(b==' ')     {ind++;x++; goto homf;}
  if(b=='\x0D')  {y++; x=1; ind+=2; goto homf;}
//  if(b=='\x0A')  {ind++; goto homf;}
//  oper=*(unsigned long *)(str+ind);
//  if(oper=='(gsm'||oper=='(rre')
//   for(tmp1=0,ind+=4,x+=4;ind<len;ind++,x++)
//   {
//    if(tmp1==0&&str[ind]!='"')
//    {SetCur(x,y);DispFixErr(0,Text_msg[117],ind);kz=-1; goto end1;}   //"Wrong, two numbers; pos %d"
//    if(str[ind]=='"')tmp1++;
//    if(tmp1==2&&str[ind]==')'){ind++;x++; goto homf;}
//   }

  for(i=0;i<sizeof(func_alg)/sizeof(sfunc_alg);i++)
  {
   len1=strlen(func_alg[i].name);
   if(strncmp(str+ind,func_alg[i].name,len1)) continue;
   if(last==p_koef || last==off_scob || last==p_inp || last==p_outp|| last==numb)
   {SetCur(x,y);DispFixErr(0,Text_msg[6],ind);kz=-1; goto end1;}   //"Wrong, two numbers; pos %d"
   ind+=len1;x+=len1;last=func_alg[i].tip;
   if(last==on_scob) scob++;
   goto homf;
  }

  SetCur(x,y);
  DispFixErr(0,Text_msg[10],b,ind);              //"Invalid formuls; pos %d"
  kz=-1;
 end1:
  if(opt==frmInsKf || opt==frmInsIn || opt==frmDelIn ||
     opt==frmDelKf || opt==frmMovIn || opt==frmMovKf)
  {
   MemData->length=strlen(MemData->buffer);
   MemoFrm->setData(MemData);
  }
  delete MemData;
  return(kz);
}

void TFormulsDialog1::SetCur(int x,int y)
{
 int i;
 MemoFrm->select();
 MemoFrm->setCurPtr(0, 0);
 for(i=1;i<y;i++) MemoFrm->setCurPtr(MemoFrm->lineMove(MemoFrm->curPtr,1), 0);
 for(i=1;i<x;i++) MemoFrm->setCurPtr(MemoFrm->nextChar(MemoFrm->curPtr), 0);
 MemoFrm->draw();
}

int TFormulsDialog1::SelectFormuls(void* source,TEvent& event)
{
 TComboBox *ComboBox = (TComboBox *)source;
 TFormulsDialog1 *Dialog = (TFormulsDialog1 *)ComboBox->owner;

 if(ComboBox->posit) Dialog->TipForm->setState(sfVisible,True);
 else Dialog->TipForm->setState(sfVisible,False);
 Dialog->ViewFixFree();
 Dialog->ViewFormul(Dialog->OldIndChek=Dialog->OldIndChekKf=Dialog->OldIndChekIn=0);
 Dialog->MyTListBox->focusItem(0); Dialog->ListBoxIn->focusItem(0); Dialog->ListBoxKf->focusItem(0);
 return(0);
}

void TFormulsDialog1::ViewFixFree()
{
 int i,ii;
 View_str *V_str;

 ViewColect->freeAll();

 for(i=0;i<FormColect->getCount();i++) if(((frm_str *)FormColect->at(i))->tip==5) break;
 if(ComboBox1->posit)
  for(ii=0;ii<i;ii++)
  {V_str=(View_str *)calloc(1,sizeof(View_str));
   strcpy(V_str->name,((frm_str *)FormColect->at(ii))->name);
   V_str->numb=ii;
   ViewColect->insert(V_str);
  }
 else
  for(ii=i;ii<FormColect->getCount();ii++)
  {V_str=(View_str *)calloc(1,sizeof(View_str));
   strcpy(V_str->name,((frm_str *)FormColect->at(ii))->name);
   V_str->numb=ii;
   ViewColect->insert(V_str);
  }
 MyTListBox->setRange(MyTListBox->list()->getCount());
 MyTListBox->drawView();
}

//=======================================================================================
int TMyApp::LoadAlgAll(char* NameFile,TCompCollect *AlgColect,TCompCollect *FormColect)
{
 int fh,i,ii,iii,x_db=0,ofs_alg=0,n_1=0,n_2=0,n_3=0,len_1=0;
 char *recfil,str_ptr1[25],*out_str,*str;
 long form_amount=0;
 frm_str *formuls;
 alg_str *algobls;

 fh=open(NameFile,O_BIN|O_RDONLY);
 if(fh <= 0) { DispFixErr(1,Text_msg[12],NameFile); return(-1); }
 FormColect->freeAll();
 ::read(fh,&ofs_alg,4);
 ::read(fh,&n_1,2);
 for(iii=0;iii<n_1;iii++)
 {
  ::read(fh,&len_1,1);
  formuls=new frm_str;
  ::read(fh,formuls->name,len_1); formuls->name[len_1]=0;
  ::read(fh,&formuls->tip,1); ::read(fh,&n_2,1); ::read(fh,&n_3,1);
  formuls->inp = new TCompCollect(10,10);

  for(ii=0;ii<n_2;ii++)
  {
   ::read(fh,&len_1,1); str = new char[len_1+1];
   ::read(fh,str,len_1); str[len_1]=0;
   formuls->inp->insert(str);
  }
  formuls->koef = new TCompCollect(10,10);
  for(ii=0;ii<n_3;ii++)
  {
   ::read(fh,&len_1,1); str = new char[len_1+1];
   ::read(fh,str,len_1); str[len_1]=0;
   formuls->koef->insert(str);
  }
  ::read(fh,&x_db,2);
  recfil = new char[x_db+1];
  ::read(fh,recfil,x_db);
  if(formuls->tip==5)
  {
   i=0;
   out_str=(char *)calloc(70000,1); out_str[0]=0;
   while (i<x_db)
   {
    if(*(word *)(recfil+i) =='//')
    {
     for(;(i<x_db && recfil[i]!=0x0D);i++)
//     for(;(i<x_db && recfil[i]!='\n');i++)
     {str_ptr1[0]=recfil[i]; str_ptr1[1]=0; strcat(out_str,str_ptr1); }
     continue;
    }
    if(recfil[i] =='"')
    {
     for(ii=0;i<x_db;i++,ii++)
     {
      str_ptr1[0]=recfil[i]; str_ptr1[1]=0;
      strcat(out_str,str_ptr1);
      if(ii&&recfil[i]=='"') {i++; break;}
     }
     continue;
    }

    if(recfil[i]=='K')
    {str_ptr1[0]='K'; sprintf(str_ptr1+1,"%d",(byte)recfil[i+1]+1);   //  itoa((byte)recfil[i+1]+1,str_ptr1+1,10);
     strcat(out_str,str_ptr1); i+=2; continue;
    }
    if(recfil[i]=='X')
    {str_ptr1[0]='X'; sprintf(str_ptr1+1,"%d",(byte)recfil[i+1]+1);   //  itoa((byte)recfil[i+1]+1,str_ptr1+1,10);
     strcat(out_str,str_ptr1); i+=2; continue;
    }
    if(recfil[i]=='C')
    {
#ifdef __QNX__
     sprintf(str_ptr1,"%.0f",*(float *)(recfil+i+1));
#else
     gcvt(*(float *)(recfil+i+1),6,str_ptr1);
#endif
     strcat(out_str,str_ptr1); i+=5; continue;
    }
    if(recfil[i]=='Y')
    {str_ptr1[0]='Y'; str_ptr1[1]=0;
     strcat(out_str,str_ptr1); i+=1; continue;
    }
    str_ptr1[0]=recfil[i]; str_ptr1[1]=0;
    strcat(out_str,str_ptr1); i++;
   }
   delete recfil;
   out_str=(char *)realloc(out_str,strlen(out_str)+1);
   formuls->formul=out_str;
  }
  else {recfil[x_db]=0; formuls->formul=recfil;}
  FormColect->insert(formuls);
 }

 AlgColect->freeAll();
 lseek(fh,0,SEEK_SET); lseek(fh,ofs_alg,SEEK_SET);
 ::read(fh,&n_1,2);
 for(i=0;i<n_1;i++)
 {
  algobls = new alg_str;
  ::read(fh,algobls->name,9); algobls->name[9]=0;
  ::read(fh,&len_1,1); algobls->disript=(char *)calloc(len_1+1,1);
  ::read(fh,algobls->disript,len_1);
  ::read(fh,&algobls->form,2);
  algobls->inp = new TCompCollect(10,10);
  n_2=((frm_str *)FormColect->at(algobls->form))->inp->getCount();
  for(ii=0;ii<n_2;ii++)
  {
   str = (char *)calloc(10,1); ::read(fh,str,9);
   algobls->inp->insert(str);
  }
  algobls->koef = new TCompCollect(10,10);
  n_3=((frm_str *)FormColect->at(algobls->form))->koef->getCount();
  for(ii=0;ii<n_3;ii++)
  {
   str = new char[4]; ::read(fh,str,4);
   algobls->koef->insert(str);
  }
  AlgColect->insert(algobls);
 }
 close(fh);
 return(0);
}
//--------------------------------------------------------
void TMyApp::FreeAlgAll(TCompCollect *AlgColect,TCompCollect *FormColect)
{
 int i;

 if(FormColect!=NULL)
 {
  for(i=0;i<FormColect->getCount();i++)
  {
   ((frm_str *)FormColect->at(i))->inp->freeAll();
   delete ((frm_str *)FormColect->at(i))->inp;
   ((frm_str *)FormColect->at(i))->koef->freeAll();
   delete ((frm_str *)FormColect->at(i))->koef;
   free(((frm_str *)FormColect->at(i))->formul);
  }
  FormColect->freeAll();
  delete FormColect;
 }

 if(AlgColect!=NULL)
 {
  for(i=0;i<AlgColect->getCount();i++)
  {
   free( ((alg_str *)AlgColect->at(i))->disript );
   ((alg_str *)AlgColect->at(i))->inp->freeAll();
   delete ((alg_str *)AlgColect->at(i))->inp;
   ((alg_str *)AlgColect->at(i))->koef->freeAll();
   delete ((alg_str *)AlgColect->at(i))->koef;
  }
  AlgColect->freeAll();
  delete AlgColect;
 }
}
//--------------------------------------------------------------------------------
void TMyApp::SaveAlgAllHdd(char* NameFile,TCompCollect *AlgColect,TCompCollect *FormColect)
{
 char *str;
 int i,ii,hd,tmp=0,n_1=0,n_2=0,counter,len;
 TCompCollect *col1;
 alg_str *algobls;

 str=(char *)calloc(65537,1);

 hd=open(NameFile,O_BIN|O_RDWR|O_CREAT|O_TRUNC,S_IWRITE);
 lseek(hd,4,SEEK_SET);                                 //ᤢ

 if(FormColect==NULL) {tmp=0; ::write(hd,&tmp,2);}
 else
 {
  tmp=FormColect->getCount(); ::write(hd,&tmp,2);
  for(i=0;i<FormColect->getCount();i++)
  {
   tmp=strlen(((frm_str *)FormColect->at(i))->name); ::write(hd,&tmp,1);
   ::write(hd,((frm_str *)FormColect->at(i))->name,tmp);
   ::write(hd,&((frm_str *)FormColect->at(i))->tip,1);
   n_1=((frm_str *)FormColect->at(i))->inp->getCount();  ::write(hd,&n_1,1);
   n_2=((frm_str *)FormColect->at(i))->koef->getCount(); ::write(hd,&n_2,1);
   col1=((frm_str *)FormColect->at(i))->inp;
   for(tmp=0,ii=0;ii<n_1;ii++)
   {
    tmp=strlen((char *)col1->at(ii)); ::write(hd,&tmp,1);
    ::write(hd,(char *)col1->at(ii),tmp);
   }
   col1=((frm_str *)FormColect->at(i))->koef;
   for(tmp=0,ii=0;ii<n_2;ii++)
   {
    tmp=strlen((char *)col1->at(ii)); ::write(hd,&tmp,1);
    ::write(hd,(char *)col1->at(ii),tmp);
   }
   if(((frm_str *)FormColect->at(i))->tip==5)
   {
    if((len=ConvertFormul1(((frm_str *)FormColect->at(i))->formul,str))==-1)
    {DispFixErr(0,Text_msg[17]);close(hd);return;}
    ::write(hd,&len,2); ::write(hd,str,len);
   }
   else
   {len=strlen(((frm_str *)FormColect->at(i))->formul);
    ::write(hd,&len,2); ::write(hd,((frm_str *)FormColect->at(i))->formul,len);
   }
  }
 }
 counter=lseek(hd,0,SEEK_CUR);
// counter=tell(hd);
 if(AlgColect==NULL) {tmp=0; ::write(hd,&tmp,2);}
 else
 {
  tmp=AlgColect->getCount(); ::write(hd,&tmp,2);
  for(i=0;i<AlgColect->getCount();i++)
  {
   algobls=(alg_str *)AlgColect->at(i);
   ::write(hd,algobls->name,9);
   tmp=strlen(algobls->disript); ::write(hd,&tmp,1);
   ::write(hd,algobls->disript,tmp);
   ::write(hd,&algobls->form,2);
   n_2=((frm_str *)FormColect->at(algobls->form))->inp->getCount();
   for(ii=0;ii<n_2;ii++) ::write(hd,(char *)algobls->inp->at(ii),9);
   n_2=((frm_str *)FormColect->at(algobls->form))->koef->getCount();
   for(ii=0;ii<n_2;ii++) ::write(hd,(char *)algobls->koef->at(ii),4);
  }
 }
 lseek(hd,0,SEEK_SET); ::write(hd,&counter,4); close(hd); free(str);
}
//---------------------------------------------------------------------------------
int TMyApp::ConvertFormul1(char *str_src,char *str_dest)
{
 char *str2,str_temp[20];
 int len,ii=0,iii,i;

 str2=str_dest;
 len=strlen(str_src);
 while(ii<len )
 {
  if(*(word *)(str_src+ii) =='//')
//  { for(;(ii<len && str_src[ii]!='\n');) *(str2++)=str_src[ii++]; continue; }
  { for(;(ii<len && str_src[ii]!=0x0D);) *(str2++)=str_src[ii++]; continue; }
  if(str_src[ii] =='"')
  {
   for(iii=0;(ii<len);ii++,str2++,iii++)
   {*(str2)=str_src[ii];
    if(iii&&str_src[ii]=='"') {ii++;str2++; break;}
   }
   continue;
  }
  if(str_src[ii]=='X')
  {
   *str2='X';
   for(i=0,++ii;(ii+i)<len;i++) if(str_src[ii+i]<'0' || str_src[ii+i]>'9') break;
   strncpy(str_temp,&str_src[ii],i); str_temp[i]=0;
   *(++str2)=(byte)(atoi(str_temp)-1);
   str2++;ii+=i;
   continue;
  }
  if(str_src[ii]=='Y')
  {
   *str2='Y';
   str2++;ii++;
   continue;
  }
  if(str_src[ii]=='K')
  {
   *str2='K';
   for(i=0,++ii;(ii+i)<len;i++) if(str_src[ii+i]<'0' || str_src[ii+i]>'9') break;
   strncpy(str_temp,&str_src[ii],i); str_temp[i]=0;
   *(++str2)=(byte)atoi(str_temp)-1;
   str2++;ii+=i;
   continue;
  }
  if((str_src[ii]>='0' && str_src[ii]<='9')|| str_src[ii]=='.')
  {
   *str2='C';
   iii=0;
   while((str_src[ii+iii]>='0' && str_src[ii+iii]<='9')|| (str_src[ii+iii]=='.'))iii++;
   strncpy(str_temp,str_src+ii,iii);
   str_temp[iii]=0;
   *(float *)(++str2)=(float)atof(str_temp);

   str2+=4;ii+=iii;
   continue;
  }
  *(str2++)=str_src[ii++];
 }
 if((str2-str_dest)>65536)return(-1);
 return(str2-str_dest);
}
//---------------------------------------------------------------------------
