#define Uses_TRect
#define Uses_TView
#define Uses_TDrawBuffer
#include <tv.h>

#ifdef __DOS32__
 #include <i86.h>
#endif

#include <sys/stat.h>
#include <time.h>
#include <stdio.h>
#include <string.h>

#include "alg.h"
#include "alg_cfg.h"
#include "gadgets.h"

#ifdef __DOS32__
 extern "C" long size_free_mem();
#endif
//
// -------------- Clock Viewer functions


TClockView::TClockView( TRect& r ) : TView( r )
{
    strcpy(lastTime, "        ");
    strcpy(curTime, "        ");
}

void TClockView::draw()
{
    TDrawBuffer buf;
    char c = getColor(2);

//    buf.moveChar(0, '*', c, size.x);
    buf.moveStr(0, curTime, c);
    writeLine(0, 0, size.x, 1, buf);
}


void TClockView::update()
{
    time_t t = time(0);
    char *date = ctime(&t);

    TRect r  = getBounds();
    TRect r1 = myApp->getExtent();    
    if(r.a.x != r1.b.x-8 || r.b.y != r1.a.y+1) 
    {
       r1.a.x = r1.b.x-8;  
       r1.b.y = r1.a.y+1;
       setBounds(r1);
       drawView();
    }            
    
    date[19] = '\0';
    strcpy(curTime, &date[11]);        /* Extract time. */

    if( strcmp(lastTime, curTime) )
    {
     drawView();
     strcpy(lastTime, curTime);
    }
}
//Theap

THeapView::THeapView(TRect& r) : TView( r )
{
    oldMem = 0;
    newMem = heapSize();
}

void THeapView::draw()
{
    TDrawBuffer buf;
    char c = getColor(2);

    buf.moveChar(0, ' ', c, size.x);
    buf.moveStr(0, heapStr, c);
    writeLine(0, 0, size.x, 1, buf);
}

void THeapView::update()
{
   TRect r  = getBounds();
   TRect r1 = myApp->getExtent();    
   if(r.a.x != r1.b.x-8 || r.a.y != r1.b.y-1) 
   {    
      r1.a.x = r1.b.x-8;  
      r1.a.y = r1.b.y-1;
      setBounds(r1);
      drawView();
   }            
  
   if( (newMem = heapSize()) != oldMem )
   { oldMem = newMem; drawView(); }
}


long THeapView::heapSize()
{
#ifdef __DOS32__
  long size;

  size=size_free_mem();
  sprintf(heapStr,"%d",size/1000);
  return(size/1000);
#else
//  struct stat st;
//  int rval=0;

//  if (stat("/proc", &st)==0) rval=st.st_size;

//  if (rval>1024*512) sprintf(heapStr, "%dK", rval/1024);
//  else sprintf(heapStr, "%d", rval);
//  return rval;
  sprintf(heapStr,"     LNX");
  return(0);
#endif
}

