#include "alg.h"
#include "mylib.h"
#include "alg_cfg.h"
#include "demohelp.h"
#include "signal.h"

TSignalDialog::TSignalDialog( ) :
               TDialog( TRect( 0, 0, 51, 17 ),""),
               TWindowInit( TSignalDialog::initFrame )
{
 char str[256];

 options |= ofCentered;
 helpCtx=hcAllASave;

 getcwd(PathDir,sizeof(PathDir));

 sprintf(str,Text_msg[36],PathDir);
 title=newStr(str);

 TView *Monosel = new TView(TRect(14,2,49,3)); Monosel->options |= ofFramed; insert(Monosel);
 Monosel = new TView(TRect(14,4,24,13)); Monosel->options |= ofFramed; insert(Monosel);
 Monosel = new TView(TRect(25,4,37,13)); Monosel->options |= ofFramed; insert(Monosel);
 Monosel = new TView(TRect(38,4,49,13)); Monosel->options |= ofFramed; insert(Monosel);

 SignColect = new TCompCollect(10,10);
 myApp->LoadSignal(PathDir,SignColect);

 ScrollBar1 = new TScrollBar( TRect( 11, 2, 12, 13) ); insert(ScrollBar1);
 MyTListBox1 = new TMyTListBox(TRect( 2, 2, 11, 13), 1, ScrollBar1,NULL); insert(MyTListBox1);
 MyTListBox1->helpCtx=hcMax;
 TMyLabel *Label = new TMyLabel(TRect(2, 1, 12, 2),"ꥪ",MyTListBox1,1); insert(Label);
 MyTListBox1->newList(SignColect);

 EditDs = new TEdit( TRect(34, 2, 43, 3),10,SelectInput); insert(EditDs);
 Label = new TMyLabel(TRect(14, 2, 34, 3)," ᨣ樨",EditDs,1); insert(Label);

 MnemColect = new TCompCollect(10,10);
 ScrollBar2 = new TScrollBar( TRect( 22, 4, 23, 13) ); insert(ScrollBar2);
 MyTListBox2 = new TMyTListBox(TRect( 14, 4, 22, 13), 1, ScrollBar2,NULL); insert(MyTListBox2);
 MyTListBox2->helpCtx=hcMax;
 Label = new TMyLabel(TRect(14, 3, 24, 4),"奬",MyTListBox2,1); insert(Label);
 MyTListBox2->newList(MnemColect);

 GrafColect = new TCompCollect(10,10);
 ScrollBar3 = new TScrollBar( TRect( 35, 4, 36, 13) ); insert(ScrollBar3);
 MyTListBox3 = new TMyTListBox(TRect( 26, 4, 35, 13), 1, ScrollBar3,NULL); insert(MyTListBox3);
 MyTListBox3->helpCtx=hcMax;
 Label = new TMyLabel(TRect(27, 3, 34, 4),"䨪",MyTListBox3,1); insert(Label);
 MyTListBox3->newList(GrafColect);

 ConturColect = new TCompCollect(10,10);
 ScrollBar4 = new TScrollBar( TRect( 48, 4, 49, 13) ); insert(ScrollBar4);
 MyTListBox4 = new TMyTListBox(TRect( 39, 4, 48, 13), 1, ScrollBar4,NULL); insert(MyTListBox4);
 MyTListBox4->helpCtx=hcMax;
 Label = new TMyLabel(TRect(40, 3, 47, 4),"",MyTListBox4,1); insert(Label);
 MyTListBox4->newList(ConturColect);

 TButton *Button = new TButton( TRect( 25,14, 35, 16),Text_msg[115], cmOK, bfDefault ); insert(Button);
 Button = new TButton( TRect( 37,14, 47, 16),Text_msg[114], cmCancel, bfNormal ); insert(Button);

 OldIndChek=0;
 ViewSignal(OldIndChek);

 MyTListBox1->select();

 Modif=False;
 Modifs=False;
}

TSignalDialog::~TSignalDialog()
{
 myApp->FreeSignal(SignColect);
 myApp->FreeColect(SignColect);
 myApp->FreeColect(MnemColect);
 myApp->FreeColect(GrafColect);
 myApp->FreeColect(ConturColect);
}

void TSignalDialog::handleEvent ( TEvent& event )
{
 int i,k1;
 char *str1,*str4;
 ushort control;
 object *obj;
 TCompCollect *TempColect;

 if( event.what == evCommand && event.message.command == cmClose)
 {
  if(Modif || Modifs)
  {
   control = messageBox(Text_msg[26],mfWarning | mfOKCancel);
   if(control==cmOK)
   {
    if(Modif) SaveChengeSignal(MyTListBox1->focused);
    myApp->SaveSignalHdd(PathDir,SignColect);                                                  //?
   }
  }
 }

 TDialog::handleEvent(event);
#ifdef __DOS32__
 if( event.what == evBroadcast && event.message.command == cmGetBuf) Modif=True;
#endif
 if( event.what == evBroadcast && event.message.command == cmScrollBarChanged) //List ListBox
 {
  if(MyTListBox1->state & sfFocused)    // ListBox1
  {
   if(Modif)
   {
    control = messageBox(mfWarning | mfOKCancel,"㯯 . ࠭ ?");
    if(control==cmOK)
    {
     SaveChengeSignal(OldIndChek);
     Modifs=True;
    }
    Modif=False;
   }
#ifdef __DOS32__
   if(getShiftState() & (kbLeftShift|kbRightShift))
   {
    str1=(char *)MyTListBox1->list()->at(OldIndChek);
    str4=(char *)MyTListBox1->list()->at(MyTListBox1->focused);
    MyTListBox1->list()->atRemove(OldIndChek);
    MyTListBox1->list()->atInsert(OldIndChek,str4);
    MyTListBox1->list()->atRemove(MyTListBox1->focused);
    MyTListBox1->list()->atInsert(MyTListBox1->focused,str1);
    MyTListBox1->drawView();
    Modifs=True;
   }
#endif
   ViewSignal(MyTListBox1->focused);
   clearEvent(event);
   OldIndChek=MyTListBox1->focused;
  }
  if(MyTListBox2->state & sfFocused)    // ListBox1
  {
#ifdef __DOS32__
   if(getShiftState() & (kbLeftShift|kbRightShift))
   {
    str1=(char *)MyTListBox2->list()->at(OldIndChek2);
    str4=(char *)MyTListBox2->list()->at(MyTListBox2->focused);
    MyTListBox2->list()->atRemove(OldIndChek2);
    MyTListBox2->list()->atInsert(OldIndChek2,str4);
    MyTListBox2->list()->atRemove(MyTListBox2->focused);
    MyTListBox2->list()->atInsert(MyTListBox2->focused,str1);
    MyTListBox2->drawView();
    Modif=True;
   }
#endif
   OldIndChek2=MyTListBox2->focused;
  }
  if(MyTListBox3->state & sfFocused)    // ListBox1
  {
#ifdef __DOS32__
   if(getShiftState() & (kbLeftShift|kbRightShift))
   {
    str1=(char *)MyTListBox3->list()->at(OldIndChek3);
    str4=(char *)MyTListBox3->list()->at(MyTListBox3->focused);
    MyTListBox3->list()->atRemove(OldIndChek3);
    MyTListBox3->list()->atInsert(OldIndChek3,str4);
    MyTListBox3->list()->atRemove(MyTListBox3->focused);
    MyTListBox3->list()->atInsert(MyTListBox3->focused,str1);
    MyTListBox3->drawView();
    Modif=True;
   }
#endif
   OldIndChek3=MyTListBox3->focused;
  }
  if(MyTListBox4->state & sfFocused)    // ListBox1
  {
#ifdef __DOS32__
   if(getShiftState() & (kbLeftShift|kbRightShift))
   {
    str1=(char *)MyTListBox4->list()->at(OldIndChek4);
    str4=(char *)MyTListBox4->list()->at(MyTListBox4->focused);
    MyTListBox4->list()->atRemove(OldIndChek4);
    MyTListBox4->list()->atInsert(OldIndChek4,str4);
    MyTListBox4->list()->atRemove(MyTListBox4->focused);
    MyTListBox4->list()->atInsert(MyTListBox4->focused,str1);
    MyTListBox4->drawView();
    Modif=True;
   }
#endif
   OldIndChek4=MyTListBox4->focused;
  }
 }

 if( event.what == evCommand )
 {
  switch( event.message.command )
  {
   case cmOK:
        SaveChengeSignal(MyTListBox1->focused);
        Modif=False;
        Modifs=True;
        clearEvent(event);
        break;
   case cmCancel:
        ViewSignal(MyTListBox1->focused);
        clearEvent(event);
        Modif=False;
        break;
   case cmReLoad:
        control = messageBox(mfWarning | mfOKCancel,Text_msg[38]);
        if(control!=cmOK) break;
        myApp->LoadSignal(PathDir,SignColect);
        MyTListBox1->setRange( MyTListBox1->list()->getCount());
        MyTListBox1->focusItem(OldIndChek=0);
        ViewSignal(OldIndChek);
        Modif=Modifs=False;
        break;
   case cmSave1:
        control = messageBox(mfWarning | mfOKCancel,Text_msg[37]);
        if(control!=cmOK) break;
        SaveChengeSignal(MyTListBox1->focused);
        myApp->SaveSignalHdd(PathDir,SignColect);
        Modif=Modifs=False;
        break;
   case cmInsert:
   case cmAdd:
   case cmRename:
        if(MyTListBox1->state & sfFocused)    // ListBox1
        {
         obj=(object *)calloc(1,sizeof(object));
         if(event.message.command==cmRename)
         {
          if(!MyTListBox1->list()->getCount())break;
          strncpy(obj->cipher,((object *)MyTListBox1->list()->at(MyTListBox1->focused))->cipher,9);
         }
         control = inputBox(" ", "㯯",obj->cipher, 9);
         if(event.message.command!=cmRename) strncpy(obj->ciph_ds,Text_msg[49],9);
         if(control==cmOK)
         {
          for(i=0;i<SignColect->getCount();i++)
           if(!strncmp(obj->cipher,((object *)SignColect->at(i))->cipher,9)){ i= -1; break;}
          if(i== -1){ DispFixErr(0,Text_msg[15],obj->cipher); free(obj); break;}

          if(event.message.command==cmAdd) k1 = MyTListBox1->list()->getCount();
          if(event.message.command==cmInsert || event.message.command==cmRename) k1 = MyTListBox1->focused;
          if(event.message.command==cmRename)
           strncpy(((object *)MyTListBox1->list()->at(k1))->cipher,obj->cipher,9);
          else MyTListBox1->list()->atInsert(k1,obj);

          MyTListBox1->setRange( MyTListBox1->list()->getCount() );
          MyTListBox1->drawView();
          ViewSignal(MyTListBox1->focused);
          Modifs=True;
         }
         else free(obj);
        }

        if(event.message.command==cmInsert) k1 = 0;
        if(event.message.command==cmRename) k1 = 1;
        if(event.message.command==cmAdd)    k1 = 2;
        if(MyTListBox2->state & sfFocused)    // 奬
        {
         if(event.message.command==cmRename) if(!MyTListBox2->list()->getCount())break;
         myApp->LoadMsh(PathDir,&TempColect);
         OperList(MyTListBox2,TempColect,k1);
         myApp->FreeMsh(TempColect);
        }

        if(MyTListBox3->state & sfFocused)    // 㯯 䨪
        {
         if(event.message.command==cmRename) if(!MyTListBox3->list()->getCount())break;
         LoadDbfName(NameGrg,&TempColect);
         OperList(MyTListBox3,TempColect,k1);
         myApp->FreeColect(TempColect);
        }

        if(MyTListBox4->state & sfFocused)    // 㯯 䨪
        {
         if(event.message.command==cmRename) if(!MyTListBox4->list()->getCount())break;
         LoadDbfName(NameGrc,&TempColect);
         OperList(MyTListBox4,TempColect,k1);
         myApp->FreeColect(TempColect);
        }
        clearEvent(event);
        break;
   case cmDelete:
        if(MyTListBox1->state & sfFocused)    // ListBox1
        {
         if(!MyTListBox1->list()->getCount())break;
         MyTListBox1->list()->atFree(MyTListBox1->focused);
         MyTListBox1->setRange( MyTListBox1->list()->getCount() );
         MyTListBox1->drawView();
         ViewSignal(MyTListBox1->focused);
         Modifs=True;
        }
        if(MyTListBox2->state & sfFocused)    // 奬
        {
         if(!MyTListBox2->list()->getCount())break;
         MyTListBox2->list()->atFree(MyTListBox2->focused);
         MyTListBox2->setRange( MyTListBox2->list()->getCount() );
         MyTListBox2->drawView();
         Modif=True;
        }
        if(MyTListBox3->state & sfFocused)    // 奬
        {
         if(!MyTListBox3->list()->getCount())break;
         MyTListBox3->list()->atFree(MyTListBox3->focused);
         MyTListBox3->setRange( MyTListBox3->list()->getCount() );
         MyTListBox3->drawView();
         Modif=True;
        }
        if(MyTListBox4->state & sfFocused)    // 奬
        {
         if(!MyTListBox4->list()->getCount())break;
         MyTListBox4->list()->atFree(MyTListBox4->focused);
         MyTListBox4->setRange( MyTListBox4->list()->getCount() );
         MyTListBox4->drawView();
         Modif=True;
        }
        clearEvent(event);
        break;
   default: ;
  }
 }
}

void TSignalDialog::ViewSignal(int item)
{
 int i;
 char *str;

 if(SignColect->getCount()<=item) return;

 MyTListBox2->list()->freeAll();
 MyTListBox3->list()->freeAll();
 MyTListBox4->list()->freeAll();
 OldIndChek2=OldIndChek3=OldIndChek4=0;

 EditDs->setData(((object *)SignColect->at(item))->ciph_ds);
 for(i=0;i<((object *)SignColect->at(item))->n_ms;i++)
 {
  str = new char[9]; strncpy(str,(( (object *)SignColect->at(item) )->ciph_ms+i)->name,7);
  MyTListBox2->list()->insert(str);
 }
 for(i=0;i<((object *)SignColect->at(item))->n_gr_c;i++)
 {
  str = new char[9]; strncpy(str,(( (object *)SignColect->at(item) )->ciph_gr_c+i)->name,8);
  MyTListBox4->list()->insert(str);
 }
 for(i=0;i<((object *)SignColect->at(item))->n_gr_g;i++)
 {
  str = new char[9]; strncpy(str,(( (object *)SignColect->at(item) )->ciph_gr_g+i)->name,8);
  MyTListBox3->list()->insert(str);
 }

 MyTListBox2->setRange( MyTListBox2->list()->getCount()); MyTListBox2->drawView(); MyTListBox2->focusItem(0);
 MyTListBox3->setRange( MyTListBox3->list()->getCount()); MyTListBox3->drawView(); MyTListBox3->focusItem(0);
 MyTListBox4->setRange( MyTListBox4->list()->getCount()); MyTListBox4->drawView(); MyTListBox4->focusItem(0);
}

int TSignalDialog::SelectInput(void* source,TEvent& event)
{
 TEdit *Edit = (TEdit *)source;
 TSignalDialog *Dialog = (TSignalDialog *)Edit->owner;
 ushort control;

 if(event.what == evKeyboard)
  switch(event.keyDown.keyCode)
  {
   case 0x3920:
     control = myApp->execView( myApp->SelDialog = new TSelDialog(Dialog->PathDir,4,((TEdit *)source)->data));
     if(control==cmOK)
     {
      ((TEdit *)source)->setData( (char *)myApp->SelDialog->Colect2->at(myApp->SelDialog->ListBox2->focused) );
      Dialog->Modif=True;
     }
     destroy(myApp->SelDialog);
     break;
   case kbDel: ((TEdit *)source)->setData(Text_msg[49]); Dialog->Modif=True; break;
  }
 return(1);
}

void TSignalDialog::SaveChengeSignal(int item)
{
 int ii;
 object *obj;

 obj=(object *)SignColect->at(item);

 strncpy(obj->ciph_ds,EditDs->data,9);
 obj->n_ms   = MyTListBox2->list()->getCount();
 obj->n_gr_c = MyTListBox4->list()->getCount();
 obj->n_gr_g = MyTListBox3->list()->getCount();

 if(obj->ciph_ms)   free(obj->ciph_ms);
 if(obj->ciph_gr_c) free(obj->ciph_gr_c);
 if(obj->ciph_gr_g) free(obj->ciph_gr_g);

 if(obj->n_ms)   obj->ciph_ms=(str8 *)calloc(obj->n_ms,sizeof(str8)); else obj->ciph_ms=NULL;
 if(obj->n_gr_c) obj->ciph_gr_c=(str9 *)calloc(obj->n_gr_c,sizeof(str9)); else obj->ciph_gr_c=NULL;
 if(obj->n_gr_g) obj->ciph_gr_g=(str9 *)calloc(obj->n_gr_g,sizeof(str9)); else obj->ciph_gr_g=NULL;

 for(ii=0;ii<obj->n_ms;ii++) strncpy((obj->ciph_ms+ii)->name,(char *)MyTListBox2->list()->at(ii),7);
 for(ii=0;ii<obj->n_gr_c;ii++) strncpy((obj->ciph_gr_c+ii)->name,(char *)MyTListBox4->list()->at(ii),8);
 for(ii=0;ii<obj->n_gr_g;ii++) strncpy((obj->ciph_gr_g+ii)->name,(char *)MyTListBox3->list()->at(ii),8);
}

//===================================================================================

void TMyApp::LoadSignal(char *Path,TCompCollect *Colect)
{
 int hd,i,ii,amount;
 word len;
 char str[256],x_db;
 object *obj;

 Colect->freeAll();

 sprintf(str,Text_msg[109],Path,NameSign);
 if((hd=open(str,O_BIN|O_RDONLY))>0)
 {
  for(amount=0;;)
  {
   if(::read(hd,&x_db,1)==-1) goto exit_fr;
   if(x_db==0x55)break;
   if(x_db!=0x0D)goto exit_fr;

   ::read(hd,&len,2);
   amount++;
   if((lseek(hd,len,SEEK_CUR)==-1) && (errno==EINVAL)) goto exit_fr;
  }
  lseek(hd,0,SEEK_SET);
  for(i=0;i<amount;i++)
  {
   obj=(object *)calloc(1,sizeof(object));

   lseek(hd,1,SEEK_CUR);
   ::read(hd,&len,2);
   ::read(hd,obj->cipher,9);
   ::read(hd,obj->ciph_ds,9);
   ::read(hd,&(obj->n_ms),1);
   ::read(hd,&(obj->n_gr_c),1);
   ::read(hd,&(obj->n_gr_g),1);
   if(obj->n_ms) { obj->ciph_ms=(str8 *)calloc(obj->n_ms,sizeof(str8)); ::read(hd,obj->ciph_ms,obj->n_ms*sizeof(str8));}
   else obj->ciph_ms=NULL;
   if(obj->n_gr_c) {obj->ciph_gr_c=(str9 *)calloc(obj->n_gr_c,sizeof(str9)); ::read(hd,obj->ciph_gr_c,obj->n_gr_c*sizeof(str9));}
   else obj->ciph_gr_c=NULL;
   if(obj->n_gr_g) {obj->ciph_gr_g=(str9 *)calloc(obj->n_gr_g,sizeof(str9)); ::read(hd,obj->ciph_gr_g,obj->n_gr_g*sizeof(str9));}
   else obj->ciph_gr_g=NULL;

   (Colect)->insert(obj);
  }
 exit_fr:
  close(hd);
  return;
 }

 TBasaDBF *basa = new TBasaDBF();
 sprintf(str,Text_msg[109],Path,NameSign1);
 if(basa->LoadFile(str)== -1){ delete basa; return;}
 amount=basa->GetCountItems();
 for(i=0; i< amount; i++)
 {
  obj=(object *)calloc(1,sizeof(object));

  basa->GetFieldIt(i,"SHIFR",obj->cipher);
  basa->GetFieldIt(i,"SH_DS",obj->ciph_ds);
  basa->GetFieldIt(i,"NUMBER_M",str);obj->n_ms = atoi(str);
  basa->GetFieldIt(i,"NUMBER_C",str);obj->n_gr_c = atoi(str);
  basa->GetFieldIt(i,"NUMBER_G",str);obj->n_gr_g = atoi(str);
  if(obj->n_ms)   obj->ciph_ms=(str8 *)calloc(obj->n_ms,sizeof(str8)); else obj->ciph_ms=NULL;
  if(obj->n_gr_c) obj->ciph_gr_c=(str9 *)calloc(obj->n_gr_c,sizeof(str9)); else obj->ciph_gr_c=NULL;
  if(obj->n_gr_g) obj->ciph_gr_g=(str9 *)calloc(obj->n_gr_g,sizeof(str9)); else obj->ciph_gr_g=NULL;

  for(ii=0;ii<obj->n_ms;ii++)
  {
   sprintf(str,"SH_M%d",ii+1);
   basa->GetFieldIt(i,str,((obj->ciph_ms+ii)->name));
  }
  for(ii=0;ii<obj->n_gr_c;ii++)
  {
   sprintf(str,"SH_C%d",ii+1);
   basa->GetFieldIt(i,str,((obj->ciph_gr_c+ii)->name));
  }
  for(ii=0;ii<obj->n_gr_g;ii++)
  {
   sprintf(str,"SH_G%d",ii+1);
   basa->GetFieldIt(i,str,((obj->ciph_gr_g+ii)->name));
  }
  (Colect)->insert(obj);
 }
 delete basa;
}

//--------------------------------------------------------------------------------

void TMyApp::FreeSignal(TCompCollect *Colect)

{
 object *obj;
 int i;

 for(i=0;i<Colect->getCount();i++)
 {
  obj = (object *)Colect->at(i);
  if(obj->ciph_ms) free(obj->ciph_ms);
  if(obj->ciph_gr_c) free(obj->ciph_gr_c);
  if(obj->ciph_gr_g) free(obj->ciph_gr_g);
 }
}

//--------------------------------------------------------------------------------
void TMyApp::SaveSignalHdd(char* Path,TCompCollect *Colect)
{
 char str[256];
 FILE *hd;
 int len;
 object *obj;

 sprintf(str,Text_msg[109],Path,NameSign);
 if((hd=fopen(str,"wb"))==NULL){DispFixErr(1,Text_msg[12],str); return;}

 for(int i=0;i<Colect->getCount();i++)
 {
  obj=(object *)Colect->at(i);
  putc(0x0D,hd);
  len=9+9+3+obj->n_ms*sizeof(str8)+obj->n_gr_c*sizeof(str9)+obj->n_gr_g*sizeof(str9);

  fwrite(&len,1,2,hd);
  fwrite(obj->cipher,9,1,hd);
  fwrite(obj->ciph_ds,9,1,hd);
  fwrite(&(obj->n_ms),1,1,hd);
  fwrite(&(obj->n_gr_c),1,1,hd);
  fwrite(&(obj->n_gr_g),1,1,hd);
  fwrite(obj->ciph_ms,obj->n_ms,sizeof(str8),hd);
  fwrite(obj->ciph_gr_c,obj->n_gr_c,sizeof(str9),hd);
  fwrite(obj->ciph_gr_g,obj->n_gr_g,sizeof(str9),hd);
 }
 putc(0x55,hd);
 fclose(hd);
}
//--------------------------------------------------------------------------------

void TSignalDialog::LoadDbfName(char *Name,TCompCollect **TempColect)
{
 int i;
 char str[256], *str1;

 TBasaDBF *basa = new TBasaDBF();
 *TempColect = new TCompCollect(10,10);
 sprintf(str,Text_msg[109],PathDir,Name);
 basa->LoadFile(str);
 for(i=0;i<basa->GetCountItems();i++)
 {
  str1 = new char[9];
  basa->GetFieldIt(i,"SHIFR",str1);
  (*TempColect)->insert(str1);
 }
 delete basa;
}

void TSignalDialog::OperList(TMyTListBox *MyTListBox,TCompCollect *TempColect,int oper)
{
 TRect r1,p;
 ushort control;
 char *str;

 r1 = MyTListBox->getBounds();
 r1.a.x -= 10; r1.b.x -= 8;
 p = getExtent(); r1.intersect( p );
 TComboBoxWindow *ComboWin = new TComboBoxWindow(r1,TempColect,0);
 control = execView(ComboWin);
 if(control==cmOK)
 {
  if(oper==1)
   strncpy((char *)MyTListBox->list()->at(MyTListBox->focused),((domineed *)TempColect->at(ComboWin->selpos))->IMJ,8);
  if(!oper || oper==2)
  {
   str = new char[9];
   strncpy(str,((domineed *)TempColect->at(ComboWin->selpos))->IMJ,8);
   if(!oper) MyTListBox->list()->atInsert(MyTListBox->focused,str);
   else MyTListBox->list()->insert(str);
  }
  MyTListBox->setRange( MyTListBox->list()->getCount());
  MyTListBox->drawView();
  Modif=True;
 }
 delete ComboWin;
}
