#include "alg.h"
#include "mylib.h"
#include "alg_cfg.h"
#include "demohelp.h"
#include "speak.h"

extern "C" int SB_Lib_via( char * File_Name );
extern "C" char SB_Installed;
extern "C" int sinth(char *str2,char **str4,char lng);
extern "C" int hear(char *str);
extern "C" int SB_via(char *wav);
extern "C" int SB_Initialize();

db_str_rec sp_dbf[] =
{
 {"SHIFR",'C',0,9,0}, {"NC",'N',0,1,0}, {"TIP",'N',0,1,0}, {"NZP",'C',0,4,0},
 {"COD_O",'N',0,2,0}, {"TEXT_S",'C',0,80,0}, {"TEXT_R",'C',0,80,0},{"PRIORITET",'N',0,2,0}, {"LNG",'C',0,2,0},
};

char *an_mes[]=
{
 ": <  孮᪮ ࠭",
 ": > 孥 孮᪮ ࠭",
 ": <  ਩ ࠭",
 ": > 孥 ਩ ࠭",
};
char *dig1_mes[]=
{
 ": < ",
 ": > ",
 ": < ",
 ": > ",
 ": > ",
};

char *dig2_mes[]=
{
 ": ",
 ": ",
};


TSpeakDialog::TSpeakDialog( ) :
               TDialog( TRect( 0, 0, 80, 14 ),""),
               TWindowInit( TSpeakDialog::initFrame )
{
 char str[256], *str1;
 int i;

 options |= ofCentered;
 helpCtx=hcAllASave;

 getcwd(PathDir,sizeof(PathDir));

 sprintf(str,Text_msg[42],PathDir);
 title=newStr(str);

 TView *Monosel = new TView(TRect(16,2,78,9)); Monosel->options |= ofFramed; insert(Monosel);

 myApp->LoadControllers(PathDir,&contr_ptr,&contr_amount);
 myApp->LoadSpk(NameSpk,&SpeakDBF);

 SpeakColect = new TCompCollect(10,10);
 LangColect = new TCompCollect(10,10);
 LangColect->insert((char *)"᪨ ."); LangColect->insert((char *)"ࠨ᪨ .");

 ScrollBar1 = new TScrollBar( TRect( 14, 2, 15, 12) ); insert(ScrollBar1);
 MyTListBox1 = new TMyTListBox(TRect( 2, 2, 14, 12), 1, ScrollBar1,NULL); insert(MyTListBox1);
 MyTListBox1->helpCtx=hcMax;
 TMyLabel *Label = new TMyLabel(TRect(2, 1, 15, 2),"饭",MyTListBox1,1); insert(Label);

 Label1 = new TMyLabel(TRect(16, 2, 78, 3),"",MyTListBox1,1); insert(Label1);
 Edit3 = new TEdit( TRect(28, 4, 30, 5),3,EnterNumber); insert(Edit3);
 Label = new TMyLabel(TRect(16, 4, 27, 5),"ਮ:",Edit3,1); insert(Label);

 Lang_Ed = new TEdit( TRect(38, 4, 54, 5),17,NoEdit); insert(Lang_Ed);
 Lang_Cb = new TComboBox(TRect(54, 4, 55, 5), Lang_Ed,LangColect,SelectFormuls); insert(Lang_Cb);

 Edit1 = new TEdit( TRect(16, 6, 78, 7),81,ChKbdUkr); insert(Edit1); Edit1->helpCtx=hcSpeak;
 Label = new TMyLabel(TRect(16, 5, 78, 6)," ᮮ饭 (Name.wav - 稢 䠩)",Edit1,1); insert(Label);
 Edit2 = new TEdit( TRect(16, 8, 78, 9),81,ChKbdUkr); insert(Edit2); Edit2->helpCtx=hcSpeak;
 Label = new TMyLabel(TRect(16, 7, 78, 8)," ४樨 (Name.wav - 稢 䠩)",Edit2,1); insert(Label);

 TButton *Button = new TButton( TRect( 16,11, 26, 13),Text_msg[115], cmOK, bfDefault ); insert(Button);
 Button = new TButton( TRect( 29,11, 39, 13),Text_msg[114], cmCancel, bfNormal ); insert(Button);

 for(i=0;i<SpeakDBF->GetCountItems();i++)
 {
  str1 = new char[12];
  SpeakDBF->GetFieldIt(i,"SHIFR",str1);
  SpeakDBF->GetFieldIt(i,"COD_O",str);
  sprintf(str1,"%.9s:%d",str1,atoi(str));
  SpeakColect->insert(str1);
 }
 MyTListBox1->newList(SpeakColect);

 MyTListBox1->select();
 ViewSpeak(OldIndChek=0);

 Modif=False;
 Modifs=False;
}

TSpeakDialog::~TSpeakDialog()
{
 delete SpeakDBF; delete(LangColect);
 myApp->FreeColect(SpeakColect);
}

void TSpeakDialog::handleEvent ( TEvent& event )
{
 int i,k,k1,l_1,fh;
 char str[256],*str1,*str2;
 ushort control;
 TCompCollect *TempColect;
 TEdit *EditTmp=NULL;

 if( event.what == evCommand && event.message.command == cmClose)
 {
  if(Modif || Modifs)
  {
   control = messageBox(Text_msg[26],mfWarning | mfOKCancel);
   if(control==cmOK)
   {
    if(Modif) SaveChenge(MyTListBox1->focused);
    sprintf(str,Text_msg[109],PathDir,NameSpk);
    SpeakDBF->SaveFile(str);
   }
  }
 }
 TDialog::handleEvent(event);

#ifdef __DOS32__
 if( event.what == evBroadcast && event.message.command == cmGetBuf) Modif=True;
#endif

 if( event.what == evBroadcast && event.message.command == cmScrollBarChanged) //List ListBox
 {
  if(MyTListBox1->state & sfFocused)    // ListBox1
  {
   if(Modif)
   {
    control = messageBox(mfWarning | mfOKCancel,"㯯 ஢ . ࠭ ?");
    if(control==cmOK)
    {
     SaveChenge(OldIndChek);
     Modifs=True;
    }
    Modif=False;
   }
#ifdef __DOS32__
   if(getShiftState() & (kbLeftShift|kbRightShift))
   {
    str1=(char *)SpeakDBF->getItem(OldIndChek);
    str2=(char *)SpeakDBF->getItem(MyTListBox1->focused);
    SpeakDBF->DeleteItems(OldIndChek,0);
    SpeakDBF->AddItem(OldIndChek,str2);
    SpeakDBF->DeleteItems(MyTListBox1->focused,0);
    SpeakDBF->AddItem(MyTListBox1->focused,str1);

    SpeakColect->freeAll();
    for(i=0;i<SpeakDBF->GetCountItems();i++)
    {
     str1 = new char[12];
     SpeakDBF->GetFieldIt(i,"SHIFR",str1);
     SpeakDBF->GetFieldIt(i,"COD_O",str);
     sprintf(str1,"%.9s:%d",str1,atoi(str));
     SpeakColect->insert(str1);
    }
    MyTListBox1->drawView();
    ViewSpeak(MyTListBox1->focused);
    Modifs=True;
   }
#endif
   ViewSpeak(MyTListBox1->focused);
   clearEvent(event);
   OldIndChek=MyTListBox1->focused;
  }
 }

 if( event.what == evCommand )
 {
  switch( event.message.command )
  {
   case cmOK:
        SaveChenge(MyTListBox1->focused);
        Modifs=True;
        Modif=False;
        clearEvent(event);
        break;
   case cmCancel:
        ViewSpeak(MyTListBox1->focused);
        Modif=False;
        clearEvent(event);
        break;
   case cmSave1:
        control = messageBox(mfWarning | mfOKCancel,Text_msg[37]);
        if(control!=cmOK) break;
        SaveChenge(MyTListBox1->focused);
        sprintf(str,Text_msg[109],PathDir,NameSpk);
        SpeakDBF->SaveFile(str);
        Modif=Modifs=False;
        break;
   case cmReLoad:
        control = messageBox(mfWarning | mfOKCancel,Text_msg[38]);
        if(control!=cmOK) break;
        sprintf(str,Text_msg[109],PathDir,NameSpk);
        myApp->LoadGrc(str,&SpeakDBF); SpeakColect->freeAll();
        for(i=0;i<SpeakDBF->GetCountItems();i++)
        {
         str1 = new char[12];
         SpeakDBF->GetFieldIt(i,"SHIFR",str1);
         SpeakDBF->GetFieldIt(i,"COD_O",str);
         sprintf(str1,"%.9s:%d",str1,atoi(str));
         SpeakColect->insert(str1);
        }
        MyTListBox1->setRange( MyTListBox1->list()->getCount());
        MyTListBox1->drawView(); MyTListBox1->focusItem(OldIndChek=0); ViewSpeak(OldIndChek);
        Modif=Modifs=False;
        break;
   case cmInsert:
        EditTmp=0;
        if(Edit1->state & sfFocused) EditTmp=Edit1;
        if(Edit2->state & sfFocused) EditTmp=Edit2;
        if(EditTmp)
        {
         TempColect = new TCompCollect(10,10);
         sprintf(str,Text_msg[109],PathDir,NameWAVLib);
         myApp->LoadLib(NULL,str, NULL, TempColect);
         k=myApp->OperList(this,EditTmp,TempColect,1,6);
         if(k != -1)
         {
          sprintf(str,"%s",(char *)TempColect->at(k));
          EditTmp->setData(str);
          Modif=True;
         }
         myApp->FreeColect(TempColect);
         clearEvent(event);
         break;
        }
   case cmAdd:
        EditTmp=0;
        if(Edit1->state & sfFocused) EditTmp=Edit1;
        if(Edit2->state & sfFocused) EditTmp=Edit2;
        if(EditTmp)
        {
#ifdef __DOS32__
         if(!SB_Installed) SB_Initialize();
         if(EditTmp->data[0]=='')
         {
           if(SB_Installed) i = SB_Lib_via(EditTmp->data+1);
         }
         else
         {
          l_1=sinth(EditTmp->data,&str2,Lang_Cb->posit); if(l_1<=0) break;
          if(SB_Installed) SB_via(str2);
          fh=open("mes.wav",O_BIN|O_RDWR|O_CREAT|O_TRUNC,S_IWRITE);
          ::write(fh,str2,l_1); ::close(fh);
          ::free(str2);
         }
         break;
#endif
        }
   case cmRename:
#ifdef __DOS32__
        EditTmp=0;
        if(Edit1->state & sfFocused) EditTmp=Edit1;
        if(Edit2->state & sfFocused) EditTmp=Edit2;
        if(EditTmp) { hear("mes.wav"); break; }
#endif
        str1 = new char[12];
        str1[0]=0;
        SpeakDBF->GetFieldIt(MyTListBox1->focused,"SHIFR",str1);
        control = myApp->execView( myApp->SelDialog = new TSelDialog(PathDir,6,str1));
        if(control==cmOK)
        {
         strcpy(str1,(char *)myApp->SelDialog->Colect2->at(myApp->SelDialog->ListBox2->focused));
         TempColect = new TCompCollect(10,10);
         if(myApp->SelDialog->tip==ANALOG) for(i=0;i<4;i++) TempColect->insert(an_mes[i]);
         if(myApp->SelDialog->tip==DIGIT)
         {
          if(((digit *)(myApp->SelDialog->Colect2->at(myApp->SelDialog->ListBox2->focused)))->type_par==5)
           for(i=0;i<5;i++) TempColect->insert(dig1_mes[i]);
          else for(i=0;i<2;i++) TempColect->insert(dig2_mes[i]);
         }
         k=myApp->OperList(this,MyTListBox1,TempColect,0,45)+1;
         delete TempColect;
         if(k)
         {
          for(i=0;i<SpeakDBF->GetCountItems();i++)
          {
           SpeakDBF->GetFieldIt(i,"SHIFR",str);
           if(!strncmp(str1,str,8))
           { SpeakDBF->GetFieldIt(i,"COD_O",str); if(k==atoi(str)){i= -1; break;} }
          }
          if(i== -1){ DispFixErr(0,Text_msg[15],str1); delete str1; destroy(myApp->SelDialog); break;}
          if(event.message.command==cmInsert || event.message.command==cmRename) k1 = MyTListBox1->focused;
          if(event.message.command==cmAdd)    k1 = SpeakDBF->GetCountItems();
          if(event.message.command==cmRename) MyTListBox1->list()->atFree(k1);
          else SpeakDBF->CreateItems(k1);

          SpeakDBF->ModifiFieldIt(k1,"SHIFR",str1);
          sprintf(str,"%d",k); SpeakDBF->ModifiFieldIt(k1,"COD_O",str);
          SpeakDBF->ModifiFieldIt(k1,"PRIORITET","99");
          sprintf(str1,"%.9s:%d",str1,k); MyTListBox1->list()->atInsert(k1,str1);

          MyTListBox1->setRange( MyTListBox1->list()->getCount() );
          MyTListBox1->drawView();
          ViewSpeak(MyTListBox1->focused);
          Modifs=True;
          destroy(myApp->SelDialog);
          clearEvent(event);
          break;
         }
        }
        delete str1;
        destroy(myApp->SelDialog);
        clearEvent(event);
        break;
   case cmDelete:
        if(!MyTListBox1->list()->getCount()) break;
        SpeakDBF->DeleteItems(MyTListBox1->focused,1);
        MyTListBox1->list()->atFree(MyTListBox1->focused);
        MyTListBox1->setRange( MyTListBox1->list()->getCount() );
        MyTListBox1->drawView();
        ViewSpeak(MyTListBox1->focused);
        Modifs=True;
        clearEvent(event);
        break;
   default: ;
  }
 }

}

void TSpeakDialog::ViewSpeak(int item)
{
 char str1[90];
 word_s nc,nz,tip;

 Lang_Cb->posit=0;
 if(SpeakDBF->GetFieldIt(item,"LNG",str1)== -1) { SpeakDBF->addField(1000,&sp_dbf[8]);}
 if(!strcmp(str1,"ru")) Lang_Cb->posit=0;
 if(!strcmp(str1,"ua")) Lang_Cb->posit=1;
 Lang_Ed->setData((char *)LangColect->at(Lang_Cb->posit));

 if(SpeakDBF->GetFieldIt(item,"TEXT_S",str1)== -1)return;
 Edit1->setData(str1);
 if(SpeakDBF->GetFieldIt(item,"TEXT_R",str1)== -1)return;
 Edit2->setData(str1);
 if(SpeakDBF->GetFieldIt(item,"PRIORITET",str1)== -1)return;
 Edit3->setData(str1);

 SpeakDBF->GetFieldIt(item,"SHIFR",str1);
 tip = myApp->ChekNamePasport(contr_ptr,contr_amount,str1,&nc,&nz);
 if(tip==ANALOG)
 {
  SpeakDBF->GetFieldIt(item,"COD_O",str1);
  Label1->SetText(an_mes[atoi(str1)-1]);
  return;
 }
 if(tip==DIGIT)
 {
  if(contr_ptr[nc]->d_ptr[nz].type_par==5)
  {
   SpeakDBF->GetFieldIt(item,"COD_O",str1);
   Label1->SetText(dig1_mes[(atoi(str1)-1 >= sizeof(dig1_mes)/sizeof(char *))?0:atoi(str1)-1]);
   return;
  }
  SpeakDBF->GetFieldIt(item,"COD_O",str1);
  Label1->SetText(dig2_mes[(atoi(str1)-1 >= sizeof(dig2_mes)/sizeof(char *))?0:atoi(str1)-1]);
  return;
 }
 Label1->SetText("ࠬ   訡祭!");
}

int TSpeakDialog::SelectInput(void* source,TEvent& event)
{
 TEdit *Edit = (TEdit *)source;
 TSpeakDialog *Dialog = (TSpeakDialog *)Edit->owner;

 ushort control;

 if(event.what == evKeyboard)
  switch(event.keyDown.keyCode)
  {
   case 0x3920:
     control = myApp->execView( myApp->SelDialog = new TSelDialog(Dialog->PathDir,6,((TEdit *)source)->data));
     if(control==cmOK)
     {
      ((TEdit *)source)->setData( (char *)myApp->SelDialog->Colect2->at(myApp->SelDialog->ListBox2->focused) );
      Dialog->Modif=True;
     }
     destroy(myApp->SelDialog);
     break;
   case kbDel: ((TEdit *)source)->setData(Text_msg[49]); Dialog->Modif=True; break;
   case kbUp: Dialog->selectNext(True); Edit->clearEvent(event); break;
   case kbDown: Dialog->selectNext(False); Edit->clearEvent(event); break;
  }
 return(1);
}

void TSpeakDialog::SaveChenge(int item)
{
 char *str;
 if(Lang_Cb->posit==0) str="ru";
 if(Lang_Cb->posit==1) str="ua";
 SpeakDBF->ModifiFieldIt(item,"LNG",str);
 SpeakDBF->ModifiFieldIt(item,"TEXT_S",Edit1->data);
 SpeakDBF->ModifiFieldIt(item,"TEXT_R",Edit2->data);
 SpeakDBF->ModifiFieldIt(item,"PRIORITET",Edit3->data);
}

int TSpeakDialog::EnterNumber(void* source,TEvent& event)
{
 char code,str[15];
 float numb;
 TEdit *Edit = (TEdit *)source;
 TSpeakDialog *Dialog = (TSpeakDialog *)Edit->owner;

 if(event.what == evKeyboard)
 {
  switch(event.keyDown.keyCode)
  {
   case kbEnter: numb=atof(Edit->data);
                 sprintf(str,"%f",numb); Edit->setData(str); //Dialog->Modif=True;
                 Dialog->selectNext(False);
                 break;
   case kbDown: Dialog->selectNext(False); Edit->clearEvent(event); break;
   case kbUp: Dialog->selectNext(True); Edit->clearEvent(event); break;
  }
  code=event.keyDown.charScan.charCode;
  if( !((code>='0'&&code<='9') || code<' ')) Edit->clearEvent(event);
 }
 return(0);
}

int TSpeakDialog::ChKbdUkr(void* source,TEvent& event)
{
 TEdit *Edit = (TEdit *)source;
 TSpeakDialog *Dialog = (TSpeakDialog *)Edit->owner;

 if(event.what == evKeyboard && Dialog->Lang_Cb->posit==1)
  switch(event.keyDown.charScan.charCode)
  {
   case '': event.keyDown.charScan.charCode=''; break;
   case '': event.keyDown.charScan.charCode=''; break;
   case '': event.keyDown.charScan.charCode='i'; break;
   case '': event.keyDown.charScan.charCode='I'; break;
   case '': event.keyDown.charScan.charCode=''; break;
   case '': event.keyDown.charScan.charCode=''; break;
   case 0x22: event.keyDown.charScan.charCode=0x27; break;    //  뢮  '  "
  }
 return(0);
}

int TSpeakDialog::SelectFormuls(void* source,TEvent& event)
{
 TComboBox *ComboBox = (TComboBox *)source;
 TSpeakDialog *Dialog = (TSpeakDialog *)ComboBox->owner;
 Dialog->Modif=True;
 return(0);
}

//==================================================
void TMyApp::LoadSpk(char* Name, TBasaDBF **BasaDBF)
{
 *BasaDBF = new TBasaDBF();
 if((*BasaDBF)->LoadFile(Name)== -1) (*BasaDBF)->LoadFields(sp_dbf,sizeof(sp_dbf)/sizeof(db_str_rec));
}

int TMyApp::OperList(TDialog *Dial,TView *View,TCompCollect *TempColect,char Napr,char Len)
{
 TRect r1,p;
 int control;

 r1 = View->getBounds();
 if(Napr==0){ r1.a.x += (r1.b.x-r1.a.x); r1.b.x += Len; }
 if(Napr==1){ r1.a.y += (r1.b.y-r1.a.y); r1.b.y += Len; r1.a.x-=2; r1.b.x+=1; }
 p = getExtent(); r1.intersect( p );
 TComboBoxWindow *ComboWin = new TComboBoxWindow(r1,TempColect,0);
 control = Dial->execView(ComboWin);
 if(control==cmOK)control=ComboWin->selpos;
 else control= -1;
 delete ComboWin;
 return(control);
}
