#include <io.h>
#include <fcntl.h>
#include <share.h>
#include <stdlib.h>
#include <string.h>
#include <sys\stat.h>
#include <i86.h>
#include <conio.h>
#include <graph.h>
#include <stdarg.h>

typedef unsigned char byte;
typedef unsigned short int word;
typedef short int word_s;
typedef unsigned long dword;

#pragma pack(2)
typedef struct pcxheader {
        char     manuf;                 /* Always =10 for Paintbrush   */
        char     hard;                  /* Version information         */
        char     encod;                 /* Run-length encoding (=1)    */
        char     bitpx;                 /* Bits per pixel              */
        word     x1;                    /* Picture dimensions (incl)   */
        word     y1;
        word     x2;
        word     y2;
        word     hres;                  /* Display horiz resolution    */
        word     vres;                  /* Display vert  resolution    */
        byte     clrma[48];             /* Pallete                     */
        char     vmode;                 /* (ignored)                   */
        char     nplanes;               /* Number of planes (ver 2.5=0)*/
        word     bplin;                 /* Bytes per line              */
        word     palinfo;               /* Palette Info (1=col, 2=gray)*/
        word     shres;                 /* Scanner resolution          */
        word     svres;                 /*                             */
        char         xtra[54];              /* Extra space (filler)        */
} PCXHEADER;

typedef struct pcxlibdir {
        char         synch;                 /* Synch byte                  */
        char         filename[13];          /* Image file name             */
        long         filesize;              /* File size                   */
        word     date;                  /* File date                   */
        word     time;                  /* File time                   */
        word     pack;                  /* Packing type                */
        char         note[40];              /* Image note                  */
        char         xtra[20];              /* Extra filler                */
} PCXLIBDIR;

typedef struct pcxlibheader {
        char         id[10];                /* Library ID string           */
        char         copyright[50];         /* Copyright notice            */
        word     version;               /* pcxLib version              */
        char         label[40];             /* Library volume label        */
        char         xtra[20];              /* filler                      */
} PCXLIBHEADER;

unsigned char   w_rv;
unsigned char   w_rg;
unsigned char   w_r;
unsigned char   w_d;
unsigned char * w_im;

typedef struct {
   word_s  kol;
   long eofs;
   struct {
          unsigned char  nazv[12];
          unsigned char  rv;
          unsigned char  rg;
          long           nsm;
   } fon[];
} tit;

#pragma pack()

tit *pff;

long flib_len;
PCXLIBHEADER * lib_prt;

word_s tol;

typedef struct fillsettingstype {short pattern;short color;};
typedef struct linesettingstype {word linestyle;word upattern;short thickness;};
typedef struct viewporttype {short left;short top;short right;short bottom;short clip;};

struct viewporttype vpA;
struct fillsettingstype fiA={0,1},fiT;
struct linesettingstype lsN={-1,0,1},lsP,lsA={-1,0,1},lsT;

word_s setpcxvideo(char *flpcx,word x_video,word y_video, word xv)
{
  int hn;
  word f_len;
  PCXHEADER *pp;

  hn=open(flpcx,O_BINARY | O_RDWR);
  if(hn==-1) return (-1);

  f_len=(word)filelength(hn);
  pp=(PCXHEADER *)malloc(f_len);
  read(hn,pp,f_len);
  close(hn);

  DisplayBufPcx(pp,f_len,x_video,y_video,xv);

  free(pp);
  return (0);
}

void loadpcxlib(char *flpcl)
{
  int hn;

  hn=open(flpcl,O_BINARY | O_RDWR);
  if(hn==-1){flib_len=0; return ;}
  flib_len=(long)filelength(hn);
  lib_prt=(PCXLIBHEADER *)malloc(flib_len);
  read(hn,lib_prt,flib_len);
  close(hn);
}

void unloadpcxlib()
{
 free(lib_prt);
}

word_s pcxDisplayLib(char *flpcx,word x_video,word y_video, word xv)
{
 word i,j,len_pcx;
 PCXLIBDIR * file_prt;
 char str[13];

 file_prt=(PCXLIBDIR *)(lib_prt+1);
 for(i=0,j=0;i<13 && flpcx[i]!=0;i++) if(flpcx[i]!=' '){flpcx[j]=flpcx[i]; j++;}
 flpcx[j]=0;
next_file:
 strncpy(str,file_prt->filename,13);
 for(i=0,j=0;i<13 && str[i]!=0;i++) if(str[i]!=' '){str[j]=str[i]; j++;}
 str[j]=0;
// printf("%s - %s\n",flpcx,str);
 if(strcmp(flpcx,str))
 {
  if(file_prt < (PCXLIBDIR *)((byte *)lib_prt+flib_len))                                    //!
  {
   file_prt = (PCXLIBDIR *)((byte *)file_prt+file_prt->filesize+sizeof(PCXLIBDIR));          //!
   goto next_file;
  };
  return (-1);
 }

 len_pcx=file_prt->filesize;
 file_prt=(PCXLIBDIR *) ((byte *)file_prt+sizeof(PCXLIBDIR));                                       //!
 DisplayBufPcx((PCXHEADER *)file_prt,len_pcx,x_video,y_video,xv);
 return (0);
}


void DisplayBufPcx(PCXHEADER *pp,word f_len,word x_video,word y_video, word xv )
{
  byte bt;
  word l_str,l_buf_str,sii,i,k;
  int ii,iii;
  unsigned char *p_buf_str,*p_buf_fil, *pc;;

  l_str=pp->bplin;
  l_buf_str=l_str<<2;
  p_buf_str=(byte *)malloc(l_buf_str+64);
  f_len-=0x80;
  p_buf_fil=(byte *)(pp+1);

  outp(0x3ce,5);
  outp(0x3cf,0);
  outp(0x3ce,8);
  outp(0x3cf,0xff);

  sii=y_video*(xv/8)+x_video/8;
  k=0; pc=p_buf_str;
  for(i=0; i<f_len; )
  {
    bt=*p_buf_fil; p_buf_fil++; i++;
    if(bt > 0xC0)
    {
      bt &= 0x3f;
      memset(pc,*p_buf_fil,bt);
      k+=bt; pc+=bt;
      p_buf_fil++; i++;
    }
    else { *pc++=bt; k++; }

    if(k>=l_buf_str)
    {
     for(ii=0;ii<4;ii++)
     {
      outp(0x3c4,2); outp(0x3c5,1<<ii);
      for(iii=0;iii<l_str;iii++)
      {
//       if(!ii)
//       {
//        msk=
//        printf("color %x",p_buf_str+l_str)
//       }
//       if(iii==l_str-1)msk=0xFF<<(l_str*8-pp->x2-pp->x1); else msk=0xFF;
       *(byte *)(0xA0000+sii+iii)=(*(p_buf_str+ii*l_str+iii))/*&msk*/;
      }
     }
     sii+=xv/8;
     k-=l_buf_str;
     pc=p_buf_str+l_buf_str;
     memcpy(p_buf_str,pc,k);
     pc=p_buf_str+k;
    }
  }
  outp(0x3cf,0xff);                           /* .᪨ ⮢ */
  outp(0x3c5,15);                             /* ᪠ p -  */

  free(p_buf_str);
}
//---------------------------------------
void ch_color(int x,int y, int color)
{
 int y1, y2, x2, x1;
 int color1, color2;  /* ⥪騩 梥   ᪨ */
 int l=1;        /* "1" - ࠢ  , "-1" -     */
 int k=0;        /* "0" - ⥪쭠 , "1" - ਧ⠫쭠 */
 int i=0;        /* 稪 */

 if((color1=_getpixel(x,y))==color) return;  /* ᫨ ⥪騩 梥 ࠢ
                                     ⮭  室  */
_setcolor(color);

x1=x; y1=y;
mi2:;

do {x1=x1-1;
  x2=x1;y2=y1;
  if(k==1) {x2=y1; y2=x1;};
  color2=_getpixel(x2,y2);
 } while(color2==color || color2==color1);

mi3:  ++x1;

mi1:  y1=y+(i*l);
   x2=x1;y2=y1;
   if(k==1) {y1=x+(i*l); x2=y1; y2=x1;};
   color2=_getpixel(x2,y2);
   ++i;
  if(color2==color1)
  {
//  putpix(color,x2,y2);
  _setpixel(x2,y2);
  goto mi1;}
  if(color2==color) goto mi1;

  if(i==1)
   {if(k==1) return;
    k=1; i=0; l=1;
    x1=y; y1=x;
    goto mi2;
   };
  if(l==-1) {l=1;i=0;goto mi3;}
  l=-1;
  i=0;
  goto mi1;
}
//**********************************************************************
unsigned char fill[]={
                           0,    0,    0,    0,    0,    0,    0,    0,
                        0377, 0377, 0377, 0377, 0377, 0377, 0377, 0377,

                        0377,    0,    0, 0377, 0377,    0,    0, 0377,
                          04,  010,  020,  040, 0100, 0200,    1,    2,
                        0203,   07,  016,  034,  070, 0160, 0340, 0301,
                        0360, 0270,  074,  036,  017, 0207, 0303, 0341,
                        0245, 0322, 0151, 0264, 0132,  055, 0226, 0113,
                         021,  021,  021, 0377,  021,  021,  021, 0377,
                        0204, 0110,  060,  060, 0110, 0204,   03,   03,
                        0146, 0231, 0146, 0231, 0146, 0231, 0146, 0231,
                           0,    1,    0,    2,    0,    1,    0,    2,
                           0, 0104,    0, 0104,    0, 0104,    0, 0104};

void setfillstyle  (word_s pat,word_s col)
  {pat=pat*8; fiA.color=col;fiA.pattern=pat;
  _setfillmask(&fill[pat]);}

void bar (short a,short b,short c,short d)
{short e;e=_getcolor();_setcolor(fiA.color);
_rectangle (_GFILLINTERIOR,a,b,c,d);_setcolor(e);}

void  setviewport(short a,short b,short c,short d)
{  _setviewport(a,b,c,d);
   vpA.left=a;vpA.top=b;vpA.right=c;vpA.bottom=d;}

void getlinesettings(struct linesettingstype   *li)
  {
  li->linestyle=_getlinestyle();
  li->upattern=0;
  li->thickness=lsA.thickness;}

void setlinestyle (word_s linestyle,word_s thickness)
  { tol=0;
    if( linestyle==-3) { _setlinestyle(-1);tol=3; }
    else _setlinestyle(linestyle);
    lsA.linestyle=linestyle;
    lsA.thickness=thickness;
  }

void getfillsettings (struct fillsettingstype   *fi)
 { fi->pattern=fiA.pattern;fi->color=fiA.color;}

void linet( short a,short b,short c,short d)
{ short e,f;e=c;f=d;
  if( tol!=3 ) { _moveto(a,b);_lineto(c,d);}
  if(lsA.thickness==3)
   {
    if(a==c){a--;c--;}
    else{b--;d--;}
    _moveto(a,b);_lineto(c,d);
    if(a==c){a+=2;c+=2;}
    else{b+=2;d+=2;}
    _moveto(a,b);_lineto(c,d);
   }
  _moveto(e,f);
}

void rectangle(short a,short b,short c,short d)
{  if(tol!=3) _rectangle (_GBORDER,a,b,c,d);
   if(lsA.thickness==3)
    {
    _rectangle (_GBORDER,a-1,b-1,c+1,d+1);
    _rectangle (_GBORDER,a+1,b+1,c-1,d-1);
    }
}
//***************** ᠫ 㭪樨 䨪 ****************************

void putpix(word c, word x, word y)
{
 byte n, wc=0x80, *pc;

 pc=(byte*)(0xa0000L+y*80+(x>>3));
 n=x&7;

 outp(0x3ce,5);

 outp(0x3cf,0);  //  0
 outp(0x3ce,8);  /* 8 -   pp ᪨ ⮢ (p.  0x3CF) */
 outp(0x3c4,2);  /* 2 -   pp ᪨ p (p.  0x3C5) */

 wc=wc>>n;

// outp(0x3cf,01); //wc);                          /* ᪠ ⮢ */
// outp(0x3c5,0xF);                         /* ᪠ p -  */
// *pc = 0x00;                           /* ⪠ */
 outp(0x3c5,c);                          /* ᪠ p - 梥 */
 *pc = wc;                           /*  梥 */
 outp(0x3cf,0xff);                           /* .᪨ ⮢ */
 outp(0x3c5,15);                             /* ᪠ p -  */
}

//-------------------------------------------------------------

void fgstr(word_s c,word_s x,word_s y,byte *str)
{
  word_s a;
  byte k,i,j,n,p,r,d,wc,*pc,*p0,*im;
  volatile byte s;

  pc=(byte*)(0xa0000L+y*80);
  outp(0x3ce,8);  /* 8 -   pp ᪨ ⮢ (p.  0x3CF) */
  outp(0x3c4,2);  /* 2 -   pp ᪨ p (p.  0x3C5) */

  k=0;
  while(s=str[k++])
  {
   im=w_im+s*w_d;
   d=*im++;
   r=(d-1) >> 3;
   p0=pc+(x>>3);                                  /* + x/8 */

   n=x&7;  p=8-n;

   for(i=0; i<w_rv; i++,im+=w_r-j,p0+=80-j)
    for(j=0,a=x; j<=r; j++,im++)
    {
     s=*p0;                                  /* ⥭   */
     wc=*im;  /* wc=(*im)>>((w_rg-d)>>1); */
     a+=8;
     wc >>= n;
     outp(0x3cf,wc);                         /* ᪠ ⮢ */
     outp(0x3c5,15);                         /* ᪠ p -  */
     *p0 = 0x00;                             /* ⪠ */
     outp(0x3c5,c);                          /* ᪠ p - 梥 */
     *p0++ = 0xff;                           /*  梥 */

     s=*p0;                                /* ⥭   */
     wc=*im;
     wc <<= p;
     outp(0x3cf,wc);                       /* ᪠ ⮢ */
     outp(0x3c5,15);                       /* ᪠ p -  */
     *p0 = 0x00;                           /* ⪠ */
     outp(0x3c5,c);                        /* ᪠ p - 梥 */
     *p0 = 0xff;                           /*  梥 */
    }
   x+=d;   /* x+=w_rg;   */
  }
  outp(0x3cf,0xff);                           /* .᪨ ⮢ */
  outp(0x3c5,15);                             /* ᪠ p -  */
}


int CorrectPCX(char* NameFile1,char* NameFile2)
{
  word f_len;
  PCXHEADER *pp;
  byte bt,msk,msk1,msk_o,tmp,count_b=0;
  word l_str,l_buf_str,i,k;
  int ii,iii,fh,fh1,k1=0;
  byte *p_buf_str,*p_buf_fil,*p_buf_1, *pc;
  byte pal1[16];

  if((fh=open(NameFile1,O_BINARY|O_RDONLY))<0) return(1);
  f_len=lseek(fh,0,SEEK_END); lseek(fh,0,SEEK_SET);
  pp=malloc(f_len); read(fh,pp,f_len);
  p_buf_1=malloc(f_len<<4);

  fh1=open(NameFile2,O_BINARY|O_CREAT|O_TRUNC|O_RDWR,S_IWRITE);

  for(i=0;i<16;i++)
  {
   msk=0;
   if(pp->clrma[i*3]>0xD4||pp->clrma[i*3+1]>0xD4||pp->clrma[i*3+2]>0xD4)
   {
    if(pp->clrma[i*3+2]>0xD4) msk|=1;
    if(pp->clrma[i*3+1]>0xD4) msk|=2;
    if(pp->clrma[i*3]>0xD4)   msk|=4;
    msk|=8; pal1[i]=msk; continue;
   }
   if(pp->clrma[i*3]<0x2a||pp->clrma[i*3+1]<0x2a||pp->clrma[i*3+2]<0x2a)
   {
    if(pp->clrma[i*3+2]>0x2a) msk|=1;
    if(pp->clrma[i*3+1]>0x2a) msk|=2;
    if(pp->clrma[i*3]>0x2a)   msk|=4;
    pal1[i]=msk; continue;
   }
   if(pp->clrma[i*3]<0x7F||pp->clrma[i*3+1]<0x7F||pp->clrma[i*3+2]<0x7F) msk|=8;
   else msk|=7;
   pal1[i]=msk; continue;
  }

  for(i=0;i<16;i++)
  {
   if(i&8) msk=0x55; else msk=0;
   if(i&4) pp->clrma[i*3]  =0xAA|msk; else pp->clrma[i*3]  =msk;
   if(i&2) pp->clrma[i*3+1]=0xAA|msk; else pp->clrma[i*3+1]=msk;
   if(i&1) pp->clrma[i*3+2]=0xAA|msk; else pp->clrma[i*3+2]=msk;
  }
  write(fh1,pp,sizeof(PCXHEADER));

  l_str=pp->bplin;
  l_buf_str=l_str<<2;

  p_buf_str=(byte *)malloc(l_buf_str+64);
  f_len-=0x80;
  p_buf_fil=(byte *)(pp+1);

  k=0; pc=p_buf_str;
  for(i=0; i<f_len; )
  {
    bt=*p_buf_fil; p_buf_fil++; i++;
    if(bt > 0xC0)
    {
      bt &= 0x3f;
      memset(pc,*p_buf_fil,bt);
      k+=bt; pc+=bt;
      p_buf_fil++; i++;
    }
    else { *pc++=bt; k++; }

    if(k>=l_buf_str)
    {
     k1++;

     for(iii=0;iii<l_str;iii++)
     {
      for(ii=0;ii<8;ii++)
      {
       msk1=1<<ii; msk=0;
       if(*(p_buf_str+iii)&msk1)         msk|=1;
       if(*(p_buf_str+iii+l_str)&msk1)   msk|=2;
       if(*(p_buf_str+iii+2*l_str)&msk1) msk|=4;
       if(*(p_buf_str+iii+3*l_str)&msk1) msk|=8;
       p_buf_1[iii*8+ii]=pal1[msk];
      }
     }
     for(ii=0;ii<4;ii++)
     {
      for(iii=0;iii<l_str;iii++)
      {
       msk1=1<<ii; msk=0;
       if(p_buf_1[iii*8]&msk1)   msk|=0x01;
       if(p_buf_1[iii*8+1]&msk1) msk|=0x02;
       if(p_buf_1[iii*8+2]&msk1) msk|=0x04;
       if(p_buf_1[iii*8+3]&msk1) msk|=0x08;
       if(p_buf_1[iii*8+4]&msk1) msk|=0x10;
       if(p_buf_1[iii*8+5]&msk1) msk|=0x20;
       if(p_buf_1[iii*8+6]&msk1) msk|=0x40;
       if(p_buf_1[iii*8+7]&msk1) msk|=0x80;
       if(msk_o==msk|| !count_b)
       {
        count_b++;
        if(count_b==0x3F) {tmp=0xFF; write(fh1,&tmp,1); write(fh1,&msk,1); count_b=0;}
       }
       else
       {
        if(count_b>1) {tmp=count_b|0xC0; write(fh1,&tmp,1); count_b=1;}
        else if(msk_o>=0xC0) {tmp=0xC1; write(fh1,&tmp,1);}
        write(fh1,&msk_o,1);
       }
       msk_o=msk;
      }
     }

     k-=l_buf_str;
     pc=p_buf_str+l_buf_str;
     memcpy(p_buf_str,pc,k);
     pc=p_buf_str+k;
    }
  }
  if(count_b>1) {tmp=count_b|0xC0; write(fh1,&tmp,1);}
  else if(msk_o>=0xC0) {tmp=0xC1; write(fh1,&tmp,1);}
  if(count_b) write(fh1,&msk_o,1);

  free(p_buf_str); free(p_buf_1);
  close(fh); close(fh1);
  return(1);
}



void __cdecl fgtext(word_s c,word_s x,word_s y,char *fmt, ...)
{
 byte str[100];
 va_list argptr;

 va_start (argptr,fmt);
 vsprintf(str,fmt,argptr);
 va_end(argptr);
 fgstr(c,x,y,str);
}

int LoadShrift(char *name)
{
 int fh,f=0;

 if((fh=open(name,O_BINARY|O_RDONLY))<=0) return -1;
 pff=(tit *)calloc(filelength(fh),1);
 read(fh,pff,filelength(fh));

 w_rv=pff->fon[f].rv;
 w_rg=pff->fon[f].rg;
 w_im=(unsigned char *)pff+(unsigned)pff->fon[f].nsm;
 w_r=(w_rg+7) >> 3;
 w_d=w_rv*w_r+1;

 close(fh);
 return 0;
}

void DelShrift()
{
 free(pff);
}