#include "alg.h"
#include "mylib.h"
#include "alg_cfg.h"
#include "grc.h"
#include "demohelp.h"

db_str_rec gr_cont[] =
 {
  {"SHIFR",'C',0,8,0}, {"NAME",'C',0,25,0}, {"NUMBER",'N',0,1,0},
  {"SHIFR_P1",'C',0,9,0}, {"NZC_1",'N',0,1,0}, {"TIP_1",'N',0,1,0}, {"NZP_1",'C',0,4,0},
  {"SHIFR_P2",'C',0,9,0}, {"NZC_2",'N',0,1,0}, {"TIP_2",'N',0,1,0}, {"NZP_2",'C',0,4,0},
  {"SHIFR_P3",'C',0,9,0}, {"NZC_3",'N',0,1,0}, {"TIP_3",'N',0,1,0}, {"NZP_3",'C',0,4,0},
  {"SHIFR_P4",'C',0,9,0}, {"NZC_4",'N',0,1,0}, {"TIP_4",'N',0,1,0}, {"NZP_4",'C',0,4,0},
  {"SHIFR_P5",'C',0,9,0}, {"NZC_5",'N',0,1,0}, {"TIP_5",'N',0,1,0}, {"NZP_5",'C',0,4,0},
  {"SHIFR_P6",'C',0,9,0}, {"NZC_6",'N',0,1,0}, {"TIP_6",'N',0,1,0}, {"NZP_6",'C',0,4,0},
  {"SHIFR_P7",'C',0,9,0}, {"NZC_7",'N',0,1,0}, {"TIP_7",'N',0,1,0}, {"NZP_7",'C',0,4,0},
  {"SHIFR_P8",'C',0,9,0}, {"NZC_8",'N',0,1,0}, {"TIP_8",'N',0,1,0}, {"NZP_8",'C',0,4,0},
 };

TGrcDialog::TGrcDialog( ) :
               TDialog( TRect( 0, 0, 41, 16 ),""),
               TWindowInit( TGrcDialog::initFrame )
{
 char str[256], *str1;
 int i;

 options |= ofCentered;
 helpCtx=hcAllASave;

 getcwd(PathDir,sizeof(PathDir));

 sprintf(str,Text_msg[33],PathDir);
 title=newStr(str);

 TView *Monosel = new TView(TRect(14,4,39,12)); Monosel->options |= ofFramed; insert(Monosel);
 Monosel = new TView(TRect(14,2,39,3)); Monosel->options |= ofFramed; insert(Monosel);

 TMyLabel *Label = new TMyLabel(TRect(23, 3, 30, 4),Text_msg[106],NULL,1); insert(Label);

 myApp->LoadGrc(NameGrc,&GrcDBF);

 GrcColect = new TCompCollect(10,10);
 ScrollBar1 = new TScrollBar( TRect( 11, 2, 12, 12) ); insert(ScrollBar1);
 MyTListBox1 = new TMyTListBox(TRect( 2, 2, 11, 12), 1, ScrollBar1,NULL); insert(MyTListBox1);
 MyTListBox1->helpCtx=hcMax;
 Label = new TMyLabel(TRect(2, 1, 12, 2),Text_msg[107],MyTListBox1,1); insert(Label);

 EditName = new TEdit( TRect(14, 2, 39, 3),26,NULL); insert(EditName);
 Label = new TMyLabel(TRect(21, 1, 32, 2),Text_msg[108],EditName,1); insert(Label);
 for(i=0;i<8;i++) {Edit[i] = new TEdit( TRect(25, 4+i, 34, 5+i),10,SelectInput); insert(Edit[i]);}
 for(i=0;i<8;i++)
 {
  sprintf(str,"Contur %d",i+1);
  Label = new TMyLabel(TRect(14, 4+i, 22, 5+i),str,Edit[i],1);
  insert(Label);
 }

 for(i=0;i<GrcDBF->GetCountItems();i++)
 {
  str1 = new char[12];
  GrcDBF->GetFieldIt(i,"SHIFR",str1);
  GrcColect->insert(str1);
 }
 MyTListBox1->newList(GrcColect);
 ViewGrc(OldIndChek=0);

 TButton *Button = new TButton( TRect( 15,13, 25, 15),Text_msg[115], cmOK, bfDefault ); insert(Button);
 Button = new TButton( TRect( 28,13, 38, 15),Text_msg[114], cmCancel, bfNormal ); insert(Button);

 MyTListBox1->select();

 Modif=False;
 Modifs=False;
}

TGrcDialog::~TGrcDialog()
{
 delete GrcDBF;
 myApp->FreeColect(GrcColect);
}

void TGrcDialog::handleEvent ( TEvent& event )
{
 int i,iii,k1;
 char str[256],*str1,*str2;
 ushort control;

 if( event.what == evCommand && event.message.command == cmClose)
 {
  if(Modif || Modifs)
  {
   control = messageBox(Text_msg[26],mfWarning | mfOKCancel);
   if(control==cmOK)
   {
    if(Modif) SaveChengeGrc(MyTListBox1->focused);
    sprintf(str,Text_msg[109],PathDir,NameGrc);
    GrcDBF->SaveFile(str);
   }
  }
 }
 TDialog::handleEvent(event);

#ifdef __DOS32__
 if( event.what == evBroadcast && event.message.command == cmGetBuf) Modif=True;
#endif

 if( event.what == evBroadcast && event.message.command == cmScrollBarChanged) //List ListBox
 {
  if(MyTListBox1->state & sfFocused)    // ListBox1
  {
   if(Modif)
   {
    control = messageBox(mfWarning | mfOKCancel,"㯯 ஢ . ࠭ ?");
    if(control==cmOK)
    {
     SaveChengeGrc(OldIndChek);
     Modifs=True;
    }
    Modif=False;
   }
#ifdef __DOS32__
   if(getShiftState() & (kbLeftShift|kbRightShift))
   {
    str1=(char *)GrcDBF->getItem(OldIndChek);
    str2=(char *)GrcDBF->getItem(MyTListBox1->focused);
    GrcDBF->DeleteItems(OldIndChek,0);
    GrcDBF->AddItem(OldIndChek,str2);
    GrcDBF->DeleteItems(MyTListBox1->focused,0);
    GrcDBF->AddItem(MyTListBox1->focused,str1);

    GrcColect->freeAll();
    for(i=0;i<GrcDBF->GetCountItems();i++)
    {
     str1 = new char[10];
     GrcDBF->GetFieldIt(i,"SHIFR",str1);
     GrcColect->insert(str1);
    }
    MyTListBox1->drawView();
    ViewGrc(MyTListBox1->focused);
    Modifs=True;
   }
#endif
   ViewGrc(MyTListBox1->focused);
   clearEvent(event);
   OldIndChek=MyTListBox1->focused;
  }
 }

 if( event.what == evCommand )
 {
  switch( event.message.command )
  {
   case cmOK:
        SaveChengeGrc(MyTListBox1->focused);
        Modifs=True;
        Modif=False;
        clearEvent(event);
        break;
   case cmCancel:
        ViewGrc(MyTListBox1->focused);
        Modif=False;
        clearEvent(event);
        break;
   case cmSave1:
        control = messageBox(mfWarning | mfOKCancel,Text_msg[37]);
        if(control!=cmOK) break;
        SaveChengeGrc(MyTListBox1->focused);
        sprintf(str,Text_msg[109],PathDir,NameGrc);
        GrcDBF->SaveFile(str);
        Modif=Modifs=False;
        break;
   case cmReLoad:
        control = messageBox(mfWarning | mfOKCancel,Text_msg[38]);
        if(control!=cmOK) break;
        sprintf(str,Text_msg[109],PathDir,NameGrc);
        myApp->LoadGrc(str,&GrcDBF); GrcColect->freeAll();
        for(i=0;i<GrcDBF->GetCountItems();i++)
        {
         str1 = new char[12];
         GrcDBF->GetFieldIt(i,"SHIFR",str1);
         GrcColect->insert(str1);
        }
        MyTListBox1->setRange( MyTListBox1->list()->getCount());
        MyTListBox1->drawView(); MyTListBox1->focusItem(OldIndChek=0); ViewGrc(OldIndChek);
        Modif=Modifs=False;
        break;
   case cmInsert:
   case cmAdd:
   case cmRename:
        str1 = new char[12]; str1[0]=0;
        if(event.message.command==cmRename) GrcDBF->GetFieldIt(MyTListBox1->focused,"SHIFR",str1);
        control = inputBox(" ", "㯯",str1, 8);
        if(control==cmOK)
        {
         for(i=0;i<GrcDBF->GetCountItems();i++)
         {
          GrcDBF->GetFieldIt(i,"SHIFR",str);
          for(iii=7;iii>=0;iii--)if(str[iii]==' ')str[iii]=0;else break;
          if(!strncmp(str1,str,8)){ i= -1; break;}
         }
         if(i== -1){ DispFixErr(0,Text_msg[15],str1); delete str1; break;}
         if(event.message.command==cmInsert || event.message.command==cmRename) k1 = MyTListBox1->focused;
         if(event.message.command==cmAdd)    k1 = GrcDBF->GetCountItems();
         if(event.message.command==cmRename)
         {
          MyTListBox1->list()->atFree(k1);
//४  Signal
          GrcDBF->GetFieldIt(MyTListBox1->focused,"SHIFR",str);
          myApp->ChekSignal(PathDir,str,3,str1);
//*****************
         }
         else GrcDBF->CreateItems(k1);
         GrcDBF->ModifiFieldIt(k1,"SHIFR",str1);
         MyTListBox1->list()->atInsert(k1,str1);

         MyTListBox1->setRange( MyTListBox1->list()->getCount() );
         MyTListBox1->drawView();
         ViewGrc(MyTListBox1->focused);
         Modifs=True;
        }
        else delete str1;
        clearEvent(event);
        break;
   case cmDelete:
        if(!MyTListBox1->list()->getCount()) break;
        GrcDBF->GetFieldIt(MyTListBox1->focused,"SHIFR",str);
        for(k1=0,i=0;i<MyTListBox1->list()->getCount();i++) if(MyTListBox1->list()->GetOptItem(i)) k1++;
        if(k1) control = messageBox(mfWarning | mfOKCancel,Text_msg[46],k1);
        else
        {
         control = messageBox(mfWarning | mfOKCancel,Text_msg[29],str);
         if(control==cmOK) MyTListBox1->list()->SetOptItem(MyTListBox1->focused,1);
        }
        if(control==cmOK)
        {
         for(i=0;i<MyTListBox1->list()->getCount();i++)
          if(MyTListBox1->list()->GetOptItem(i))
          {
//४  Signal
           GrcDBF->GetFieldIt(i,"SHIFR",str);
           myApp->ChekSignal(PathDir,str,3,NULL);
//*****************
           GrcDBF->DeleteItems(i,1);
           MyTListBox1->list()->atFree(i);
           i--;
          }
         MyTListBox1->setRange( MyTListBox1->list()->getCount() );
         MyTListBox1->drawView();
         ViewGrc(MyTListBox1->focused);
         Modifs=True;
        }
        clearEvent(event);
        break;
   default: ;
  }
 }
}

void TGrcDialog::ViewGrc(int item)
{
 char str1[30];

 if(GrcDBF->GetFieldIt(item,"NAME",str1)== -1)return;
 EditName->setData(str1);

 for(int i=0;i<8;i++)
 {
  sprintf(str1,"SHIFR_P%d",i+1);
  if(GrcDBF->GetFieldIt(item,str1,str1)== -1)return;
  Edit[i]->setData(str1);
 }
}

int TGrcDialog::SelectInput(void* source,TEvent& event)
{
 TEdit *Edit = (TEdit *)source;
 TGrcDialog *Dialog = (TGrcDialog *)Edit->owner;

 ushort control;

 if(event.what == evKeyboard)
  switch(event.keyDown.keyCode)
  {
   case 0x3920:
     control = myApp->execView( myApp->SelDialog = new TSelDialog(Dialog->PathDir,6,((TEdit *)source)->data));
     if(control==cmOK)
     {
      ((TEdit *)source)->setData( (char *)myApp->SelDialog->Colect2->at(myApp->SelDialog->ListBox2->focused) );
      Dialog->Modif=True;
     }
     destroy(myApp->SelDialog);
     break;
   case kbDel: ((TEdit *)source)->setData(Text_msg[49]); Dialog->Modif=True; break;
   case kbUp: Dialog->selectNext(True); Edit->clearEvent(event); break;
   case kbDown: Dialog->selectNext(False); Edit->clearEvent(event); break;
  }
 return(1);
}

void TGrcDialog::SaveChengeGrc(int item)
{
 char str1[30];

 GrcDBF->ModifiFieldIt(item,"NAME",EditName->data);
 for(int i=0;i<8;i++)
 {
  sprintf(str1,"SHIFR_P%d",i+1);
  GrcDBF->ModifiFieldIt(item,str1,Edit[i]->data);
 }
}

//==================================================
void TMyApp::LoadGrc(char* Name, TBasaDBF **BasaDBF)
{
 *BasaDBF = new TBasaDBF();
 if((*BasaDBF)->LoadFile(Name)== -1) (*BasaDBF)->LoadFields(gr_cont,sizeof(gr_cont)/sizeof(db_str_rec));
}

