#include "alg.h"
#include "mylib.h"
#include "alg_cfg.h"
#include "grg.h"
#include "demohelp.h"

db_str_rec gr_graf[] =
 {
  {"SHIFR",'C',0,8,0}, {"NAME",'C',0,25,0}, {"NUMBER",'N',0,1,0},
  {"SHIFR_P1",'C',0,9,0},{"NZC_1",'N',0,1,0},{"TIP_1",'N',0,1,0},{"NZP_1",'C',0,4,0},{"NO_1",'N',0,8,2},{"NV_1",'N',0,8,2},
  {"SHIFR_P2",'C',0,9,0},{"NZC_2",'N',0,1,0},{"TIP_2",'N',0,1,0},{"NZP_2",'C',0,4,0},{"NO_2",'N',0,8,2},{"NV_2",'N',0,8,2},
  {"SHIFR_P3",'C',0,9,0},{"NZC_3",'N',0,1,0},{"TIP_3",'N',0,1,0},{"NZP_3",'C',0,4,0},{"NO_3",'N',0,8,2},{"NV_3",'N',0,8,2},
  {"SHIFR_P4",'C',0,9,0},{"NZC_4",'N',0,1,0},{"TIP_4",'N',0,1,0},{"NZP_4",'C',0,4,0},{"NO_4",'N',0,8,2},{"NV_4",'N',0,8,2},
  {"SHIFR_P5",'C',0,9,0},{"NZC_5",'N',0,1,0},{"TIP_5",'N',0,1,0},{"NZP_5",'C',0,4,0},{"NO_5",'N',0,8,2},{"NV_5",'N',0,8,2},
  {"SHIFR_P6",'C',0,9,0},{"NZC_6",'N',0,1,0},{"TIP_6",'N',0,1,0},{"NZP_6",'C',0,4,0},{"NO_6",'N',0,8,2},{"NV_6",'N',0,8,2},
  {"SHIFR_P7",'C',0,9,0},{"NZC_7",'N',0,1,0},{"TIP_7",'N',0,1,0},{"NZP_7",'C',0,4,0},{"NO_7",'N',0,8,2},{"NV_7",'N',0,8,2},
  {"SHIFR_P8",'C',0,9,0},{"NZC_8",'N',0,1,0},{"TIP_8",'N',0,1,0},{"NZP_8",'C',0,4,0},{"NO_8",'N',0,8,2},{"NV_8",'N',0,8,2},
 };

TGrgDialog::TGrgDialog( ) :
               TDialog( TRect( 0, 0, 54, 17 ),""),
               TWindowInit( TGrgDialog::initFrame )
{
 char str[256], *str1;
 int i;

 options |= ofCentered;
 helpCtx=hcAllASave;

 getcwd(PathDir,sizeof(PathDir));

 sprintf(str,Text_msg[35],PathDir);
 title=newStr(str);

 TView *Monosel = new TView(TRect(14,4,32,13)); Monosel->options |= ofFramed; insert(Monosel);
 Monosel = new TView(TRect(14,2,52,3)); Monosel->options |= ofFramed; insert(Monosel);
 Monosel = new TView(TRect(33,4,52,13)); Monosel->options |= ofFramed; insert(Monosel);

 TMyLabel *Label = new TMyLabel(TRect(19, 3, 26, 4),"䨪",NULL,1); insert(Label);
 Label = new TMyLabel(TRect(33, 3, 52, 4),"࠭ ⮡ࠦ",NULL,1); insert(Label);
 Label = new TMyLabel(TRect(33, 4, 42, 5),"",NULL,1); insert(Label);
 Label = new TMyLabel(TRect(42, 4, 52, 5),"",NULL,1); insert(Label);

 myApp->LoadGrg(NameGrg,&GrgDBF);

 GrgColect = new TCompCollect(10,10);
 ScrollBar1 = new TScrollBar( TRect( 11, 2, 12, 13) ); insert(ScrollBar1);
 MyTListBox1 = new TMyTListBox(TRect( 2, 2, 11, 13), 1, ScrollBar1,NULL); insert(MyTListBox1);
 MyTListBox1->helpCtx=hcMax;
 Label = new TMyLabel(TRect(2, 1, 12, 2),"㯯",MyTListBox1,1); insert(Label);

 EditName = new TEdit( TRect(14, 2, 39, 3),26,NULL); insert(EditName);
 Label = new TMyLabel(TRect(26, 1, 37, 2)," 㯯",EditName,1); insert(Label);
 for(i=0;i<8;i++){ Edit1[i] = new TEdit( TRect(23, 5+i, 32, 6+i),10,SelectInput); insert(Edit1[i]);}
 for(i=0;i<8;i++){ Edit2[i] = new TEdit( TRect(34, 5+i, 42, 6+i),9,EnterNumber); insert(Edit2[i]);}
 for(i=0;i<8;i++){ Edit3[i] = new TEdit( TRect(43, 5+i, 51, 6+i),9,EnterNumber); insert(Edit3[i]);}

 for(i=0;i<8;i++)
 {
  sprintf(str,"䨪 %d",i+1);
  Label = new TMyLabel(TRect(14, 5+i, 22, 6+i),str,Edit1[i],1);
  insert(Label);
 }

 TButton *Button = new TButton( TRect( 28,14, 38, 16),Text_msg[115], cmOK, bfDefault ); insert(Button);
 Button = new TButton( TRect( 41,14, 51, 16),Text_msg[114], cmCancel, bfNormal ); insert(Button);

 for(i=0;i<GrgDBF->GetCountItems();i++)
 {
  str1 = new char[12];
  GrgDBF->GetFieldIt(i,"SHIFR",str1);
  GrgColect->insert(str1);
 }
 MyTListBox1->newList(GrgColect);
 ViewGrg(0);

 MyTListBox1->select();

 Modif=False;
 Modifs=False;
}

TGrgDialog::~TGrgDialog()
{
 delete GrgDBF;
 myApp->FreeColect(GrgColect);
}

void TGrgDialog::handleEvent ( TEvent& event )
{
 int i,iii,k1;
 char str[256],*str1,*str2;
 ushort control;

 if( event.what == evCommand && event.message.command == cmClose)
 {
  if(Modif || Modifs)
  {
   control = messageBox(Text_msg[26],mfWarning | mfOKCancel);
   if(control==cmOK)
   {
    if(Modif) SaveChengeGrg(MyTListBox1->focused);
    sprintf(str,Text_msg[109],PathDir,NameGrg);
    GrgDBF->SaveFile(str);
   }
  }
 }

 TDialog::handleEvent(event);
#ifdef __DOS32__
 if( event.what == evBroadcast && event.message.command == cmGetBuf) Modif=True;
#endif
 if( event.what == evBroadcast && event.message.command == cmScrollBarChanged) //List ListBox
 {
  if(MyTListBox1->state & sfFocused)    // ListBox1
  {
   if(Modif)
   {
    control = messageBox(mfWarning | mfOKCancel,"㯯 . ࠭ ?");
    if(control==cmOK)
    {
     SaveChengeGrg(OldIndChek);
     Modifs=True;
    }
    Modif=False;
   }
#ifdef __DOS32__
   if(getShiftState() & (kbLeftShift|kbRightShift))
   {
    str1=(char *)GrgDBF->getItem(OldIndChek);
    str2=(char *)GrgDBF->getItem(MyTListBox1->focused);
    GrgDBF->DeleteItems(OldIndChek,0);
    GrgDBF->AddItem(OldIndChek,str2);
    GrgDBF->DeleteItems(MyTListBox1->focused,0);
    GrgDBF->AddItem(MyTListBox1->focused,str1);

    GrgColect->freeAll();
    for(i=0;i<GrgDBF->GetCountItems();i++)
    {
     str1 = new char[10];
     GrgDBF->GetFieldIt(i,"SHIFR",str1);
     GrgColect->insert(str1);
    }
    MyTListBox1->drawView();
    ViewGrg(MyTListBox1->focused);
    Modifs=True;
   }
#endif
   ViewGrg(MyTListBox1->focused);
   clearEvent(event);
   OldIndChek=MyTListBox1->focused;
  }
 }

 if( event.what == evCommand )
 {
  switch( event.message.command )
  {
   case cmOK:
        SaveChengeGrg(MyTListBox1->focused);
        Modifs=True; Modif=False;
        clearEvent(event);
        break;
   case cmCancel:
        ViewGrg(MyTListBox1->focused);
        Modif=False;
        clearEvent(event);
        break;
   case cmSave1:
        control = messageBox(mfWarning | mfOKCancel,Text_msg[37]);
        if(control!=cmOK) break;
        SaveChengeGrg(MyTListBox1->focused);
        sprintf(str,Text_msg[109],PathDir,NameGrg);
        GrgDBF->SaveFile(str);
        Modif=Modifs=False;
        break;
   case cmReLoad:
        control = messageBox(mfWarning | mfOKCancel,Text_msg[38]);
        if(control!=cmOK) break;
        sprintf(str,Text_msg[109],PathDir,NameGrg);
        myApp->LoadGrg(str,&GrgDBF); GrgColect->freeAll();
        for(i=0;i<GrgDBF->GetCountItems();i++)
        {
         str1 = new char[12];
         GrgDBF->GetFieldIt(i,"SHIFR",str1);
         GrgColect->insert(str1);
        }
        MyTListBox1->setRange( MyTListBox1->list()->getCount());
        MyTListBox1->drawView(); MyTListBox1->focusItem(OldIndChek=0); ViewGrg(OldIndChek);
        Modif=Modifs=False;
        break;
   case cmInsert:
   case cmAdd:
   case cmRename:
        str1 = new char[12]; str1[0]=0;
        if(event.message.command==cmRename) GrgDBF->GetFieldIt(MyTListBox1->focused,"SHIFR",str1);
        control = inputBox(" ", "㯯",str1, 8);
        if(control==cmOK)
        {
         for(i=0;i<GrgDBF->GetCountItems();i++)
         {
          GrgDBF->GetFieldIt(i,"SHIFR",str);
          for(iii=7;iii>=0;iii--)if(str[iii]==' ')str[iii]=0;else break;
          if(!strncmp(str1,str,8)){ i= -1; break;}
         }
         if(i== -1){ DispFixErr(0,Text_msg[15],str1); delete str1; break;}
         if(event.message.command==cmInsert || event.message.command==cmRename) k1 = MyTListBox1->focused;
         if(event.message.command==cmAdd)    k1 = GrgDBF->GetCountItems();
         if(event.message.command==cmRename)
         {
          MyTListBox1->list()->atFree(k1);
//४  Signal
          GrgDBF->GetFieldIt(MyTListBox1->focused,"SHIFR",str);
          myApp->ChekSignal(PathDir,str,2,str1);
//*****************
         }
         else GrgDBF->CreateItems(k1);

         GrgDBF->ModifiFieldIt(k1,"SHIFR",str1);
         MyTListBox1->list()->atInsert(k1,str1);
         MyTListBox1->setRange( MyTListBox1->list()->getCount() );
         MyTListBox1->drawView();
         ViewGrg(MyTListBox1->focused);
         Modifs=True;
        }
        else delete str1;
        clearEvent(event);
        break;
   case cmDelete:
        if(!MyTListBox1->list()->getCount()) break;
        GrgDBF->GetFieldIt(MyTListBox1->focused,"SHIFR",str);
        for(k1=0,i=0;i<MyTListBox1->list()->getCount();i++) if(MyTListBox1->list()->GetOptItem(i)) k1++;
        if(k1) control = messageBox(mfWarning | mfOKCancel,Text_msg[46],k1);
        else
        {
         control = messageBox(mfWarning | mfOKCancel,Text_msg[29],str);
         if(control==cmOK) MyTListBox1->list()->SetOptItem(MyTListBox1->focused,1);
        }
        if(control==cmOK)
        {
         for(i=0;i<MyTListBox1->list()->getCount();i++)
          if(MyTListBox1->list()->GetOptItem(i))
          {
//४  Signal
           GrgDBF->GetFieldIt(i,"SHIFR",str);
           myApp->ChekSignal(PathDir,str,2,NULL);
//*****************
           GrgDBF->DeleteItems(i,1);
           MyTListBox1->list()->atFree(i);
           i--;
          }
         MyTListBox1->setRange( MyTListBox1->list()->getCount() );
         MyTListBox1->drawView();
         ViewGrg(MyTListBox1->focused);
         Modifs=True;
        }
        clearEvent(event);
        break;
   default: ;
  }
 }

}

void TGrgDialog::ViewGrg(int item)
{
 char str1[30];

 if(GrgDBF->GetFieldIt(item,"NAME",str1)== -1)return;
 EditName->setData(str1);

 for(int i=0;i<8;i++)
 {
  sprintf(str1,"SHIFR_P%d",i+1);
  if(GrgDBF->GetFieldIt(item,str1,str1)== -1)return;
  Edit1[i]->setData(str1);
  sprintf(str1,"NV_%d",i+1);
  if(GrgDBF->GetFieldIt(item,str1,str1)== -1)return;
  Edit2[i]->setData(str1);
  sprintf(str1,"NO_%d",i+1);
  if(GrgDBF->GetFieldIt(item,str1,str1)== -1)return;
  Edit3[i]->setData(str1);
 }
}

int TGrgDialog::SelectInput(void* source,TEvent& event)
{
 TEdit *Edit = (TEdit *)source;
 TGrgDialog *Dialog = (TGrgDialog *)Edit->owner;
 char str[30];
 ushort control;

 if(event.what == evKeyboard)
  switch(event.keyDown.keyCode)
  {
   case 0x3920:
     control = myApp->execView( myApp->SelDialog = new TSelDialog(Dialog->PathDir,2,((TEdit *)source)->data));
     if(control==cmOK)
     {
      ((TEdit *)source)->setData( (char *)myApp->SelDialog->Colect2->at(myApp->SelDialog->ListBox2->focused) );
      if(myApp->SelDialog->tip==0)
      {
       sprintf(str,"%f",((analog *)(myApp->SelDialog->Colect2->at(myApp->SelDialog->ListBox2->focused)))->max_sc);
       Dialog->Edit2[Edit->origin.y-Dialog->Edit1[0]->origin.y]->setData(str);
       sprintf(str,"%f",((analog *)(myApp->SelDialog->Colect2->at(myApp->SelDialog->ListBox2->focused)))->min_sc);
       Dialog->Edit3[Edit->origin.y-Dialog->Edit1[0]->origin.y]->setData(str);
      }
      Dialog->Modif=True;
     }
     destroy(myApp->SelDialog);
     break;
   case kbDel: ((TEdit *)source)->setData(Text_msg[49]); Dialog->Modif=True; break;
   case kbUp: Dialog->selectNext(True); Edit->clearEvent(event); break;
   case kbDown: Dialog->selectNext(False); Edit->clearEvent(event); break;
  }
 return(1);
}

void TGrgDialog::SaveChengeGrg(int item)
{
 char str1[30];

 GrgDBF->ModifiFieldIt(item,"NAME",EditName->data);
 for(int i=0;i<8;i++)
 {
  sprintf(str1,"SHIFR_P%d",i+1);
  GrgDBF->ModifiFieldIt(item,str1,Edit1[i]->data);
  sprintf(str1,"NV_%d",i+1);
  GrgDBF->ModifiFieldIt(item,str1,Edit2[i]->data);
  sprintf(str1,"NO_%d",i+1);
  GrgDBF->ModifiFieldIt(item,str1,Edit3[i]->data);
 }
}

int TGrgDialog::EnterNumber(void* source,TEvent& event)
{
 char code,str[15];
 float numb;
 TEdit *Edit = (TEdit *)source;
 TGrgDialog *Dialog = (TGrgDialog *)Edit->owner;

 if(event.what == evKeyboard)
 {
  switch(event.keyDown.keyCode)
  {
   case kbEnter: numb=atof(Edit->data);
                 sprintf(str,"%f",numb); Edit->setData(str); //Dialog->Modif=True;
                 Dialog->selectNext(False); break;
   case kbDown: Dialog->selectNext(False); Edit->clearEvent(event); break;
   case kbUp: Dialog->selectNext(True); Edit->clearEvent(event); break;
  }
  code=event.keyDown.charScan.charCode;
  if( !((code>='0'&&code<='9') || code=='-' || code=='.' || code<' ')) Edit->clearEvent(event);
 }
 return(0);
}


//==================================================
void TMyApp::LoadGrg(char* Name, TBasaDBF **BasaDBF)
{
 int i;
 *BasaDBF = new TBasaDBF();
 if((*BasaDBF)->LoadFile(Name)== -1) (*BasaDBF)->LoadFields(gr_graf,sizeof(gr_graf)/sizeof(db_str_rec));
 if(!(*BasaDBF)->getField("SHIFR_P8")) for(i=39;i<sizeof(gr_graf)/sizeof(db_str_rec);i++) (*BasaDBF)->addField(100,gr_graf+i);
}

