const ushort cmDownLeftMouse = 70;
const ushort cmDownSpace = 71;

//================================================================================
//==================== TAlgCollection ============================================
//================================================================================
class TAlgCollection : public TCollection
{

public:
    TAlgCollection( ccIndex aLimit, ccIndex aDelta) : TCollection( aLimit, aDelta ) {}
;
private:

#ifndef NO_TV_STREAMS
    virtual const char *streamableName() const
        { return name; }
    virtual void *readItem( ipstream& ){return NULL;};
    virtual void writeItem( void *, opstream& ){};

protected:

    TAlgCollection( StreamableInit ) : TCollection ( streamableInit ) {}

public:

    static const char * const near name;
    static TStreamable *build()
    { return new TAlgCollection( streamableInit ); };
#endif  // ifndef NO_TV_STREAMS
};


//================================================================================
//==================== TCompCollect ==============================================
//================================================================================

struct CollIt
{
 char opt;
 void *item;
};

class TCompCollect : public TObject
{
public:

    TCompCollect( ccIndex aLimit, ccIndex aDelta );
    ~TCompCollect();

    virtual void shutDown();

    void *at( ccIndex index );
    virtual ccIndex indexOf( void *item );

    void atFree( ccIndex index );
    void atRemove( ccIndex index );
    void remove( void *item );
    void removeAll();
    void free( void *item );
    void freeAll();

    void atInsert( ccIndex index, void *item );
    void atPut( ccIndex index, void *item );
    virtual ccIndex insert( void *item );

    static void error( ccIndex code, ccIndex info );

    void *firstThat( ccTestFunc Test, void *arg );
    void *lastThat( ccTestFunc Test, void *arg );
    void forEach( ccAppFunc action, void *arg );

    void pack();
    virtual void setLimit( ccIndex aLimit );

    void SetOptItem(int item,char opt){if(item<count) items[item].opt=opt;}
    char GetOptItem(int item){return(items[item].opt);}

    ccIndex getCount()
        { return count; }

protected:

    TCompCollect();
    CollIt *items;
    ccIndex count;
    ccIndex limit;
    ccIndex delta;
    Boolean shouldDelete;

private:

    virtual void freeItem( void *item );
};


//================================================================================
//==================== TMyCheckBoxes  ============================================
//================================================================================
class TMyCheckBoxes : public TCheckBoxes
{
public:
  TMyCheckBoxes( const TRect& bounds, TSItem *aStrings,funcptr func) :
                 TCheckBoxes( bounds, aStrings), funcEvent(func) {};
  void press(int item);
  funcptr funcEvent;
};


//=================================================================
//========= TMyTListBox ===========================================
//=================================================================
class TMyTListBox : public TListViewer
{
 public:
  TMyTListBox(const TRect& bounds, ushort aNumCols, TScrollBar *aScrollBar,funcptr func);
  ~TMyTListBox();

  virtual size_t dataSize();
  virtual void getData( void *rec );
  virtual void getText( char *dest, int item, int maxLen );
  virtual void setData( void *rec );

  virtual void handleEvent ( TEvent& event );
  virtual void newList( TCompCollect *aList,int optFre=1);
  virtual void draw();
  funcptr funcEvent;

  TCompCollect *list();

 private:

  TCompCollect *items;

 protected:

  virtual void write( opstream& ){};
  virtual void *read( ipstream& ){return(NULL);};
};

inline TCompCollect *TMyTListBox::list()
{
    return items;
}


//=================================================================
//========= TEdit       ===========================================
//=================================================================
class TEdit : public TInputLine
{
 public:
  TEdit( const TRect& bounds, int aMaxLen,funcptr func) :
         TInputLine(bounds,aMaxLen) {funcEvent=func;};
  virtual void draw();
  void  handleEvent( TEvent& event );
  void selectAll( Boolean enable );
  void setData( void *rec );
  void setState( ushort aState, Boolean enable );
  funcptr funcEvent;
 private:
  Boolean canScroll( int delta );
  int mouseDelta( TEvent& event );
  int mousePos( TEvent& event );
  void deleteSelect();
  static const char near rightArrow;
  static const char near leftArrow;
};

//================================================================================
//==================== TMyLabel  =================================================
//================================================================================
class TMyLabel : public TLabel
{
 public:
  TMyLabel( const TRect& bounds, const char *aText, TView *aLink,char algn) :
            TLabel(bounds,aText,aLink) {align=algn;};
  void handleEvent( TEvent& event );
  void SetText(char *aText);
  void draw();
  char align;
};



//================================================================================
//==================== TComboBoxWindow  ==========================================
//================================================================================
class TComboBoxWindow : public TDialog
{
public:

 TComboBoxWindow(const TRect& bounds, TCompCollect * items,int st_pos);
 virtual void handleEvent( TEvent& event );

 int selpos;

protected:
 TMyTListBox *MyTListBox;

};

//================================================================================
//==================== TComboBox  ================================================
//================================================================================
class TComboBox : public TView
{
public:
 TComboBox( const TRect& bounds, TEdit *aLink, TCompCollect *list, funcptr func);

 virtual void draw();
 virtual TPalette& getPalette() const;
 virtual void handleEvent( TEvent& event );
// virtual TComboBoxWindow *initComboBoxWindow( const TRect& bounds );

 funcptr funcEvent;

 TCompCollect *list() { return items; } ;
 int posit;

protected:

 TEdit *link;

private:
 TCompCollect *items;
 static const char * near icon;
};

//ꥪ  DBF

//================================================================================
//==================== TBasaDBF  =================================================
//================================================================================
class TBasaDBF
{
public:
 TBasaDBF();
 ~TBasaDBF();

 int LoadFields(db_str_rec *fields,int number);
 int addField(int pos,db_str_rec *field_ptr);
 int DelField(int pos);
 int DelField(char *NameField);
 db_str_rec *getField(int posField);
 db_str_rec *getField(char *NameField);
 int CreateItems(int pos);
 int DeleteItems(int pos,int fr);
 void *getItem(int posItem);
 void AddItem(int posItem,void *it);

 int ModifiFieldIt(int posItems,int posField,char *str);
 int ModifiFieldIt(int posItems,char *NameField,char *str);

 int GetFieldIt(int posItems,int posField, char *str);
 int GetFieldIt(int posItems,char *NameField, char *str);

 int GetCountItems();

 int SaveFile(char *Name);
 int LoadFile(char *Name);

protected:
 db_head *db_head_ptr;       //⥫  
 db_str_rec *db_field_ptr;   //⥫    
 void **items;                //
};


//================================================================================
//==================== TInputBox  ================================================
//================================================================================

//----------------------------------------------------------------------
#define MAXLABELLEN 62
#define MAXVALUELEN 10

typedef struct
{
  char label[MAXLABELLEN];
  char value[MAXVALUELEN];
} ListBoxItem;

class TExecInputLine : TEdit  //TInputLine
{
  public:
   TExecInputLine(const TRect&, int,funcptr func);
   virtual ushort execute();
   virtual void set(void *rec);
   virtual void get(void *rec);
};

class TInputBox :  public TListBox
{
  public:
    TInputBox( const TRect&, ushort, TScrollBar *,funcptr func);
    virtual void getText( char *, int, int );
    virtual void handleEvent(TEvent& );
    virtual ushort inputData();
    funcptr funcT;
};

class TTextView : public TScroller
{
public:
 TAlgCollection *fileLines;
 TTextView( const TRect& bounds, TScrollBar *aHScrollBar, TScrollBar *aVScrollBar);
 ~TTextView();
 virtual TPalette& getPalette() const;
 void setData(char *str);
 void setState( ushort aState, Boolean enable );
 void draw();
 void scrollDraw();

 static const char * const name;

private:
 virtual const char *streamableName() const { return name; }
};
