#include "alg.h"
#include "alg_cfg.h"
#include "gadgets.h"
#include "mylib.h"
#include "ed_alg1.h"
#include "ed_frm1.h"
#include "mnemo.h"
#include "grc.h"
#include "grg.h"
#include "view.h"
#include "comtabl.h"
#include "signal.h"
#include "lib.h"
#include "speak.h"
#include "control.h"
#include "demohelp.h"

#ifdef __DOS32__
extern "C" int SB_Initialize();
extern "C" int SB_DeInitialize();
extern "C" int SB_Lib_via( char * File_Name );
#endif

void CDECL DispFixErr(int op,char *fmt, ...);
void readFile(char *fileName );
void deleteFile();
//------------------------ Constructors --------------------------------------

char *disp_lines[] ={
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"" };

int main()
{
 myApp = new TMyApp();
 myApp->run();
#ifdef __DOS32__
 SB_DeInitialize();
#endif
 delete myApp;
 return 0;
}

TMyApp::TMyApp() :
        TProgInit(&TMyApp::initStatusLine,&TMyApp::initMenuBar, &TMyApp::initDeskTop)
{
    TRect r = getExtent();                      // Create the clock view.
    r.a.x = r.b.x - 8;      r.b.y = r.a.y + 1;
    clock = new TClockView( r );
    insert(clock);

    r = getExtent();                            // Create the heap view.
    r.a.x = r.b.x - 8;     r.a.y = r.b.y - 1;
    heap = new THeapView( r );
    insert(heap);
};

//--------------- FUNCTIONS ----------------------
void TMyApp::ChengeDir()
{
 TView *d = validView( new TChDirDialog( 0, hlChangeDir ) );
 if( d != 0 ) { deskTop->execView( d ); destroy( d ); }
};

void TMyApp::Speak()
{
 char str[256],str1[256];
 getcwd(str1,sizeof(str1)); sprintf(str,Text_msg[42],str1);

 if(ChekWin(str)) if(messageBox(mfWarning | mfOKCancel,Text_msg[95])!=cmOK) return;
 TView *d = validView(new TSpeakDialog( ));
 deskTop->insert( d );
}


void TMyApp::PasportA()
{
 char str[256], str1[256];
 getcwd(str1,sizeof(str1)); sprintf(str,Text_msg[44],str1);

 if(ChekWin(str)) if(messageBox(mfWarning | mfOKCancel,Text_msg[95])!=cmOK) return;
 TView *d = validView(new TPasportDialog(str1,1,0));
 deskTop->insert( d );
}

void TMyApp::PasportD()
{
 char str[256], str1[256];
 getcwd(str1,sizeof(str1)); sprintf(str,Text_msg[45],str1);

 if(ChekWin(str)) if(messageBox(mfWarning | mfOKCancel,Text_msg[95])!=cmOK) return;
 TView *d = validView(new TPasportDialog(str1,2,0));
 deskTop->insert( d );
}

void TMyApp::Controller()
{
 char str[256],str1[256];
 getcwd(str1,sizeof(str1)); sprintf(str,Text_msg[43],str1);

 if(ChekWin(str)) if(messageBox(mfWarning | mfOKCancel,Text_msg[95])!=cmOK) return;
 TView *d = validView(new TControlDialog( ));
 deskTop->insert( d );
}

void TMyApp::Lib()
{
 char str[256],str1[256];
 getcwd(str1,sizeof(str1)); sprintf(str,Text_msg[41],str1);

 if(ChekWin(str)) if(messageBox(mfWarning | mfOKCancel,Text_msg[95])!=cmOK) return;
 TView *d = validView(new TLibDialog( ));
 deskTop->insert( d );
}

void TMyApp::MshView()
{
 char str[256],str1[256];
 getcwd(str1,sizeof(str1)); sprintf(str,Text_msg[32],str1);

 if(ChekWin(str)) if(messageBox(mfWarning | mfOKCancel,Text_msg[95])!=cmOK) return;
 TView *d = validView(new TMshDialog( ));
 deskTop->insert( d );
};

void TMyApp::GrcView()
{
 char str[256],str1[256];
 getcwd(str1,sizeof(str1)); sprintf(str,Text_msg[33],str1);

 if(ChekWin(str)) if(messageBox(mfWarning | mfOKCancel,Text_msg[95])!=cmOK) return;
 TView *d = validView(new TGrcDialog( ));
 deskTop->insert( d );
}

void TMyApp::GrgView()
{
 char str[256],str1[256];
 getcwd(str1,sizeof(str1)); sprintf(str,Text_msg[35],str1);

 if(ChekWin(str)) if(messageBox(mfWarning | mfOKCancel,Text_msg[95])!=cmOK) return;
 TView *d = validView(new TGrgDialog( ));
 deskTop->insert( d );
}

void TMyApp::Signal()
{
 char str[256],str1[256];
 getcwd(str1,sizeof(str1)); sprintf(str,Text_msg[36],str1);

 if(ChekWin(str)) if(messageBox(mfWarning | mfOKCancel,Text_msg[95])!=cmOK) return;
 TView *d = validView(new TSignalDialog( ));
 deskTop->insert( d );
}

void TMyApp::View()
{
 char str[256],str1[256];
 getcwd(str1,sizeof(str1)); sprintf(str,Text_msg[39],str1);

 if(ChekWin(str)) if(messageBox(mfWarning | mfOKCancel,Text_msg[95])!=cmOK) return;
 TView *d = validView(new TViewDialog( ));
 deskTop->insert( d );
}

void TMyApp::Comt()
{
 char str[256],str1[256];
 getcwd(str1,sizeof(str1)); sprintf(str,Text_msg[40],str1);

 if(ChekWin(str)) if(messageBox(mfWarning | mfOKCancel,Text_msg[95])!=cmOK) return;
 TView *d = validView(new TComtDialog( ));
 deskTop->insert( d );
}

void TMyApp::FormulsView1()
{
 char str[256],str1[256];
 getcwd(str1,sizeof(str1)); sprintf(str,Text_msg[31],str1);

 if(ChekWin(str)) if(messageBox(mfWarning | mfOKCancel,Text_msg[95])!=cmOK) return;
 TView *d = validView(new TFormulsDialog1( ));
 deskTop->insert( d );
}

void TMyApp::AlgoblView1()
{
 char str[256],str1[256];
 getcwd(str1,sizeof(str1)); sprintf(str,Text_msg[30],str1);

 if(ChekWin(str)) if(messageBox(mfWarning | mfOKCancel,Text_msg[95])!=cmOK) return;
 TView *d = validView(new TAlgDialog1( ));
 deskTop->insert( d );
}

void TMyApp::ProtocolView()
{
 TView *Nearptr;
 TRect r1( 0, 0, 26, 7 );           // ⠭ 砫쭮
                                    // ࠧ  ᯮ
 Nearptr =(TView *)message(deskTop, evBroadcast, cmFindProtocol, 0);
 if (Nearptr != 0) Nearptr->select();
 else
 {
  TView *w= validView( new TFileWindow1( NameErr ) );
  if( w != 0 ) deskTop->insert(w);
 }
}

void TMyApp::idle()
{
    TProgram::idle();
    clock->update();
    heap->update();
    statusLine->update();
}

void TMyApp::handleEvent( TEvent& event )
{

    TApplication::handleEvent( event );
    if( event.what == evCommand )
    {
     switch( event.message.command )
     {
      case cmProtocol:  ProtocolView(); break;
      case cmAlgobls1:  AlgoblView1();  break;
      case cmFormuls1:  FormulsView1(); break;
      case cmChangeDir: ChengeDir();    break;
      case cmMsh:       MshView();      break;
      case cmGrc:       GrcView();      break;
      case cmGrg:       GrgView();      break;
      case cmSignal:    Signal();       break;
      case cmView:      View();         break;
      case cmCmpt:      Comt();         break;
      case cmLib:       Lib();          break;
      case cmSpeak:     Speak();        break;
      case cmContr:     Controller();   break;
      case cmPaspA:     PasportA();     break;
      case cmPaspD:     PasportD();     break;
      case cmAllCntr:   AllControl();   break;
//      case cmRetry:
//           Algobloks->execView();
      default:
           return;
     }
     clearEvent( event );
    }
};

//
// DemoApp::getEvent()
//  Event loop to check for context help request
//

void TMyApp::getEvent(TEvent &event)
{
    TWindow *w;
    THelpFile *hFile;
    fpstream *helpStrm;
    static Boolean helpInUse = False;



    TApplication::getEvent(event);
    switch (event.what)
        {
        case evCommand:
            if ((event.message.command == cmHelp) && ( helpInUse == False))
                {
                helpInUse = True;
                helpStrm = new fpstream(NameHelp, ios::in|ios::binary);
                hFile = new THelpFile(*helpStrm);
                if (!helpStrm)
                    {
                    messageBox(Text_msg[105], mfError | mfOKButton);
                    delete hFile;
                    }
                else
                    {
                    w = new THelpWindow(hFile, getHelpCtx());
                    if (validView(w) != 0)
                        {
                        execView(w);
                        destroy( w );
                        }
                    clearEvent(event);
                    }
                helpInUse = False;
                }
            break;
        case evMouseDown:
            if (event.mouse.buttons != 1)
                event.what = evNothing;
            break;
        }
}

TMenuBar *TMyApp::initMenuBar (TRect r)
{
 r.b.y = r.a.y+1;

 return new TMenuBar( r,
     *new TSubMenu( "~F~ile", kbAltF )+
//       *new TMenuItem( "~O~en", cmFileOpen,kbF3,hcNoContext,"F3")+
       *new TMenuItem( "~P~rotocol", cmProtocol,kbNoKey)+
       *new TMenuItem( "~C~hange dir...", cmChangeDir, kbNoKey ) +
       newLine()+
       *new TMenuItem( "E~x~it", cmQuit,cmQuit,hcNoContext,"Alt-X") +
     *new TSubMenu( "~E~dit", kbAltE ) +
       *new TMenuItem( "~U~ndo", cmUndo, kbNoKey ) +
            newLine() +
       *new TMenuItem( "Cu~t~", cmCut, kbShiftDel, hcNoContext, "Shift-Del" ) +
       *new TMenuItem( "~C~opy", cmCopy, kbCtrlIns, hcNoContext, "Ctrl-Ins" ) +
       *new TMenuItem( "~P~aste", cmPaste, kbShiftIns, hcNoContext, "Shift-Ins" ) +
//       *new TMenuItem( "~S~how clipboard", cmShowClip, kbNoKey ) +
            newLine() +
       *new TMenuItem( "~C~lear", cmClear, kbCtrlDel, hcNoContext, "Ctrl-Del" ) +
     *new TSubMenu( "~C~ontroller`s", kbAltC) +
       *new TMenuItem( "~C~ontroller`s", cmContr,kbNoKey) +
       *new TMenuItem( "~A~nalog pasports", cmPaspA,kbF5/*kbNoKey*/) +
       *new TMenuItem( "~D~igit pasports", cmPaspD,kbNoKey) +
     *new TSubMenu( "F~o~rm", kbAltO) +
       *new TMenuItem( "~O~bjekt signal", cmSignal,kbNoKey) +
       *new TMenuItem( "~C~onturs", cmGrc,kbNoKey) +
       *new TMenuItem( "~G~rafics", cmGrg,kbNoKey) +
       *new TMenuItem( "~V~iew", cmView,kbNoKey) +
       *new TMenuItem( "Co~m~tabl", cmCmpt,kbNoKey) +
       *new TMenuItem( "~S~peaks", cmSpeak,kbNoKey) +
       *new TMenuItem( "~M~nemoshems", cmMsh,kbNoKey) +
     *new TSubMenu( "~A~lgobloks", kbAltA) +
       *new TMenuItem( "~F~ormuls", cmFormuls1,kbNoKey) +
       *new TMenuItem( "~A~lgobloks", cmAlgobls1,kbNoKey) +
     *new TSubMenu( "~U~tils", kbAltU) +
       *new TMenuItem( "~L~ibs", cmLib,kbNoKey) +
       *new TMenuItem( "~A~ll control", cmAllCntr,kbNoKey) +
     *new TSubMenu( "~W~indows",0) +
       *new TMenuItem( "~R~esize/move", cmResize,kbCtrlF5,0,"Ctrl-F5") +
       *new TMenuItem( "~Z~oom", cmZoom,kbF5,0,"F5")+
       *new TMenuItem( "~N~ext", cmNext,kbF6,0,"F6")+
       *new TMenuItem( "~C~lose", cmClose,kbAltF3,0,"Alt-F3")+
       *new TMenuItem( "~T~ile", cmTile,kbNoKey)+
       *new TMenuItem( "C~a~scade", cmCascade,kbNoKey)
     );
};

TStatusLine *TMyApp::initStatusLine (TRect r)
{
 r.a.y = r.b.y-1;

 TStatusDef& StDef1 =
     *new TStatusDef( 0, hcNocontext ) +
     *new TStatusItem( "~Alt-X~ Exit", kbAltX, cmQuit ) +
     *new TStatusItem( 0, kbF10, cmMenu ) + *new TStatusItem( 0, kbCtrlF4,cmClose) +
     *new TStatusItem( 0, kbF5, cmZoom ) +  *new TStatusItem( 0, kbCtrlF5, cmResize ) +
     *new TStatusItem( 0, kbF6, cmNext ) +  *new TStatusItem( 0, kbF1, cmHelp );

 TStatusDef& StDef2 =
     *new TStatusDef( 0, hcMain ) +
     *new TStatusItem( "~Alt-X~ Exit", kbAltX, cmQuit ) +
     *new TStatusItem( 0, kbF10, cmMenu ) + *new TStatusItem( 0, kbCtrlF4,cmClose) +
     *new TStatusItem( 0, kbF5, cmZoom ) +  *new TStatusItem( 0, kbCtrlF5, cmResize ) +
     *new TStatusItem( 0, kbF6, cmNext ) +  *new TStatusItem( 0, kbF1, cmHelp );

 TStatusDef& StDef3 =
     *new TStatusDef( 0, hcAllASearch ) +
     *new TStatusItem( "~Ins~ Ins", kbIns, cmInsert) +
     *new TStatusItem( "~Gr +~ Add", kbGrayPlus, cmAdd) +
     *new TStatusItem( "~Gr -~ Del", kbDel, cmDelete) +
     *new TStatusItem( "~Gr *~ Ren", 0x372A, cmRename) +
     *new TStatusItem( "~Gr -~ Rem", kbGrayMinus, cmMove) +
     *new TStatusItem( "~F7~ Search", kbF7, cmSearch) +
     *new TStatusItem( "~Sh F7~ Search next", kbShiftF7, cmSearchNext) +
     *new TStatusItem( "~F3~ Reload", kbF3, cmReLoad) +
     *new TStatusItem( "~F2~ Save", kbF2, cmSave1) +
     *new TStatusItem( "~F4~ Fill", kbF4, cmFill) +
     *new TStatusItem( 0, kbF10, cmMenu ) + *new TStatusItem( 0, kbCtrlF4,cmClose) +
     *new TStatusItem( 0, kbF5, cmZoom ) +  *new TStatusItem( 0, kbCtrlF5, cmResize ) +
     *new TStatusItem( 0, kbF6, cmNext ) +  *new TStatusItem( 0, kbF1, cmHelp );

 TStatusDef& StDef4 =
     *new TStatusDef( 0, hcFormulsEditor ) +
     *new TStatusItem( "~Gr -~ Del", kbGrayMinus, cmDelete) +
     *new TStatusItem( "~Gr +~ Add", kbGrayPlus, cmAdd) +
     *new TStatusItem( "~F3~ Reload", kbF3, cmReLoad) +
     *new TStatusItem( "~F2~ Save", kbF2, cmSave1) +
     *new TStatusItem( 0, kbF10, cmMenu ) + *new TStatusItem( 0, kbCtrlF4,cmClose) +
     *new TStatusItem( 0, kbF5, cmZoom ) +  *new TStatusItem( 0, kbCtrlF5, cmResize ) +
     *new TStatusItem( 0, kbF6, cmNext ) +  *new TStatusItem( 0, kbF1, cmHelp );

 TStatusDef& StDef5 =
     *new TStatusDef( 0, hcSearch ) +
     *new TStatusItem( "~F7~ Search", kbF7, cmSearch) +
     *new TStatusItem( "~Shift F7~ Search next", kbShiftF7, cmSearchNext) +
     *new TStatusItem( "~F3~ Reload", kbF3, cmReLoad) +
     *new TStatusItem( "~F2~ Save", kbF2, cmSave1) +
     *new TStatusItem( 0, kbF10, cmMenu ) + *new TStatusItem( 0, kbCtrlF4,cmClose) +
     *new TStatusItem( 0, kbF5, cmZoom ) +  *new TStatusItem( 0, kbCtrlF5, cmResize ) +
     *new TStatusItem( 0, kbF6, cmNext ) +  *new TStatusItem( 0, kbF1, cmHelp );

 TStatusDef& StDef6 =
     *new TStatusDef( 0, hcAllASave ) +
     *new TStatusItem( "~F3~ Reload", kbF3, cmReLoad) +
     *new TStatusItem( "~F2~ Save", kbF2, cmSave1) +
     *new TStatusItem( 0, kbF10, cmMenu ) + *new TStatusItem( 0, kbCtrlF4,cmClose) +
     *new TStatusItem( 0, kbF5, cmZoom ) +  *new TStatusItem( 0, kbCtrlF5, cmResize ) +
     *new TStatusItem( 0, kbF6, cmNext ) +  *new TStatusItem( 0, kbF1, cmHelp );

 TStatusDef& StDef7 =
     *new TStatusDef( 0, hcMax ) +
     *new TStatusItem( "~Gr +~ Add", kbGrayPlus, cmAdd) +
     *new TStatusItem( "~Ins~ Ins", kbIns, cmInsert) +
     *new TStatusItem( "~Del~ Del", kbDel, cmDelete) +
     *new TStatusItem( "~Gr *~ Ren/Rep", 0x372A, cmRename) +
     *new TStatusItem( "~F3~ Reload", kbF3, cmReLoad) +
     *new TStatusItem( "~F2~ Save", kbF2, cmSave1) +
     *new TStatusItem( 0, kbF10, cmMenu ) + *new TStatusItem( 0, kbCtrlF4,cmClose) +
     *new TStatusItem( 0, kbF5, cmZoom ) +  *new TStatusItem( 0, kbCtrlF5, cmResize ) +
     *new TStatusItem( 0, kbF6, cmNext ) +  *new TStatusItem( 0, kbF1, cmHelp );

 TStatusDef& StDef8 =
     *new TStatusDef( 0, hcLib ) +
     *new TStatusItem( "~Ins~ Ins", kbIns, cmInsert) +
     *new TStatusItem( "~Gray +~ Add", kbGrayPlus, cmAdd) +
     *new TStatusItem( "~Delete~ Del", kbDel, cmDelete) +
     *new TStatusItem( "~Gray *~ Extract", 0x372A, cmRename) +
     *new TStatusItem( "~F4~ Correcting", kbF4, cmRes1) +
     *new TStatusItem( 0, kbF10, cmMenu ) + *new TStatusItem( 0, kbCtrlF4,cmClose) +
     *new TStatusItem( 0, kbF5, cmZoom ) +  *new TStatusItem( 0, kbCtrlF5, cmResize ) +
     *new TStatusItem( 0, kbF6, cmNext ) +  *new TStatusItem( 0, kbF1, cmHelp );

 TStatusDef& StDef9 =
     *new TStatusDef( 0, hcSpeak ) +
     *new TStatusItem( "~F3~ Attach The Wav file", kbF3, cmInsert) +
#ifdef __DOS32__
     *new TStatusItem( "~F5~ Hear message", kbF5, cmRename) +
     *new TStatusItem( "~F4~ Speak message", kbF4, cmAdd) +
#endif
     *new TStatusItem( 0, kbF10, cmMenu ) + *new TStatusItem( 0, kbCtrlF4,cmClose) +
     *new TStatusItem( 0, kbF5, cmZoom ) +  *new TStatusItem( 0, kbCtrlF5, cmResize ) +
     *new TStatusItem( 0, kbF6, cmNext ) +  *new TStatusItem( 0, kbF1, cmHelp );

 TStatusDef& StDef10 =
     *new TStatusDef( 0, hcAnCtr ) +
     *new TStatusItem( "~F4~ ஢  ᯮ⮢", kbF4, cmRes1) +
     *new TStatusItem( "~F3~ Reload", kbF3, cmReLoad) +
     *new TStatusItem( "~F2~ Save", kbF2, cmSave1) +
     *new TStatusItem( 0, kbF10, cmMenu ) + *new TStatusItem( 0, kbCtrlF4,cmClose) +
     *new TStatusItem( 0, kbF5, cmZoom ) +  *new TStatusItem( 0, kbCtrlF5, cmResize ) +
     *new TStatusItem( 0, kbF6, cmNext ) +  *new TStatusItem( 0, kbF1, cmHelp );

 TStatusDef& StDef11 =
     *new TStatusDef( 0, hcDigCtr ) +
     *new TStatusItem( "~F4~ ஢  ᯮ⮢", kbF4, cmRes2) +
     *new TStatusItem( "~F3~ Reload", kbF3, cmReLoad) +
     *new TStatusItem( "~F2~ Save", kbF2, cmSave1) +
     *new TStatusItem( 0, kbF10, cmMenu ) + *new TStatusItem( 0, kbCtrlF4,cmClose) +
     *new TStatusItem( 0, kbF5, cmZoom ) +  *new TStatusItem( 0, kbCtrlF5, cmResize ) +
     *new TStatusItem( 0, kbF6, cmNext ) +  *new TStatusItem( 0, kbF1, cmHelp );

 TStatusDef& StDef12 =
     *new TStatusDef( 0, hcMnem ) +
     *new TStatusItem( "~Gr +~ Add", kbGrayPlus, cmAdd) +
     *new TStatusItem( "~Ins~ Ins", kbIns, cmInsert) +
     *new TStatusItem( "~Del~ Del", kbDel, cmDelete) +
     *new TStatusItem( "~Gr *~ Ren/Rep", 0x372A, cmRename) +
     *new TStatusItem( "~F3~ Reload", kbF3, cmReLoad) +
     *new TStatusItem( "~F2~ Save", kbF2, cmSave1) +
#ifdef __DOS32__
     *new TStatusItem( "~F4~ Mnem", kbF4, cmRes1) +
#endif
     *new TStatusItem( 0, kbF10, cmMenu ) + *new TStatusItem( 0, kbCtrlF4,cmClose) +
     *new TStatusItem( 0, kbF5, cmZoom ) +  *new TStatusItem( 0, kbCtrlF5, cmResize ) +
     *new TStatusItem( 0, kbF6, cmNext ) +  *new TStatusItem( 0, kbF1, cmHelp );

 TStatusDef& StDef13 =
     *new TStatusDef( 0, hcDin ) +
     *new TStatusItem( "~Gr +~ Add", kbGrayPlus, cmAdd) +
     *new TStatusItem( "~Ins~ Ins", kbIns, cmInsert) +
     *new TStatusItem( "~Del~ Del", kbDel, cmDelete) +
     *new TStatusItem( "~Gr *~ Ren/Rep", 0x372A, cmRename) +
     *new TStatusItem( "~F3~ Reload", kbF3, cmReLoad) +
     *new TStatusItem( "~F2~ Save", kbF2, cmSave1) +
     *new TStatusItem( "~F4~ Positions", kbF4, cmRes2) +
     *new TStatusItem( 0, kbF10, cmMenu ) + *new TStatusItem( 0, kbCtrlF4,cmClose) +
     *new TStatusItem( 0, kbF5, cmZoom )  + *new TStatusItem( 0, kbCtrlF5, cmResize ) +
     *new TStatusItem( 0, kbF6, cmNext )  + *new TStatusItem( 0, kbF1, cmHelp );

 TStatusDef& StDef14 =
     *new TStatusDef( 0, hcEdit ) +
     *new TStatusItem( "~F3~ Reload", kbF3, cmReLoad) +
     *new TStatusItem( "~F2~ Save", kbF2, cmSave1) +
     *new TStatusItem( 0, kbF10, cmMenu ) + *new TStatusItem( 0, kbCtrlF4,cmClose) +
     *new TStatusItem( 0, kbF5, cmZoom )  + *new TStatusItem( 0, kbCtrlF5, cmResize ) +
     *new TStatusItem( 0, kbF6, cmNext )  + *new TStatusItem( 0, kbF1, cmHelp )+
     *new TStatusItem( 0, kbAltBack, cmUndo ) + *new TStatusItem( 0, kbShiftDel, cmCut ) +
     *new TStatusItem( 0, kbCtrlIns, cmCopy ) + *new TStatusItem( 0, kbShiftIns, cmPaste );

 TStatusDef& StDef15 =
     *new TStatusDef( 0, hcComboEdit ) +
     *new TStatusItem( "~F3~ Reload", kbF3, cmReLoad) +
     *new TStatusItem( "~F2~ Save", kbF2, cmSave1) +
     *new TStatusItem( "~F4~ Edit", kbF4, cmChange) +
     *new TStatusItem( 0, kbF10, cmMenu ) + *new TStatusItem( 0, kbCtrlF4,cmClose) +
     *new TStatusItem( 0, kbF5, cmZoom )  + *new TStatusItem( 0, kbCtrlF5, cmResize ) +
     *new TStatusItem( 0, kbF6, cmNext )  + *new TStatusItem( 0, kbF1, cmHelp )+
     *new TStatusItem( 0, kbAltBack, cmUndo ) + *new TStatusItem( 0, kbShiftDel, cmCut ) +
     *new TStatusItem( 0, kbCtrlIns, cmCopy ) + *new TStatusItem( 0, kbShiftIns, cmPaste );

return new TStatusLine( r,StDef1+StDef2+StDef3+StDef4+StDef5+StDef6+StDef7+
                          StDef8+StDef9+StDef10+StDef11+StDef12+StDef13+StDef14+StDef15);

};

TDeskTop *TMyApp::initDeskTop( TRect r )
{
 r.a.y++;
 r.b.y--;
 return ( new TNewDeskTop( r ) );
}

void TNewBackground::draw()
{
 TDrawBuffer b;

 for(int i= 0; i < size.y; i++)
 {
  for( int j= 0; j < size.x; j++) b.moveChar( j, disp_lines[i][j], getColor(0x01), 1 );
  writeLine( 0, i, size.x, 1, b );
 }
}

TBackground *TNewDeskTop::initBackground( TRect r )
{
 return new TNewBackground( r, 177 );
}
