/*
 * UFC-crypt: ultra fast crypt(3) implementation
 * md5-crypt: one way encryption based on MD5 sum
 * blowfish-crypt: compatible with OpenBSD bcrypt (version 2a)
 *
 * Copyright (C) 1991-1993,1996-1998,2000,2004,2012
 * Free Software Foundation, Inc.
 *
 * The GNU C Library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * The GNU C Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with the GNU C Library; if not, see
 * <http://www.gnu.org/licenses/>.
 *
 * @(#)crypt.h	1.5 12/20/96
 *
 */

#ifndef _CRYPT_H
#define _CRYPT_H	1

#include <features.h>

__BEGIN_DECLS

/* Encrypt at most 8 characters from KEY using salt to perturb DES.  */
extern char *crypt (const char *__key, const char *__setting)
     __THROW __nonnull ((1, 2));

/* Setup DES tables according KEY.  */
extern void setkey (const char *__key) __THROW __nonnull ((1));

/* Encrypt data in BLOCK in place if EDFLAG is zero; otherwise decrypt
   block in place.  */
extern void encrypt (char *__block, int __edflag) __THROW __nonnull ((1));

#ifdef __USE_GNU
/* Reentrant versions of the functions above.  The additional argument
   points to a structure where the results are placed in.  */
struct crypt_data
  {
    char keysched[16 * 8];
    char sb0[32768];
    char sb1[32768];
    char sb2[32768];
    char sb3[32768];
    /* end-of-aligment-critical-data */
    char crypt_3_buf[14];
    char current_salt[2];
    long int current_saltbits;
    int  direction, initialized;
  };

extern char *crypt_r (const char *__key, const char *__setting,
		      struct crypt_data * __restrict __data)
     __THROW __nonnull ((1, 2, 3));

extern void setkey_r (const char *__key,
		      struct crypt_data * __restrict __data)
     __THROW __nonnull ((1, 2));

extern void encrypt_r (char *__block, int __edflag,
		       struct crypt_data * __restrict __data)
     __THROW __nonnull ((1, 3));
#endif

#if defined(__USE_GNU) || defined(_OW_SOURCE) || defined(__USE_OW)
extern char *crypt_rn (__const char *__key, __const char *__setting,
		       void *__data, int __size)
     __THROW __nonnull ((1, 2, 3));

extern char *crypt_ra (__const char *__key, __const char *__setting,
		       void **__data, int *__size)
     __THROW __nonnull ((1, 2, 3, 4));

extern char *crypt_gensalt (__const char *__prefix, unsigned long __count,
			    __const char *__input, int __size)
     __THROW __nonnull ((1, 3));

extern char *crypt_gensalt_rn (__const char *__prefix, unsigned long __count,
			       __const char *__input, int __input_size,
			       char *__output, int __output_size)
     __THROW __nonnull ((1, 3, 5));

extern char *crypt_gensalt_ra (__const char *prefix, unsigned long __count,
			       __const char *__input, int __size)
     __THROW __nonnull ((1, 3));
#endif

__END_DECLS

#endif	/* crypt.h */
