#! /usr/bin/env python
# -*- coding: utf-8 -*-

from __future__ import generators
__doc__ = """\
Project:    rPAS 
Version:    $Id: python.compileall.py 29 2006-06-10 12:08:45Z ns $
Licence:    GPL
Start:      Mon Mar 15 00:52:16 MSK 2004
Title:      RPM Build Python  / Compile All
Author:     
    Andrey Orlov (c) 2004
        
Description:     

    This application is intendent to byte compile python modules 
    
Call:
    compileall.py <prefix>

Switches:

    --select=(ALL|ALREADY|BOTH) -- Method of select files to compile;
    
    --exclude=<LIST> -- List of paths to be excluded from byte compilation;
    
    --include=<LIST> -- List of paths to be included into byte compilation;
    
    --deep=<INT> -- Deep of search down into directory tree;
    
    --skip_x -- Skip executable files from byte compilation;
    
    --clean -- Clean not-comileable modules;
    
    --prefix=<STRING> -- Install prefix;

Warranty:

    There is no warranty of any kind, either expressed
    or implied
                        
TODO:
    Nothing

"""
__version__ = '$Revision: 1.1 $'[10:-1]
# $Id: python.compileall.py 29 2006-06-10 12:08:45Z ns $
def _(s) : return s

import sys, os, py_compile

prefix = "python%u.%u" % sys.version_info[0:2]
ALL = 1
ALREADY = 2
BOTH = 3
SUFFIX = __debug__ and 'c' or 'o'

def join_prefix(prefix,path) :
    return os.path.abspath(os.path.join(prefix,os.path.abspath(path)[1:]))

def executable(file):
    import stat
    if stat.S_IEXEC & (os.stat(file)[stat.ST_MODE]) :
        header = open(file, 'rb').read(2)
        if b'#!' == header :
            return True

def compile_all(path,exclude=['/usr/share/doc'],select=ALL,deep=20,skip_x=False,clean=False,prefix='') :
    if path not in exclude and deep > 0 :
        try:
            lp = os.listdir(path)
        except os.error:
            print _("Can't list '%s'") % path
        else :
            lp.sort()
            lp = [ os.path.join(path,p) for p in lp ]
            if clean :
                for p in lp :
                    if os.path.isfile(p) and os.path.splitext(p)[1] == ('.py' + SUFFIX) :
                        print _('unlink'),p
                        os.unlink(p)
                    
            for p in lp :
                if os.path.isdir(p) :
                    compile_all(p,exclude,select,deep-1,skip_x,clean,prefix)
                elif os.path.isfile(p) :
                    if os.path.splitext(p)[1] == '.py' :
                        pc = p + SUFFIX
                        pd = p[len(prefix):]
                        if not (skip_x and executable(p)) :
                            try :
                                if select == ALL :
                                    print _('compile'),p
                                    py_compile.compile(p, pc, pd, True)
                                elif select == ALREADY :
                                    if (p + SUFFIX) in lp :
                                        print _('compile'),p
                                        py_compile.compile(p, pc, pd, True)
                                elif select == BOTH :
                                    if (p+'c') in lp or (p+'o') in lp :
                                        print _('compile'),p
                                        py_compile.compile(p, pc, pd, True)
                            except py_compile.PyCompileError, msg:
                                print _("%s can't be compiled : %s") % (p,msg)                                        

def compile_path(include=sys.path[2:],exclude=[],select=ALL,deep=10,skip_x=False,clean=False,prefix='/') : 
    for item in set(include) :
        compile_all(join_prefix(prefix,item),[join_prefix(prefix,x) for x in exclude],select,deep,skip_x,clean,prefix)

def main() :
    """Script main program."""
    import getopt,re
    lopt = ['select=','exclude=','include=','deep=','skip_x','clean','prefix=']
    cut = re.compile("^-*([^=]*)=?$").match
    lenv = [ ('python_bc_%s' % cut(x).group(1)) for x in lopt ]
    dopt = dict([ (x[0:10],y) for x,y in os.environ.items() if x in lenv])
    
    try:
        opts, args = getopt.getopt(sys.argv[1:], 'h',lopt)
    except getopt.error, msg:
        print msg
        print __doc__
        sys.exit(2)
    else :
        dopt.update(dict([ (cut(x).group(1),y) for x,y in opts]))
        if dopt.has_key('h') :
            print __doc__
        else :
            if dopt.has_key('exclude') :
                dopt['exclude'] = dopt['exclude'].split()
            if dopt.has_key('include') and dopt['include'] :
                dopt['include'] = dopt['include'].split()
            if dopt.has_key('skip_x') :
                dopt['skip_x'] = True
            if dopt.has_key('clean') :
                dopt['clean'] = True
            if dopt.has_key('deep') :
                dopt['deep'] = int(dopt['deep'])
            if dopt.has_key('select') :
                dopt['select'] = {'all':ALL,'already':ALREADY,'both':BOTH}[dopt['select'].lower()]
            
            if args :
                dopt['include'] = args

            return compile_path(**dopt)

if __name__ == '__main__' :
    exit_status = bool(main())
    sys.exit(exit_status)

# ex: set ts=8 sts=4 sw=4 et:
