#! /usr/bin/env python

from __future__ import generators
__doc__ = """\
Project:    rPAS 
Licence:    GPL
Start:      Mon Mar 15 00:52:16 MSK 2004
Title:      RPM Build Python  / Find Requires
Author:     
    Andrey Orlov (c) 2004
        
Description:     

    This application is intendent to extract requires for python modules.
    
Call:
    python_requires.py [<MODULE>]+

Switches:

    None

Warranty:

    There is no warranty of any kind, either expressed
    or implied
                        
TODO:
    Nothing

"""

__version__ = '$Revision: 1.1 $'[10:-1]

try :
    import sys, os
    from os.path import basename, dirname
    import parser, symbol, token, types
    import subprocess
except :
    raise
else :    
    def _(s) : return s
    prefix = "python%u.%u" % sys.version_info[0:2]

    if sys.version_info[0:2] < (2,3) :
        symbol_skip = [symbol.classdef]
    else :    
        symbol_skip = [symbol.encoding_decl, symbol.classdef]

    # Preliminary hack to python 2.4 compatibility
    if sys.version_info[0:2] < (2,4) :
        def pro(x) :
            return x
        def namelist(import_node) :
            return [x for x in import_node[2:] if x[0] != 12 ]
    else :
        def pro(x) :
            return x[1]
        def namelist(import_node) :
            return [x for x in import_node[2][1:] if x[0] != 12 ]

    # Provides: from python-base package
    base_modules = []
    base_provides = subprocess.check_output(['rpmquery','--provides', 'python-base']).split('\n')
    for module in base_provides:
        if module.strip()[:9] == prefix :
            base_modules.append(module.strip()[10:][:-1])

    # Provides: from python-modules package
    pymodules_modules = []
    fnull = open(os.devnull, 'w')
    try:
        modules_provides = subprocess.check_output(['rpmquery','--provides', 'python-modules'], stderr=fnull).split('\n')
        for module in modules_provides:
            if module.strip()[:9] == prefix :
                pymodules_modules.append(module.strip()[10:][:-1])
    except subprocess.CalledProcessError:
        pymodules_modules = []
    fnull.close()

    ignore = dict([ (x,1) for x in
        list(os.getenv('RPM_PYTHON_REQ_SKIP',"").split())
        + list(sys.builtin_module_names)]).has_key

    REQ=os.getenv('RPM_PYTHON_REQ_METHOD','relaxed')
    IS_HIER = os.getenv('RPM_PYTHON_REQ_HIER',None)

    src = None
    def match(tree,deep=0) :
        if tree[0] not in  symbol_skip :
            deep += 1
        for node in tree :
            if type(node) in [types.ListType, types.TupleType] :
                if node[0] == symbol.import_stmt :
                    line = 0
                    deps = []
                    node = pro(node)
                    if node[1][1] == 'import' :
                        line = node[1][2]
                        for name in namelist(node) :
                            if IS_HIER is None :
                                deps.append(name[1][1][1])
                            else :
                                deps.append(".".join( [ i[1] for i in  name[1][1:] if i[0]==1 ]))
                    elif node[1][1] == 'from' :
                        line = node[1][2]
                        if type(node[2][1]) is types.ListType:
                            if IS_HIER is None :
                                deps.append(node[2][1][1])
                            else :
                                deps.append(".".join( [ i[1] for i in  node[2][1:] if i[0]==1 ]))
                        else:   # XXX temporary 2.5 PEP 328 workaround
                            print >> sys.stderr, "%s: %s: line=%d possible relative import from %s, UNIMPLEMENTED" % (sys.argv[0], src, line, node[2][1])

                    if REQ not in ['slight','relaxed'] or deep == 4 :
                        for dep in deps :
                            yield dep
                    else :
                        for dep in deps:
                            print >> sys.stderr, "%s: %s: line=%d IGNORE module=%s" % (sys.argv[0], src, line, dep)

                for item in match(node,deep) :
                    yield item

    if __name__ == '__main__' :
        files = sys.argv[1:] or [ x.strip() for x in sys.stdin.readlines() ]

        reqs = {}
        prov = {}
        for src in files :
            prov.setdefault(dirname(src),[]).append(os.path.splitext(basename(src))[0])
            if basename(src) == "__init__.py" :
                    prov.setdefault(dirname(dirname(src)),[]).append(basename(dirname(src)))


        prov_new = {}
        for d,reqs in prov.items() :
            l = []
            r = d.split("/")
            while r :
                item = r.pop()
                l.insert(0,item)
                for req in reqs :
                    prov_new.setdefault("/".join(r),[]).append(".".join(l + [req]))

        for path,reqs in prov_new.items() :
            prov.setdefault(path,[]).extend(reqs)

        #for d,reqs in prov.items() :
        #    print d
        #    for req in reqs :
        #        print "\t",req

        all_prov_items = []
        map(lambda items: all_prov_items.extend(items), prov.values())

        import re
        # Parser/tokenizer.c:get_coding_spec()
        re_coding = re.compile(r'^\s*#.*?coding[:=]\s*([\w._-]+)')

        def get_raw_encoding(line) :
            enc = re_coding.search(line)
            if enc :
                return enc.group(1)

        # Parser/tokenizer.c:get_normal_name()
        def get_enc_normal_name(enc) :
            enc = enc.lower().replace('_','-')
            if enc.startswith('utf-8') :
                return 'utf-8'
            for alias in ['latin-1','iso-8859-1','iso-latin-1'] :
                if enc.startswith(alias) :
                    return 'iso-8859-1'
            return enc

        missing_encodings = None
        def get_encoding_module(enc) :
            mod = 'encodings'
            try :
                from encodings import search_function
            except :
                global missing_encodings
                missing_encodings = True
                return mod
            try :
                mod = search_function(enc)[1].im_class.__module__
                print >> sys.stderr, "python.req: %s: encoding=%s module=%s" % (src,enc,mod)
            except :
                pass
            return mod

        def need_encoding_module(line):
            enc = get_raw_encoding(line)
            if enc :
                enc = get_enc_normal_name(enc)
                if enc not in ['utf-8','iso-8859-1'] :
                    print >>sys.stderr, "python.req: %s: non-standard encoding: %s" % (src,enc)
                    mod = get_encoding_module(enc)
                    return mod

        found_deps = []

        for src in files :
            ext = os.path.splitext(basename(src))[1]
            if ext not in ['.so','.pyc','.pyo','.pth'] :
                lines = [ line.rstrip().replace('\r','') for line in open(src).readlines() ]
                encmod = None
                if len(lines) > 0 :
                    encmod = need_encoding_module(lines[0])
                if not encmod and len(lines) > 1 :
                    encmod = need_encoding_module(lines[1])
                if encmod :
                    print "%s(%s)" % (prefix,encmod)

                def must_fail() :
                    if ext == '.py' :
                        return True
                    if len(lines) > 0 and lines[0].startswith('#!') :
                        return True
                try :
                    lis = parser.suite('\n'.join(lines)+'\n').tolist(line_info=1)
                except StandardError,msg :
                    print >> sys.stderr, 'python.req: ERROR: %s: %s' % (src,msg)
                    if encmod and missing_encodings :
                        print >> sys.stderr, "python.req: maybe you need python-modules-encodings"
                    if must_fail() :
                        raise
                    else :
                        print >> sys.stderr, "python.req: %s: possibly not pythonish file" % src
                        continue

                for item in match(lis) :
                    #if not item in prov[dirname(src)] :
                    if not item in all_prov_items :
                        if not ignore(item) :
                            if not item in pymodules_modules and not item in base_modules :
                                # module is not in python-base and not in python-modules
                                found_deps.append("%s(%s)" % (prefix,item))
                            elif item in pymodules_modules :
                                if not "python-base" in found_deps and not "python-modules" in found_deps :
                                    # module is in python-modules and no python-base dependency found
                                    found_deps.append("python-modules")
                                elif not "python-modules" in found_deps :
                                    # module is in python-modules and python-base dependency found,
                                    # need to drop python-base in favour of python-modules
                                    found_deps.remove("python-base")
                                    found_deps.append("python-modules")
                            else:
                                if not "python-base" in found_deps and not "python-modules" in found_deps :
                                    # module is in python-base and no python-base dependency found
                                    found_deps.append("python-base")

        for dep in found_deps :
            print dep

        rpm_br=os.path.normpath(os.getenv('RPM_BUILD_ROOT',""))

        if rpm_br in ['','/','.'] :
            br_len = 0
        else :
            br_len = len(rpm_br)

        #print rpm_br
            
        modules = [ os.path.normpath(x) for x in os.getenv('RPM_PYTHON_MODULE_DECLARED','').split() ]
        #print modules

        # it's better to use set here
        # it's better to remove pythons with version < 2.4 HA XEP to use set here and arround
        dirs = {}
        for src in files :
            #print 1,src
            if os.path.splitext(basename(src))[1] in ['.py',''] :
                src = dirname(os.path.normpath(src))
                #print 2,br_len,src[br_len:]
                if src[br_len:] in modules:
                    dirs[src] = 1

        #print dirs	
        # collected [unique] directories which are marked as separate packages.
        # now filter them to keep only those which don't have __init__.py (in this package)
        # and finally print required dependencies
        def print_func(a): print a
        
        map(lambda finit: print_func(finit[br_len:]),                # print path to __init__.py w/o buildroot
            filter(lambda init: not init in files,                   # remove __init__.py's which are in package
                   map(lambda dir: os.path.join(dir, '__init__.py'), # make full path to __init__.py from dirname
                       dirs.keys())))

# ex: set ts=8 sts=4 sw=4 et:
