/***************************************************************************
 *   Copyright (C) 2004 by Roman Savochenko                                *
 *   rom_as@fromru.com                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef MAIL_H
#define MAIL_H

#include <ttransports.h>

class TMailIn;

class TMailIn: public TTransportIn
{
    public:
	/*
	 * Open input socket <name> for locale <address>
	 * address : <type:<specific>>
	 * 	type: 
	 * 	  TCP  - TCP socket with  "UDP:<host>:<port>"
	 * 	  UDP  - UDP socket with  "TCP:<host>:<port>"
	 * 	  UNIX - UNIX socket with "UNIX:<path>"
	 */
	TMailIn(string name, TTipTransport *owner);
	~TMailIn();

    private:
	
    private:
};

class TMailOut: public TTransportOut
{
    public:
    	TMailOut(string name, TTipTransport *owner);
	~TMailOut();

    private:
};

class TTransMail: public TTipTransport
{
    public:
	TTransMail( string name );
	~TTransMail();
        
	TTransportIn  *In( const string &name );
	TTransportOut *Out( const string &name );	    
	
	void mod_CheckCommandLine( );
	void mod_UpdateOpt();	
    public:

    private:
	
	void pr_opt_descr( FILE * stream );
    private:
};

#endif //MAIL_H

