
//OpenSCADA system module DAQ.System file: os_contr.h
/***************************************************************************
 *   Copyright (C) 2005-2008 by Roman Savochenko                           *
 *   rom_as@fromru.com                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2 of the License.               *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef OS_CONTR_H
#define OS_CONTR_H

#include <tmodule.h>
#include <tcontroller.h>
#include <ttipdaq.h>
#include <tparamcontr.h>

#include <string>
#include <vector>

#include "da.h"

#undef _
#define _(mess) mod->I18N(mess)

using std::string;
using std::vector;

namespace SystemCntr
{

//*************************************************
//* TMdPrm                                        *
//*************************************************
class TMdContr;

class TMdPrm : public TParamContr
{
    public:
	//Methods
	TMdPrm( string name, TTipParam *tp_prm );
	~TMdPrm( );

	void enable( );
	void disable( );

	void autoC( bool val )	{ m_auto = val; }
	bool autoC( )		{ return m_auto; }

	//- Set perameter type -
	void setType( const string &da_id );
	//- Get new value -
	void getVal( );
	void setEval( );

	TMdContr &owner( );

    protected:
	//Methods
	void load_( );
	void save_( );

	bool cfgChange( TCfg &cfg );	//config change

	void vlGet( TVal &val );
	void vlArchMake( TVal &val );

	void postEnable( int flag );

    private:
	//Attributes
	bool	m_auto;			//Autocreated
	DA	*m_da;
};

//*************************************************
//* TMdContr                                      *
//*************************************************
class TMdContr: public TController
{
    friend class TMdPrm;
    public:
	//Methods
	TMdContr( string name_c, const string &daq_db, ::TElem *cfgelem );
	~TMdContr( );

	string getStatus( );

	int period( )	{ return vmax(1,m_per); }
	int prior( )	{ return m_prior; }

	AutoHD<TMdPrm> at( const string &nm )	{ return TController::at(nm); }

    protected:
	//Methods
	void enable_( );
	void start_( );
	void stop_( );
	void prmEn( const string &id, bool val );

    private:
	//Methods
	TParamContr *ParamAttach( const string &name, int type );
	static void *Task( void *icntr );

	//Attributes
	Res	en_res;		//Resource for enable params
	int	&m_per,		// ms
		&m_prior;	// Process task priority

	bool	prc_st,		// Process task active
		endrun_req;	// Request to stop of the Process task
	vector< AutoHD<TMdPrm> >  p_hd;

	double	tm_calc;	// Scheme's calc time
	pthread_t procPthr;	// Process task thread
};

//*************************************************
//* TTpContr                                      *
//*************************************************
class TTpContr: public TTipDAQ
{
    public:
	//Methods
	TTpContr( string name );
	~TTpContr( );

	void	daList( vector<string> &da );
	void	daReg( DA *da );
	DA	*daGet( const string &da );

    protected:
	//Methods
	void postEnable( int flag );
	void load_( );

	bool redntAllow( )	{ return true; }

    private:
	//Methods
	TController *ContrAttach( const string &name, const string &daq_db );
	string optDescr( );

	//Attributes
	vector<DA *> m_da;
};

extern TTpContr *mod;

} //End namespace

#endif //OS_CONTR_H
