# build images
IMAGES=install-cd.iso install-dvd5.iso rescue-cd.iso minimal.iso live-cd.iso boot-debug-cd.iso addon-cd.iso
FLASHIMAGES=install-cd.flash install-dvd5.flash rescue-cd.flash minimal.flash live-cd.flash
OUTNAME_PREFIX_FULL=altlinux-$(INFO_VERSION)-$(DATE)-kdesktop-i586-en
OUTNAME_PREFIX_LATEST=altlinux-$(INFO_VERSION)-latest-kdesktop-i586-en

define image_out
mkdir -p /home/roman/out/kdesktop
rm -rf /home/roman/out/kdesktop/$(OUTNAME_PREFIX_FULL)-$@
mv -f /home/roman/out/kdesktop/$@ /home/roman/out/kdesktop/$(OUTNAME_PREFIX_FULL)-$@
ln -snf $(OUTNAME_PREFIX_FULL)-$@ /home/roman/out/kdesktop/$(OUTNAME_PREFIX_LATEST)-$@
endef

define image_build
setarch i586 make -C profiles
endef

$(IMAGES):
	@echo '--- Building $@'
	$(call set,OUTNAME,$@,$(AUTOCFG))
	$(image_build)
	tests/check-iso-size /home/roman/out/kdesktop/$@
	$(image_out)
	$(call done,$@)

$(FLASHIMAGES):
	$(call set,OUTNAME,$@,$(AUTOCFG))
	$(call set,GLOBAL_BOOT_TYPE,syslinux,$(AUTOCFG))
	#(call set,GLOBAL_PROPAGATOR_MAR_MODULES,./modules-usb,$(AUTOCFG))
	$(image_build)
	$(image_out)
	$(call done,$@)

