const char *WebVisionVCA_js=
   "\n"
   "//OpenSCADA system module UI.WebVision file: VCA.js\n"
   "/***************************************************************************\n"
   " *   Copyright (C) 2007-2009 by Roman Savochenko                           *\n"
   " *   rom_as@fromru.com                                                     *\n"
   " *                                                                         *\n"
   " *   This program is free software; you can redistribute it and/or modify  *\n"
   " *   it under the terms of the GNU General Public License as published by  *\n"
   " *   the Free Software Foundation; version 2 of the License.               *\n"
   " *                                                                         *\n"
   " *   This program is distributed in the hope that it will be useful,       *\n"
   " *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *\n"
   " *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *\n"
   " *   GNU General Public License for more details.                          *\n"
   " *                                                                         *\n"
   " *   You should have received a copy of the GNU General Public License     *\n"
   " *   along with this program; if not, write to the                         *\n"
   " *   Free Software Foundation, Inc.,                                       *\n"
   " *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *\n"
   " ***************************************************************************/\n"
   "\n"
   "MOD_ID = 'WebVision';\n"
   "var isNN = navigator.appName.indexOf('Netscape') != -1;\n"
   "var isIE = navigator.appName.indexOf('Microsoft') != -1;\n"
   "var isOpera = navigator.appName.indexOf('Opera') != -1;\n"
   "var isKonq = navigator.userAgent.indexOf('Konqueror') != -1;\n"
   "\n"
   "/***************************************************\n"
   " * strEncode - String encoding.                    *\n"
   " ***************************************************/\n"
   "function strEncode( vl, tp )\n"
   "{\n"
   "  var encRez = '';\n"
   "  if(!tp || tp == \"html\")\n"
   "    for(var i_enc = 0; i_enc < vl.length; i_enc++)\n"
   "      switch(vl.charAt(i_enc))\n"
   "      {\n"
   "        case '&': encRez += '&amp;'; break;\n"
   "        case '>': encRez += '&gt;'; break;\n"
   "        case '<': encRez += '&lt;'; break;\n"
   "        case '\"': encRez += '&quot;'; break;\n"
   "        default:  encRez += vl.charAt(i_enc);\n"
   "      }\n"
   "  return encRez;\n"
   "}\n"
   "\n"
   "/***************************************************\n"
   " * pathLev - Path parsing function.                *\n"
   " ***************************************************/\n"
   "pathLev.off = 0;\n"
   "function pathLev( path, level, scan )\n"
   "{\n"
   "  var an_dir = scan ? pathLev.off : 0;\n"
   "  var t_lev = 0;\n"
   "  var t_dir;\n"
   "  while(an_dir < path.length && path.charAt(an_dir) == '/') an_dir++;\n"
   "  if(an_dir >= path.length) return '';\n"
   "  while(true)\n"
   "  {\n"
   "    t_dir = path.indexOf('/',an_dir);\n"
   "    if( t_dir < 0 ) { pathLev.off=path.length; return (t_lev==level)?path.substr(an_dir):''; }\n"
   "    if( t_lev==level ) { pathLev.off=t_dir; return path.substr(an_dir,t_dir-an_dir); }\n"
   "    an_dir = t_dir;\n"
   "    t_lev++;\n"
   "    while( an_dir<path.length && path.charAt(an_dir)=='/' ) an_dir++;\n"
   "  }\n"
   "}\n"
   "/***************************************************\n"
   " * noSpace - Get no space string                   *\n"
   " ***************************************************/\n"
   "function noSpace( str )\n"
   "{\n"
   "  var posSt = -1; var posEnd = 0;\n"
   "  for( var i = 0; i < str.length; i++ )\n"
   "    if( str[i] != ' ' ) { if(posSt<0) posSt=i; posEnd = i; }\n"
   "  return (posSt>=0)?str.substr(posSt,posEnd-posSt+1):'';\n"
   "}\n"
   "/***************************************************\n"
   " * nodeText - Get DOM node text                    *\n"
   " ***************************************************/\n"
   "function nodeText( node )\n"
   "{\n"
   "  var rez = '';\n"
   "  for( var i = 0; i < node.childNodes.length; i++ )\n"
   "    if( node.childNodes[i].nodeType == 3 ) rez += node.childNodes[i].data;\n"
   "  return rez;\n"
   "}\n"
   "/***************************************************\n"
   " * setNodeText - Set DOM node text                 *\n"
   " ***************************************************/\n"
   "function setNodeText( node, val )\n"
   "{\n"
   "  if( !node ) return;\n"
   "  for( var i = 0; i < node.childNodes.length; i++ )\n"
   "    if( node.childNodes[i].nodeType == 3 )\n"
   "    { node.childNodes[i].data = val; return; }\n"
   "  node.appendChild(node.ownerDocument.createTextNode(val));\n"
   "}\n"
   "/*****************************************************\n"
   " * nodeTextByTagId - Get DOM node by tag name and id *\n"
   " *****************************************************/\n"
   "function nodeTextByTagId( node, tag, avl )\n"
   "{\n"
   "  for( var i = 0; i < node.childNodes.length; i++ )\n"
   "    if( node.childNodes[i].nodeName == tag && node.childNodes[i].getAttribute('id') == avl )\n"
   "      return nodeText(node.childNodes[i]);\n"
   "  return '';\n"
   "}\n"
   "/***************************************************\n"
   " * posGetX - Get absolute position                 *\n"
   " **************************************************/\n"
   "function posGetX(obj,noWScrl)\n"
   "{\n"
   "  var posX = 0;\n"
   "  for( ; obj && obj.nodeName != 'BODY' ; obj=obj.parentNode )\n"
   "  {\n"
   "    posX += (obj.style.left?parseInt(obj.style.left):0)+\n"
   "	(obj.parentNode.style.borderLeftWidth?parseInt(obj.parentNode.style.borderLeftWidth):0)+\n"
   "	(obj.parentNode.style.marginLeft?parseInt(obj.parentNode.style.marginLeft):0);\n"
   "    if(obj.style.position == 'relative') posX += obj.offsetLeft;\n"
   "  }\n"
   "  return posX+(!noWScrl?-window.pageXOffset:0);\n"
   "}\n"
   "/***************************************************\n"
   " * posGetY - Get absolute position                 *\n"
   " **************************************************/\n"
   "function posGetY(obj,noWScrl)\n"
   "{\n"
   "  var posY = 0;\n"
   "  for( ; obj && obj.nodeName != 'BODY' ; obj=obj.parentNode )\n"
   "  {\n"
   "    posY += (obj.style.top?parseInt(obj.style.top):0)+\n"
   "	(obj.parentNode.style.borderTopWidth?parseInt(obj.parentNode.style.borderTopWidth):0)+\n"
   "	(obj.parentNode.style.marginTop?parseInt(obj.parentNode.style.marginTop):0);\n"
   "    if(obj.style.position == 'relative') posY += obj.offsetTop;\n"
   "  }\n"
   "  return posY+(!noWScrl?-window.pageYOffset:0);\n"
   "}\n"
   "/***************************************************\n"
   " * getXmlHttp - Check and return XMLHttpRequest for*\n"
   " *  various browsers.                              *\n"
   " ***************************************************/\n"
   "function getXmlHttp( )\n"
   "{\n"
   "  if( window.XMLHttpRequest ) return new XMLHttpRequest();\n"
   "  else if( window.ActiveXObject )\n"
   "  {\n"
   "    try { return new ActiveXObject('Msxml2.XMLHTTP'); }\n"
   "    catch(e) { return new ActiveXObject('Microsoft.XMLHTTP'); }\n"
   "  }\n"
   "  return null;\n"
   "}\n"
   "/***************************************************\n"
   " * realRound - Real numbers round                  *\n"
   " ***************************************************/\n"
   "function realRound( val, dig, toInt )\n"
   "{\n"
   "  rez = Math.floor(val*Math.pow(10,dig?dig:0)+0.5)/Math.pow(10,dig?dig:0);\n"
   "  if( toInt ) return Math.floor(rez+0.5);\n"
   "  return rez;\n"
   "}\n"
   "/***************************************************\n"
   " * evMouseGet - Get mouse key code from event      *\n"
   " ***************************************************/\n"
   "function evMouseGet( e )\n"
   "{\n"
   "  if(e.which == 1) return 'Left';\n"
   "  else if(e.which == 2) return 'Midle';\n"
   "  else if(e.which == 3) return 'Right';\n"
   "}\n"
   "/***************************************************\n"
   " * evKeyGet - Get key code from event              *\n"
   " ***************************************************/\n"
   "function evKeyGet( e )\n"
   "{\n"
   "  if( (e.keyCode >= 48 && e.keyCode <= 57) || (e.keyCode >= 65 && e.keyCode <= 90) )\n"
   "    return String.fromCharCode(e.keyCode);\n"
   "  switch(e.keyCode)\n"
   "  {\n"
   "    case 27: return 'Esc';\n"
   "    case 8:  return 'BackSpace';\n"
   "    case 13: return 'Enter';\n"
   "    case 45: return 'Insert';\n"
   "    case 19: return 'Pause';\n"
   "    case 36: return 'Home';\n"
   "    case 35: return 'End';\n"
   "    case 37: return 'Left';\n"
   "    case 38: return 'Up';\n"
   "    case 39: return 'Right';\n"
   "    case 40: return 'Down';\n"
   "    case 33: return 'PageUp';\n"
   "    case 34: return 'PageDown';\n"
   "    case 112: return 'F1';\n"
   "    case 113: return 'F2';\n"
   "    case 114: return 'F3';\n"
   "    case 115: return 'F4';\n"
   "    case 116: return 'F5';\n"
   "    case 117: return 'F6';\n"
   "    case 118: return 'F7';\n"
   "    case 119: return 'F8';\n"
   "    case 120: return 'F9';\n"
   "    case 121: return 'F10';\n"
   "    case 122: return 'F11';\n"
   "    case 123: return 'F12';\n"
   "    case 32: return 'Space';\n"
   "    case 59: return 'Semicolon';\n"
   "    case 61: return 'Equal';\n"
   "  }\n"
   "  if(isNN) switch(e.keyCode)\n"
   "  {\n"
   "    case 46: return 'Delete';\n"
   "    case 44: return 'Print';\n"
   "    case 192: return 'Apostrophe';\n"
   "    case 106: return 'Asterisk';\n"
   "    case 107: return 'Plus';\n"
   "    case 188: return 'Comma';\n"
   "    case 109: return 'Minus';\n"
   "    case 190: return 'Period';\n"
   "    case 220: return 'Slash';\n"
   "    case 219: return 'BracketLeft';\n"
   "    case 191: return 'BackSlash';\n"
   "    case 221: return 'BracketRight';\n"
   "    case 222: return 'QuoteLeft';\n"
   "  }\n"
   "  else switch(e.keyCode)\n"
   "  {\n"
   "    case 127: return 'Delete';\n"
   "    case 96: return 'Apostrophe';\n"
   "    case 42: return 'Asterisk';\n"
   "    case 43: return 'Plus';\n"
   "    case 44: return 'Comma';\n"
   "    case 45: return 'Minus';\n"
   "    case 46: return 'Period';\n"
   "    case 92: return 'Slash';\n"
   "    case 91: return 'BracketLeft';\n"
   "    case 47: return 'BackSlash';\n"
   "    case 93: return 'BracketRight';\n"
   "    case 39: return 'QuoteLeft';\n"
   "  }\n"
   "  return '#'+e.keyCode.toString(16);\n"
   "}\n"
   "/***************************************************\n"
   " * servGet - XML get request to server             *\n"
   " ***************************************************/\n"
   "function servGet( adr, prm )\n"
   "{\n"
   "  var req = getXmlHttp();\n"
   "  req.open('GET',encodeURI('/'+MOD_ID+adr+'?'+prm),false);\n"
   "  try\n"
   "  { req.send(null);\n"
   "    if( req.status == 200 && req.responseXML.childNodes.length )\n"
   "      return req.responseXML.childNodes[0];\n"
   "  } catch( e ) { window.location='/'+MOD_ID; }\n"
   "}\n"
   "/***************************************************\n"
   " * servSet - XML set request to server             *\n"
   " ***************************************************/\n"
   "function servSet( adr, prm, body, waitRez )\n"
   "{\n"
   "  var req = getXmlHttp();\n"
   "  req.open('POST',encodeURI('/'+MOD_ID+adr+'?'+prm),!waitRez);\n"
   "  try\n"
   "  { req.send(body);\n"
   "    if( waitRez && req.status == 200 && req.responseXML.childNodes.length )\n"
   "      return req.responseXML.childNodes[0];\n"
   "  }\n"
   "  catch( e ) { window.location='/'+MOD_ID; }\n"
   "  return null;\n"
   "}\n"
   "/***************************************************\n"
   " * getWAttr - request page/widget attribute        *\n"
   " ***************************************************/\n"
   "function getWAttr( wId, attr )\n"
   "{\n"
   "  var rNode = servGet(wId,'com=attr&attr='+attr);\n"
   "  if( !rNode ) return null;\n"
   "  return nodeText(rNode);\n"
   "}\n"
   "/***************************************************\n"
   " * setWAttrs - set page/widget attributes          *\n"
   " ***************************************************/\n"
   "function setWAttrs( wId, attrs, val )\n"
   "{\n"
   "  var body = '<set>';\n"
   "  if( typeof(attrs) == 'string' ) body+='<el id=\\''+attrs+'\\'>'+val+'</el>';\n"
   "  else for( var i in attrs ) body+='<el id=\\''+i+'\\'>'+attrs[i]+'</el>';\n"
   "  body+='</set>';\n"
   "  servSet(wId,'com=attrs',body);\n"
   "}\n"
   "/***************************************************\n"
   " * getFont - Parse font                            *\n"
   " ***************************************************/\n"
   "function getFont( fStr, fSc, inPt )\n"
   "{\n"
   "  var rez = '';\n"
   "  if( fStr )\n"
   "  {\n"
   "    var allFnt = fStr.split(' ');\n"
   "    if( allFnt.length >= 1 ) rez += 'font-family: ' + allFnt[0].replace(/_/g,' ') + '; ';\n"
   "    if( allFnt.length >= 2 ) rez += 'font-size: ' + (parseInt(allFnt[1])*(fSc?fSc:1)).toFixed(0) + (inPt?'pt; ':'px; ');\n"
   "    if( allFnt.length >= 3 ) rez += 'font-weight: ' + (parseInt(allFnt[2])?'bold':'normal') + '; ';\n"
   "    if( allFnt.length >= 4 ) rez += 'font-style: ' + (parseInt(allFnt[3])?'italic':'normal') + '; ';\n"
   "  }\n"
   "  return rez;\n"
   "}\n"
   "/***************************************************\n"
   " * getColor - Parse color                          *\n"
   " ***************************************************/\n"
   "function getColor( cStr )\n"
   "{\n"
   "  var fPos = cStr.indexOf('-');\n"
   "  if( fPos >= 0 ) return cStr.slice(0,fPos);\n"
   "  return cStr;\n"
   "}\n"
   "/*****************************************************\n"
   " * chkPattern - Check for allow expression to pattern *\n"
   " *****************************************************/\n"
   "function chkPattern( val, patt )\n"
   "{\n"
   "  //> Check by regular expression\n"
   "  if(patt.length > 2 && patt.charAt(0) == '/' && patt.charAt(patt.length-1) == '/')\n"
   "    return (new RegExp(patt.slice(1,patt.length-1),'')).test(val);\n"
   "\n"
   "  //> Check by simple pattern\n"
   "  var mult_s = false;\n"
   "  var v_cnt = 0, p_cnt = 0;\n"
   "  var v_bck = -1, p_bck = -1;\n"
   "\n"
   "  while(true)\n"
   "  {\n"
   "    if( p_cnt >= patt.length )	return true;\n"
   "    if( patt.charAt(p_cnt) == '?' )	{ v_cnt++; p_cnt++; mult_s = false; continue; }\n"
   "    if( patt.charAt(p_cnt) == '*' )	{ p_cnt++; mult_s = true; v_bck = -1; continue; }\n"
   "    if( patt.charAt(p_cnt) == '\\\\' )	p_cnt++;\n"
   "    if( v_cnt >= val.length )	break;\n"
   "    if( patt.charAt(p_cnt) == val.charAt(v_cnt) )\n"
   "    {\n"
   "      if( mult_s && v_bck < 0 )	{ v_bck = v_cnt+1; p_bck = p_cnt; }\n"
   "      v_cnt++; p_cnt++;\n"
   "    }\n"
   "    else\n"
   "    {\n"
   "      if( mult_s )\n"
   "      {\n"
   "	if( v_bck >= 0 ) { v_cnt = v_bck; p_cnt = p_bck; v_bck = -1; }\n"
   "	else v_cnt++;\n"
   "      }\n"
   "      else break;\n"
   "    }\n"
   "  }\n"
   "  return false;\n"
   "}\n"
   "\n"
   "/***************************************************\n"
   " * setFocus - Command for set focus                *\n"
   " ***************************************************/\n"
   "function setFocus( wdg, onlyClr )\n"
   "{\n"
   "  if( masterPage.focusWdf && masterPage.focusWdf == wdg ) return;\n"
   "  var attrs = new Object();\n"
   "  if( masterPage.focusWdf ) { attrs.focus = '0'; attrs.event = 'ws_FocusOut'; setWAttrs(masterPage.focusWdf,attrs); }\n"
   "  masterPage.focusWdf = wdg;\n"
   "  if( onlyClr ) return;\n"
   "  attrs.focus = '1'; attrs.event = 'ws_FocusIn'; setWAttrs(masterPage.focusWdf,attrs);\n"
   "}\n"
   "\n"
   "/**********************************************************\n"
   " * callPage - call page 'pgId' for open update and other. *\n"
   " **********************************************************/\n"
   "function callPage( pgId, updWdg, pgGrp, pgOpenSrc )\n"
   "{\n"
   "  if(!pgId) return true;\n"
   "  //> Check and update present page\n"
   "  if(this == masterPage)\n"
   "  {\n"
   "    var opPg = this.findOpenPage(pgId);\n"
   "    if(opPg)\n"
   "    {\n"
   "      if(!(prcCnt%5)) opPg.makeEl(servGet(pgId,'com=attrsBr&FullTree=1&tm='+tmCnt),false,false,true);\n"
   "      else if(updWdg) opPg.makeEl(servGet(pgId,'com=attrsBr&tm='+tmCnt));\n"
   "      return true;\n"
   "    }\n"
   "  }\n"
   "  //> Create or replace main page\n"
   "  if(!pgGrp) pgGrp = getWAttr(pgId,'pgGrp');\n"
   "  if(!pgOpenSrc) pgOpenSrc = getWAttr(pgId,'pgOpenSrc');\n"
   "  if(this == masterPage && (!this.addr.length || pgGrp == 'main' || pgGrp == this.attrs['pgGrp']))\n"
   "  {\n"
   "    if(this.addr.length)\n"
   "    {\n"
   "	servSet(this.addr,'com=pgClose','');\n"
   "	document.body.removeChild(this.window);\n"
   "    }\n"
   "    this.addr  = pgId;\n"
   "    this.place = document.createElement('div');\n"
   "    this.place.setAttribute('id','mainCntr');\n"
   "    this.makeEl(servGet(pgId,'com=attrsBr'),false,true);\n"
   "    var centerTag = document.createElement('center');\n"
   "    centerTag.appendChild(this.place);\n"
   "    document.body.appendChild(centerTag);\n"
   "    this.window = centerTag;\n"
   "    //> Set project's icon and RunTime page title\n"
   "    document.getElementsByTagName('link')[0].setAttribute('href',location.pathname+'?com=ico');\n"
   "    return true;\n"
   "  }\n"
   "  //> Find for include page creation\n"
   "  for(var i in this.wdgs)\n"
   "    if(this.wdgs[i].attrs['root'] == 'Box' && this.wdgs[i].isVisible)\n"
   "    {\n"
   "      if(pgGrp == this.wdgs[i].attrs['pgGrp'] && pgId != this.wdgs[i].attrs['pgOpenSrc'])\n"
   "      {\n"
   "	this.wdgs[i].attrs['pgOpenSrc'] = pgId;\n"
   "	this.wdgs[i].makeEl(null,true);\n"
   "	setWAttrs(this.wdgs[i].addr,'pgOpenSrc',pgId);\n"
   "	return true;\n"
   "      }\n"
   "      if(this.wdgs[i].inclOpen && this.wdgs[i].pages[this.wdgs[i].inclOpen].callPage(pgId,updWdg,pgGrp,pgOpenSrc)) return true;\n"
   "    }\n"
   "  //> Put checking to child pages\n"
   "  for(var i in this.pages)\n"
   "    if(this.pages[i].callPage(pgId,updWdg,pgGrp,pgOpenSrc)) return true;\n"
   "  //> Check for open child page or for unknown and empty source pages open as master page child windows\n"
   "  if((!pgGrp.length && pgOpenSrc == this.addr) || this == masterPage)\n"
   "  {\n"
   "    var iPg = new pwDescr(pgId,true,this);\n"
   "    var attrBrVal = servGet(pgId,'com=attrsBr');\n"
   "\n"
   "    var winName = null;\n"
   "    var winWidth = 600;\n"
   "    var winHeight = 400;\n"
   "    for(var i_ch = 0; i_ch < attrBrVal.childNodes.length; i_ch++)\n"
   "      if(attrBrVal.childNodes[i_ch].nodeName != 'el' ) continue;\n"
   "      else if(attrBrVal.childNodes[i_ch].getAttribute('id') == 'name') winName = nodeText(attrBrVal.childNodes[i_ch]);\n"
   "      else if(attrBrVal.childNodes[i_ch].getAttribute('id') == 'geomW') winWidth = parseInt(nodeText(attrBrVal.childNodes[i_ch]));\n"
   "      else if(attrBrVal.childNodes[i_ch].getAttribute('id') == 'geomH') winHeight = parseInt(nodeText(attrBrVal.childNodes[i_ch]));\n"
   "\n"
   "    //> New external <div> window create\n"
   "    if(winWidth < parseInt(masterPage.attrs['geomW']) && winHeight < parseInt(masterPage.attrs['geomH']))\n"
   "    {\n"
   "	iPg.window = document.createElement('table');\n"
   "	iPg.window.setAttribute('cellpadding','2');\n"
   "	iPg.window.setAttribute('cellspacing','0');\n"
   "	iPg.window.setAttribute('border','0');\n"
   "	iPg.window.setAttribute('style','position: absolute; font-size: 12px; z-index: 9999; background-color: #8FA9FF; border: 1px solid darkblue; '+\n"
   "	    'left: '+((parseInt(masterPage.attrs['geomW'])-winWidth-5)/2)+'px; '+\n"
   "	    'top: '+((parseInt(masterPage.attrs['geomH'])-winHeight-18)/2)+'px; ');\n"
   "	var wRow = document.createElement('tr');\n"
   "	iPg.window.appendChild(wRow);\n"
   "	wRow.setAttribute('style','cursor: move;');\n"
   "	wRow.win = iPg.window;\n"
   "        wRow.onmousedown = function(e)\n"
   "        {\n"
   "	    if(!e) e = window.event;\n"
   "	    this.clX = e.clientX; this.clY = e.clientY;\n"
   "	    return false;\n"
   "	}\n"
   "        wRow.onmouseup = function(e)\n"
   "        {\n"
   "	    if(!e) e = window.event;\n"
   "	    this.clX = this.clY = null;\n"
   "	    return false;\n"
   "	}\n"
   "	wRow.onmouseout = wRow.onmouseup;\n"
   "	wRow.onmousemove = function(e)\n"
   "	{\n"
   "	    if(!e) e = window.event;\n"
   "	    if(this.clX != null)\n"
   "	    {\n"
   "		this.win.style.left = (parseInt(this.win.style.left)+e.clientX-this.clX)+\"px\";\n"
   "		this.win.style.top  = (parseInt(this.win.style.top)+e.clientY-this.clY)+\"px\";\n"
   "		this.clX = e.clientX; this.clY = e.clientY;\n"
   "	    }\n"
   "	}\n"
   "	var titleBlk = document.createElement('td');\n"
   "	wRow.appendChild(titleBlk);\n"
   "	titleBlk.setAttribute('style','max-width: '+(winWidth-7)+'px; width: '+(winWidth-7)+'px; overflow: hidden; white-space: nowrap;');\n"
   "	titleBlk.setAttribute('title',winName);\n"
   "	titleBlk.appendChild(document.createTextNode(winName));\n"
   "	var closeWin = document.createElement('td');\n"
   "	wRow.appendChild(closeWin);\n"
   "	closeWin.appendChild(document.createTextNode('X'));\n"
   "	closeWin.setAttribute('style','color: red; cursor: pointer;');\n"
   "	closeWin.onclick = function()\n"
   "	{ servSet(this.iPg.addr,'com=pgClose',''); document.getElementById('mainCntr').removeChild(this.iPg.window); delete this.iPg.parent.pages[this.iPg.addr]; }\n"
   "	closeWin.iPg = iPg;\n"
   "	wRow = document.createElement('tr');\n"
   "	iPg.window.appendChild(wRow);\n"
   "	var wCntCell = document.createElement('td');\n"
   "	wRow.appendChild(wCntCell);\n"
   "	wCntCell.setAttribute('colspan','2');\n"
   "	wCntCell.setAttribute('align','center');\n"
   "	iPg.place = document.createElement('div');\n"
   "	wCntCell.appendChild(iPg.place);\n"
   "	document.getElementById('mainCntr').appendChild(iPg.window);\n"
   "    }\n"
   "    //> New external window create\n"
   "    else\n"
   "    {\n"
   "	iPg.window = window.open('about:blank',pgId,'width='+(winWidth+20)+',height='+(winHeight+60)+',directories=no,menubar=no,toolbar=no,scrollbars=yes,dependent=yes,location=no,locationbar=no,status=no,statusbar=no,alwaysRaised=yes');\n"
   "	if(!iPg.window) return true;\n"
   "	iPg.window.document.open( );\n"
   "	iPg.window.document.write(\"<html><body style='background-color: #E6E6E6;'><center><div id='main'/></center></body></html>\\n\");\n"
   "	iPg.window.document.close( );\n"
   "	iPg.window.document.title = winName;\n"
   "	var mainDiv = iPg.window.document.getElementById('main');\n"
   "	iPg.place = mainDiv;\n"
   "	iPg.windowExt = true;\n"
   "    }\n"
   "\n"
   "    this.pages[iPg.addr] = iPg;\n"
   "    iPg.makeEl(attrBrVal,false,true);\n"
   "\n"
   "    return true;\n"
   "  }\n"
   "\n"
   "  return false;\n"
   "}\n"
   "\n"
   "function findOpenPage( pgId )\n"
   "{\n"
   "  var opPg;\n"
   "  if(pgId == this.addr) return this;\n"
   "  //> Check from included widgets\n"
   "  for(var i in this.wdgs)\n"
   "    if(this.wdgs[i].attrs['root'] == 'Box' && this.wdgs[i].isVisible)\n"
   "    {\n"
   "      if(pgId == this.wdgs[i].attrs['pgOpenSrc']) return this.wdgs[i].pages[pgId];\n"
   "      if(this.wdgs[i].inclOpen)\n"
   "      {\n"
   "	opPg = this.wdgs[i].pages[this.wdgs[i].inclOpen].findOpenPage(pgId);\n"
   "	if(opPg) return opPg;\n"
   "      }\n"
   "    }\n"
   "  //> Put checking to child pages\n"
   "  for(var i in this.pages)\n"
   "  {\n"
   "    opPg = this.pages[i].findOpenPage(pgId);\n"
   "    if(opPg) return opPg;\n"
   "  }\n"
   "  return null;\n"
   "}\n"
   "\n"
   "function makeEl( pgBr, inclPg, full, FullTree )\n"
   "{\n"
   "  var margBrdUpd = false; var newAttr = false;\n"
   "  this.place.wdgLnk = this;\n"
   "  if( !inclPg && pgBr )\n"
   "    for( var j = 0; j < pgBr.childNodes.length; j++ )\n"
   "    {\n"
   "      if(pgBr.childNodes[j].nodeName != 'el') continue;\n"
   "      var i = pgBr.childNodes[j].getAttribute('id');\n"
   "      if((i == 'bordWidth' || i == 'geomMargin') && this.attrs[i] != nodeText(pgBr.childNodes[j])) margBrdUpd = true;\n"
   "      this.attrs[i] = nodeText(pgBr.childNodes[j]);\n"
   "      newAttr = true;\n"
   "    }\n"
   "  if( newAttr || inclPg || !pgBr )\n"
   "  {\n"
   "  var elMargin = parseInt(this.attrs['geomMargin']);\n"
   "  var elBorder = 0;\n"
   "  if(this.attrs['bordWidth']) elBorder = parseInt(this.attrs['bordWidth']);\n"
   "  var elStyle = '';\n"
   "  this.isVisible = true;\n"
   "  if(!(parseInt(this.attrs['en']) && (this.pg || parseInt(this.attrs['perm'])&SEC_RD)))\n"
   "  { elStyle += 'visibility : hidden; '; this.isVisible = false; }\n"
   "  var geomX = parseFloat(this.attrs['geomX']);\n"
   "  var geomY = parseFloat(this.attrs['geomY']);\n"
   "  if( this.pg ) { geomX = geomY = 0; elStyle += 'overflow: hidden; '; }\n"
   "  else{ geomX *= this.parent.xScale(true); geomY *= this.parent.yScale(true); }\n"
   "  if( this.parent && !(this.pg && this.parent.pg) )\n"
   "  {\n"
   "    geomX -= parseInt(this.parent.attrs['geomMargin'])+parseInt(this.parent.attrs['bordWidth']);\n"
   "    geomY -= parseInt(this.parent.attrs['geomMargin'])+parseInt(this.parent.attrs['bordWidth']);\n"
   "  }\n"
   "  elStyle+='position: '+((this==masterPage || this.window)?'relative':'absolute')+'; left: '+realRound(geomX)+'px; top: '+realRound(geomY)+'px; ';\n"
   "\n"
   "  var xSc = this.xScale(true);\n"
   "  var ySc = this.yScale(true);\n"
   "  var geomW = realRound(parseFloat(this.attrs['geomW'])*xSc);\n"
   "  var geomH = realRound(parseFloat(this.attrs['geomH'])*ySc);\n"
   "\n"
   "  if(this.pg && this.parent && this.parent.inclOpen && this.parent.inclOpen == this.addr)\n"
   "  {\n"
   "    var geomWpar = parseFloat(this.parent.attrs['geomW'])*this.parent.xScale(true);\n"
   "    var geomHpar = parseFloat(this.parent.attrs['geomH'])*this.parent.yScale(true);\n"
   "    this.parent.place.style.overflow = (geomW > geomWpar || geomH > geomHpar) ? 'scroll' : 'visible';\n"
   "    //elStyle += 'overflow: auto; ';\n"
   "    geomW = Math.max(geomW, geomWpar);\n"
   "    geomH = Math.max(geomH, geomHpar);\n"
   "  }\n"
   "  //else elStyle += 'overflow: hidden; ';\n"
   "\n"
   "  geomW -= 2*(elMargin+elBorder);\n"
   "  geomH -= 2*(elMargin+elBorder);\n"
   "\n"
   "  this.mousedown = new Array();\n"
   "  this.mouseup = new Array();\n"
   "\n"
   "  //> Set included window geometry to widget size\n"
   "//  if( this == masterPage ) resizeTo(geomW,geomH);\n"
   "  if(this.pg && this.window && this.windowExt)\n"
   "  {\n"
   "    if(this.window.innerHeight)\n"
   "      this.window.resizeTo(geomW+(this.window.outerWidth-this.window.innerWidth)+20,geomH+(this.window.outerHeight-this.window.innerHeight)+20);\n"
   "    else this.window.resizeTo(geomW+20,geomH+40);\n"
   "  }\n"
   "\n"
   "  if( parseInt(this.attrs['focus']) ) setFocus(this.addr,true);\n"
   "\n"
   "  if( !(parseInt(this.attrs['perm'])&SEC_RD) )\n"
   "  {\n"
   "    if( this.pg )\n"
   "    {\n"
   "      elStyle+='background-color: #B0B0B0; border: 1px solid black; color: red; overflow: auto; ';\n"
   "      this.place.innerHTML = \"<div class='vertalign' style='width: \"+(geomW-2)+\"px; height: \"+(geomH-2)+\"px;'>Page: '\"+this.addr+\"'.<br/>View access is no permitted.</div>\";\n"
   "    }\n"
   "  }\n"
   "  else if( this.attrs['root'] == 'ElFigure' )\n"
   "  {\n"
   "    if( this.attrs['backColor'] ) elStyle+='background-color: '+getColor(this.attrs['backColor'])+'; ';\n"
   "    if( this.attrs['backImg'] )\n"
   "      elStyle+='background-image: url(\\'/'+MOD_ID+this.addr+'?com=res&val='+this.attrs['backImg']+'\\'); ';\n"
   "    var figObj = this.place.childNodes[0];\n"
   "    if( !figObj )\n"
   "    {\n"
   "      figObj = this.place.ownerDocument.createElement('img');\n"
   "      figObj.border = 0;\n"
   "      figObj.wdgLnk = this;\n"
   "      this.place.appendChild(figObj);\n"
   "    }\n"
   "    figObj.width = geomW; figObj.height = geomH;\n"
   "    figObj.src = '/'+MOD_ID+this.addr+'?com=obj&tm='+tmCnt+'&geomX='+geomX.toFixed(3)+'&geomY='+geomY.toFixed(3)+\n"
   "							   '&xSc='+xSc.toFixed(3)+'&ySc='+ySc.toFixed(3);\n"
   "    if( parseInt(this.attrs['active']) && parseInt(this.attrs['perm'])&SEC_WR )\n"
   "    {\n"
   "      figObj.onclick = function(e)\n"
   "      {\n"
   "	if(!e) e = window.event;\n"
   "	servSet(this.wdgLnk.addr,'com=obj&sub=point&geomX='+geomX.toFixed(3)+'&geomY='+geomY.toFixed(3)+\n"
   "						  '&xSc='+xSc.toFixed(3)+'&ySc='+ySc.toFixed(3)+\n"
   "						  '&x='+(e.offsetX?e.offsetX:(e.clientX-posGetX(this)))+\n"
   "						  '&y='+(e.offsetY?e.offsetY:(e.clientY-posGetY(this)))+\n"
   "						  '&key='+evMouseGet(e),'');\n"
   "	return false;\n"
   "      }\n"
   "      figObj.ondblclick = function(e)\n"
   "      {\n"
   "	if(!e) e = window.event;\n"
   "	servSet(this.wdgLnk.addr,'com=obj&sub=point&geomX='+geomX.toFixed(3)+'&geomY='+geomY.toFixed(3)+\n"
   "						  '&xSc='+xSc.toFixed(3)+'&ySc='+ySc.toFixed(3)+\n"
   "						  '&x='+(e.offsetX?e.offsetX:(e.clientX-posGetX(this)))+\n"
   "						  '&y='+(e.offsetY?e.offsetY:(e.clientY-posGetY(this)))+\n"
   "						  '&key=DblClick','');\n"
   "      }\n"
   "    }\n"
   "    else { figObj.onclick = ''; figObj.ondblclick = ''; }\n"
   "  }\n"
   "  else if( this.attrs['root'] == 'Box' )\n"
   "  {\n"
   "    if(this == masterPage && this.attrs['tipStatus'].length) setStatus(this.attrs['tipStatus'],10000);\n"
   "    if(this.attrs['backColor']) elStyle += 'background-color: '+getColor(this.attrs['backColor'])+'; ';\n"
   "    if(this.attrs['backImg'])   elStyle += 'background-image: url(\\'/'+MOD_ID+this.addr+'?com=res&val='+this.attrs['backImg']+'\\'); ';\n"
   "      elStyle+='border-style: solid; border-width: '+this.attrs['bordWidth']+'px; ';\n"
   "    if(this.attrs['bordColor']) elStyle += 'border-color: '+getColor(this.attrs['bordColor'])+'; ';\n"
   "    switch(parseInt(this.attrs['bordStyle']))\n"
   "    {\n"
   "	case 1: elStyle+='border-style: dotted; '; break;\n"
   "	case 2: elStyle+='border-style: dashed; '; break;\n"
   "	case 3: elStyle+='border-style: solid; ';  break;\n"
   "	case 4: elStyle+='border-style: double; '; break;\n"
   "	case 5: elStyle+='border-style: groove; '; break;\n"
   "	case 6: elStyle+='border-style: ridge; ';  break;\n"
   "	case 7: elStyle+='border-style: inset; ';  break;\n"
   "	case 8: elStyle+='border-style: outset; '; break;\n"
   "    }\n"
   "    if(!this.pg && ((this.inclOpen && this.attrs['pgOpenSrc'] != this.inclOpen) || (!this.inclOpen && this.attrs['pgOpenSrc'].length)))\n"
   "    {\n"
   "      //elStyle += 'overflow: auto; ';\n"
   "      if(this.inclOpen)\n"
   "      {\n"
   "	servSet(this.inclOpen,'com=pgClose','');\n"
   "	pgCache[this.inclOpen] = this.pages[this.inclOpen];\n"
   "	pgCache[this.inclOpen].reqTm = tmCnt;\n"
   "	this.place.removeChild(this.pages[this.inclOpen].place);\n"
   "	this.pages[this.inclOpen].perUpdtEn(false);\n"
   "	delete this.pages[this.inclOpen];\n"
   "	this.inclOpen = null;\n"
   "      }\n"
   "      if( this.attrs['pgOpenSrc'].length )\n"
   "      {\n"
   "        this.inclOpen = this.attrs['pgOpenSrc'];\n"
   "        if( pgCache[this.inclOpen] )\n"
   "        {\n"
   "	  this.pages[this.inclOpen] = pgCache[this.inclOpen];\n"
   "	  this.place.appendChild(this.pages[this.inclOpen].place);\n"
   "	  pgBr = servGet(this.inclOpen,'com=attrsBr&tm='+pgCache[this.inclOpen].reqTm);\n"
   "	  this.pages[this.inclOpen].perUpdtEn(true);\n"
   "	  this.pages[this.inclOpen].makeEl(pgBr);\n"
   "	  delete pgCache[this.inclOpen];\n"
   "        }\n"
   "        else\n"
   "        {\n"
   "	  var iPg = new pwDescr(this.inclOpen,true,this);\n"
   "	  iPg.place = this.place.ownerDocument.createElement('div');\n"
   "	  iPg.makeEl(servGet(this.inclOpen,'com=attrsBr'),false,true);\n"
   "	  this.pages[this.inclOpen] = iPg;\n"
   "	  this.place.appendChild(iPg.place);\n"
   "        }\n"
   "      }\n"
   "    }\n"
   "    this.place.wdgLnk = this;\n"
   "    if( parseInt(this.attrs['active']) && parseInt(this.attrs['perm'])&SEC_WR )\n"
   "      this.place.onclick = function() { setFocus(this.wdgLnk.addr); return false; };\n"
   "    else this.place.onclick = '';\n"
   "  }\n"
   "  else if( this.attrs['root'] == 'Text' )\n"
   "  {\n"
   "    if( this.attrs['backColor'] ) elStyle+='background-color: '+getColor(this.attrs['backColor'])+'; ';\n"
   "    if( this.attrs['backImg'] )   elStyle+='background-image: url(\\'/'+MOD_ID+this.addr+'?com=res&val='+this.attrs['backImg']+'\\'); ';\n"
   "    elStyle+='border-style: solid; border-width: '+this.attrs['bordWidth']+'px; ';\n"
   "    if( this.attrs['bordColor'] ) elStyle+='border-color: '+getColor(this.attrs['bordColor'])+'; ';\n"
   "    if( parseInt(this.attrs['orient']) == 0 )\n"
   "    {\n"
   "      var txtAlign = parseInt(this.attrs['alignment']);\n"
   "      var spanStyle = 'display: table-cell; width: '+geomW+'px; height: '+geomH+'px; ';\n"
   "      switch(txtAlign&0x3)\n"
   "      {\n"
   "        case 0: spanStyle+='text-align: left; '; break;\n"
   "        case 1: spanStyle+='text-align: right; '; break;\n"
   "        case 2: spanStyle+='text-align: center; '; break;\n"
   "        case 3: spanStyle+='text-align: justify; '; break;\n"
   "      }\n"
   "      switch(txtAlign>>2)\n"
   "      {\n"
   "        case 0: spanStyle+='vertical-align: top; '; break;\n"
   "        case 1: spanStyle+='vertical-align: bottom; '; break;\n"
   "        case 2: spanStyle+='vertical-align: middle; '; break;\n"
   "      }\n"
   "      spanStyle += getFont(this.attrs['font'],Math.min(xSc,ySc));\n"
   "      spanStyle += 'color: ' + (this.attrs['color']?getColor(this.attrs['color']):'black') + '; ';\n"
   "      var txtVal = this.attrs['text'];\n"
   "      for( var i = 0; i < parseInt(this.attrs['numbArg']); i++ )\n"
   "      {\n"
   "	var argVal;\n"
   "	var argCfg = new Array();\n"
   "	switch(parseInt(this.attrs['arg'+i+'tp']))\n"
   "	{\n"
   "	  case 0: case 2:\n"
   "	    argCfg[0]=this.attrs['arg'+i+'cfg'];\n"
   "	    argVal=this.attrs['arg'+i+'val'];\n"
   "	    break;\n"
   "	  case 1:\n"
   "	    argCfg=this.attrs['arg'+i+'cfg'].split(';');\n"
   "	    if( argCfg[1] == 'g' )      argVal=parseFloat(this.attrs['arg'+i+'val']).toPrecision(argCfg[2]);\n"
   "	    else if( argCfg[1] == 'e' ) argVal=parseFloat(this.attrs['arg'+i+'val']).toExponential(argCfg[2]);\n"
   "	    else if( argCfg[1] == 'f' ) argVal=parseFloat(this.attrs['arg'+i+'val']).toFixed(argCfg[2]);\n"
   "	    else argVal=this.attrs['arg'+i+'val'];\n"
   "	    break;\n"
   "        }\n"
   "        var argSize = parseInt(argCfg[0]);\n"
   "        var argPad = '';\n"
   "        for( var j = argVal.length; j < Math.abs(argSize); j++ ) argPad+='&nbsp;';\n"
   "        if( argSize > 0 ) argVal=argPad+argVal; else argVal+=argPad;\n"
   "        txtVal = txtVal.replace('%'+(i+1),argVal);\n"
   "      }\n"
   "      var txtVal1 = '';\n"
   "      for( var j = 0; j < txtVal.length; j++ )\n"
   "        if( txtVal[j] == '\\n' ) txtVal1+='<br />'; else txtVal1+=txtVal[j];\n"
   "//    txtVal.replace(/\\n/g,'<br />');\n"
   "//    while(this.place.childNodes.length) this.place.removeChild(this.place.childNodes[0]);\n"
   "      this.place.innerHTML = \"<span style='\"+spanStyle+\"'>\"+txtVal1+\"</span>\";\n"
   "    }\n"
   "    else\n"
   "      this.place.innerHTML = \"<img width='\"+geomW+\"px' height='\"+geomH+\"px' border='0' src='/\"+MOD_ID+this.addr+\"?com=obj&tm=\"+tmCnt+\"&xSc=\"+xSc.toFixed(2)+\"&ySc=\"+ySc.toFixed(2)+\"'/>\";\n"
   "\n"
   "    this.place.wdgLnk = this;\n"
   "    if( parseInt(this.attrs['active']) && parseInt(this.attrs['perm'])&SEC_WR )\n"
   "      this.place.onclick = function() { setFocus(this.wdgLnk.addr); return false; };\n"
   "    else this.place.onclick = '';\n"
   "  }\n"
   "  else if( this.attrs['root'] == 'Media' )\n"
   "  {\n"
   "    if(this.attrs['backColor']) elStyle += 'background-color: '+getColor(this.attrs['backColor'])+'; ';\n"
   "    if(this.attrs['backImg'])\n"
   "      elStyle += 'background-image: url(\\'/'+MOD_ID+this.addr+'?com=res&val='+this.attrs['backImg']+'\\'); ';\n"
   "    elStyle += 'border-style: solid; border-width: '+this.attrs['bordWidth']+'px; ';\n"
   "    if(this.attrs['bordColor']) elStyle += 'border-color: '+getColor(this.attrs['bordColor'])+'; ';\n"
   "    while(this.place.childNodes.length) this.place.removeChild(this.place.childNodes[0]);\n"
   "    var medObj = this.place.ownerDocument.createElement('img');\n"
   "    medObj.wdgLnk = this;\n"
   "    medObj.src = this.attrs['src'].length ? ('/'+MOD_ID+this.addr+'?com=res&val='+this.attrs['src']) : '';\n"
   "    medObj.border = 0;\n"
   "    if(this.attrs['fit'] == 1)\n"
   "    {\n"
   "	medObj.width = geomW; medObj.height = geomH;\n"
   "	if(this.attrs['src'].length) medObj.src += \"&size=\"+geomH;\n"
   "    }\n"
   "    else medObj.onload = function()\n"
   "    {\n"
   "	var cWdth = this.width; var cHeight = this.height;\n"
   "	this.width = cWdth * this.wdgLnk.xScale(true);\n"
   "	this.height = cHeight * this.wdgLnk.yScale(true);\n"
   "    }\n"
   "    if( parseInt(this.attrs['active']) && parseInt(this.attrs['perm'])&SEC_WR )\n"
   "    {\n"
   "      if( parseInt(this.attrs['areas']) )\n"
   "      {\n"
   "	var mapObj = this.place.ownerDocument.createElement('map');\n"
   "	mapObj.name = this.addr;\n"
   "	for( var i = 0; i <  parseInt(this.attrs['areas']); i++ )\n"
   "	{\n"
   "	  var arObj = this.place.ownerDocument.createElement('area');\n"
   "	  switch(parseInt(this.attrs['area'+i+'shp']))\n"
   "	  {\n"
   "	    case 0: arObj.shape = 'rect'; break;\n"
   "	    case 1: arObj.shape = 'poly'; break;\n"
   "	    case 2: arObj.shape = 'circle'; break;\n"
   "	  }\n"
   "	  arObj.coords = this.attrs['area'+i+'coord'];\n"
   "	  arObj.title = this.attrs['area'+i+'title'];\n"
   "	  arObj.href = '';\n"
   "	  arObj.onclick = function() { setWAttrs(this.wdgLnk.addr,'event','ws_MapAct'+i+'Left'); return false; }\n"
   "	  arObj.wdgLnk = this;\n"
   "	  mapObj.appendChild(arObj);\n"
   "	}\n"
   "	this.place.appendChild(mapObj);\n"
   "	medObj.setAttribute('usemap','#'+this.addr);\n"
   "	this.place.appendChild(medObj);\n"
   "      }\n"
   "    }\n"
   "    else this.place.appendChild(medObj);\n"
   "  }\n"
   "  else if( this.attrs['root'] == 'FormEl' && !this.place.isModify )\n"
   "  {\n"
   "    var elTp = parseInt(this.attrs['elType']);\n"
   "    while( this.place.childNodes.length ) this.place.removeChild(this.place.childNodes[0]);\n"
   "    var fontCfg = '';\n"
   "    if( this.attrs['font'] )\n"
   "    {\n"
   "      var allFnt = this.attrs['font'].split(' ');\n"
   "      if( allFnt.length >= 3 && parseInt(allFnt[2]) ) fontCfg += 'bold ';\n"
   "      if( allFnt.length >= 4 && parseInt(allFnt[3]) ) fontCfg += 'italic ';\n"
   "      if( allFnt.length >= 2 ) fontCfg += (parseInt(allFnt[1])*Math.min(xSc,ySc)).toFixed(0)+'px ';\n"
   "      if( allFnt.length >= 1 ) fontCfg += allFnt[0].replace(/_/g,' ')+' ';\n"
   "    }\n"
   "    switch(elTp)\n"
   "    {\n"
   "      case 0:	//Line edit\n"
   "	var formObj = this.place.ownerDocument.createElement('input');\n"
   "	formObj.disabled = !( parseInt(this.attrs['active']) && parseInt(this.attrs['perm'])&SEC_WR );\n"
   "	formObj.tabIndex = parseInt(this.attrs['geomZ'])+1;\n"
   "	this.place.appendChild(formObj);\n"
   "	var geomWint = geomW-4;\n"
   "	formObj.wdgLnk = this;\n"
   "	formObj.style.cssText = 'position: absolute; left: 0px; top: '+((geomH-20)/2)+'px; width: '+geomWint+'px; height: '+Math.min(geomH,16)+'px; border: 1px solid black; font: '+fontCfg+'; padding: 1px;';\n"
   "	this.place.view = parseInt(this.attrs['view']);\n"
   "	this.place.cfg = this.attrs['cfg'];\n"
   "	if( parseInt(this.attrs['active']) && parseInt(this.attrs['perm'])&SEC_WR )\n"
   "	{\n"
   "	 switch(this.place.view)\n"
   "	 {\n"
   "	  case 1:		//Combo\n"
   "	    var combImg = this.place.ownerDocument.createElement('img');\n"
   "	    combImg.src = '/'+MOD_ID+'/img_combar';\n"
   "	    combImg.style.cssText = 'position: absolute; left: '+(geomW-16)+'px; top: '+((geomH-20)/2)+'px; width: 16px; height: 20px; cursor: pointer; ';\n"
   "	    this.place.appendChild(combImg);\n"
   "	    formObj.style.width = (geomWint-16)+'px';\n"
   "	    combImg.onclick = function()\n"
   "	    {\n"
   "	      var formObj = this.parentNode.childNodes[0];\n"
   "	      var combList = this.ownerDocument.getElementById('#combo');\n"
   "	      if( !combList )\n"
   "	      {\n"
   "		combList = this.ownerDocument.createElement('div');\n"
   "		combList.id = '#combo';\n"
   "		combList.appendChild(this.ownerDocument.createElement('select'));\n"
   "		combList.childNodes[0].size='100';\n"
   "		combList.childNodes[0].onchange = function() { this.formObj.value = this.options[this.selectedIndex].value; this.formObj.setModify(true); this.parentNode.style.visibility = 'hidden'; }\n"
   "		combList.childNodes[0].onblur = function() { this.parentNode.style.visibility = 'hidden'; this.parentNode.style.top = \"-100px\"; }\n"
   "		this.ownerDocument.body.appendChild(combList);\n"
   "	      }\n"
   "	      while(combList.childNodes[0].childNodes.length) combList.childNodes[0].removeChild(combList.childNodes[0].childNodes[0]);\n"
   "	      var elLst = formObj.parentNode.cfg.split('\\n');\n"
   "	      for( var i = 0; i < elLst.length; i++ )\n"
   "	      {\n"
   "		var optEl = this.ownerDocument.createElement('option');\n"
   "		optEl.appendChild(this.ownerDocument.createTextNode(elLst[i]));\n"
   "		if( formObj.valGet() == elLst[i] ) optEl.defaultSelected=optEl.selected=true;\n"
   "		combList.childNodes[0].appendChild(optEl);\n"
   "	      }\n"
   "	      if( combList.childNodes[0].childNodes.length )\n"
   "	      {\n"
   "		combList.style.cssText = 'position: absolute; visibility : visible; left: '+posGetX(formObj,true)+'px; top: '+(posGetY(formObj,true)+formObj.offsetHeight)+'px; width: '+formObj.offsetWidth+'px; height: '+Math.min(elLst.length*15,70)+'px; border: 0; ';\n"
   "		combList.childNodes[0].style.cssText = 'width: '+formObj.offsetWidth+'px; height: '+Math.min(elLst.length*15,70)+'px; border-width: 2px; font: '+fontCfg+'; padding: 1px;';\n"
   "		combList.childNodes[0].formObj = formObj;\n"
   "		combList.childNodes[0].focus();\n"
   "	      }\n"
   "	      return false;\n"
   "	    }\n"
   "	    break;\n"
   "	  case 2: case 3:	//Integer, Real\n"
   "	    var spinImg = this.place.ownerDocument.createElement('img');\n"
   "	    spinImg.src = '/'+MOD_ID+'/img_spinar';\n"
   "	    spinImg.style.cssText = 'position: absolute; left: '+(geomW-16)+'px; top: '+((geomH-20)/2)+'px; width: 16px; height: 20px; cursor: pointer; ';\n"
   "	    spinImg.border = '0';\n"
   "	    formObj.style.width = (geomWint-16)+'px';\n"
   "	    spinImg.onclick = function(e)\n"
   "	    {\n"
   "	      if( !e ) e = window.event;\n"
   "	      var formObj = this.parentNode.childNodes[0];\n"
   "	      var argCfg = this.parentNode.cfg.split(':');\n"
   "	      if( (e.clientY-posGetY(this)) < 10 )\n"
   "		formObj.valSet(formObj.valGet()+((argCfg.length>2)?((this.parentNode.view==2)?parseInt(argCfg[2]):parseFloat(argCfg[2])):1));\n"
   "	      else formObj.valSet(formObj.valGet()-((argCfg.length>2)?((this.parentNode.view==2)?parseInt(argCfg[2]):parseFloat(argCfg[2])):1));\n"
   "	      formObj.setModify(true);\n"
   "	      return false;\n"
   "	    }\n"
   "	    this.place.appendChild(spinImg);\n"
   "	    break;\n"
   "	 }\n"
   "	 formObj.onkeyup = function(e)\n"
   "	 {\n"
   "	  if( !e ) e = window.event;\n"
   "	  if( this.modify() && e.keyCode == 13 ) this.chApply();\n"
   "	  if( this.modify() && e.keyCode == 27 ) this.chEscape();\n"
   "	  if( this.saveVal != this.value ) this.setModify(true);\n"
   "	 }\n"
   "	 formObj.modify = function( )\n"
   "	 { return (this.parentNode.childNodes[(this.parentNode.view>=1&&this.parentNode.view<=3)?2:1].style.visibility == 'visible'); }\n"
   "	 formObj.setModify = function( on )\n"
   "	 {\n"
   "	  if( on && this.clearTm ) this.clearTm = 5;\n"
   "	  if( this.modify() == on ) return;\n"
   "	  var posOkImg = (this.parentNode.view>=1&&this.parentNode.view<=3)?2:1;\n"
   "	  var okImg = this.parentNode.childNodes[posOkImg];\n"
   "	  if( on )\n"
   "	  {\n"
   "	    this.style.width = (parseInt(this.style.width)-16)+'px';\n"
   "	    if(posOkImg==2) this.parentNode.childNodes[1].style.left = (parseInt(this.parentNode.childNodes[1].style.left)-16)+'px';\n"
   "	    okImg.style.visibility = 'visible';\n"
   "	    this.wdgLnk.perUpdtEn( true ); this.clearTm = 5;\n"
   "	  }\n"
   "	  else\n"
   "	  {\n"
   "	    this.style.width = (parseInt(this.style.width)+16)+'px';\n"
   "	    if(posOkImg==2) this.parentNode.childNodes[1].style.left = (parseInt(this.parentNode.childNodes[1].style.left)+16)+'px';\n"
   "	    okImg.style.visibility = 'hidden';\n"
   "	    this.wdgLnk.perUpdtEn( false ); this.clearTm = 0;\n"
   "	  }\n"
   "	  this.parentNode.isModify = on;\n"
   "	 }\n"
   "	}\n"
   "	formObj.valSet = function(val)\n"
   "	{\n"
   "	  switch(this.parentNode.view)\n"
   "	  {\n"
   "	    case 0: case 1: this.value = val; break;\n"
   "	    case 2:\n"
   "	      var argCfg = this.parentNode.cfg.split(':');\n"
   "	      this.value = ((argCfg.length>3)?argCfg[3]:'')+Math.max((argCfg.length>1)?parseInt(argCfg[0]):0,Math.min((argCfg.length>1)?parseInt(argCfg[1]):100,parseInt(val)))+((argCfg.length>4)?argCfg[4]:'');\n"
   "	      break;\n"
   "	    case 3:\n"
   "	      var argCfg = this.parentNode.cfg.split(':');\n"
   "	      this.value = ((argCfg.length>3)?argCfg[3]:'')+Math.max((argCfg.length>1)?parseFloat(argCfg[0]):0,Math.min((argCfg.length>1)?parseFloat(argCfg[1]):100,parseFloat(val))).toFixed((argCfg.length>5)?parseInt(argCfg[5]):2)+((argCfg.length>4)?argCfg[4]:'');\n"
   "	      break;\n"
   "	    case 4:\n"
   "	      var rez = (this.parentNode.cfg.length) ? this.parentNode.cfg : 'hh:mm';\n"
   "	      var v = (Math.floor(val/3600)%(ap?12:24)).toString(10); rez = rez.replace('hh',(v.length==1)?'0'+v:v); rez = rez.replace('h',v);\n"
   "	      v = (Math.floor(val/60)%60).toString(10); rez = rez.replace('mm',(v.length==1)?'0'+v:v); rez = rez.replace('m',v);\n"
   "	      v = (val%60).toString(10); rez = rez.replace('ss',(v.length==1)?'0'+v:v); rez = rez.replace('s',v);\n"
   "	      if( rez.indexOf('ap') >= 0 ) { rez = rez.replace('ap',(val>=43200)?'pm':'am'); var ap = true; }\n"
   "	      if( rez.indexOf('AP') >= 0 ) { rez = rez.replace('AP',(val>=43200)?'PM':'AM'); var ap = true; }\n"
   "	      this.value = rez;\n"
   "	      break;\n"
   "	    case 5:\n"
   "	      var rez = (this.parentNode.cfg.length) ? this.parentNode.cfg : 'dd.MM.yy';\n"
   "	      var dt = new Date(parseInt(val)*1000);\n"
   "	      var v = dt.getDate().toString(10); rez = rez.replace('dddd',(v.length==1)?'0'+v:v); rez = rez.replace('ddd',(v.length==1)?'0'+v:v); rez = rez.replace('dd',(v.length==1)?'0'+v:v); rez = rez.replace('d',v);\n"
   "	      v = (dt.getMonth()+1).toString(10); rez = rez.replace('MMMM',(v.length==1)?'0'+v:v); rez = rez.replace('MMM',(v.length==1)?'0'+v:v); rez = rez.replace('MM',(v.length==1)?'0'+v:v); rez = rez.replace('M',v);\n"
   "	      v = dt.getFullYear().toString(10); rez = rez.replace('yyyy',v); rez = rez.replace('yy',v.substr(2,2));\n"
   "	      delete dt;\n"
   "	      this.value = rez;\n"
   "	      break;\n"
   "	    case 6:\n"
   "	      var rez = (this.parentNode.cfg.length) ? this.parentNode.cfg : 'dd.MM.yy hh:mm';\n"
   "	      var dt = new Date(parseInt(val)*1000);\n"
   "	      var v = dt.getDate().toString(10); rez = rez.replace('dddd',(v.length==1)?'0'+v:v); rez = rez.replace('ddd',(v.length==1)?'0'+v:v); rez = rez.replace('dd',(v.length==1)?'0'+v:v); rez = rez.replace('d',v);\n"
   "	      v = (dt.getMonth()+1).toString(10); rez = rez.replace('MMMM',(v.length==1)?'0'+v:v); rez = rez.replace('MMM',(v.length==1)?'0'+v:v); rez = rez.replace('MM',(v.length==1)?'0'+v:v); rez = rez.replace('M',v);\n"
   "	      v = dt.getFullYear().toString(10); rez = rez.replace('yyyy',v); rez = rez.replace('yy',v.substr(2,2));\n"
   "	      v = dt.getHours().toString(10); rez = rez.replace('hh',(v.length==1)?'0'+v:v); rez = rez.replace('h',v);\n"
   "	      v = dt.getMinutes().toString(10); rez = rez.replace('mm',(v.length==1)?'0'+v:v); rez = rez.replace('m',v);\n"
   "	      v = dt.getSeconds().toString(10); rez = rez.replace('ss',(v.length==1)?'0'+v:v); rez = rez.replace('s',v);\n"
   "	      if( rez.indexOf('ap') >= 0 ) { rez = rez.replace('ap',(val>=43200)?'pm':'am'); var ap = true; }\n"
   "	      if( rez.indexOf('AP') >= 0 ) { rez = rez.replace('AP',(val>=43200)?'PM':'AM'); var ap = true; }\n"
   "	      delete dt;\n"
   "	      this.value = rez;\n"
   "	      break;\n"
   "	  }\n"
   "	  this.saveVal = this.value;\n"
   "	  this.srcVal = val;\n"
   "	}\n"
   "	formObj.valGet = function( )\n"
   "	{\n"
   "	  switch(this.parentNode.view)\n"
   "	  {\n"
   "	    case 0: case 1: return this.value;\n"
   "	    case 2:\n"
   "	      var rez = this.value;\n"
   "	      var argCfg = this.parentNode.cfg.split(':');\n"
   "	      var tmp = (argCfg&&argCfg.length>3)?noSpace(argCfg[3]):'';\n"
   "	      if( tmp.length && rez.indexOf(tmp) >= 0 ) rez=rez.substring(rez.indexOf(tmp)+tmp.length);\n"
   "	      tmp = (argCfg&&argCfg.length>4)?noSpace(argCfg[4]):'';\n"
   "	      if( tmp.length && rez.indexOf(tmp) >= 0 ) rez=rez.substring(0,rez.indexOf(tmp));\n"
   "	      return parseInt(rez);\n"
   "	    case 3:\n"
   "	      var rez = this.value;\n"
   "	      var argCfg = this.parentNode.cfg.split(':');\n"
   "	      var tmp = (argCfg&&argCfg.length>3)?noSpace(argCfg[3]):'';\n"
   "	      if( tmp.length && rez.indexOf(tmp) >= 0 ) rez=rez.substring(rez.indexOf(tmp)+tmp.length);\n"
   "	      tmp = (argCfg&&argCfg.length>4)?noSpace(argCfg[4]):'';\n"
   "	      if( tmp.length && rez.indexOf(tmp) >= 0 ) rez=rez.substring(0,rez.indexOf(tmp));\n"
   "	      return parseFloat(rez);\n"
   "	    case 4:\n"
   "	      var cfg  = (this.parentNode.cfg.length) ? this.parentNode.cfg : 'hh:mm';\n"
   "	      var rez  = this.value;\n"
   "	      if( cfg.indexOf('ap') >= 0 || cfg.indexOf('AP') >= 0 )\n"
   "	      { cfg = cfg.replace('ap',''); cfg = cfg.replace('AP',''); rez = rez.replace('am',''); rez = rez.replace('AM',''); rez = rez.replace('pm',''); rez = rez.replace('PM',''); }\n"
   "	      var hour = Math.floor(this.srcVal/3600);\n"
   "	      var min  = Math.floor(this.srcVal/60)%60;\n"
   "	      var sec  = this.srcVal%60;\n"
   "	      var i = 0; var lstS = ''; var lenS = 0;\n"
   "	      while( true )\n"
   "	      {\n"
   "		if( i >= cfg.length || cfg.charAt(i) == 'h' || cfg.charAt(i) == 'm' || cfg.charAt(i) == 's' )\n"
   "		{\n"
   "		  var space = lenS ? noSpace(cfg.substr(i-lenS,lenS)) : ''; if( lenS && !space.length ) space = ' ';\n"
   "		  if( (space.length && lstS != '') || i >= cfg.length )\n"
   "		  {\n"
   "		    if( space.length && rez.indexOf(space) == -1 ) return 0;\n"
   "		    var val = parseInt(space.length?rez.substr(0,rez.indexOf(space)):rez,10);\n"
   "		    rez = rez.substr(rez.indexOf(space));\n"
   "		    if( lstS == 'h' ) hour = val; else if( lstS == 'm' ) min = val; else if( lstS == 's' ) sec = val;\n"
   "		    if( i >= cfg.length ) break;\n"
   "		  }\n"
   "		  if( space.length )\n"
   "		  {\n"
   "		    if( rez.indexOf(space) == -1 ) return 0;\n"
   "		    rez = rez.substr(rez.indexOf(space)+space.length);\n"
   "		  }\n"
   "		  lstS = cfg.charAt(i); lenS = 0; i++; continue;\n"
   "		}\n"
   "		lenS++; i++;\n"
   "	      }\n"
   "	      if( this.value.indexOf('pm') >= 0 || this.value.indexOf('PM') >= 0 ) hour+=12;\n"
   "	      return (hour%24)*3600+(min%60)*60+(sec%60);\n"
   "	    case 5:\n"
   "	      var cfg  = (this.parentNode.cfg.length) ? this.parentNode.cfg : 'd.MM.yy';\n"
   "	      var rez  = this.value;\n"
   "	      var dt = new Date(this.srcVal*1000);\n"
   "	      var i = 0; var lstS = ''; var lenS = 0;\n"
   "	      while( true )\n"
   "	      {\n"
   "		if( i >= cfg.length || cfg.charAt(i) == 'd' || cfg.charAt(i) == 'M' || cfg.charAt(i) == 'y' )\n"
   "		{\n"
   "		  var space = lenS ? noSpace(cfg.substr(i-lenS,lenS)) : ''; if( lenS && !space.length ) space = ' ';\n"
   "		  if( (space.length && lstS != '') || i >= cfg.length )\n"
   "		  {\n"
   "		    if( space.length && rez.indexOf(space) == -1 ) return 0;\n"
   "		    var val = parseInt(space.length?rez.substr(0,rez.indexOf(space)):rez,10);\n"
   "		    rez = rez.substr(rez.indexOf(space));\n"
   "		    if( lstS == 'd' ) dt.setDate(val); else if( lstS == 'M' ) dt.setMonth(val-1); else if( lstS == 'y' ) dt.setFullYear((val<100)?2000+val:val);\n"
   "		    if( i >= cfg.length ) break;\n"
   "		  }\n"
   "		  if( space.length )\n"
   "		  {\n"
   "		    if( rez.indexOf(space) == -1 ) return 0;\n"
   "		    rez = rez.substr(rez.indexOf(space)+space.length);\n"
   "		  }\n"
   "		  lstS = cfg.charAt(i); lenS = 0; i++; continue;\n"
   "		}\n"
   "		lenS++; i++;\n"
   "	      }\n"
   "	      return dt.getTime()/1000;\n"
   "	    case 6:\n"
   "	      var cfg = (this.parentNode.cfg.length) ? this.parentNode.cfg : 'dd.MM.yy hh:mm';\n"
   "	      var rez  = this.value;\n"
   "	      if( cfg.indexOf('ap') >= 0 || cfg.indexOf('AP') >= 0 )\n"
   "	      { cfg = cfg.replace('ap',''); cfg = cfg.replace('AP',''); rez = rez.replace('am',''); rez = rez.replace('AM',''); rez = rez.replace('pm',''); rez = rez.replace('PM',''); }\n"
   "	      var dt = new Date(this.srcVal*1000);\n"
   "	      var i = 0; var lstS = ''; var lenS = 0;\n"
   "	      while( true )\n"
   "	      {\n"
   "		if( i >= cfg.length || cfg.charAt(i) == 'd' || cfg.charAt(i) == 'M' || cfg.charAt(i) == 'y' || cfg.charAt(i) == 'h' || cfg.charAt(i) == 'm' || cfg.charAt(i) == 's' )\n"
   "		{\n"
   "		  var space = lenS ? noSpace(cfg.substr(i-lenS,lenS)) : ''; if( lenS && !space.length ) space = ' ';\n"
   "		  if( (space.length && lstS != '') || i >= cfg.length )\n"
   "		  {\n"
   "		    if( space.length && rez.indexOf(space) == -1 ) return 0;\n"
   "		    var val = parseInt(space.length?rez.substr(0,rez.indexOf(space)):rez,10);\n"
   "		    rez = rez.substr(rez.indexOf(space));\n"
   "		    if( lstS == 'd' ) dt.setDate(val); else if( lstS == 'M' ) dt.setMonth(val-1); else if( lstS == 'y' ) dt.setFullYear((val<100)?2000+val:val);\n"
   "		    else if( lstS == 'h' ) dt.setHours(val); else if( lstS == 'm' ) dt.setMinutes(val); else if( lstS == 's' ) dt.setSeconds(val);\n"
   "		    if( i >= cfg.length ) break;\n"
   "		  }\n"
   "		  if( space.length )\n"
   "		  {\n"
   "		    if( rez.indexOf(space) == -1 ) return 0;\n"
   "		    rez = rez.substr(rez.indexOf(space)+space.length);\n"
   "		  }\n"
   "		  lstS = cfg.charAt(i); lenS = 0; i++; continue;\n"
   "		}\n"
   "		lenS++; i++;\n"
   "	      }\n"
   "	      if( this.value.indexOf('pm') >= 0 || this.value.indexOf('PM') >= 0 ) dt.setHours(dt.getHours()+12);\n"
   "	      return dt.getTime()/1000;\n"
   "	  }\n"
   "	}\n"
   "	formObj.chApply = function( )\n"
   "	{\n"
   "	  var val = this.valGet();\n"
   "	  this.valSet(val);\n"
   "	  var okImg = this.parentNode.childNodes[(this.parentNode.view>=1&&this.parentNode.view<=3)?2:1];\n"
   "	  this.setModify(false);\n"
   "	  var attrs = new Object(); attrs.value = val; attrs.event = 'ws_LnAccept';\n"
   "	  setWAttrs(this.wdgLnk.addr,attrs);\n"
   "	}\n"
   "	formObj.chEscape = function( )\n"
   "	{\n"
   "	  this.value = this.saveVal;\n"
   "	  var okImg = this.parentNode.childNodes[(this.parentNode.view>=1&&this.parentNode.view<=3)?2:1];\n"
   "	  this.setModify(false);\n"
   "	}\n"
   "	var okImg = this.place.ownerDocument.createElement('img');\n"
   "	okImg.src = '/'+MOD_ID+'/img_button_ok';\n"
   "	okImg.style.cssText = 'visibility: hidden; position: absolute; left: '+(geomW-16)+'px; top: '+((geomH-16)/2)+'px; width: 16px; height: 16px; cursor: pointer;';\n"
   "	okImg.onclick = function() { this.parentNode.childNodes[0].chApply(); return false; };\n"
   "	this.place.appendChild(okImg);\n"
   "	formObj.valSet(this.attrs['value']);\n"
   "	break;\n"
   "      case 1:	//Text edit\n"
   "	var formObj = this.place.ownerDocument.createElement('textarea');\n"
   "	formObj.disabled = !( parseInt(this.attrs['active']) && parseInt(this.attrs['perm'])&SEC_WR );\n"
   "	formObj.wdgLnk = this;\n"
   "	formObj.tabIndex = parseInt(this.attrs['geomZ'])+1;\n"
   "	formObj.style.cssText = 'width: '+(geomW-5)+'px; height: '+(geomH-5)+'px; border: 1px solid black; font: '+fontCfg+'; padding: 1px;';\n"
   "	formObj.appendChild(this.place.ownerDocument.createTextNode(this.attrs['value']));\n"
   "	formObj.saveVal = formObj.value = this.attrs['value'];\n"
   "	formObj.onkeyup = function( ) { if( this.saveVal != this.value ) this.setModify(true); };\n"
   "	formObj.modify = function( ) { return (this.parentNode.childNodes[1].style.visibility == 'visible'); }\n"
   "	formObj.setModify = function( on )\n"
   "	{\n"
   "	  if( this.modify() == on ) return;\n"
   "	  if( on ) { this.style.height = (parseInt(this.style.height)-16)+'px'; this.parentNode.childNodes[1].style.visibility = this.parentNode.childNodes[2].style.visibility = 'visible'; }\n"
   "	  else     { this.style.height = (parseInt(this.style.height)+16)+'px'; this.parentNode.childNodes[1].style.visibility = this.parentNode.childNodes[2].style.visibility = 'hidden'; }\n"
   "	}\n"
   "	var okImg = this.place.ownerDocument.createElement('img');\n"
   "	okImg.src = '/'+MOD_ID+'/img_button_ok';\n"
   "	okImg.style.cssText = 'visibility: hidden; position: absolute; left: '+(geomW-35)+'px; top: '+(geomH-16)+'px; width: 16px; height: 16px; cursor: pointer;';\n"
   "	okImg.onclick = function() { var attrs = new Object(); attrs.value = this.parentNode.childNodes[0].value; attrs.event = 'ws_TxtAccept'; setWAttrs(this.parentNode.childNodes[0].wdgLnk.addr,attrs); this.parentNode.childNodes[0].setModify(false); return false; };\n"
   "	var cancelImg = this.place.ownerDocument.createElement('img');\n"
   "	cancelImg.src = '/'+MOD_ID+'/img_button_cancel';\n"
   "	cancelImg.style.cssText = 'visibility: hidden; position: absolute; left: '+(geomW-16)+'px; top: '+(geomH-16)+'px; width: 16px; height: 16px; cursor: pointer;';\n"
   "	cancelImg.onclick = function() { this.parentNode.childNodes[0].value = this.parentNode.childNodes[0].saveVal; this.parentNode.childNodes[0].setModify(false); return false; };\n"
   "	this.place.appendChild(formObj); this.place.appendChild(okImg); this.place.appendChild(cancelImg);\n"
   "	break;\n"
   "      case 2:	//Chek box\n"
   "	var tblCell = this.place.ownerDocument.createElement('div');\n"
   "	tblCell.style.cssText = 'position: absolute; top: '+((geomH-15)/2)+'px; width: '+geomW+'px; height: '+Math.min(geomH,15)+'px; text-align: left; font: '+fontCfg+'; ';\n"
   "	var formObj = this.place.ownerDocument.createElement('input');\n"
   "	formObj.disabled = !( parseInt(this.attrs['active']) && parseInt(this.attrs['perm'])&SEC_WR );\n"
   "	formObj.tabIndex = parseInt(this.attrs['geomZ'])+1;\n"
   "	formObj.type='checkbox'; formObj.checked=parseInt(this.attrs['value']);\n"
   "	formObj.wdgLnk = this;\n"
   "	formObj.onclick = function( ) { var attrs = new Object(); attrs.value = (this.checked)?'1':'0'; attrs.event = 'ws_ChkChange'; setWAttrs(this.wdgLnk.addr,attrs); return true; }\n"
   "	tblCell.appendChild(formObj); tblCell.appendChild(this.place.ownerDocument.createTextNode(this.attrs['name'])); this.place.appendChild(tblCell);\n"
   "	break;\n"
   "      case 3:	//Button\n"
   "	var formObj;\n"
   "	var iconImg = this.attrs['img'];\n"
   "	this.place.checkable = parseInt(this.attrs['checkable']);\n"
   "	if( iconImg || this.place.checkable )\n"
   "	{\n"
   "	  formObj = this.place.ownerDocument.createElement('div');\n"
   "	  formObj.className = 'vertalign';\n"
   "	  formObj.style.font = fontCfg;\n"
   "	  elStyle += 'border-style: '+((this.place.checkable && parseInt(this.attrs['value']))?'inset; ':'outset; ')+\n"
   "				      (parseInt(this.attrs['active'])?'cursor: pointer; ':'')+'border-width: 2px; ';\n"
   "	  if(this.attrs['colorText']) elStyle += 'color: '+(parseInt(this.attrs['active']) ? getColor(this.attrs['colorText']) : 'silver')+'; ';\n"
   "	  if(parseInt(this.attrs['active']) && this.attrs['color']) elStyle += 'background-color: '+getColor(this.attrs['color'])+'; ';\n"
   "	  else elStyle += 'background-color: snow; ';\n"
   "	  if(parseInt(this.attrs['active']) && parseInt(this.attrs['perm'])&SEC_WR)\n"
   "	  {\n"
   "	    this.mouseup[this.mouseup.length] = function(e,el)\n"
   "	    {\n"
   "	      if(el.checkable) return;\n"
   "	      el.style.borderStyle='outset'; setWAttrs(el.wdgLnk.addr,'event','ws_BtRelease');\n"
   "	    };\n"
   "	    this.mousedown[this.mousedown.length] = function(e,el)\n"
   "	    {\n"
   "	      if(el.checkable) return;\n"
   "	      el.style.borderStyle=\"inset\"; setWAttrs(el.wdgLnk.addr,'event','ws_BtPress');\n"
   "	    };\n"
   "	    this.place.onmouseout = function()\n"
   "	    {\n"
   "	      if(this.checkable || this.style.borderStyle=='outset') return false;\n"
   "	      this.style.borderStyle='outset'; setWAttrs(this.wdgLnk.addr,'event','ws_BtRelease');\n"
   "	    };\n"
   "	    this.place.onclick = function()\n"
   "	    {\n"
   "	      if(!this.checkable) return false;\n"
   "	      var attrs = new Object();\n"
   "	      if(this.style.borderLeftStyle=='outset')\n"
   "	      { attrs.value = '1'; this.style.borderStyle='inset'; setWAttrs(this.wdgLnk.addr,'event','ws_BtPress'); }\n"
   "	      else { attrs.value = '0'; this.style.borderStyle='outset'; setWAttrs(this.wdgLnk.addr,'event','ws_BtRelease'); }\n"
   "	      setWAttrs(this.wdgLnk.addr,'event','ws_BtToggleChange');\n"
   "	      setWAttrs(this.wdgLnk.addr,'value',attrs.value);\n"
   "	      return false;\n"
   "	    };\n"
   "	    this.place.wdgLnk = this;\n"
   "	  }\n"
   "	  var txtVal1 = '';\n"
   "	  if(iconImg)\n"
   "	    txtVal1 += \"<IMG src='/\"+MOD_ID+this.addr+\"?com=res&val=\"+this.attrs['img']+\"&size=\"+Math.min(geomW-6,geomH-6)+\n"
   "				  (!parseInt(this.attrs['active'])?\"&filtr=unact\":\"\")+\"' \"+\n"
   "			\"width='\"+Math.min(geomW-6,geomH-6)+\"' height='\"+Math.min(geomW-6,geomH-6)+\"' float='left' \"+\n"
   "			(this.attrs['name'].length?\"style='margin-right: 2px'\":\"\")+\"/>\";\n"
   "	  if(this.attrs['name'].length)\n"
   "	  {\n"
   "	    var begBlk = true;\n"
   "	    for(var j = 0; j < this.attrs['name'].length; j++)\n"
   "		if(this.attrs['name'].substr(j,2) == '\\\\n')\n"
   "		{\n"
   "		    if(!begBlk) { txtVal1 += \"</span>\"; begBlk = true; }\n"
   "		    txtVal1 += '<br />';\n"
   "		}\n"
   "		else\n"
   "		{\n"
   "		    if(begBlk) { txtVal1 += \"<span>\"; begBlk = false; }\n"
   "		    txtVal1 += strEncode(this.attrs['name'][j]);\n"
   "		}\n"
   "	  }\n"
   "	  if(!begBlk) txtVal1 += \"</span>\";\n"
   "	  formObj.innerHTML = txtVal1;\n"
   "	  geomW -= 4; geomH -= 4;\n"
   "	}\n"
   "	else\n"
   "	{\n"
   "	  formObj = this.place.ownerDocument.createElement('input');\n"
   "	  formObj.disabled = !( parseInt(this.attrs['active']) && parseInt(this.attrs['perm'])&SEC_WR );\n"
   "	  formObj.tabIndex = parseInt(this.attrs['geomZ'])+1;\n"
   "	  formObj.style.font = fontCfg;\n"
   "	  formObj.type = 'button';\n"
   "	  formObj.value = this.attrs['name'].replace('\\\\n','\\n');\n"
   "	  this.mouseup[this.mouseup.length] = function(e,el)	{ setWAttrs(el.wdgLnk.addr,'event','ws_BtRelease'); };\n"
   "	  this.mousedown[this.mousedown.length] = function(e,el){ setWAttrs(el.wdgLnk.addr,'event','ws_BtPress'); };\n"
   "	  formObj.wdgLnk = this;\n"
   "	  if( this.attrs['color'] ) formObj.style.backgroundColor=getColor(this.attrs['color']);\n"
   "	  if( this.attrs['colorText'] ) formObj.style.color=getColor(this.attrs['colorText']);\n"
   "	}\n"
   "	formObj.style.width = geomW+'px'; formObj.style.height = geomH+'px';\n"
   "	this.place.appendChild(formObj);\n"
   "	break;\n"
   "      case 4: case 5:	//Combo box, List\n"
   "	var formObj = this.place.ownerDocument.createElement('select');\n"
   "	formObj.disabled = !( parseInt(this.attrs['active']) && parseInt(this.attrs['perm'])&SEC_WR );\n"
   "	formObj.tabIndex = parseInt(this.attrs['geomZ'])+1;\n"
   "	formObj.style.cssText = 'position: absolute; left: 0px; top: '+((elTp==4)?(geomH-20)/2:0)+'px; height: '+((elTp==4)?Math.min(geomH,20):(geomH-4))+'px; width: '+(geomW-4)+'px; border: 1px solid black; font: '+fontCfg+'; padding: 1px; ';\n"
   "	formObj.wdgLnk = this;\n"
   "//	if( elTp == 5 ) formObj.setAttribute('size',100);\n"
   "	if( elTp == 4 )\n"
   "	  formObj.onchange = function( ) { var attrs = new Object(); attrs.value = this.options[this.selectedIndex].value; attrs.event = 'ws_CombChange'; setWAttrs(this.wdgLnk.addr,attrs); }\n"
   "	else\n"
   "	{\n"
   "	  formObj.size = 100;\n"
   "	  formObj.onchange = function( ) { var attrs = new Object(); attrs.value = this.options[this.selectedIndex].value; attrs.event = 'ws_ListChange'; setWAttrs(this.wdgLnk.addr,attrs); }\n"
   "	}\n"
   "	var selVal = this.attrs['value'];\n"
   "	var elLst = this.attrs['items'].split('\\n');\n"
   "	var selOk = false;\n"
   "	for( var i = 0; i < elLst.length; i++ )\n"
   "	{\n"
   "	  var optEl = this.place.ownerDocument.createElement('option');\n"
   "	  optEl.appendChild(this.place.ownerDocument.createTextNode(elLst[i]));\n"
   "	  if( selVal == elLst[i] ) selOk=optEl.defaultSelected=optEl.selected=true;\n"
   "	  formObj.appendChild(optEl);\n"
   "	}\n"
   "	if( !selOk && elTp == 4 )\n"
   "	{\n"
   "	  var optEl = this.place.ownerDocument.createElement('option');\n"
   "	  optEl.textContent = selVal;\n"
   "	  optEl.selected = optEl.defaultSelected = true;\n"
   "	  formObj.appendChild(optEl);\n"
   "	}\n"
   "	this.place.appendChild(formObj);\n"
   "	break;\n"
   "    }\n"
   "  }\n"
   "  else if( this.attrs['root'] == 'Diagram' )\n"
   "  {\n"
   "    if( this.attrs['backColor'] ) elStyle+='background-color: '+getColor(this.attrs['backColor'])+'; ';\n"
   "    if( this.attrs['backImg'] )   elStyle+='background-image: url(\\'/'+MOD_ID+this.addr+'?com=res&val='+this.attrs['backImg']+'\\'); ';\n"
   "    elStyle+='border-style: solid; border-width: '+this.attrs['bordWidth']+'px; ';\n"
   "    if( this.attrs['bordColor'] ) elStyle+='border-color: '+getColor(this.attrs['bordColor'])+'; ';\n"
   "    var anchObj = this.place.childNodes[0];\n"
   "    if( !anchObj )\n"
   "    {\n"
   "      anchObj = this.place.ownerDocument.createElement('a');\n"
   "      anchObj.wdgLnk = this;\n"
   "      var dgrObj = this.place.ownerDocument.createElement('img');\n"
   "      dgrObj.border = 0;\n"
   "      anchObj.appendChild(dgrObj); this.place.appendChild(anchObj);\n"
   "    }\n"
   "    anchObj.isActive = (parseInt(this.attrs['active']) && parseInt(this.attrs['perm'])&SEC_WR);\n"
   "    anchObj.href = '#';\n"
   "    anchObj.tabIndex = parseInt(this.attrs['geomZ'])+1;\n"
   "    anchObj.onfocus = function( ) { if(this.isActive) setFocus(this.wdgLnk.addr); }\n"
   "    anchObj.onkeydown = function(e) { if(this.isActive) setWAttrs(this.wdgLnk.addr,'event','key_pres'+evKeyGet(e?e:window.event)); }\n"
   "    anchObj.onkeyup = function(e) { if(this.isActive) setWAttrs(this.wdgLnk.addr,'event','key_rels'+evKeyGet(e?e:window.even)); }\n"
   "    anchObj.onclick = function(e)\n"
   "    {\n"
   "      if( !this.isActive ) return false;\n"
   "      if(!e) e = window.event;\n"
   "      servSet(this.wdgLnk.addr,'com=obj&sub=point&x='+(e.offsetX?e.offsetX:(e.clientX-posGetX(this)))+\n"
   "						'&y='+(e.offsetY?e.offsetY:(e.clientY-posGetY(this)))+\n"
   "						'&key='+evMouseGet(e),'');\n"
   "      setFocus(this.wdgLnk.addr);\n"
   "      return false;\n"
   "    }\n"
   "    var dgrObj = anchObj.childNodes[0];\n"
   "    dgrObj.isLoad = false;\n"
   "    dgrObj.onload = function( )	{ this.isLoad = true; }\n"
   "    dgrObj.src = '/'+MOD_ID+this.addr+'?com=obj&tm='+tmCnt+'&xSc='+xSc.toFixed(2)+'&ySc='+ySc.toFixed(2);\n"
   "    this.perUpdtEn( this.isEnabled() && parseInt(this.attrs['trcPer']) );\n"
   "  }\n"
   "  else if( this.attrs['root'] == 'Protocol' )\n"
   "  {\n"
   "    if( this.attrs['backColor'] ) elStyle += 'background-color: '+getColor(this.attrs['backColor'])+'; ';\n"
   "    else elStyle+='background-color: white; ';\n"
   "    if( this.attrs['backImg'] )   elStyle += 'background-image: url(\\'/'+MOD_ID+this.addr+'?com=res&val='+this.attrs['backImg']+'\\'); ';\n"
   "    elStyle += 'border: 1px solid black; overflow: auto; padding: 2px; text-align: left; ';\n"
   "    geomW -= 6; geomH -= 6;\n"
   "\n"
   "    this.wFont = getFont(this.attrs['font'],Math.min(xSc,ySc));\n"
   "\n"
   "    if( !this.place.firstChild )\n"
   "    {\n"
   "      this.place.appendChild(document.createElement('table'));\n"
   "      this.place.firstChild.wdgLnk = this;\n"
   "      this.place.firstChild.isActive = (parseInt(this.attrs['active']) && parseInt(this.attrs['perm'])&SEC_WR);\n"
   "      this.place.firstChild.onclick = function(e)\n"
   "      {\n"
   "	if( this.isActive ) setFocus(this.wdgLnk.addr);\n"
   "	return false;\n"
   "      }\n"
   "      this.place.firstChild.className='prot';\n"
   "      this.loadData = function( )\n"
   "      {\n"
   "	var tblB = this.place.firstChild;\n"
   "\n"
   "	//> Get archive parameters\n"
   "	var tTime = parseInt(this.attrs['time']);\n"
   "	if( !tTime ) tTime = (new Date()).getTime()/1000;\n"
   "	var tTimeGrnd = tTime - parseInt(this.attrs['tSize']);\n"
   "\n"
   "	if( this.curCols != this.attrs['col'] || this.curArch != this.attrs['arch'] || this.curTmpl != this.attrs['tmpl'] || \n"
   "	    this.curLev != this.attrs['lev'] || this.headVis != this.attrs['headVis'] )\n"
   "	{\n"
   "	  this.arhBeg = this.arhEnd = 0;\n"
   "	  this.messList = new Array();\n"
   "\n"
   "	  this['col_pos'] = this['col_tm'] = this['col_utm'] = this['col_lev'] = this['col_cat'] = this['col_mess'] = -1;\n"
   "	  this.curCols = this.attrs['col'];\n"
   "	  this.curArch = this.attrs['arch'];\n"
   "	  this.curTmpl = this.attrs['tmpl'];\n"
   "	  this.curLev = this.attrs['lev'];\n"
   "	  this.headVis = this.attrs['headVis'];\n"
   "	  var rowEl = document.createElement('tr');\n"
   "	  tblB.appendChild(rowEl);\n"
   "	  var colCfg = '';\n"
   "	  var clm = this.curCols.split(';');\n"
   "	  for( var c_off = 0; c_off < clm.length; c_off++ )\n"
   "	  {\n"
   "	    if( !parseInt(this.attrs['headVis']) ) colCfg += \"<th/>\";\n"
   "	    else colCfg += \"<th ind='\"+clm[c_off]+\"' \"+\n"
   "			   \"style='\"+this.wFont+\"'>\"+((clm[c_off]=='pos') ? '#' :\n"
   "						    (clm[c_off]=='tm') ? '###Date and time###' :\n"
   "						    (clm[c_off]=='utm') ? '###mcsec###' :\n"
   "						    (clm[c_off]=='lev') ? '###Level###' :\n"
   "						    (clm[c_off]=='cat') ? '###Category###' :\n"
   "						    (clm[c_off]=='mess') ? '###Message###' : '')+\"</th>\";\n"
   "	    this['col_'+clm[c_off]] = c_off;\n"
   "	  }\n"
   "	  rowEl.innerHTML = colCfg;\n"
   "	}\n"
   "\n"
   "	if( parseInt(this.curLev) < 0 ) this.messList = new Array();\n"
   "	else\n"
   "	{\n"
   "	  if( !this.arhBeg || !this.arhEnd || !tTime || tTime > this.arhEnd )\n"
   "	  {\n"
   "	    var rez = servSet('/Archive/%2fserv%2fmess','com=com',\"<info arch='\"+this.curArch+\"'/>\",true);\n"
   "	    if( !rez || parseInt(rez.getAttribute('rez')) != 0 ) { this.arhBeg = this.arhEnd = 0; }\n"
   "	    else\n"
   "	    {\n"
   "	      this.arhBeg = parseInt(rez.getAttribute('beg'));\n"
   "	      this.arhEnd = parseInt(rez.getAttribute('end'));\n"
   "	      if( !tTime ) { tTime = this.arhEnd; tTimeGrnd += tTime; }\n"
   "	    }\n"
   "	  }\n"
   "	  if( !this.arhBeg || !this.arhEnd ) return;\n"
   "\n"
   "	  //> Correct request to archive border\n"
   "	  tTime = Math.min(tTime,this.arhEnd); tTimeGrnd = Math.max(tTimeGrnd,this.arhBeg);\n"
   "	}\n"
   "\n"
   "	//> Clear data at time error\n"
   "	var valEnd = 0; var valBeg = 0;\n"
   "	while( this.messList.length && (valEnd=this.messList[0].time) > tTime) this.messList.shift();\n"
   "	while( this.messList.length && (valBeg=this.messList[this.messList.length-1].time) < tTimeGrnd ) this.messList.pop();\n"
   "\n"
   "	if( tTime < tTimeGrnd || (tTime < valEnd && tTimeGrnd > valBeg) )\n"
   "	{\n"
   "	  this.messList = new Array();\n"
   "	  while( tblB.childNodes.length > 1 ) tblB.removeChild(tblB.lastChild);\n"
   "	  valEnd = valBeg = 0;\n"
   "	  return;\n"
   "	}\n"
   "\n"
   "	//> Correct request to present data\n"
   "	var toUp = false, isDtChang = false;\n"
   "	if( valEnd && tTime >= valEnd ) { tTimeGrnd = valEnd; toUp = true; }\n"
   "	else if( valBeg && tTimeGrnd < valBeg ) tTime = valBeg-1;\n"
   "\n"
   "	var rez = servSet('/Archive/%2fserv%2fmess','com=com',\n"
   "	    \"<get arch='\"+this.curArch+\"' tm='\"+tTime+\"' tm_grnd='\"+tTimeGrnd+\"' cat='\"+this.curTmpl+\"' lev='\"+this.curLev+\"' />\",true);\n"
   "	if( !rez || parseInt(rez.getAttribute('rez')) != 0 ) return;\n"
   "\n"
   "	if( toUp )\n"
   "	  for( var i_req = 0; i_req < rez.childNodes.length; i_req++ )\n"
   "	  {\n"
   "	    var rcd = rez.childNodes[i_req];\n"
   "	    var mess = new Array(parseInt(rcd.getAttribute('time')),parseInt(rcd.getAttribute('utime')),parseInt(rcd.getAttribute('lev')),rcd.getAttribute('cat'),nodeText(rcd));\n"
   "\n"
   "	    //>> Check for dublicates\n"
   "	    var i_p;\n"
   "	    for( i_p = 0; i_p < this.messList.length; i_p++ )\n"
   "	    {\n"
   "	      if( mess[0] > this.messList[0][0] && i_p ) continue;\n"
   "	      if( this.messList[i_p][1] == mess[1] && this.messList[i_p][2] == mess[2] && this.messList[i_p][3] == mess[3] && this.messList[i_p][4] == mess[4] )\n"
   "		break;\n"
   "	    }\n"
   "	    if( i_p < this.messList.length ) continue;\n"
   "\n"
   "	    //>> Insert new row\n"
   "	    this.messList.unshift(mess);\n"
   "	    isDtChang = true;\n"
   "	  }\n"
   "	else\n"
   "	  for( var i_req = rez.childNodes.length-1; i_req >= 0; i_req-- )\n"
   "	  {\n"
   "	    var rcd = rez.childNodes[i_req];\n"
   "	    var mess = new Array(parseInt(rcd.getAttribute('time')),parseInt(rcd.getAttribute('utime')),parseInt(rcd.getAttribute('lev')),rcd.getAttribute('cat'),nodeText(rcd));    \n"
   "\n"
   "	    //>> Check for dublicates\n"
   "	    var i_p;\n"
   "	    for( i_p = this.messList.length-1; i_p >= 0; i_p-- )\n"
   "	    {\n"
   "	      if( mess[0] < this.messList[this.messList.length-1][0] && i_p < (this.messList.length-1) ) continue;\n"
   "	      if( this.messList[i_p][1] == mess[1] && this.messList[i_p][2] == mess[2] && this.messList[i_p][3] == mess[3] && this.messList[i_p][4] == mess[4] )\n"
   "		break;\n"
   "	    }\n"
   "	    if( i_p >= 0 ) continue;\n"
   "\n"
   "	    //>> Insert new row\n"
   "	    this.messList.push(mess);\n"
   "	    isDtChang = true;\n"
   "	  }\n"
   "\n"
   "	if( (tblB.childNodes.length-1) == this.messList.length && !isDtChang ) return;\n"
   "\n"
   "	//> Sort data\n"
   "	var sortIts = new Array();\n"
   "	switch( parseInt(this.attrs['viewOrd'])&0x3 )\n"
   "	{\n"
   "	    case 0:\n"
   "		for( var i_m = 0; i_m < this.messList.length; i_m++ )\n"
   "		    sortIts.push( this.messList[i_m][0]+' '+this.messList[i_m][1]+':'+i_m );\n"
   "		break;\n"
   "	    case 1:\n"
   "		for( var i_m = 0; i_m < this.messList.length; i_m++ )\n"
   "		    sortIts.push( this.messList[i_m][2]+':'+i_m );\n"
   "		break;\n"
   "	    case 2:\n"
   "		for( var i_m = 0; i_m < this.messList.length; i_m++ )\n"
   "		    sortIts.push( this.messList[i_m][3]+':'+i_m );\n"
   "		break;\n"
   "	    case 3:\n"
   "		for( var i_m = 0; i_m < this.messList.length; i_m++ )\n"
   "		    sortIts.push_back( this.messList[i_m][4]+':'+i_m );\n"
   "		break;\n"
   "	}\n"
   "\n"
   "	sortIts.sort();\n"
   "	if( parseInt(this.attrs['viewOrd'])&0x4 ) sortIts.reverse();\n"
   "\n"
   "	//> Write to table\n"
   "	for( var i_m = 0; i_m < sortIts.length; i_m++ )\n"
   "	{\n"
   "	    var rowEl = (i_m>=(tblB.childNodes.length-1)) ? document.createElement('tr') : tblB.childNodes[i_m+1];\n"
   "	    var elPos = parseInt(sortIts[i_m].slice(sortIts[i_m].lastIndexOf(':')+1));\n"
   "\n"
   "	    var rowFnt = this.wFont;\n"
   "	    var rowColor = '';\n"
   "\n"
   "	    //>> Check properties\n"
   "	    for( var i_it = 0, lst_lev = -1; i_it < parseInt(this.attrs['itProp']); i_it++ )\n"
   "	    {\n"
   "		var prpLev = parseInt(this.attrs['it'+i_it+'lev']);\n"
   "		if( this.messList[elPos][2] >= prpLev && prpLev > lst_lev && chkPattern(this.messList[elPos][3],this.attrs['it'+i_it+'tmpl']) )\n"
   "		{\n"
   "		    var tRowFnt = getFont(this.attrs['it'+i_it+'fnt'],Math.min(xSc,ySc));\n"
   "		    if(tRowFnt.length) rowFnt = tRowFnt;\n"
   "		    rowColor = 'background-color: '+getColor(this.attrs['it'+i_it+'color'])+'; ';\n"
   "		    if( this.messList[elPos][2] == parseInt(this.attrs['it'+i_it+'lev']) ) break;\n"
   "		    lst_lev = prpLev;\n"
   "		}\n"
   "	    }\n"
   "	    //if( rowColor.length ) fclr = ((0.3*clr.red()+0.59*clr.green()+0.11*clr.blue()) > 128) ? Qt::black : Qt::white;\n"
   "	    rowEl.style.cssText = rowFnt+rowColor;\n"
   "\n"
   "	    for( var i_cel = 0; i_cel < tblB.childNodes[0].childNodes.length; i_cel++ )\n"
   "	    {\n"
   "	      var celEl = (i_cel>=rowEl.childNodes.length) ? document.createElement('td') : rowEl.childNodes[i_cel];\n"
   "	      if( this.col_pos == i_cel ) { setNodeText(celEl,i_m); celEl.style.cssText += ' text-align: center; '; }\n"
   "	      else if( this.col_tm == i_cel )\n"
   "	      {\n"
   "		var dt = new Date(this.messList[elPos][0]*1000);\n"
   "		setNodeText(celEl,dt.getDate()+'.'+(dt.getMonth()+1)+'.'+dt.getFullYear()+' '+dt.getHours()+':'+\n"
   "				  ((dt.getMinutes()<10)?('0'+dt.getMinutes()):dt.getMinutes())+':'+((dt.getSeconds()<10)?('0'+dt.getSeconds()):dt.getSeconds()));\n"
   "	      }\n"
   "	      else if( this.col_utm == i_cel ) setNodeText(celEl,this.messList[elPos][1]);\n"
   "	      else if( this.col_lev == i_cel ) setNodeText(celEl,this.messList[elPos][2]);\n"
   "	      else if( this.col_cat == i_cel ) setNodeText(celEl,this.messList[elPos][3]);\n"
   "	      else if( this.col_mess == i_cel ) setNodeText(celEl,this.messList[elPos][4]);\n"
   "	      if( i_cel >= rowEl.childNodes.length ) rowEl.appendChild(celEl);\n"
   "	    }\n"
   "	    if( i_m >= (tblB.childNodes.length-1) ) tblB.appendChild(rowEl);\n"
   "	}\n"
   "	while( (tblB.childNodes.length-1) > sortIts.length ) tblB.removeChild(tblB.lastChild);\n"
   "      }\n"
   "    }\n"
   "\n"
   "    if( this.isEnabled() && parseInt(this.attrs['trcPer']) ) this.perUpdtEn( true );\n"
   "    else { this.perUpdtEn( false ); this.loadData(); }\n"
   "  }\n"
   "  else if( this.attrs['root'] == 'Document' )\n"
   "  {\n"
   "    elStyle += 'background-color: white; ';\n"
   "\n"
   "    this.wFont = getFont(this.attrs['font'],Math.min(xSc,ySc),true);\n"
   "\n"
   "    var ifrmObj = this.place.childNodes[0];\n"
   "    if( !ifrmObj )\n"
   "    {\n"
   "      ifrmObj = this.place.ownerDocument.createElement('iframe');\n"
   "      this.place.appendChild(ifrmObj);\n"
   "    }\n"
   "    ifrmObj.style.cssText = 'width: '+(geomW-14)+'px; height: '+(geomH-14)+'px; border-style: ridge; border-width: 2px; padding: 5px;';\n"
   "    this.perUpdtEn(true);\n"
   "  }\n"
   "  elStyle+='width: '+geomW+'px; height: '+geomH+'px; z-index: '+this.attrs['geomZ']+'; margin: '+elMargin+'px; ';\n"
   "  this.place.style.cssText = elStyle;\n"
   "  }\n"
   "  if(margBrdUpd) for(var i in this.wdgs) this.wdgs[i].makeEl();\n"
   "  this.place.setAttribute('title',this.attrs['tipTool']);\n"
   "  this.place.onmouseover = function() { if( this.wdgLnk.attrs['tipStatus'] ) setStatus(this.wdgLnk.attrs['tipStatus'],10000); };\n"
   "\n"
   "  //> Generic mouse events process\n"
   "  if( parseInt(this.attrs['active']) && parseInt(this.attrs['perm'])&SEC_WR )\n"
   "  {\n"
   "    this.mousedown[this.mousedown.length] = function(e,el)\n"
   "    {\n"
   "      if(!e) e = window.event;\n"
   "      setWAttrs(el.wdgLnk.addr,'event','key_mousePres'+evMouseGet(e));\n"
   "    }\n"
   "    this.mouseup[this.mouseup.length] = function(e,el)\n"
   "    {\n"
   "      if(!e) e = window.event;\n"
   "      setWAttrs(el.wdgLnk.addr,'event','key_mouseRels'+evMouseGet(e));\n"
   "    }\n"
   "    this.place.ondblclick = function(e) { setWAttrs(this.wdgLnk.addr,'event','key_mouseDblClick'); return false; }\n"
   "  }\n"
   "  else this.place.ondblclick = '';\n"
   "\n"
   "  //> Context menu setup\n"
   "  if( parseInt(this.attrs['perm'])&SEC_WR && parseInt(this.attrs['active']) && this.attrs['contextMenu'].length )\n"
   "  {\n"
   "    var ctxEv = function(e,el)\n"
   "    {\n"
   "      var cel = el ? el : this;\n"
   "      if( !e ) e = window.event;\n"
   "      if( (isKonq || isOpera) && evMouseGet(e) != 'Right' ) return true;\n"
   "      var popUpMenu = getPopup();\n"
   "      var optEl = '';\n"
   "      var cntxEls = cel.wdgLnk.attrs['contextMenu'].split('\\n');\n"
   "      for( var i_ce = 0; i_ce < cntxEls.length; i_ce++ )\n"
   "	optEl += \"<option sign='\"+cntxEls[i_ce].split(':')[1]+\"'>\"+cntxEls[i_ce].split(':')[0]+\"</option>\";\n"
   "      popUpMenu.childNodes[0].innerHTML = optEl;\n"
   "      if( popUpMenu.childNodes[0].childNodes.length )\n"
   "      {\n"
   "	popUpMenu.childNodes[0].wdgLnk = cel.wdgLnk;\n"
   "	popUpMenu.childNodes[0].size = Math.max(3,popUpMenu.childNodes[0].childNodes.length);\n"
   "	popUpMenu.style.cssText = 'visibility: visible; left: '+(e.clientX+window.pageXOffset)+'px; top: '+(e.clientY+window.pageYOffset)+'px;';\n"
   "	popUpMenu.childNodes[0].selectedIndex = -1;\n"
   "	popUpMenu.childNodes[0].onclick = function()\n"
   "	{\n"
   "	    this.parentNode.style.cssText = 'visibility: hidden; left: -200px; top: -200px;';\n"
   "	    if( this.selectedIndex < 0 ) return false;\n"
   "	    setWAttrs(this.wdgLnk.addr,'event','usr_'+this.options[this.selectedIndex].getAttribute('sign'));\n"
   "	    return false;\n"
   "	}\n"
   "      }\n"
   "      return false;\n"
   "    }\n"
   "    if( isKonq || isOpera ) this.mousedown[this.mousedown.length] = ctxEv;\n"
   "    else this.place.oncontextmenu = ctxEv;\n"
   "  }\n"
   "  else this.place.oncontextmenu = null;\n"
   "\n"
   "  //> Common mouse events process\n"
   "  if(this.mousedown && this.mousedown.length )\n"
   "    this.place.onmousedown = function(e)\n"
   "    {\n"
   "      for( var i_on = 0; i_on < this.wdgLnk.mousedown.length; i_on++ )\n"
   "	this.wdgLnk.mousedown[i_on](e,this);\n"
   "      return true;\n"
   "    }\n"
   "  if(this.mouseup && this.mouseup.length)\n"
   "    this.place.onmouseup = function(e)\n"
   "    {\n"
   "      for( var i_on = 0; i_on < this.wdgLnk.mouseup.length; i_on++ )\n"
   "	this.wdgLnk.mouseup[i_on](e,this);\n"
   "      return true;\n"
   "    }\n"
   "\n"
   "  //> Delete child widgets check\n"
   "  if(FullTree)\n"
   "    for(var i in this.wdgs)\n"
   "    {\n"
   "	var j;\n"
   "	for(j = 0; j < pgBr.childNodes.length; j++)\n"
   "	    if(pgBr.childNodes[j].nodeName == 'w' && pgBr.childNodes[j].getAttribute('id') == i)\n"
   "		break;\n"
   "	if(j >= pgBr.childNodes.length)\n"
   "	{\n"
   "	    this.wdgs[i].place.parentNode.removeChild(this.wdgs[i].place);\n"
   "	    delete this.wdgs[i];\n"
   "	}\n"
   "    }\n"
   "\n"
   "  //> Child widgets process\n"
   "  if(pgBr && !inclPg && parseInt(this.attrs['perm'])&SEC_RD)\n"
   "    for(var j = 0; j < pgBr.childNodes.length; j++)\n"
   "    {\n"
   "      if(pgBr.childNodes[j].nodeName != 'w') continue;\n"
   "      var chEl = pgBr.childNodes[j].getAttribute('id');\n"
   "      if(this.wdgs[chEl]) this.wdgs[chEl].makeEl(pgBr.childNodes[j], false, full, FullTree);\n"
   "      else\n"
   "      {\n"
   "	var wdgO = new pwDescr(this.addr+'/wdg_'+chEl,false,this);\n"
   "	wdgO.place = this.place.ownerDocument.createElement('div');\n"
   "	this.place.appendChild(wdgO.place);\n"
   "	this.wdgs[chEl] = wdgO;\n"
   "	wdgO.makeEl(full?pgBr.childNodes[j]:servGet(wdgO.addr,'com=attrsBr'));\n"
   "	//wdgO.makeEl(pgBr.childNodes[j]);		//!!!! Need full\n"
   "      }\n"
   "    }\n"
   "}\n"
   "function perUpdtEn( en )\n"
   "{\n"
   "  if( this.attrs['root'] == 'Diagram' || this.attrs['root'] == 'Protocol' )\n"
   "  {\n"
   "     if( en && this.isEnabled() && !perUpdtWdgs[this.addr] && parseInt(this.attrs['trcPer']) ) perUpdtWdgs[this.addr] = this;\n"
   "     if( !en && perUpdtWdgs[this.addr] ) delete perUpdtWdgs[this.addr];\n"
   "  }\n"
   "  else if(this.attrs['root'] == 'Document' || this.attrs['root'] == 'FormEl')\n"
   "  { if(en) perUpdtWdgs[this.addr] = this; else delete perUpdtWdgs[this.addr]; }\n"
   "  for( var i in this.wdgs ) this.wdgs[i].perUpdtEn(en);\n"
   "}\n"
   "function perUpdt( )\n"
   "{\n"
   "  if( this.attrs['root'] == 'FormEl' && this.place.childNodes.length && this.place.childNodes[0].clearTm && (--this.place.childNodes[0].clearTm) <= 0 )\n"
   "    this.place.childNodes[0].chEscape();\n"
   "  else if( this.attrs['root'] == 'Diagram' && (this.updCntr % parseInt(this.attrs['trcPer'])) == 0 )\n"
   "  {\n"
   "    var dgrObj = this.place.childNodes[0].childNodes[0];\n"
   "    if( dgrObj && dgrObj.isLoad )\n"
   "    {\n"
   "      dgrObj.isLoad = false;\n"
   "      dgrObj.src = '/'+MOD_ID+this.addr+'?com=obj&tm='+tmCnt+'&xSc='+this.xScale(true).toFixed(2)+'&ySc='+this.yScale(true).toFixed(2);\n"
   "    }\n"
   "  }\n"
   "  else if( this.attrs['root'] == 'Protocol' && (this.updCntr % parseInt(this.attrs['trcPer'])) == 0 ) this.loadData();\n"
   "  else if( this.attrs['root'] == 'Document' )\n"
   "  {\n"
   "    var frDoc = this.place.childNodes[0].contentDocument || this.place.childNodes[0].contentWindow || this.place.childNodes[0].document;\n"
   "    frDoc.open();\n"
   "    frDoc.write(\"<html><head>\"+\n"
   "		\"<style type='text/css'>\"+\n"
   "		\" * { \"+this.wFont+\" }\\n\"+\n"
   "		\" big { font-size: 120%; }\\n\"+\n"
   "		\" small { font-size: 90%; }\\n\"+\n"
   "		\" h1 { font-size: 200%; }\\n\"+\n"
   "		\" h2 { font-size: 150%; }\\n\"+\n"
   "		\" h3 { font-size: 120%; }\\n\"+\n"
   "		\" h4 { font-size: 105%; }\\n\"+\n"
   "		\" h5 { font-size: 95%; }\\n\"+\n"
   "		\" h6 { font-size: 70%; }\\n\"+\n"
   "		\" u,b,i { font-size : inherit; }\\n\"+\n"
   "		\" sup,sub { font-size: 80%; }\\n\"+\n"
   "		this.attrs['style']+\"</style>\"+\n"
   "		\"</head>\"+(this.attrs['doc']?this.attrs['doc']:this.attrs['tmpl'])+\"</html>\");\n"
   "    frDoc.close();\n"
   "    frDoc.body.wdgLnk = this;\n"
   "    frDoc.body.isActive = (parseInt(this.attrs['active']) && parseInt(this.attrs['perm'])&SEC_WR);\n"
   "    frDoc.body.onclick = function(e)\n"
   "    {\n"
   "      if( this.isActive ) setFocus(this.wdgLnk.addr);\n"
   "      return false;\n"
   "    }\n"
   "    this.perUpdtEn( false );\n"
   "  }\n"
   "  this.updCntr++;\n"
   "}\n"
   "function xScale( full )\n"
   "{\n"
   "    var rez = parseFloat(this.attrs['geomXsc'])\n"
   "    if(!full) return rez;\n"
   "    if(!this.pg) return rez*this.parent.xScale(full);\n"
   "    // if(this != masterPage) return masterPage.xScale()*rez;\n"
   "    return rez;\n"
   "}\n"
   "function yScale( full )\n"
   "{\n"
   "    var rez = parseFloat(this.attrs['geomYsc'])\n"
   "    if(!full) return rez;\n"
   "    if(!this.pg) return rez*this.parent.yScale(full);\n"
   "    // if(this != masterPage) return masterPage.yScale()*rez;\n"
   "    return rez;\n"
   "}\n"
   "function isEnabled( )\n"
   "{\n"
   "  var rez = parseInt(this.attrs['en']);\n"
   "  if( !rez || this.pg ) return rez;\n"
   "  return this.parent.isEnabled();\n"
   "}\n"
   "\n"
   "/***************************************************\n"
   " * pwDescr - Page/widget descriptor object         *\n"
   " ***************************************************/\n"
   "function pwDescr( pgAddr, pg, parent )\n"
   "{\n"
   "  this.addr = pgAddr;\n"
   "  this.pages = new Object();\n"
   "  this.wdgs = new Object();\n"
   "  this.attrs = new Object();\n"
   "  this.pg = pg;\n"
   "  this.parent = parent;\n"
   "  this.window = null;\n"
   "  this.windowExt = false;\n"
   "  this.place = null;\n"
   "  this.callPage = callPage;\n"
   "  this.findOpenPage = findOpenPage;\n"
   "  this.makeEl = makeEl;\n"
   "  this.perUpdtEn = perUpdtEn;\n"
   "  this.perUpdt = perUpdt;\n"
   "  this.xScale = xScale;\n"
   "  this.yScale = yScale;\n"
   "  this.isEnabled = isEnabled;\n"
   "  this.updCntr = 0;\n"
   "}\n"
   "/***************************************************\n"
   " * makeUI                                          *\n"
   " ***************************************************/\n"
   "function makeUI()\n"
   "{\n"
   "  prcCnt++;\n"
   "  //> Get open pages list\n"
   "  var pgNode = servGet('/'+sessId,'com=pgOpenList&tm='+tmCnt);\n"
   "  if(pgNode)\n"
   "  {\n"
   "    //>> Check for delete pages\n"
   "    for(var i_p = 0; i_p < pgList.length; i_p++)\n"
   "    {\n"
   "      var opPg; var i_ch;\n"
   "      for(i_ch = 0; i_ch < pgNode.childNodes.length; i_ch++)\n"
   "	if(pgNode.childNodes[i_ch].nodeName == 'pg' && nodeText(pgNode.childNodes[i_ch]) == pgList[i_p])\n"
   "	  break;\n"
   "      if(i_ch < pgNode.childNodes.length || !(opPg=masterPage.findOpenPage(pgList[i_p]))) continue;\n"
   "      if(opPg.window)\n"
   "      {\n"
   "        if(opPg.windowExt) opPg.window.close();\n"
   "        else document.getElementById('mainCntr').removeChild(opPg.window);\n"
   "        delete opPg.parent.pages[pgList[i_p]];\n"
   "      }\n"
   "      else if(opPg.parent && opPg.parent.inclOpen && opPg.parent.inclOpen == pgList[i_p])\n"
   "      { opPg.parent.attrs['pgOpenSrc'] = ''; opPg.parent.makeEl(null,true); }\n"
   "    }\n"
   "    //>> Process opened pages\n"
   "    pgList = new Array();\n"
   "    for( var i = 0; i < pgNode.childNodes.length; i++ )\n"
   "      if( pgNode.childNodes[i].nodeName == 'pg' )\n"
   "      {\n"
   "	var prPath = nodeText(pgNode.childNodes[i]);\n"
   "	//>>> Check for closed window\n"
   "	var opPg = masterPage.findOpenPage(prPath);\n"
   "	if(opPg && opPg.window && opPg.windowExt && opPg.window.closed)\n"
   "	{ servSet(prPath,'com=pgClose',''); delete opPg.parent.pages[prPath]; continue; }\n"
   "	//>>> Call page\n"
   "	pgList.push(prPath);\n"
   "	masterPage.callPage(prPath,parseInt(pgNode.childNodes[i].getAttribute('updWdg')));\n"
   "      }\n"
   "    tmCnt = parseInt(pgNode.getAttribute('tm'));\n"
   "  }\n"
   "  //> Update some widgets\n"
   "  for(var i in perUpdtWdgs) perUpdtWdgs[i].perUpdt();\n"
   "  setTimeout(makeUI,1000);\n"
   "}\n"
   "\n"
   "/***************************************************\n"
   " * setStatus - Setup status message.               *\n"
   " ***************************************************/\n"
   "function setStatus( mess, tm )\n"
   "{\n"
   "    window.status = mess ? mess : '###Ready###';\n"
   "    if(!mess) return;\n"
   "    if(stTmID) clearTimeout(stTmID);\n"
   "    if(!tm || tm > 0) stTmID = setTimeout('setStatus(null)',tm?tm:1000);\n"
   "}\n"
   "\n"
   "/**************************************************\n"
   " * getPopup - Get popup menu.                     *\n"
   " **************************************************/\n"
   "function getPopup( )\n"
   "{\n"
   "  var popUpMenu = document.getElementById('popupmenu');\n"
   "  if( !popUpMenu )\n"
   "  {\n"
   "    popUpMenu = document.createElement('div'); popUpMenu.id = 'popupmenu';\n"
   "    popUpMenu.appendChild(document.createElement('select'));\n"
   "    document.body.appendChild(popUpMenu);\n"
   "    popUpMenu.style.visibility = 'hidden';\n"
   "  }\n"
   "  return popUpMenu;\n"
   "}\n"
   "\n"
   "/***************************************************\n"
   " * Main start code                                 *\n"
   " ***************************************************/\n"
   "SEC_XT = 0x01;	//Extended\n"
   "SEC_WR = 0x02;	//Write access\n"
   "SEC_RD = 0x04;	//Read access\n"
   "//Call session identifier\n"
   "sessId = location.pathname.split('/');\n"
   "for( var i_el = sessId.length-1; i_el >= 0; i_el-- )\n"
   "  if( sessId[i_el].length )\n"
   "  { sessId = sessId[i_el]; break; }\n"
   "\n"
   "document.body.onmouseup = function(e)\n"
   "{\n"
   "  if( !e ) e = window.event;\n"
   "  if( evMouseGet(e) != 'Left' ) return true;\n"
   "  var popUpMenu = document.getElementById('popupmenu');\n"
   "  if( popUpMenu ) popUpMenu.style.visibility = 'hidden';\n"
   "}\n"
   "\n"
   "prcCnt = 0;				//Process counter\n"
   "tmCnt = 0;				//Call counter\n"
   "pgList = new Array();			//Opened pages list\n"
   "pgCache = new Object();			//Cached pages' data\n"
   "perUpdtWdgs = new Object();		//Periodic updated widgets register\n"
   "masterPage = new pwDescr('',true);	//Master page create\n"
   "stTmID = null;				//Status line timer identifier\n"
   "\n"
   "setTimeout(makeUI,1000);		//First call init\n";
