# core/feature functionality chunks
# see profiles/pkg/lists/ for all package lists

# NB: if use-* target is not defined explicitly,
#     it will be processed by an implicit rule (at bottom)
#     to add a named package list to main/live subprofiles

DE_TARGETS = \
	use-gnome use-gnome-dvd use-gnome-light use-gnome-workbench \
	use-kde3-lite use-kde3 \
	use-kde-desktop use-kde-lite \
	use-lxde \
	use-sugar \
	use-xfce use-xfce-school \
	use-slinux
LIVE_TARGETS = \
	       use-gnome-live use-kde-live-dvd use-kde3-live use-kde-live

WM_TARGETS = \
	use-fvwm \
	use-icewm \
	use-wmaker \
	use-xdm \
	use-gdm

FEATURE_TARGETS = \
	use-etersoft use-etersoft-network \
	use-pspo \
	use-nm \
	use-homeros-friend \
	use-homeros-desktop \
	use-children \
	use-ltsp \
	use-runa \
	use-artist \
	use-encfs-homes

DESKTOP_TARGETS = $(DE_TARGETS) $(WM_TARGETS) $(FEATURE_TARGETS)
SERVER_TARGETS = use-server use-server-light use-centaurus use-pbx-office use-pbx-huge

$(SERVER_TARGETS):  | $(AUTOCFG)
$(LIVE_TARGETS):  | $(AUTOCFG)
$(DESKTOP_TARGETS): | $(AUTOCFG) use-xorg
$(DE_TARGETS): | use-desktop

# base graphics
### FIXME: implicit?
use-xorg:
	echo '#use-xorg:' >> "$(call scfg,main)"
	echo GLOBAL_BASE_PACKAGE_LISTS+='xorg' >> "$(call scfg,main)"
	$(call done,$@)

### FIXME: implicit? (or not, depending on tuning resolution)
use-xdm:
	echo GLOBAL_BASE_PACKAGES+='xdm' >> "$(call scfg,main)"
	# TODO: tune it as well, see live/image-scripts.d/05xdm
	$(call done,$@)

use-gdm:
	echo GLOBAL_BASE_PACKAGES+='gdm2.20' >> "$(call scfg,main)"
	$(call done,$@)

use-lxdm:
	echo GLOBAL_BASE_PACKAGES+='lxde-lxdm' >> "$(call scfg,main)"
	echo GLOBAL_LIVE_PACKAGES+='lxde-lxdm' >> "$(call scfg,live)"
	$(call done,$@)

use-alterator-desktop:
	echo '#use-alterator-desktop:' >> "$(call scfg,main)"
	echo GLOBAL_BASE_PACKAGE_LISTS+='alterator-desktop' >> "$(call scfg,main)"
	$(call done,$@)

### implicit rules

# install by default and put on live
use-%:
	echo GLOBAL_BASE_PACKAGE_LISTS+='$(subst use-,,$@)' >> "$(call scfg,main)"
	echo GLOBAL_LIVE_PACKAGE_LISTS+='$(subst use-,,$@)' >> "$(call scfg,live)"
	echo GLOBAL_PLC_PACKAGE_LISTS+='$(subst use-,,$@)' >> "$(call scfg,plc)"
	@echo "*** added $(subst use-,,$@) to main/live" >&2
# put on second disk
addon-%:
	echo GLOBAL_ADDON_PACKAGE_LISTS+='$(subst addon-,,$@)' >> "$(call scfg,addon)"
	@echo "*** added $(subst addon-,,$@) to addon" >&2
# put on first disk, but don't install by default
disk-%:
	echo GLOBAL_DISK_PACKAGE_LISTS+='$(subst disk-,,$@)' >> "$(call scfg,main)"
	@echo "*** added $(subst disk-,,$@) to main" >&2
# install by default
base-%:
	echo GLOBAL_BASE_PACKAGE_LISTS+='$(subst base-,,$@)' >> "$(call scfg,main)"
	@echo "*** added $@ to main" >&2
# put on first disk, but don't install by default
group-%:
	echo GLOBAL_PKG_GROUPS+='$(subst group-,,$@)' >> $(AUTOCFG)
	@echo "*** added $@ to main" >&2
# put on live
live-%:
	echo GLOBAL_LIVE_PACKAGE_LISTS+='$(subst live-,,$@)' >> "$(call scfg,live)"
	@echo "*** added $@ to live" >&2

# put volumes-profile into install2 
vm-profile-%:
	echo GLOBAL_INSTALL2_PACKAGES+='volumes-profile-$(subst vm-profile-,,$@)' >> "$(call scfg,install2)"
	@echo "*** added $@ to install2" >&2
	echo GLOBAL_LIVE_PACKAGES+='volumes-profile-$(subst vm-profile-,,$@)' >> "$(call scfg,live)"
	@echo "*** added $@ to live" >&2

# catch-all rule transforming --with-features into package list names used
use-custom:
	# iterate over --with-features list, add to base/live
	for i in $(shell echo  | tr ',' ' '); do \
		echo GLOBAL_BASE_PACKAGE_LISTS+=$$i >> "$(call scfg,main)"; \
		echo GLOBAL_LIVE_PACKAGE_LISTS+=$$i >> "$(call scfg,live)"; \
	done
	$(call done,$@)

### explicit rules

# moderately beefy/managed desktop
use-desktop: use-xorg use-alterator-desktop
	echo '#use-desktop:' >> "$(call scfg,main)"
	echo GLOBAL_BASE_PACKAGE_LISTS+='desktop' >> "$(call scfg,main)"
	echo GLOBAL_BASE_PACKAGE_LISTS+='kernel-wifi' >> "$(call scfg,main)"
	echo GLOBAL_BASE_PACKAGE_LISTS+='kernel-video' >> "$(call scfg,main)"
	echo GLOBAL_BASE_PACKAGE_LISTS+='kernel-desktop' >> "$(call scfg,main)"
	$(call done,$@)

use-live-restore:
	echo GLOBAL_LIVE_PACKAGE_LISTS+='live-restore' >> "$(call scfg,live)"
	$(call done,$@)

use-children:
	echo GLOBAL_LIVE_PACKAGE_LISTS+='live-children' >> "$(call scfg,live)"
	echo GLOBAL_LIVE_PACKAGE_LISTS+='children' >> "$(call scfg,live)"
	$(call done,$@)

use-kde3-live:
	echo GLOBAL_LIVE_PACKAGE_LISTS+='kde3-lite' >> "$(call scfg,live)"
	# echo GLOBAL_LIVE_PACKAGES+='autologin' >> "$(call scfg,live)"
	echo GLOBAL_LIVE_PACKAGES+='kdebase-kdm' >> "$(call scfg,live)"
	echo GLOBAL_LIVE_PKG_GROUPS+='docs' >> "$(call scfg,live)"
	$(call done,$@)

use-kde3-lite:
	echo GLOBAL_BASE_PACKAGE_LISTS+='kde3-lite kde3-dial-up' >> "$(call scfg,main)"
	$(call done,$@)

use-kde3:
	# NB: see also a test in use-compiz target
	echo GLOBAL_BASE_PACKAGE_LISTS+='kde3' >> "$(call scfg,main)"
	echo GLOBAL_DISK_PACKAGE_LISTS+='disk-dvd' >> "$(call scfg,main)"
	echo GLOBAL_PKG_GROUPS+='docs  edu games graphics-editing \
	video-editing sound-editing scanning peer-to-peer \
	dictionary emulators publishing 3d money blogs kde3-dial-up phone' >> $(AUTOCFG)
	$(call done,$@)

ADD_KERNEL = el-smp
use-kde-desktop: use-desktop
	echo " \
	    installer-feature-nfs-client-stage3 \
	    installer-feature-runlevel5-stage3 \
	    installer-feature-xdg-user-dirs \
	    installer-feature-cpufreq-stage3 \
	    " > profiles/pkg/lists/add-installer-features-stage3
	echo GLOBAL_BASE_PACKAGE_LISTS+='kde-base add-installer-features-stage3' >> "$(call scfg,main)"
	echo GLOBAL_DISK_PACKAGES+=$(shell cat profiles/pkg/lists/{kernel,kernel-video,kernel-desktop,kernel-wifi,emulators,centaurus-dev} | \
		grep kernel | \
		sed "s/std-def/$(ADD_KERNEL)/g;s/std-def/$(ADD_KERNEL)/g;s/#.*//")  >> "$(call scfg,main)"
	echo GLOBAL_DISK_PACKAGE_LISTS+='disk-dvd disk-dvd-kde science selinux' >> "$(call scfg,main)"
	cat profiles/pkg/lists/skype >> profiles/pkg/lists/kde
	echo GLOBAL_PKG_GROUPS+='kde docs dropbox remote-desktop edu games \
		video-editing sound-editing graphics-editing scanning printing \
		centaurus-dev \
		emulators publishing' >> $(AUTOCFG)
	echo GLOBAL_INSTALL2_PACKAGES+=' \
	    installer-feature-samba-usershares-stage2 \
	    installer-feature-eth-by-mac-stage2 \
	    installer-feature-freenx-stage2 \
	    installer-feature-weak-passwd \
	    installer-feature-autoxorg \
	    installer-feature-desktop-other-fs-stage2 \
	    installer-feature-desktop-suspend-stage2 \
	    installer-feature-desktop-disable-remote-stage2 \
	    installer-feature-hwtweaks-stage2 \
	    installer-feature-kdesktop-tmpfs \
	    installer-feature-kdesktop-services \
	    installer-feature-kdesktop-fontconfig \
	    installer-feature-symlinks-from-sbin \
	    installer-feature-online-repo \
	    installer-feature-set-tz' >> $(AUTOCFG)
	$(call done,$@)

use-kde-lite:
	echo GLOBAL_BASE_PACKAGE_LISTS+='kde-lite k3b' >> "$(call scfg,main)"
	$(call done,$@)

use-kde-live:
	echo GLOBAL_LIVE_PACKAGE_LISTS+='kde-lite' >> "$(call scfg,live)"
	echo GLOBAL_LIVE_PKG_GROUPS+='docs' >> "$(call scfg,live)"
	$(call done,$@)

use-kde-live-dvd:
	echo GLOBAL_LIVE_PACKAGE_LISTS+='kde' >> "$(call scfg,live)"
	echo GLOBAL_LIVE_PKG_GROUPS+='network graphics docs' >> "$(call scfg,live)"
	$(call done,$@)

use-gnome-dvd:
	echo GLOBAL_BASE_PACKAGE_LISTS+='gnome-base gnome-office gnome-dvd' >> "$(call scfg,main)"
	echo GLOBAL_DISK_PACKAGE_LISTS+='disk-dvd disk-dvd-gnome gnome-addons gnome-network-lite science' >> "$(call scfg,main)"
	echo GLOBAL_DISK_PACKAGES+='gnome-full gnome-a11y' >> "$(call scfg,main)"
	echo GLOBAL_PKG_GROUPS+='graphics-editing gnome-phone gnome-peer-to-peer \
		gtk-video-editing sound-editing scanning gtk-dictionary blogs docs \
	        emulators publishing 3d gnome-money' >> $(AUTOCFG)
	#gnome-money
	$(call done,$@)


use-gnome:
	echo GLOBAL_BASE_PACKAGE_LISTS+='gnome-base gnome-office-light-cd' >> "$(call scfg,main)"
	echo GLOBAL_DISK_PACKAGE_LISTS+='disk-cd' >> "$(call scfg,main)"
	echo GLOBAL_LIVE_PACKAGE_LISTS+='gnome-base gnome-office gnome-addons' >> "$(call scfg,live)"
	echo GLOBAL_LIVE_PACKAGES+='autologin gnome-default gnome-a11y gimp' >> "$(call scfg,live)"
	echo GLOBAL_LIVE_PKG_GROUPS+='gnome-network-lite' >> "$(call scfg,live)"
	echo GLOBAL_PKG_GROUPS+='gnome-network-lite' >> $(AUTOCFG)
	$(call done,$@)

use-gnome-light:
	echo GLOBAL_BASE_PACKAGE_LISTS+='gnome-base' >> "$(call scfg,main)"
	echo GLOBAL_DISK_PACKAGE_LISTS+='disk-cd' >> "$(call scfg,main)"
	echo GLOBAL_LIVE_PACKAGE_LISTS+='gnome-base gnome-office-light \
	gnome-addons-light' >> "$(call scfg,live)"
	echo GLOBAL_LIVE_PACKAGES+='autologin gnome-default gthumb gnome-nettool consolehelper' >> "$(call scfg,live)"
	echo GLOBAL_LIVE_PKG_GROUPS+='gnome-network-lite' >> "$(call scfg,live)"
	echo GLOBAL_PKG_GROUPS+='gnome-network-lite' >> $(AUTOCFG)
	$(call done,$@)

use-gnome-live:
	echo GLOBAL_LIVE_PACKAGE_LISTS+='gnome-base gnome-office' >> "$(call scfg,live)"
	echo GLOBAL_LIVE_PACKAGES+='autologin gimp' >> "$(call scfg,live)"
	echo GLOBAL_LIVE_PKG_GROUPS+='gnome-network-lite' >> "$(call scfg,live)"
	$(call done,$@)

use-artist:
	echo GLOBAL_BASE_PACKAGE_LISTS+='artist photo-raw' >> "$(call scfg,main)"
	echo GLOBAL_LIVE_PACKAGE_LISTS+='artist photo-raw' >> "$(call scfg,live)"
	$(call done,$@)

use-gnome-live-dvd:
	echo GLOBAL_LIVE_PACKAGE_LISTS+='gnome-base gnome-office gnome-addons gnome-addons-light' >> "$(call scfg,live)"
	echo GLOBAL_LIVE_PACKAGES+='autologin gnome-full gnome-a11y gimp' >> "$(call scfg,live)"
	echo GLOBAL_LIVE_PKG_GROUPS+='gnome-network-lite' >> "$(call scfg,live)"
#	echo GLOBAL_PKG_GROUPS+='gnome-network-lite' >> $(AUTOCFG)
	$(call done,$@)

use-homeros-friend:
	echo GLOBAL_LIVE_PACKAGE_LISTS+='homeros-base homeros-friend voiceman tts-full emacspeak' >> "$(call scfg,live)"
#	echo GLOBAL_LIVE_PACKAGES+='autologin gnome-a11y' >> "$(call scfg,live)"
#	echo GLOBAL_LIVE_PKG_GROUPS+='gnome-network-lite' >> "$(call scfg,live)"
#	echo GLOBAL_PKG_GROUPS+='gnome-network-lite' >> $(AUTOCFG)
	echo GLOBAL_HOMEROS=1 >> "$(call scfg,live)"
	echo GLOBAL_HOMEROS_FRIEND=1 >> "$(call scfg,live)"
	$(call done,$@)

use-homeros-desktop:
#	echo GLOBAL_BASE_PACKAGE_LISTS+='gnome-base' >> "$(call scfg,main)"
#	echo GLOBAL_DISK_PACKAGE_LISTS+='disk-cd' >> "$(call scfg,main)"
	echo GLOBAL_LIVE_PACKAGE_LISTS+='gnome-base homeros-live' >> "$(call scfg,live)"
	echo GLOBAL_LIVE_PACKAGES+='autologin gnome-a11y' >> "$(call scfg,live)"
	echo GLOBAL_LIVE_PKG_GROUPS+='gnome-network-lite' >> "$(call scfg,live)"
	echo GLOBAL_PKG_GROUPS+='gnome-network-lite' >> $(AUTOCFG)
	echo GLOBAL_HOMEROS=1 >> "$(call scfg,live)"
	$(call done,$@)

ADD_KERNEL = std-def
use-centaurus:
	echo GLOBAL_DISK_PACKAGES+=$(shell cat profiles/pkg/lists/{kernel,kernel-video,kernel-desktop,kernel-wifi,emulators,centaurus-dev} | \
		grep kernel | \
		sed "s/std-def/$(ADD_KERNEL)/g;s/std-def/$(ADD_KERNEL)/g;s/#.*//")  >> "$(call scfg,main)"
	echo GLOBAL_BASE_PACKAGE_LISTS+='centaurus-base kernel-video autofs' >> "$(call scfg,main)"
	echo GLOBAL_LIVE_PACKAGE_LISTS+='remmina cups' >> "$(call scfg,live)" 
	echo GLOBAL_LIVE_PACKAGES+='livecd-gnome-nowarn-space git-core xdg-user-dirs livecd-install \
		installer-feature-desktop-suspend-stage2' >> "$(call scfg,live)" 
	echo GLOBAL_DISK_PACKAGE_LISTS+='cluster disk-dvd disk-dvd-gnome gnome-addons \
		docs pgu selinux runa-botstation kernel-ovz' >> "$(call scfg,main)"
	echo -n '' > profiles/pkg/lists/centaurus-gnome
	for name in desktop alterator-desktop gnome-base nm skype ;\
		do cat profiles/pkg/lists/$$name >> profiles/pkg/lists/centaurus-gnome; \
	done
	cat profiles/pkg/lists/firefox >> profiles/pkg/lists/xorg
	subst 's/etcnet-defaults-desktop//' profiles/pkg/lists/xorg
	cat profiles/pkg/lists/fvwm-base >> profiles/pkg/lists/xorg
	echo GLOBAL_PKG_GROUPS+='centaurus-office centaurus-desktop centaurus-xorg centaurus-gnome centaurus-dev \
		emulators publishing gnome-phone gtk-dictionary blogs \
		 gtk-video-editing sound-editing scanning 3d \
		 graphics-editing gnome-peer-to-peer remmina virt-manager' >> $(AUTOCFG)
	echo GLOBAL_PKG_GROUPS+='ftp-server-a dhcp-server-a mysql-server-a \
	dns-server-a mail-server-a netinst samba-server freenx-server\
	alterator server-apps bacula bacula-server bacula-client bacula-client-a \
		centaurus-dev eclipse buildsystem docs' >> $(AUTOCFG)
	#echo GLOBAL_PKG_GROUPS+='ganeti' >> $(AUTOCFG)
	echo GLOBAL_INSTALL2_PACKAGES+='installer-feature-autoxorg installer-feature-vm-ofs-stage2 \
		installer-feature-desktop-other-fs-stage2 installer-feature-setup-openldap \
		installer-feature-remove-fvwm installer-feature-centaurus-profiles \
		installer-feature-load-tun installer-feature-desktop-suspend-stage2 \
		installer-feature-auto-domain' >> $(AUTOCFG)
	$(call done,$@)

use-xfce:
	# FIXME: need to rethink package lists flexibility limit
	echo GLOBAL_BASE_PACKAGES+='xfce-settings-kdesktop' \
		>> "$(call scfg,main)"
	echo GLOBAL_BASE_PACKAGE_LISTS+='xfce' >> "$(call scfg,main)"
	echo GLOBAL_DISK_PACKAGE_LISTS+='disk-cd' >> "$(call scfg,main)"
	echo GLOBAL_LIVE_PACKAGES+='autologin \
		docs-issue-desktop_lite docs-install-desktop_lite' >> "$(call scfg,live)"
	echo GLOBAL_LIVE_PACKAGE_LISTS+='xfce' >> "$(call scfg,live)"
	echo GLOBAL_LIVE_PKG_GROUPS+='xfce-office-lite xfce-network-lite xfce-graphics-lite' \
		>> "$(call scfg,live)"
	echo GLOBAL_PKG_GROUPS+='xfce-docs xfce-office-lite office-superlite \
		xfce-games-lite xfce-graphics-lite ' >> $(AUTOCFG)
	$(call done,$@)

use-xfce-school:
	# FIXME: need to rethink package lists flexibility limit
	#        (settings should go into branding-* now)
	echo GLOBAL_BASE_PACKAGES+='branding-altlinux-kdesktop-xfce-settings' \
		>> "$(call scfg,main)"
	echo GLOBAL_BASE_PACKAGE_LISTS+='xfce' >> "$(call scfg,main)"
	echo GLOBAL_DISK_PACKAGE_LISTS+='disk-cd' >> "$(call scfg,main)"
	echo GLOBAL_PKG_GROUPS+='xfce-office-lite office-superlite pspo-teacher' >> $(AUTOCFG)
	$(call done,$@)

use-slinux:
	for name in nm skype ;\
		do cat profiles/pkg/lists/$$name >> profiles/pkg/lists/slinux-network; \
	done

	echo GLOBAL_BASE_PACKAGE_LISTS+='slinux-xfce slinux-misc kernel-video gnome-peer-to-peer slinux-games slinux-graphics slinux-multimedia slinux-network slinux-misc-dvd' >> "$(call scfg,main)"
	echo GLOBAL_DISK_PACKAGE_LISTS+='disk-dvd' >> "$(call scfg,main)"
	echo GLOBAL_LIVE_PACKAGES+='autologin' >> "$(call scfg,live)"
	echo GLOBAL_LIVE_PACKAGE_LISTS+='slinux-xfce slinux-misc slinux-live kernel-video' >> "$(call scfg,live)"
	echo GLOBAL_LIVE_PKG_GROUPS+='gnome-peer-to-peer slinux-games slinux-graphics slinux-multimedia slinux-network' >> "$(call scfg,live)"
	echo GLOBAL_PKG_GROUPS+='slinux-dropbox slinux-games slinux-games-base slinux-games-extra \
		slinux-graphics slinux-graphics-base \
		slinux-graphics-blender slinux-graphics-inkscape \
		slinux-graphics-shotwell slinux-graphics-synfigstudio	\
		slinux-multimedia slinux-multimedia-base \
		slinux-multimedia-audacity slinux-multimedia-pitivi slinux-multimedia-sound-juicer \
		slinux-emulators-dvd' >> $(AUTOCFG)
	$(call done,$@)

use-lxde-desktop: use-lxde-live use-live-restore use-autologin
	echo GLOBAL_BASE_PACKAGE_LISTS+='lxde lxde-office' >> "$(call scfg,main)"
	echo GLOBAL_BASE_PACKAGE_LISTS+='lxde-audio lxde-internet lxde-video' >> "$(call scfg,main)"
	echo GLOBAL_BASE_PACKAGE_LISTS+='scanning lxde-games graphics-editing gtk-dictionary desktop alterator-desktop' >> "$(call scfg,main)"
	echo GLOBAL_INSTALL2_PACKAGES+='installer-feature-rmdir-documents-stage2 installer-feature-radeon-without-kms-stage2 installer-feature-gdm-abstraction-stage2' >> "$(call scfg,install2)"
	echo GLOBAL_DISK_PACKAGE_LISTS+='disk-cd' >> "$(call scfg,main)"
	$(call done,$@)

use-lxde-lite:
	echo GLOBAL_BASE_PACKAGE_LISTS+='lxde-lite lxde-lite-office' >> "$(call scfg,main)"
	echo GLOBAL_BASE_PACKAGE_LISTS+='lxde-audio lxde-lite-internet' >> "$(call scfg,main)"
	echo GLOBAL_BASE_PACKAGE_LISTS+='lxde-video alterator-desktop' >> "$(call scfg,main)"
	echo GLOBAL_INSTALL2_PACKAGES+='installer-feature-rmdir-documents-stage2 installer-feature-radeon-without-kms-stage2 installer-feature-gdm-abstraction-stage2' >> "$(call scfg,install2)"
	echo GLOBAL_DISK_PACKAGES+='openoffice.org openoffice.org-langpack-ru openoffice.org-langpack-uk' >> "$(call scfg,main)"
	echo GLOBAL_DISK_PACKAGE_LISTS+='disk-cd' >> "$(call scfg,main)"
	$(call done,$@)

use-lxde-lite-live:
	echo GLOBAL_LIVE_PACKAGE_LISTS+='lxde-lite lxde-lite-office' >> "$(call scfg,live)"
	echo GLOBAL_LIVE_PACKAGE_LISTS+='lxde-audio lxde-lite-internet' >> "$(call scfg,live)"
	echo GLOBAL_LIVE_PACKAGE_LISTS+='lxde-video' >> "$(call scfg,live)"
	$(call done,$@)

use-lxde-live:
	echo GLOBAL_LIVE_PACKAGE_LISTS+='lxde lxde-office' >> "$(call scfg,live)"
	echo GLOBAL_LIVE_PACKAGE_LISTS+='lxde-audio lxde-internet lxde-video' >> "$(call scfg,live)"
	echo GLOBAL_LIVE_PACKAGE_LISTS+='scanning graphics-editing gtk-dictionary' >> "$(call scfg,live)"
	echo GLOBAL_LIVE_PACKAGE_LISTS+='desktop alterator-desktop' >> "$(call scfg,live)"
	$(call done,$@)


# TODO: add pspo-desktop and pspo-services
use-pspo: base-pspo base-pspo-desktop group-pspo-teacher \
	base-3d base-eclipse base-emulators base-graphics-editing \
	base-publishing base-sound-editing \
	use-desktop use-docs use-freenx-server use-live-restore use-nm
	echo "Target $@ done"

use-pspo-kde: use-pspo base-pspo-kde base-pspo-desktop base-pspo-services \
	use-kde use-kde-live base-scanning base-video-editing
	echo "Target $@ done"

use-pspo-gnome: use-pspo base-pspo-gnome live-pspo-gnome \
	base-docs base-gnome-base base-gnome-dvd base-gnome-office base-gtk-video-editing \
	disk-gnome-addons use-compiz use-gnome-live-dvd
	echo "Target $@ done"

use-school-lite: use-xfce-school use-xdm use-freenx-server
	echo "Target $@ done"

use-autologin:
	echo GLOBAL_LIVE_PACKAGES+='installer-feature-autologin-stage3' \
		>> "$(call scfg,live)"
	$(call done,$@)

use-freenx:
	echo GLOBAL_BASE_PACKAGES+='freenx-server nxclient' >> "$(call scfg,main)"
	echo GLOBAL_INSTALL2_PACKAGES+='installer-feature-freenx-stage2' \
		>> "$(call scfg,install2)"
	$(call done,$@)

use-freenx-server:
	echo GLOBAL_BASE_PACKAGES+='freenx-server' >> "$(call scfg,main)"
	echo GLOBAL_INSTALL2_PACKAGES+='installer-feature-freenx-stage2' \
		>> "$(call scfg,install2)"
	$(call done,$@)

use-webkiosk:
	echo GLOBAL_BASE_PACKAGE_LISTS+='webkiosk' >> "$(call scfg,main)"
	$(call done,$@)

use-runa:
	echo GLOBAL_PKG_GROUPS+='runa-client runa-editor runa-botstation' >> $(AUTOCFG)
	$(call done,$@)

use-etersoft:
	echo GLOBAL_PKG_GROUPS+='wine-local' >> $(AUTOCFG)
	$(call done,$@)

use-etersoft-network:
	echo GLOBAL_BASE_PACKAGE_LISTS+='wine-network' >> "$(call scfg,main)"
	$(call done,$@)

use-ltsp: use-freenx
	# FIXME: hm, is this a good place for installer features?..
	echo GLOBAL_INSTALL2_PACKAGES+='installer-feature-ltsp-stage2' \
		>> "$(call scfg,install2)"
	echo GLOBAL_BASE_PACKAGE_LISTS+='ltsp' >> "$(call scfg,main)"
	# currently handled in profiles/ltsp/Makefile.in
	#echo GLOBAL_DISK_PACKAGE_LISTS+='disk-ltsp' >> "$(call scfg,main)"
	$(call done,$@)

use-rdp:
	echo GLOBAL_LIVE_PACKAGES+=autordp >> "$(call scfg,live)"
	$(call done,$@)

use-compiz:
	echo GLOBAL_BASE_PACKAGE_LISTS+='compiz' >> "$(call scfg,main)"
	# FIXME: the below test isn't elegant
	grep "^GLOBAL_BASE_PACKAGE.*\<kde\>" "$(call scfg,main)" \
		&& echo GLOBAL_BASE_PACKAGE_LISTS+='compiz-kde' >> "$(call scfg,main)" ||:
	egrep '^GLOBAL_BASE_PACKAGE.*\<(gnome|xfce|icewm)' "$(call scfg,main)" \
		&& echo GLOBAL_BASE_PACKAGES+='compiz-gtk' >> "$(call scfg,main)" ||:
	$(call done,$@)

use-clamav:
	echo USE_CLAMAV=1 >> "$(call scfg,live)"
	$(call done,$@)

use-server:
	echo LOCAL_BASE_PACKAGE_LISTS='base kernel-server'  >> "$(call scfg,main)"
	echo GLOBAL_BASE_PACKAGE_LISTS+='server docs' >> "$(call scfg,main)"
	echo GLOBAL_DISK_PACKAGE_LISTS+='disk-server' >> "$(call scfg,main)"
	$(call done,$@)

use-school-server:
	echo GLOBAL_BASE_PACKAGE_LISTS+='skf' >> "$(call scfg,main)"
	echo GLOBAL_DISK_PACKAGES+='twclass' >> "$(call scfg,main)"
	$(call done,$@)

use-school-master:
	echo GLOBAL_BASE_PACKAGE_LISTS+='skf' >> "$(call scfg,main)"
	$(call done,$@)

use-server-light: use-kernel-wifi
	echo LOCAL_BASE_PACKAGE_LISTS='base-server kernel-server'  >> "$(call scfg,main)"
	echo NODOCS='#'  >> "$(call scfg,main)"
	echo GLOBAL_BASE_PACKAGE_LISTS+='server-light' >> "$(call scfg,main)"
	echo GLOBAL_DISK_PACKAGE_LISTS+='disk-server-light' >> "$(call scfg,main)"
	echo GLOBAL_PKG_GROUPS+='dns-server http-server ftp-server' >> $(AUTOCFG)
	echo GLOBAL_PKG_GROUPS+='ipmi mysql-server dhcp-server mail-server' >> $(AUTOCFG)
	echo GLOBAL_PKG_GROUPS+='monitoring diag-tools' >> $(AUTOCFG)
	#echo GLOBAL_PKG_GROUPS+='kvm-server' >> $(AUTOCFG)

use-pbx-office: disk-asterisk-devel use-asterisk-1.6.2
	echo LOCAL_BASE_PACKAGE_LISTS='base-server kernel-server kernel-pbx'  >> "$(call scfg,main)"
	echo NODOCS='#'  >> "$(call scfg,main)"
	echo GLOBAL_BASE_PACKAGE_LISTS+='pbx' >> "$(call scfg,main)"
	#echo GLOBAL_DISK_PACKAGE_LISTS+='disk-server-light' >> "$(call scfg,main)"
	#echo GLOBAL_PKG_GROUPS+='dns-server http-server ftp-server mysql-server dhcp-server mail-server' >> $(AUTOCFG)

use-pbx-huge:
	echo LOCAL_BASE_PACKAGE_LISTS='base-server kernel-server kernel-pbx'  >> "$(call scfg,main)"
	echo NODOCS='#'  >> "$(call scfg,main)"
	echo GLOBAL_BASE_PACKAGE_LISTS+='pbx' >> "$(call scfg,main)"
	echo GLOBAL_PKG_GROUPS+='asterisk-devel' >> $(AUTOCFG)
	echo GLOBAL_PKG_GROUPS+='asterisk-1.4' >> $(AUTOCFG)
	echo GLOBAL_PKG_GROUPS+='asterisk-1.6.0' >> $(AUTOCFG)
	echo GLOBAL_PKG_GROUPS+='asterisk-1.6.1' >> $(AUTOCFG)
	echo GLOBAL_PKG_GROUPS+='asterisk-1.6.2' >> $(AUTOCFG)
	echo GLOBAL_PKG_GROUPS+='pbx-callweaver' >> $(AUTOCFG)
	echo GLOBAL_PKG_GROUPS+='pbx-freeswitch' >> $(AUTOCFG)
	echo GLOBAL_PKG_GROUPS+='pbx-gateway' >> $(AUTOCFG)
	#echo GLOBAL_DISK_PACKAGE_LISTS+='disk-server-light' >> "$(call scfg,main)"
	#echo GLOBAL_PKG_GROUPS+='dns-server http-server ftp-server mysql-server dhcp-server mail-server' >> $(AUTOCFG)

use-encfs-homes:
	echo GLOBAL_CRYPT_HOMES=encfs >> "$(call scfg,live)"
	echo GLOBAL_LIVE_PACKAGE_LISTS+='encfs live-encfs' >> "$(call scfg,live)"
	@echo "Enable encrypted homes feature: encfs" >&2
	$(call done,$@)

# use 1/4 of RAM for compressed swap in live
use-zram:
ifeq (std-def,std-def)
	 echo GLOBAL_LIVE_PACKAGES+=kernel-modules-staging-std-def >> "$(call scfg,live)"
	 echo GLOBAL_LIVE_PACKAGES+=zram-swap>> "$(call scfg,live)"
endif
	true

use-docs:
	echo GLOBAL_BASE_PACKAGE_LISTS+='docs' >> "$(call scfg,main)"
	$(call done,$@)
