const char *WebVisionVCA_js=
   "\n"
   "//OpenSCADA system module UI.WebVision file: VCA.js\n"
   "/***************************************************************************\n"
   " *   Copyright (C) 2007-2018 by Roman Savochenko, <rom_as@oscada.org>      *\n"
   " *                                                                         *\n"
   " *   This program is free software; you can redistribute it and/or modify  *\n"
   " *   it under the terms of the GNU General Public License as published by  *\n"
   " *   the Free Software Foundation; version 2 of the License.               *\n"
   " *                                                                         *\n"
   " *   This program is distributed in the hope that it will be useful,       *\n"
   " *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *\n"
   " *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *\n"
   " *   GNU General Public License for more details.                          *\n"
   " *                                                                         *\n"
   " *   You should have received a copy of the GNU General Public License     *\n"
   " *   along with this program; if not, write to the                         *\n"
   " *   Free Software Foundation, Inc.,                                       *\n"
   " *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *\n"
   " ***************************************************************************/\n"
   "\n"
   "var MOD_ID = 'WebVision';\n"
   "var isNN = navigator.appName.indexOf('Netscape') != -1;\n"
   "var isIE = navigator.appName.indexOf('Microsoft') != -1;\n"
   "var isOpera = navigator.appName.indexOf('Opera') != -1;\n"
   "var isKonq = navigator.userAgent.indexOf('Konqueror') != -1;\n"
   "var mainTmId = 0;\n"
   "var gPrms = window.location.search || '';\n"
   "\n"
   "/***************************************************\n"
   " * pathLev - Path parsing function.                *\n"
   " ***************************************************/\n"
   "pathLev.off = 0;\n"
   "function pathLev( path, level, scan )\n"
   "{\n"
   "    var an_dir = scan ? pathLev.off : 0;\n"
   "    var t_lev = 0;\n"
   "    var t_dir;\n"
   "    while(an_dir < path.length && path.charAt(an_dir) == '/') an_dir++;\n"
   "    if(an_dir >= path.length) return '';\n"
   "    while(true) {\n"
   "	t_dir = path.indexOf('/', an_dir);\n"
   "	if(t_dir < 0)		{ pathLev.off = path.length; return (t_lev==level)?path.substr(an_dir):''; }\n"
   "	if(t_lev == level)	{ pathLev.off = t_dir; return path.substr(an_dir,t_dir-an_dir); }\n"
   "	an_dir = t_dir;\n"
   "	t_lev++;\n"
   "	while(an_dir < path.length && path.charAt(an_dir) == '/') an_dir++;\n"
   "    }\n"
   "}\n"
   "\n"
   "/***************************************************\n"
   " * noSpace - Get no space (trimmed) string         *\n"
   " ***************************************************/\n"
   "function noSpace( str )\n"
   "{\n"
   "    var posSt = -1; var posEnd = 0;\n"
   "    for(var i = 0; i < str.length; i++)\n"
   "	if(str[i] != ' ') { if(posSt<0) posSt = i; posEnd = i; }\n"
   "    return (posSt>=0) ? str.substr(posSt,posEnd-posSt+1) : '';\n"
   "}\n"
   "\n"
   "/***************************************************\n"
   " * i2s - integer to string                         *\n"
   " ***************************************************/\n"
   "function i2s( vl, base, len )\n"
   "{\n"
   "    rez = vl.toString(base);\n"
   "    if(len) while(rez.length < len) rez = \"0\"+rez;\n"
   "    return rez;\n"
   "}\n"
   "\n"
   "/***************************************************\n"
   " * posGetX - Get absolute position                 *\n"
   " **************************************************/\n"
   "function posGetX( obj, noWScrl )\n"
   "{\n"
   "    var posX = 0;\n"
   "    for( ; obj && obj.nodeName != 'BODY'; obj = obj.parentNode) {\n"
   "	posX += (obj.style.left?parseInt(obj.style.left):0)+\n"
   "	    (obj.parentNode.style.borderLeftWidth?parseInt(obj.parentNode.style.borderLeftWidth):0)+\n"
   "	    (obj.parentNode.style.marginLeft?parseInt(obj.parentNode.style.marginLeft):0);\n"
   "	if(obj.style.position == 'relative') posX += obj.offsetLeft;\n"
   "    }\n"
   "    return posX + (!noWScrl?-window.pageXOffset:0);\n"
   "}\n"
   "\n"
   "/***************************************************\n"
   " * posGetY - Get absolute position                 *\n"
   " **************************************************/\n"
   "function posGetY( obj, noWScrl )\n"
   "{\n"
   "    var posY = 0;\n"
   "    for( ; obj && obj.nodeName != 'BODY'; obj = obj.parentNode) {\n"
   "	posY += (obj.style.top?parseInt(obj.style.top):0)+\n"
   "	    (obj.parentNode.style.borderTopWidth?parseInt(obj.parentNode.style.borderTopWidth):0)+\n"
   "	    (obj.parentNode.style.marginTop?parseInt(obj.parentNode.style.marginTop):0);\n"
   "	if(obj.style.position == 'relative') posY += obj.offsetTop;\n"
   "    }\n"
   "    return posY + (!noWScrl?-window.pageYOffset:0);\n"
   "}\n"
   "\n"
   "/***************************************************\n"
   " * getXmlHttp - Check and return XMLHttpRequest for*\n"
   " *  various browsers.                              *\n"
   " ***************************************************/\n"
   "function getXmlHttp( )\n"
   "{\n"
   "    if(window.XMLHttpRequest) return new XMLHttpRequest();\n"
   "    else if(window.ActiveXObject) {\n"
   "	try { return new ActiveXObject('Msxml2.XMLHTTP'); }\n"
   "	catch(e) { return new ActiveXObject('Microsoft.XMLHTTP'); }\n"
   "    }\n"
   "    return null;\n"
   "}\n"
   "\n"
   "/***************************************************\n"
   " * realRound - Real numbers round                  *\n"
   " ***************************************************/\n"
   "function realRound( val, dig, toInt )\n"
   "{\n"
   "    var rrRez = Math.floor(val*Math.pow(10,dig?dig:0)+0.5)/Math.pow(10,dig?dig:0);\n"
   "    if(toInt) return Math.floor(rrRez+0.5);\n"
   "    return rrRez;\n"
   "}\n"
   "\n"
   "/***************************************************\n"
   " * evMouseGet - Get mouse key code from event      *\n"
   " ***************************************************/\n"
   "function evMouseGet( e )\n"
   "{\n"
   "    if(e.which == 1)		return 'Left';\n"
   "    else if(e.which == 2)	return 'Midle';\n"
   "    else if(e.which == 3)	return 'Right';\n"
   "    return '';\n"
   "}\n"
   "\n"
   "/***************************************************\n"
   " * evKeyGet - Get key code from event              *\n"
   " ***************************************************/\n"
   "function evKeyGet( e )\n"
   "{\n"
   "    if((e.keyCode >= 48 && e.keyCode <= 57) || (e.keyCode >= 65 && e.keyCode <= 90))\n"
   "	return String.fromCharCode(e.keyCode);\n"
   "    switch(e.keyCode) {\n"
   "	case 27: return 'Esc';\n"
   "	case 8:  return 'BackSpace';\n"
   "	case 13: return 'Enter';\n"
   "	case 45: return 'Insert';\n"
   "	case 19: return 'Pause';\n"
   "	case 36: return 'Home';\n"
   "	case 35: return 'End';\n"
   "	case 37: return 'Left';\n"
   "	case 38: return 'Up';\n"
   "	case 39: return 'Right';\n"
   "	case 40: return 'Down';\n"
   "	case 33: return 'PageUp';\n"
   "	case 34: return 'PageDown';\n"
   "	case 112: return 'F1';\n"
   "	case 113: return 'F2';\n"
   "	case 114: return 'F3';\n"
   "	case 115: return 'F4';\n"
   "	case 116: return 'F5';\n"
   "	case 117: return 'F6';\n"
   "	case 118: return 'F7';\n"
   "	case 119: return 'F8';\n"
   "	case 120: return 'F9';\n"
   "	case 121: return 'F10';\n"
   "	case 122: return 'F11';\n"
   "	case 123: return 'F12';\n"
   "	case 32: return 'Space';\n"
   "	case 59: return 'Semicolon';\n"
   "	case 61: return 'Equal';\n"
   "    }\n"
   "    if(isNN) switch(e.keyCode) {\n"
   "	case 46: return 'Delete';\n"
   "	case 44: return 'Print';\n"
   "	case 192: return 'Apostrophe';\n"
   "	case 106: return 'Asterisk';\n"
   "	case 107: return 'Plus';\n"
   "	case 188: return 'Comma';\n"
   "	case 109: return 'Minus';\n"
   "	case 190: return 'Period';\n"
   "	case 220: return 'Slash';\n"
   "	case 219: return 'BracketLeft';\n"
   "	case 191: return 'BackSlash';\n"
   "	case 221: return 'BracketRight';\n"
   "	case 222: return 'QuoteLeft';\n"
   "    }\n"
   "    else switch(e.keyCode) {\n"
   "	case 127: return 'Delete';\n"
   "	case 96: return 'Apostrophe';\n"
   "	case 42: return 'Asterisk';\n"
   "	case 43: return 'Plus';\n"
   "	case 44: return 'Comma';\n"
   "	case 45: return 'Minus';\n"
   "	case 46: return 'Period';\n"
   "	case 92: return 'Slash';\n"
   "	case 91: return 'BracketLeft';\n"
   "	case 47: return 'BackSlash';\n"
   "	case 93: return 'BracketRight';\n"
   "	case 39: return 'QuoteLeft';\n"
   "    }\n"
   "    return '#'+e.keyCode.toString(16);\n"
   "}\n"
   "\n"
   "/***************************************************\n"
   " * servGet - XML get request to server             *\n"
   " ***************************************************/\n"
   "function servGet( adr, prm, callBack, callBackPrm )\n"
   "{\n"
   "    var req = getXmlHttp();\n"
   "    req.open('GET', encodeURI('/'+MOD_ID+adr+(gPrms.length?gPrms+'&':'?')+prm), callBack ? true : false);\n"
   "    if(callBack) {\n"
   "	req.callBack = callBack;\n"
   "	req.callBackPrm = callBackPrm;\n"
   "	req.onreadystatechange = function( ) {\n"
   "	    if(this.readyState != 4) return;\n"
   "	    if(this.status == 200 && this.responseXML.childNodes.length) {\n"
   "		this.responseXML.childNodes[0].callBackPrm = this.callBackPrm;\n"
   "		this.callBack(this.responseXML.childNodes[0]);\n"
   "	    }\n"
   "	    else this.callBack(-1);\n"
   "	};\n"
   "	req.send(null);\n"
   "	return null;\n"
   "    }\n"
   "    //else console.log(\"TEST 00: Sync GET=\"+adr+'?'+prm);\n"
   "    try {\n"
   "	req.send(null);\n"
   "	if(req.status == 200 && req.responseXML.childNodes.length)\n"
   "	    return req.responseXML.childNodes[0];\n"
   "    } catch(e) { window.location.reload(); /*window.location = '/'+MOD_ID;*/ }\n"
   "\n"
   "    return null;\n"
   "}\n"
   "\n"
   "/***************************************************\n"
   " * servSet - XML set request to server             *\n"
   " ***************************************************/\n"
   "function servSet( adr, prm, body, waitRez )\n"
   "{\n"
   "    var req = getXmlHttp();\n"
   "    req.open('POST', encodeURI('/'+MOD_ID+adr+(gPrms.length?gPrms+'&':'?')+prm), !waitRez);\n"
   "    try {\n"
   "	req.send(body);\n"
   "	if(waitRez && req.status == 200 && req.responseXML.childNodes.length)\n"
   "	    return req.responseXML.childNodes[0];\n"
   "	//if(mainTmId) clearTimeout(mainTmId);\n"
   "	//mainTmId = setTimeout(makeUI, 1000);\n"
   "	//console.log(\"TEST 01: SET=\"+body);\n"
   "    } catch(e) { window.location.reload(); /*window.location = '/'+MOD_ID;*/ }\n"
   "\n"
   "    return null;\n"
   "}\n"
   "\n"
   "/***************************************************\n"
   " * getWAttr - request page/widget attribute        *\n"
   " ***************************************************/\n"
   "function getWAttr( wId, attr )\n"
   "{\n"
   "    var rNode = servGet(wId,'com=attr&attr='+attr);\n"
   "    if(!rNode) return null;\n"
   "\n"
   "    return rNode.textContent;\n"
   "}\n"
   "\n"
   "/***************************************************\n"
   " * setWAttrs - set page/widget attributes          *\n"
   " ***************************************************/\n"
   "function setWAttrs( wId, attrs, val )\n"
   "{\n"
   "    var body = '<set>';\n"
   "    if(typeof(attrs) == 'string') body += '<el id=\\''+attrs+'\\'>'+val+'</el>';\n"
   "    else for(var i in attrs) body += '<el id=\\''+i+'\\'>'+attrs[i]+'</el>';\n"
   "    body += '</set>';\n"
   "    servSet(wId, 'com=attrs', body);\n"
   "}\n"
   "\n"
   "/***************************************************\n"
   " * getFont( fStr, fSc, opt ) - Parse font          *\n"
   " *  opt - options: 1-punkts; 2-return size         *\n"
   " ***************************************************/\n"
   "function getFont( fStr, fSc, opt )\n"
   "{\n"
   "    var rez = '';\n"
   "    if(fStr) {\n"
   "	var allFnt = fStr.split(' ');\n"
   "	if(opt == 2) return (parseInt(allFnt[1])*(fSc?fSc:1)).toFixed(0);\n"
   "	if(allFnt.length >= 1) rez += 'font-family: ' + allFnt[0].replace(/_/g,' ') + '; ';\n"
   "	if(allFnt.length >= 2) rez += 'font-size: ' + (parseInt(allFnt[1])*(fSc?fSc:1)).toFixed(0) + (opt==1?'pt; ':'px; ');\n"
   "	if(allFnt.length >= 3) rez += 'font-weight: ' + (parseInt(allFnt[2])?'bold':'normal') + '; ';\n"
   "	if(allFnt.length >= 4) rez += 'font-style: ' + (parseInt(allFnt[3])?'italic':'normal') + '; ';\n"
   "	if(allFnt.length >= 5 && parseInt(allFnt[4])) rez += 'text-decoration: underline; ';\n"
   "	else if(allFnt.length >= 6 && parseInt(allFnt[5])) rez += 'text-decoration: line-through; ';\n"
   "    }\n"
   "\n"
   "    return rez;\n"
   "}\n"
   "\n"
   "/***************************************************\n"
   " * getFontCond( fStr, fSc, opt ) - Parse font          *\n"
   " *  opt - options: 1-punkts; 2-return size         *\n"
   " ***************************************************/\n"
   "function getFontCond( fStr, fSc, opt )\n"
   "{\n"
   "    fontCfg = \"\";\n"
   "    if(fStr) {\n"
   "	allFnt = fStr.split(\" \");\n"
   "	if(allFnt.length >= 3 && parseInt(allFnt[2])) fontCfg += \"bold \";\n"
   "	if(allFnt.length >= 4 && parseInt(allFnt[3])) fontCfg += \"italic \";\n"
   "	if(allFnt.length >= 2) fontCfg += (parseInt(allFnt[1])*(fSc?fSc:1)).toFixed(0) + (opt==1?\"pt \":\"px \");\n"
   "	if(allFnt.length >= 1) fontCfg += allFnt[0].replace(/_/g,\" \") + \" \";\n"
   "    }\n"
   "\n"
   "    return fontCfg;\n"
   "}\n"
   "\n"
   "/***************************************************\n"
   " * getColor - Parse color                          *\n"
   " ***************************************************/\n"
   "function getColor( cStr, getOpacity )\n"
   "{\n"
   "    var fPos = cStr.indexOf('-');\n"
   "    if(getOpacity) return (fPos >= 0) ? Math.max(0,Math.min(255,parseFloat(cStr.slice(fPos+1))/255)) : 1;\n"
   "    return (fPos >= 0) ? cStr.slice(0,fPos) : cStr;\n"
   "}\n"
   "\n"
   "/*****************************************************\n"
   " * chkPattern - Check for allow expression to pattern *\n"
   " *****************************************************/\n"
   "function chkPattern( val, patt )\n"
   "{\n"
   "    //Check by regular expression\n"
   "    if(patt.length > 2 && patt.charAt(0) == '/' && patt.charAt(patt.length-1) == '/')\n"
   "	return (new RegExp(patt.slice(1,patt.length-1),'')).test(val);\n"
   "\n"
   "    //Check by simple pattern\n"
   "    var mult_s = false;\n"
   "    var v_cnt = 0, p_cnt = 0;\n"
   "    var v_bck = -1, p_bck = -1;\n"
   "\n"
   "    while(true) {\n"
   "	if(p_cnt >= patt.length)	return true;\n"
   "	if(patt.charAt(p_cnt) == '?')	{ v_cnt++; p_cnt++; mult_s = false; continue; }\n"
   "	if(patt.charAt(p_cnt) == '*')	{ p_cnt++; mult_s = true; v_bck = -1; continue; }\n"
   "	if(patt.charAt(p_cnt) == '\\\\')	p_cnt++;\n"
   "	if(v_cnt >= val.length)	break;\n"
   "	if(patt.charAt(p_cnt) == val.charAt(v_cnt)) {\n"
   "	    if(mult_s && v_bck < 0)	{ v_bck = v_cnt+1; p_bck = p_cnt; }\n"
   "	    v_cnt++; p_cnt++;\n"
   "	}\n"
   "	else {\n"
   "	    if(mult_s) {\n"
   "		if(v_bck >= 0) { v_cnt = v_bck; p_cnt = p_bck; v_bck = -1; }\n"
   "		else v_cnt++;\n"
   "	    }\n"
   "	    else break;\n"
   "	}\n"
   "    }\n"
   "    return false;\n"
   "}\n"
   "\n"
   "/***************************************************\n"
   " * setFocus - Command for set focus                *\n"
   " ***************************************************/\n"
   "function setFocus( wdg, onlyClr )\n"
   "{\n"
   "    if(masterPage.focusWdf && masterPage.focusWdf == wdg) return;\n"
   "    var attrs = new Object();\n"
   "    if(masterPage.focusWdf) { attrs.focus = '0'; attrs.event = 'ws_FocusOut'; setWAttrs(masterPage.focusWdf,attrs); }\n"
   "    masterPage.focusWdf = wdg;\n"
   "    if(!onlyClr) { attrs.focus = '1'; attrs.event = 'ws_FocusIn'; setWAttrs(masterPage.focusWdf,attrs); }\n"
   "}\n"
   "\n"
   "/**********************************************************\n"
   " * callPage - call page 'pgId' for open update and other. *\n"
   " **********************************************************/\n"
   "function callPage( pgId, updWdg, pgGrp, pgOpenSrc )\n"
   "{\n"
   "    if(!pgId) return true;\n"
   "\n"
   "    //Check and update present page\n"
   "    if(this == masterPage) {\n"
   "	var opPg = this.findOpenPage(pgId);\n"
   "	if(opPg) {\n"
   "	    /*if(!(prcCnt%5)) opPg.makeEl(servGet(pgId,'com=attrsBr&FullTree=1&tm='+tmCnt),false,false,true);\n"
   "	    else*/ if(updWdg) servGet(pgId, 'com=attrsBr&tm='+tmCnt, makeEl, opPg);\n"
   "				//opPg.makeEl(servGet(pgId,'com=attrsBr&tm='+tmCnt));\n"
   "	    return true;\n"
   "	}\n"
   "    }\n"
   "\n"
   "    //Create or replace the main page\n"
   "    if(!pgGrp) pgGrp = getWAttr(pgId,'pgGrp');\n"
   "    if(!pgOpenSrc) pgOpenSrc = getWAttr(pgId,'pgOpenSrc');\n"
   "    if(this == masterPage && (!this.addr.length || pgGrp == 'main' || pgGrp == this.attrs['pgGrp'])) {\n"
   "	if(this.addr.length) {\n"
   "	    servSet(this.addr,'com=pgClose','');\n"
   "	    this.pwClean();\n"
   "	    document.body.removeChild(this.window);\n"
   "	}\n"
   "	this.addr  = pgId;\n"
   "	this.place = document.createElement('div');\n"
   "	this.place.setAttribute('id', 'mainCntr');\n"
   "\n"
   "	//Get and activate for specific attributes to the master-page\n"
   "	servSet(\"/UI/VCAEngine\"+this.addr, 'com=com', \"<CntrReqs>\"+\n"
   "	    \"<activate path='/%2fserv%2fattr%2fkeepAspectRatio' aNm='Keep aspect ratio on scale' aTp='0'/>\"+\n"
   "	    \"<activate path='/%2fserv%2fattr%2fstBarNoShow' aNm='Not show status bar' aTp='0'/>\"+\n"
   "	    \"</CntrReqs>\", true);\n"
   "\n"
   "	this.makeEl(servGet(pgId,'com=attrsBr'), false, true);\n"
   "	var centerTag = document.createElement('center');\n"
   "	centerTag.appendChild(this.place);\n"
   "	document.body.appendChild(centerTag);\n"
   "	this.window = centerTag;\n"
   "	//Set project's icon and RunTime page title\n"
   "	document.getElementsByTagName('link')[0].setAttribute('href',location.pathname+'?com=ico');\n"
   "	return true;\n"
   "    }\n"
   "\n"
   "    //Find for include page creation\n"
   "    for(var i in this.wdgs)\n"
   "	if(this.wdgs[i].attrs['root'] == 'Box' && this.wdgs[i].isVisible) {\n"
   "	    if(pgGrp == this.wdgs[i].attrs['pgGrp'] && pgId != this.wdgs[i].attrs['pgOpenSrc']) {\n"
   "		this.wdgs[i].attrs['pgOpenSrc'] = pgId;\n"
   "		this.wdgs[i].makeEl(null, true);\n"
   "		setWAttrs(this.wdgs[i].addr,'pgOpenSrc',pgId);\n"
   "		return true;\n"
   "	    }\n"
   "	    if(this.wdgs[i].inclOpen && this.wdgs[i].pages[this.wdgs[i].inclOpen].callPage(pgId,updWdg,pgGrp,pgOpenSrc)) return true;\n"
   "	}\n"
   "    //Put checking to child pages\n"
   "    for(var i in this.pages)\n"
   "	if(this.pages[i].callPage(pgId,updWdg,pgGrp,pgOpenSrc)) return true;\n"
   "    //Check for open child page or for unknown and empty source pages open as master page child windows\n"
   "    if((!pgGrp.length && pgOpenSrc == this.addr) || this == masterPage) {\n"
   "	var iPg = new pwDescr(pgId, true, this);\n"
   "	var attrBrVal = servGet(pgId,'com=attrsBr');\n"
   "\n"
   "	var winName = null;\n"
   "	var winWidth = 600;\n"
   "	var winHeight = 400;\n"
   "	for(var i_ch = 0; i_ch < attrBrVal.childNodes.length; i_ch++)\n"
   "	    if(attrBrVal.childNodes[i_ch].nodeName != 'el') continue;\n"
   "	    else if(attrBrVal.childNodes[i_ch].getAttribute('id') == 'name') winName = attrBrVal.childNodes[i_ch].textContent;\n"
   "	    else if(attrBrVal.childNodes[i_ch].getAttribute('id') == 'geomW') winWidth = parseInt(attrBrVal.childNodes[i_ch].textContent);\n"
   "	    else if(attrBrVal.childNodes[i_ch].getAttribute('id') == 'geomH') winHeight = parseInt(attrBrVal.childNodes[i_ch].textContent);\n"
   "\n"
   "	//New external <div> window create\n"
   "	if(winWidth < parseInt(masterPage.attrs['geomW']) && winHeight < parseInt(masterPage.attrs['geomH'])) {\n"
   "	    iPg.window = document.createElement('table');\n"
   "	    iPg.window.iPg = iPg;\n"
   "	    iPg.window.id = \"gen-pnl-dlg\";\n"
   "	    iPg.window.setAttribute('cellspacing', '0');\n"
   "	    iPg.window.setAttribute('style','left: '+((parseInt(masterPage.attrs['geomW'])-winWidth-5)/2)+'px; '+\n"
   "					    'top: '+((parseInt(masterPage.attrs['geomH'])-winHeight-18)/2)+'px; ');\n"
   "	    iPg.window.innerHTML = \"<tr class='hd' onmousedown='this.clX = event.clientX; this.clY = event.clientY; return false;' \"+\n"
   "		\"onmouseup='this.clX = this.clY = null; return false;' onmouseout='this.onmouseup()' \"+\n"
   "		\"onmousemove='if(this.clX != null) { \"+\n"
   "		\" this.offsetParent.style.left = (parseInt(this.offsetParent.style.left)+event.clientX-this.clX)+\\\"px\\\"; \"+\n"
   "		\" this.offsetParent.style.top  = (parseInt(this.offsetParent.style.top)+event.clientY-this.clY)+\\\"px\\\"; \"+\n"
   "		\" this.clX = event.clientX; this.clY = event.clientY; }'>\"+\n"
   "		\" <td title='\"+winName+\"' style='padding-left: 5px; overflow: hidden; white-space: nowrap;'>\"+winName+\"</td>\"+\n"
   "		\" <td style='color: red; cursor: pointer; text-align: right; width: 1px;' \"+\n"
   "		\"  onclick='servSet(this.offsetParent.iPg.addr,\\\"com=pgClose\\\",\\\"\\\"); \"+\n"
   "		\"   this.offsetParent.iPg.pwClean(); \"+\n"
   "		\"   delete this.offsetParent.iPg.parent.pages[this.offsetParent.iPg.addr]; \"+\n"
   "		\"   document.getElementById(\\\"mainCntr\\\").removeChild(this.offsetParent.iPg.window);'>X</td></tr>\\n\"+\n"
   "		\"<tr><td colspan='2'><div/></td></tr>\";\n"
   "	    document.getElementById('mainCntr').appendChild(iPg.window);\n"
   "	    iPg.place = iPg.window.rows[1].cells[0].children[0];\n"
   "	}\n"
   "	//New external window create\n"
   "	else {\n"
   "	    iPg.window = window.open('about:blank',pgId,'width='+(winWidth+20)+',height='+(winHeight+60)+\n"
   "		',directories=no,menubar=no,toolbar=no,scrollbars=yes,dependent=yes,location=no,locationbar=no,status=no,statusbar=no,alwaysRaised=yes');\n"
   "	    if(!iPg.window) return true;\n"
   "	    iPg.window.document.open();\n"
   "	    iPg.window.document.write(\"<html><body style='background-color: #E6E6E6;'><center><div id='main'/></center></body></html>\\n\");\n"
   "	    iPg.window.document.close();\n"
   "	    iPg.window.document.title = winName;\n"
   "	    var mainDiv = iPg.window.document.getElementById('main');\n"
   "	    iPg.place = mainDiv;\n"
   "	    iPg.windowExt = true;\n"
   "	}\n"
   "\n"
   "	this.pages[iPg.addr] = iPg;\n"
   "	iPg.makeEl(attrBrVal, false, true);\n"
   "\n"
   "	return true;\n"
   "    }\n"
   "\n"
   "  return false;\n"
   "}\n"
   "\n"
   "function findOpenPage( pgId )\n"
   "{\n"
   "    var opPg;\n"
   "    if(pgId == this.addr) return this;\n"
   "    //Check from included widgets\n"
   "    for(var i in this.wdgs)\n"
   "	if(this.wdgs[i].attrs['root'] == 'Box' && this.wdgs[i].isVisible) {\n"
   "	    if(pgId == this.wdgs[i].attrs['pgOpenSrc']) return this.wdgs[i].pages[pgId];\n"
   "	    if(this.wdgs[i].inclOpen) {\n"
   "		opPg = this.wdgs[i].pages[this.wdgs[i].inclOpen].findOpenPage(pgId);\n"
   "		if(opPg) return opPg;\n"
   "	    }\n"
   "	}\n"
   "    //Put checking to child pages\n"
   "    for(var i in this.pages) {\n"
   "	opPg = this.pages[i].findOpenPage(pgId);\n"
   "	if(opPg) return opPg;\n"
   "    }\n"
   "\n"
   "    return null;\n"
   "}\n"
   "\n"
   "function makeEl( pgBr, inclPg, full, FullTree )\n"
   "{\n"
   "    //Callback processing\n"
   "    if(pgBr) {\n"
   "	if(pgBr == -1) return;\n"
   "	if(pgBr.callBackPrm) {\n"
   "	    elO = pgBr.callBackPrm; pgBr.callBackPrm = null;\n"
   "	    elO.makeEl(pgBr, inclPg, full, FullTree);\n"
   "	    return;\n"
   "	}\n"
   "    }\n"
   "\n"
   "    //Main processing\n"
   "    var margBrdUpd = false; var newAttr = false;\n"
   "    this.place.wdgLnk = this;\n"
   "    if(!inclPg && pgBr) {\n"
   "	//Clear modify flag for all\n"
   "	for(var j in this.attrsMdf) this.attrsMdf[j] = false;\n"
   "	//Updated attributes\n"
   "	for(var j = 0; j < pgBr.childNodes.length; j++) {\n"
   "	    if(pgBr.childNodes[j].nodeName != 'el') continue;\n"
   "	    var i = pgBr.childNodes[j].getAttribute('id');\n"
   "	    if((i == 'bordWidth' || i == 'geomMargin') && (!this.attrs[i] || this.attrs[i] != pgBr.childNodes[j].textContent)) margBrdUpd = true;\n"
   "	    var curAttr = pgBr.childNodes[j].textContent;\n"
   "	    this.attrsMdf[i] = !this.attrs[i] || this.attrs[i] != curAttr;\n"
   "	    this.attrs[i] = curAttr;\n"
   "	    newAttr = true;\n"
   "	}\n"
   "    }\n"
   "\n"
   "    if(newAttr || inclPg || !pgBr) {\n"
   "	var elWr = (parseInt(this.attrs['active']) && parseInt(this.attrs['perm'])&SEC_WR);\n"
   "	var elMargin = parseInt(this.attrs['geomMargin']);\n"
   "	var elBorder = 0;\n"
   "	if(this.attrs['bordWidth']) elBorder = parseInt(this.attrs['bordWidth']);\n"
   "	var elStyle = '';\n"
   "	this.isVisible = true;\n"
   "	if(!(parseInt(this.attrs['en']) && (this.pg || parseInt(this.attrs['perm'])&SEC_RD)))\n"
   "	{ elStyle += 'visibility : hidden; '; this.isVisible = false; }\n"
   "	var geomX = parseFloat(this.attrs['geomX']);\n"
   "	var geomY = parseFloat(this.attrs['geomY']);\n"
   "	if(this.pg) { geomX = geomY = 0; elStyle += 'overflow: hidden; '; }\n"
   "	else { geomX *= this.parent.xScale(true); geomY *= this.parent.yScale(true); }\n"
   "	if(this.parent && !(this.pg && this.parent.pg)) {\n"
   "	    geomX -= parseInt(this.parent.attrs['geomMargin'])+parseInt(this.parent.attrs['bordWidth']);\n"
   "	    geomY -= parseInt(this.parent.attrs['geomMargin'])+parseInt(this.parent.attrs['bordWidth']);\n"
   "	}\n"
   "	elStyle += 'position: '+((this==masterPage || this.window)?'relative':'absolute')+'; left: '+realRound(geomX)+'px; top: '+realRound(geomY)+'px; ';\n"
   "\n"
   "	// Calculation of the main window/page scale\n"
   "	if(this == masterPage) {\n"
   "	    //  Own status bar reserve\n"
   "	    if(!parseInt(this.attrs[\"stBarNoShow\"]) && !masterPage.status) {\n"
   "		masterPage.status = document.createElement('div');\n"
   "		masterPage.status.height = 25;\n"
   "		masterPage.status.setAttribute('id', 'gen-pnl-status');\n"
   "		this.place.appendChild(masterPage.status);\n"
   "		masterPage.status.innerHTML = \"<table width='100%'><TR><td id='StatusBar' width='100%'/><td id='st_user'><a href='/login/\"+MOD_ID+\"/'>\"+pgBr.getAttribute('user')+\"</a></td></TR></table>\";\n"
   "	    }\n"
   "\n"
   "	    var geomW = parseFloat(this.attrs['geomW']);\n"
   "	    var geomH = parseFloat(this.attrs['geomH']);\n"
   "	    wx_scale = Math.max(1, window.innerWidth/geomW);\n"
   "	    wy_scale = Math.max(1, window.innerHeight/(geomH+(masterPage.status?masterPage.status.height:0)));\n"
   "	    if(parseInt(this.attrs['keepAspectRatio']))\n"
   "		wx_scale = wy_scale = Math.min(wx_scale, wy_scale);\n"
   "\n"
   "	    if(masterPage.status) {\n"
   "		masterPage.status.style.top = Math.floor(geomH*wy_scale)+\"px\";\n"
   "		masterPage.status.style.width = (Math.floor(geomW*wx_scale)-5)+\"px\";\n"
   "		masterPage.status.style.height = Math.floor((masterPage.status.height-1)*wy_scale)+\"px\";\n"
   "		masterPage.status.style.fontSize = Math.floor(masterPage.status.height*0.6*wy_scale)+\"px\";\n"
   "		elStyle += \"overflow: visible; \";\n"
   "	    }\n"
   "	}\n"
   "\n"
   "	var xSc = this.xScale(true);\n"
   "	var ySc = this.yScale(true);\n"
   "	var geomW = parseFloat(this.attrs['geomW'])*xSc;\n"
   "	var geomH = parseFloat(this.attrs['geomH'])*ySc;\n"
   "\n"
   "	this.mousedown = new Array;\n"
   "	this.mouseup = new Array;\n"
   "\n"
   "	if(this.pg && this.parent && this.parent.inclOpen && this.parent.inclOpen == this.addr) {\n"
   "	    var geomWpar = parseFloat(this.parent.attrs['geomW'])*this.parent.xScale(true);\n"
   "	    var geomHpar = parseFloat(this.parent.attrs['geomH'])*this.parent.yScale(true);\n"
   "	    this.parent.place.style.overflow = (geomW > geomWpar || geomH > geomHpar) ? 'scroll' : 'hidden';\n"
   "	    geomW = Math.max(geomW, geomWpar);\n"
   "	    geomH = Math.max(geomH, geomHpar);\n"
   "	}\n"
   "	//else elStyle += 'overflow: hidden; ';\n"
   "\n"
   "	geomW = realRound(geomX+geomW-xSc) - realRound(geomX) + 1;\n"
   "	geomH = realRound(geomY+geomH-ySc) - realRound(geomY) + 1;\n"
   "\n"
   "	geomW -= 2*(elMargin+elBorder);\n"
   "	geomH -= 2*(elMargin+elBorder);\n"
   "\n"
   "	//Set included window geometry to widget size\n"
   "	//if( this == masterPage ) resizeTo(geomW,geomH);\n"
   "	if(this.pg && this.window && this.windowExt) {\n"
   "	    if(this.window.innerHeight)\n"
   "		this.window.resizeTo(geomW+(this.window.outerWidth-this.window.innerWidth)+20,\n"
   "				     geomH+(this.window.outerHeight-this.window.innerHeight)+20);\n"
   "	    else this.window.resizeTo(geomW+20,geomH+40);\n"
   "	}\n"
   "\n"
   "	if(this.attrs['focus'] && parseInt(this.attrs['focus'])) setFocus(this.addr,true);\n"
   "\n"
   "	var isPrim = true;\n"
   "	if(!(parseInt(this.attrs['perm'])&SEC_RD)) {\n"
   "	    if(this.pg) {\n"
   "		elStyle += 'background-color: #B0B0B0; border: 1px solid black; color: red; overflow: auto; ';\n"
   "		this.place.innerHTML = \"<div class='vertalign' style='width: \"+(geomW-2)+\"px; height: \"+(geomH-2)+\"px;'>Page: '\"+this.addr+\"'.<br/>View access is no permitted.</div>\";\n"
   "	    }\n"
   "	    isPrim = false;\n"
   "	}\n"
   "	else if(this.attrs['root'] == 'ElFigure') {\n"
   "	    var toInit = !this.place.childNodes.length;\n"
   "	    var figObj = toInit ? this.place.ownerDocument.createElement('img') : this.place.childNodes[0];\n"
   "	    figObj.width = geomW; figObj.height = geomH;\n"
   "	    // Src update always therefore for any changes is shape update\n"
   "	    figObj.src = '/'+MOD_ID+this.addr+'?com=obj&tm='+tmCnt+'&geomX='+geomX.toFixed(3)+'&geomY='+geomY.toFixed(3)+\n"
   "						    '&geomW='+geomW.toFixed(3)+'&geomH='+geomH.toFixed(3)+\n"
   "						    '&xSc='+xSc.toFixed(3)+'&ySc='+ySc.toFixed(3);\n"
   "	    if(elWr != this.place.elWr) {\n"
   "		figObj.onclick = !elWr ? '' : function(e) {\n"
   "		    if(!e) e = window.event;\n"
   "		    servSet(this.wdgLnk.addr,'com=obj&sub=point&geomX='+geomX.toFixed(3)+'&geomY='+geomY.toFixed(3)+\n"
   "						    '&xSc='+xSc.toFixed(3)+'&ySc='+ySc.toFixed(3)+\n"
   "						    '&x='+(e.offsetX?e.offsetX:(e.clientX-posGetX(this)))+\n"
   "						    '&y='+(e.offsetY?e.offsetY:(e.clientY-posGetY(this)))+\n"
   "						    '&key='+evMouseGet(e),'');\n"
   "		    return false;\n"
   "		}\n"
   "		figObj.ondblclick = !elWr ? '' : function(e) {\n"
   "		    if(!e) e = window.event;\n"
   "		    servSet(this.wdgLnk.addr,'com=obj&sub=point&geomX='+geomX.toFixed(3)+'&geomY='+geomY.toFixed(3)+\n"
   "						    '&xSc='+xSc.toFixed(3)+'&ySc='+ySc.toFixed(3)+\n"
   "						    '&x='+(e.offsetX?e.offsetX:(e.clientX-posGetX(this)))+\n"
   "						    '&y='+(e.offsetY?e.offsetY:(e.clientY-posGetY(this)))+\n"
   "						    '&key=DblClick','');\n"
   "		}\n"
   "	    }\n"
   "\n"
   "	    if(toInit) {\n"
   "		figObj.border = 0;\n"
   "		figObj.wdgLnk = this;\n"
   "		this.place.appendChild(figObj);\n"
   "		//Disable drag mostly for FireFox\n"
   "		figObj.onmousedown = function(e) { e = e?e:window.event; if(e.preventDefault) e.preventDefault(); }\n"
   "	    }\n"
   "	}\n"
   "	else if(this.attrs['root'] == 'Box') {\n"
   "	    if(this == masterPage && this.attrs['tipStatus'].length) { setStatus(this.attrs['tipStatus'],10000); this.attrs['tipStatus'] = \"\"; }\n"
   "	    elStyle += 'border-style: solid; border-width: '+this.attrs['bordWidth']+'px; ';\n"
   "	    if(!this.pg && ((this.inclOpen && this.attrs['pgOpenSrc'] != this.inclOpen) ||\n"
   "		    (!this.inclOpen && this.attrs['pgOpenSrc'].length)))\n"
   "	    {\n"
   "		if(this.inclOpen) {\n"
   "		    servSet(this.inclOpen,'com=pgClose','');\n"
   "		    pgCache[this.inclOpen] = this.pages[this.inclOpen];\n"
   "		    pgCache[this.inclOpen].reqTm = tmCnt;\n"
   "		    this.place.removeChild(this.pages[this.inclOpen].place);\n"
   "		    this.pages[this.inclOpen].perUpdtEn(false);\n"
   "		    delete this.pages[this.inclOpen];\n"
   "		    this.inclOpen = null;\n"
   "		}\n"
   "		if(this.attrs['pgOpenSrc'].length) {\n"
   "		    this.inclOpen = this.attrs['pgOpenSrc'];\n"
   "		    if(pgCache[this.inclOpen]) {\n"
   "			this.pages[this.inclOpen] = pgCache[this.inclOpen];\n"
   "			this.place.appendChild(this.pages[this.inclOpen].place);\n"
   "			pgBr = servGet(this.inclOpen,'com=attrsBr&tm='+pgCache[this.inclOpen].reqTm);\n"
   "			this.pages[this.inclOpen].perUpdtEn(true);\n"
   "			this.pages[this.inclOpen].makeEl(pgBr);\n"
   "			delete pgCache[this.inclOpen];\n"
   "		    }\n"
   "		    else {\n"
   "			var iPg = new pwDescr(this.inclOpen,true,this);\n"
   "			iPg.place = this.place.ownerDocument.createElement('div');\n"
   "			iPg.makeEl(servGet(this.inclOpen,'com=attrsBr'),false,true);\n"
   "			this.pages[this.inclOpen] = iPg;\n"
   "			this.place.appendChild(iPg.place);\n"
   "		    }\n"
   "		}\n"
   "	    }\n"
   "	    this.place.wdgLnk = this;\n"
   "	    this.place.onclick = (!elWr) ? null : function() { setFocus(this.wdgLnk.addr); return true; };	//Changed to return true for <input type=\"file\">\n"
   "	}\n"
   "	else if(this.attrs['root'] == 'Text') {\n"
   "	    elStyle += 'border-style: solid; border-width: '+this.attrs['bordWidth']+'px; overflow: hidden; ';\n"
   "	    if(elMargin) { elStyle += 'padding: '+elMargin+'px; '; elMargin = 0; }\n"
   "	    //if(parseInt(this.attrs['orient']) == 0) {\n"
   "		var txtAlign = parseInt(this.attrs['alignment']);\n"
   "		var spanStyle = \"display: table-cell; width: \"+geomW+\"px; height: \"+geomH+\"px; line-height: 1; white-space: \"+(parseInt(this.attrs[\"wordWrap\"])?\"pre-wrap\":\"pre\")+\"; \";\n"
   "		switch(txtAlign&0x3) {\n"
   "		    case 0: spanStyle += 'text-align: left; ';		break;\n"
   "		    case 1: spanStyle += 'text-align: right; ';		break;\n"
   "		    case 2: spanStyle += 'text-align: center; ';	break;\n"
   "		    case 3: spanStyle += 'text-align: justify; ';	break;\n"
   "		}\n"
   "		switch(txtAlign>>2) {\n"
   "		    case 0: spanStyle += 'vertical-align: top; ';	break;\n"
   "		    case 1: spanStyle += 'vertical-align: bottom; ';	break;\n"
   "		    case 2: spanStyle += 'vertical-align: middle; ';	break;\n"
   "		}\n"
   "		if(parseInt(this.attrs['orient']) != 0) spanStyle += \"transform: rotate(\"+parseInt(this.attrs['orient'])+\"deg); \";\n"
   "		spanStyle += getFont(this.attrs['font'], Math.min(xSc, ySc));\n"
   "		spanStyle += 'color: ' + (this.attrs['color']?getColor(this.attrs['color']):'black') + '; ';\n"
   "		var txtVal = this.attrs['text'];\n"
   "		for(var i = 0; i < parseInt(this.attrs['numbArg']); i++) {\n"
   "		    var argVal;\n"
   "		    var argCfg = new Array();\n"
   "		    switch(parseInt(this.attrs['arg'+i+'tp'])) {\n"
   "			case 0: case 2:\n"
   "			    argCfg[0] = this.attrs['arg'+i+'cfg'];\n"
   "			    argVal = this.attrs['arg'+i+'val'];\n"
   "			    break;\n"
   "			case 1:\n"
   "			    argCfg = this.attrs['arg'+i+'cfg'].split(';');\n"
   "			    if(argCfg[1] == 'g')	argVal = parseFloat(this.attrs['arg'+i+'val']).toPrecision(Math.max(0,argCfg[2]));\n"
   "			    else if(argCfg[1] == 'e')	argVal = parseFloat(this.attrs['arg'+i+'val']).toExponential(Math.max(0,argCfg[2]));\n"
   "			    else if(argCfg[1] == 'f')	argVal = parseFloat(this.attrs['arg'+i+'val']).toFixed(Math.max(0,argCfg[2]));\n"
   "			    else argVal = this.attrs['arg'+i+'val'];\n"
   "			    if(isNaN(argVal)) argVal = 0;\n"
   "			    break;\n"
   "		    }\n"
   "		    var argSize = Math.max(-1000,Math.min(1000,parseInt(argCfg[0])));\n"
   "		    var argPad = '';\n"
   "		    for(var j = argVal.length; j < Math.abs(argSize); j++) argPad += ' ';//&nbsp;';\n"
   "		    if(argSize > 0) argVal = argPad+argVal; else argVal += argPad;\n"
   "		    txtVal = txtVal.replace('%'+(i+1),argVal);\n"
   "		}\n"
   "		var spEl = this.place.children.length ? this.place.children[0] : this.place.ownerDocument.createElement('span');\n"
   "		this.place.appendChild(spEl);\n"
   "		if(parseInt(this.attrs['inHtml'])) spEl.innerHTML = txtVal;\n"
   "		else spEl.innerText = txtVal;\n"
   "		spEl.setAttribute('style', spanStyle);\n"
   "		//this.place.innerHTML = \"<span style='\"+spanStyle+\"'>\"+txtVal+\"</span>\";\n"
   "	    //}\n"
   "	    //else this.place.innerHTML = \"<img width='\"+geomW+\"px' height='\"+geomH+\"px' border='0' src='/\"+MOD_ID+this.addr+\n"
   "	    //				\"?com=obj&tm=\"+tmCnt+\"&xSc=\"+xSc.toFixed(3)+\"&ySc=\"+ySc.toFixed(3)+\"'/>\";\n"
   "\n"
   "	    this.place.wdgLnk = this;\n"
   "	    if(elWr) this.place.onclick = function() { setFocus(this.wdgLnk.addr); return false; };\n"
   "	    else this.place.onclick = '';\n"
   "	}\n"
   "	else if(this.attrs['root'] == 'Media') {\n"
   "	    this.place.className = \"Media\";\n"
   "	    elStyle += 'border-width: '+this.attrs['bordWidth']+'px; ';\n"
   "	    if(this.place.elWr != elWr || (parseInt(this.attrs['areas']) && this.place.children.length <= 1) ||\n"
   "					  (!parseInt(this.attrs['areas']) && this.place.children.length > 1) ||\n"
   "					  ((this.attrsMdf[\"src\"] || this.attrsMdf[\"fit\"]) && this.attrs['fit'] != 1))\n"
   "		while(this.place.children.length) this.place.removeChild(this.place.children[0]);\n"
   "\n"
   "	    var toInit = !this.place.children.length;\n"
   "	    var medObj = toInit ? this.place.ownerDocument.createElement('img') : this.place.children[0];\n"
   "	    if(toInit || this.attrsMdf[\"src\"] || this.attrsMdf[\"fit\"] || !pgBr) {\n"
   "		medObj.src = this.attrs['src'].length ? \"/\"+MOD_ID+this.addr+\"?com=res&val=\"+this.attrs['src'] : \"\";\n"
   "		medObj.hidden = !this.attrs['src'].length;\n"
   "	    }\n"
   "	    if(toInit || this.attrsMdf[\"fit\"] || !pgBr) {\n"
   "		if(this.attrs['fit'] == 1) {\n"
   "		    medObj.width = geomW; medObj.height = geomH;\n"
   "		    if(this.attrs['src'].length) medObj.src += \"&size=\"+geomH;\n"
   "		    medObj.onload = null;\n"
   "		}\n"
   "		else medObj.onload = function() {\n"
   "		    cWdth = this.width;\n"
   "		    cHeight = this.height;\n"
   "		    this.width = cWdth * this.wdgLnk.xScale(true);\n"
   "		    this.height = cHeight * this.wdgLnk.yScale(true);\n"
   "		    //this.style.cssText = \"top: \"+((this.parentNode.height-this.height)/2)+\"px; \"+\n"
   "		    //				\"left: \"+((this.parentNode.width-this.width)/2)+\"px; \";\n"
   "		}\n"
   "	    }\n"
   "	    if(elWr && (toInit || this.attrsMdf[\"areas\"])) {\n"
   "		var mapObj = toInit ? this.place.ownerDocument.createElement('map') : this.place.children[1];\n"
   "		while(mapObj.children.length) mapObj.removeChild(mapObj.children[0]);\n"
   "		for(var i = 0; i < parseInt(this.attrs['areas']); i++) {\n"
   "		    var arObj = this.place.ownerDocument.createElement('area');\n"
   "		    switch(parseInt(this.attrs['area'+i+'shp'])) {\n"
   "			case 0: arObj.shape = 'rect';	break;\n"
   "			case 1: arObj.shape = 'poly';	break;\n"
   "			case 2: arObj.shape = 'circle';	break;\n"
   "		    }\n"
   "		    arObj.coords = this.attrs['area'+i+'coord'];\n"
   "		    arObj.title = this.attrs['area'+i+'title'];\n"
   "		    arObj.href = '';\n"
   "		    arObj.areaId = i;\n"
   "		    arObj.onclick = function( )	{ setWAttrs(this.wdgLnk.addr,'event','ws_MapAct'+this.areaId+'Left'); return false; }\n"
   "		    arObj.wdgLnk = this;\n"
   "		    mapObj.appendChild(arObj);\n"
   "		}\n"
   "	    }\n"
   "	    if(toInit) {\n"
   "		medObj.wdgLnk = this;\n"
   "		//Disable drag mostly for FireFox\n"
   "		medObj.onmousedown = function(e) { e = e?e:window.event; if(e.preventDefault) e.preventDefault(); }\n"
   "		medObj.border = 0;\n"
   "		this.place.appendChild(medObj);\n"
   "		if(elWr) {\n"
   "		    this.place.appendChild(mapObj);\n"
   "		    mapObj.name = this.addr;\n"
   "		    medObj.setAttribute('usemap','#'+this.addr);\n"
   "		}\n"
   "	    }\n"
   "	}\n"
   "	else if(this.attrs['root'] == 'FormEl' && !this.place.isModify) {\n"
   "	    this.place.className = \"FormEl\";	//Move to the proper style after HTML code moving to different file.\n"
   "	    var elTp = parseInt(this.attrs['elType']);\n"
   "	    if(this.attrsMdf['elType'] || this.place.elWr != elWr)\n"
   "		while(this.place.childNodes.length) this.place.removeChild(this.place.childNodes[0]);\n"
   "\n"
   "	    if(this.attrsMdf['font'])	this.place.fontCfg = getFontCond(this.attrs['font'], Math.min(xSc,ySc));\n"
   "	    var fntSz = Math.min(geomH,(getFont(this.attrs['font'],Math.min(xSc,ySc),2)*1.4).toFixed(0));\n"
   "	    switch(elTp) {\n"
   "		case 0:	//Line edit\n"
   "		    var toInit = !this.place.childNodes.length;\n"
   "		    var formObj = toInit ? this.place.ownerDocument.createElement('input') : this.place.childNodes[0];\n"
   "		    if(toInit || this.attrsMdf['geomZ']) formObj.tabIndex = parseInt(this.attrs['geomZ'])+1;\n"
   "		    if(toInit || this.attrsMdf['geomH'] || this.attrsMdf['geomW'] || this.attrsMdf['font']) {\n"
   "			var geomWint = geomW-4;\n"
   "			formObj.className = \"LineEd\";\n"
   "			formObj.style.cssText = 'top: '+((geomH-fntSz)/2)+'px; width: '+geomWint+'px; '+\n"
   "						'height: '+(fntSz-2)+'px; font: '+this.place.fontCfg+';';\n"
   "		    }\n"
   "		    if(formObj.valSet && this.attrsMdf['value']) formObj.valSet(this.attrs['value']);\n"
   "		    this.place.view = parseInt(this.attrs['view']);\n"
   "		    this.place.cfg = this.attrs['cfg'];\n"
   "		    if(!toInit) break;\n"
   "		    formObj.wdgLnk = this;\n"
   "		    formObj.disabled = !elWr;\n"
   "		    this.place.appendChild(formObj);\n"
   "		    if(elWr) {\n"
   "			switch(this.place.view) {\n"
   "			    case 1:		//Combo\n"
   "				var combImg = this.place.ownerDocument.createElement('img');\n"
   "				combImg.className = \"cntr\"; combImg.src = '/'+MOD_ID+'/img_combar';\n"
   "				combImg.style.cssText = 'left: '+(geomW-16)+'px; top: '+((geomH-fntSz)/2)+'px; height: '+fntSz+'px; ';\n"
   "				this.place.appendChild(combImg);\n"
   "				formObj.style.width = (geomWint-16)+'px';\n"
   "				combImg.onclick = function( ) {\n"
   "				    var formObj = this.parentNode.children[0];\n"
   "				    var combList = this.ownerDocument.getElementById('combomenu');\n"
   "				    if(!combList) {\n"
   "					combList = this.ownerDocument.createElement('div');\n"
   "					combList.id = 'combomenu';\n"
   "					combList.appendChild(this.ownerDocument.createElement('select'));\n"
   "					combList.childNodes[0].size = '100';\n"
   "					combList.childNodes[0].onclick = function( ) {\n"
   "					    //this.formObj.value = this.options[this.selectedIndex].value;\n"
   "					    //this.formObj.setModify(true);\n"
   "					    this.formObj.valSet(this.options[this.selectedIndex].value);\n"
   "					    this.formObj.chApply();\n"
   "					    this.parentNode.style.visibility = 'hidden';\n"
   "					    this.parentNode.style.top = \"-100px\";\n"
   "					}\n"
   "					combList.childNodes[0].onblur = function( ) {\n"
   "					    this.parentNode.style.visibility = 'hidden';\n"
   "					    this.parentNode.style.top = \"-100px\";\n"
   "					}\n"
   "					combList.onmouseleave = function( ) { this.style.visibility = 'hidden'; this.style.top = \"-100px\"; }\n"
   "					this.ownerDocument.body.appendChild(combList);\n"
   "				    }\n"
   "				    while(combList.childNodes[0].childNodes.length)\n"
   "					combList.childNodes[0].removeChild(combList.childNodes[0].childNodes[0]);\n"
   "				    var elLst = formObj.parentNode.cfg.split('\\n');\n"
   "				    for(var i = 0; i < elLst.length; i++) {\n"
   "					var optEl = this.ownerDocument.createElement('option');\n"
   "					optEl.appendChild(this.ownerDocument.createTextNode(elLst[i]));\n"
   "					if(formObj.valGet() == elLst[i]) optEl.defaultSelected = optEl.selected = true;\n"
   "					combList.childNodes[0].appendChild(optEl);\n"
   "				    }\n"
   "				    if(combList.childNodes[0].childNodes.length) {\n"
   "					combList.style.cssText = 'left: '+posGetX(formObj,true)+'px; top: '+(posGetY(formObj,true)+formObj.offsetHeight)+'px; '+\n"
   "								 'width: '+formObj.offsetWidth+'px; height: '+Math.min(elLst.length*15,70)+'px; ';\n"
   "					combList.childNodes[0].style.cssText = 'width: '+formObj.offsetWidth+'px; height: '+Math.min(elLst.length*15,70)+'px; '+\n"
   "									       'font: '+formObj.parentNode.fontCfg+'; ';\n"
   "					combList.childNodes[0].formObj = formObj;\n"
   "					combList.childNodes[0].focus();\n"
   "				    }\n"
   "				    return false;\n"
   "				}\n"
   "				break;\n"
   "			    case 2: case 3:	//Integer, Real\n"
   "				if(this.place.childNodes.length >= 2) break;\n"
   "				var spinImg = this.place.ownerDocument.createElement('img');\n"
   "				spinImg.className = \"cntr\"; spinImg.src = '/'+MOD_ID+'/img_spinar';\n"
   "				spinImg.style.cssText = 'left: '+(geomW-16)+'px; top: '+((geomH-fntSz)/2)+'px; height: '+fntSz+'px; ';\n"
   "				spinImg.border = '0';\n"
   "				formObj.style.width = (geomWint-16)+'px';\n"
   "				spinImg.onclick = function(e) {\n"
   "				    if(!e) e = window.event;\n"
   "				    var formObj = this.parentNode.childNodes[0];\n"
   "				    var argCfg = this.parentNode.cfg.split(':');\n"
   "				    if((e.clientY-posGetY(this)) < fntSz/2)\n"
   "					formObj.valSet(formObj.valGet()+((argCfg.length>2)?((this.parentNode.view==2)?parseInt(argCfg[2]):parseFloat(argCfg[2])):1));\n"
   "				    else formObj.valSet(formObj.valGet()-((argCfg.length>2)?((this.parentNode.view==2)?parseInt(argCfg[2]):parseFloat(argCfg[2])):1));\n"
   "				    formObj.setModify(true);\n"
   "				    return false;\n"
   "				}\n"
   "				this.place.appendChild(spinImg);\n"
   "				break;\n"
   "			    case 4:	break;	//Time\n"
   "			    case 5:	//Date\n"
   "			    case 6:	//Date and time\n"
   "				formObj.onclick = function( ) {\n"
   "				    if((cldrDlg=this.ownerDocument.getElementById('clndrdlg'))) cldrDlg.style.visibility = 'hidden';\n"
   "				}\n"
   "				var cldrImg = this.place.ownerDocument.createElement('img');\n"
   "				cldrImg.className = \"cntr\"; cldrImg.src = '/'+MOD_ID+'/img_combar';\n"
   "				cldrImg.style.cssText = 'left: '+(geomW-16)+'px; top: '+((geomH-fntSz)/2)+'px; height: '+fntSz+'px; ';\n"
   "				this.place.appendChild(cldrImg);\n"
   "				formObj.style.width = (geomWint-16)+'px';\n"
   "				cldrImg.onclick = function( ) {\n"
   "				    var formObj = this.parentNode.children[0];\n"
   "				    var cldrDlg = this.ownerDocument.getElementById('clndrdlg');\n"
   "				    if(!cldrDlg) {\n"
   "					cldrDlg = this.ownerDocument.createElement('div');\n"
   "					cldrDlg.id = 'clndrdlg';\n"
   "					cldrDlg.innerHTML = \"<input type='button' value='###Today###'/><select></select><select></select>\"+\n"
   "					    \"<table><tr><th>###Mon###</th><th>###Tue###</th><th>###Wed###</th><th>###Thr###</th><th>###Fri###</th><th class='end'>###Sat###</th><th class='end'>###Sun###</th></tr>\"+\n"
   "					    \"<tr><td/><td/><td/><td/><td/><td/><td/></tr>\"+\n"
   "					    \"<tr><td/><td/><td/><td/><td/><td/><td/></tr>\"+\n"
   "					    \"<tr><td/><td/><td/><td/><td/><td/><td/></tr>\"+\n"
   "					    \"<tr><td/><td/><td/><td/><td/><td/><td/></tr>\"+\n"
   "					    \"<tr><td/><td/><td/><td/><td/><td/><td/></tr>\"+\n"
   "					    \"<tr><td/><td/><td/><td/><td/><td/><td/></tr>\"+\n"
   "					    \"</table>\";\n"
   "					cldrDlg.children[0].onclick = function( ) {\n"
   "					    this.parentElement.formObj.valSet((new Date()).getTime()/1000);\n"
   "					    this.parentElement.formObj.chApply();\n"
   "					    this.parentElement.style.visibility = 'hidden';\n"
   "					    this.parentElement.style.top = \"-100px\";\n"
   "					}\n"
   "					cldrDlg.children[1].onchange = cldrDlg.children[2].onchange = function( ) {\n"
   "					    this.parentElement.tmSet((new Date(parseInt(this.parentElement.children[1].options[this.parentElement.children[1].selectedIndex].value),\n"
   "									this.parentElement.children[2].selectedIndex,1)).getTime()/1000);\n"
   "					}\n"
   "					cldrDlg.daySet = function() {\n"
   "					    dlgN = this.offsetParent.parentElement;\n"
   "					    dtSrc = new Date(dlgN.formObj.valGet()*1000);\n"
   "					    dtSrc.setFullYear(parseInt(dlgN.children[1].options[dlgN.children[1].selectedIndex].value));\n"
   "					    dtSrc.setMonth(dlgN.children[2].selectedIndex);\n"
   "					    dtSrc.setDate(parseInt(this.textContent));\n"
   "					    dlgN.formObj.valSet(dtSrc.getTime()/1000);\n"
   "					    dlgN.formObj.chApply();\n"
   "					    dlgN.style.visibility = 'hidden';\n"
   "					    dlgN.style.top = \"-100px\";\n"
   "					    dlgN.cldrDlg = null;\n"
   "					}\n"
   "					//Fill and activate the table\n"
   "					cldrDlg.tmSet = function(tm) {\n"
   "					    var dtCur = new Date();\n"
   "					    var dtSet = new Date(parseInt(tm)*1000);\n"
   "					    // Years fill\n"
   "					    var optLs = \"\"; hasCur = false;\n"
   "					    for(iY = 0; iY < 10; iY++) {\n"
   "						iY_ = (dtCur.getFullYear()-iY);\n"
   "						if(iY_ != dtSet.getFullYear()) optLs += \"<option>\"+iY_+\"</option>\";\n"
   "						else { optLs += \"<option selected>\"+iY_+\"</option>\"; hasCur = true; }\n"
   "					    }\n"
   "					    if(!hasCur) optLs += \"<option selected>\"+dtSet.getFullYear()+\"</option>\";\n"
   "					    this.children[1].innerHTML = optLs;\n"
   "					    // Months fill\n"
   "					    var optLs = \"\";\n"
   "					    for(iM = 0; iM < 12; iM++) {\n"
   "						var mNm = \"\";\n"
   "						if(iM == 0)		mNm = \"###January###\";\n"
   "						else if(iM == 1)	mNm = \"###February###\";\n"
   "						else if(iM == 2)	mNm = \"###March###\";\n"
   "						else if(iM == 3)	mNm = \"###April###\";\n"
   "						else if(iM == 4)	mNm = \"###May###\";\n"
   "						else if(iM == 5)	mNm = \"###June###\";\n"
   "						else if(iM == 6)	mNm = \"###July###\";\n"
   "						else if(iM == 7)	mNm = \"###August###\";\n"
   "						else if(iM == 8)	mNm = \"###September###\";\n"
   "						else if(iM == 9)	mNm = \"###October###\";\n"
   "						else if(iM == 10)	mNm = \"###November###\";\n"
   "						else if(iM == 11)	mNm = \"###December###\";\n"
   "						optLs += \"<option\"+((iM==dtSet.getMonth())?\" selected\":\"\")+\">\"+mNm+\"</option>\";\n"
   "					    }\n"
   "					    this.children[2].innerHTML = optLs;\n"
   "					    // Days fill\n"
   "					    dtSetMBeg = new Date(dtSet.getFullYear(), dtSet.getMonth(), 1);\n"
   "					    maxDayInMonth = 28;\n"
   "					    while((new Date(dtSet.getFullYear(),dtSet.getMonth(),maxDayInMonth+1)).getMonth() == dtSet.getMonth() && maxDayInMonth < 31)\n"
   "						maxDayInMonth++;\n"
   "					    for(iW = 0, iD = 1; iW < 6; iW++)\n"
   "						for(iWd = 0; iWd < 7; iWd++) {\n"
   "						    tdEl = this.children[3].rows[iW+1].cells[iWd];\n"
   "						    if((iW == 0 && iWd < (dtSetMBeg.getDay()-1)) || iD > maxDayInMonth)\n"
   "						    { tdEl.innerHTML = \"\"; tdEl.className = \"\"; tdEl.onclick = null; continue; }\n"
   "						    tdEl.innerHTML = iD;\n"
   "						    tdEl.className = \"active\";\n"
   "						    tdEl.onclick = this.daySet;\n"
   "						    if(iD == dtSet.getDate()) tdEl.className += \" sel\";\n"
   "						    if(iWd == 5 || iWd == 6) tdEl.className += \" end\";\n"
   "						    iD++;\n"
   "						}\n"
   "					    this.formObj.setModify(true);\n"
   "					}\n"
   "					this.ownerDocument.body.appendChild(cldrDlg);\n"
   "				    }\n"
   "				    //cldrDlg.onmouseleave = formObj.onclick;\n"
   "				    formObj.cldrDlg = cldrDlg;\n"
   "				    cldrDlg.formObj = formObj;\n"
   "				    cldrDlg.tmSet(formObj.valGet());\n"
   "				    cldrDlg.style.cssText = 'left: '+posGetX(formObj,true)+'px; top: '+(posGetY(formObj,true)+formObj.offsetHeight)+'px; '+\n"
   "					'font: '+formObj.parentNode.fontCfg+'; ';\n"
   "				    return false;\n"
   "				}\n"
   "				break;\n"
   "			}\n"
   "			formObj.onkeyup = function(e) {\n"
   "			    if(!e) e = window.event;\n"
   "			    if(this.modify() && e.keyCode == 13) this.chApply();\n"
   "			    if(this.modify() && e.keyCode == 27) this.chEscape();\n"
   "			    if(this.saveVal != this.value) this.setModify(true);\n"
   "			}\n"
   "			formObj.modify = function( )\n"
   "			{ return (this.parentNode.children[this.parentNode.children.length-1].style.visibility == 'visible'); }\n"
   "			formObj.setModify = function(on) {\n"
   "			    if(on && this.clearTm) this.clearTm = clearTm;\n"
   "			    if(this.modify() == on) return;\n"
   "			    var posOkImg = this.parentNode.children.length-1;\n"
   "			    var okImg = this.parentNode.children[posOkImg];\n"
   "			    if(on) {\n"
   "				this.style.width = (parseInt(this.style.width)-16)+'px';\n"
   "				if(posOkImg == 2)\n"
   "				    this.parentNode.children[1].style.left = (parseInt(this.parentNode.children[1].style.left)-16)+'px';\n"
   "				okImg.style.visibility = 'visible';\n"
   "				this.wdgLnk.perUpdtEn(true); this.clearTm = clearTm;\n"
   "			    }\n"
   "			    else {\n"
   "				this.style.width = (parseInt(this.style.width)+16)+'px';\n"
   "				if(posOkImg == 2)\n"
   "				    this.parentNode.children[1].style.left = (parseInt(this.parentNode.children[1].style.left)+16)+'px';\n"
   "				okImg.style.visibility = 'hidden';\n"
   "				this.wdgLnk.perUpdtEn(false); this.clearTm = 0;\n"
   "				if(this.cldrDlg) this.onclick();\n"
   "			    }\n"
   "			    this.parentNode.isModify = on;\n"
   "			}\n"
   "		    }\n"
   "		    formObj.valSet = function(val) {\n"
   "			switch(this.parentNode.view) {\n"
   "			    case 0: case 1: this.value = val; break;\n"
   "			    case 2:	//Integer\n"
   "				var argCfg = this.parentNode.cfg.split(':');\n"
   "				this.value = ((argCfg.length>3)?argCfg[3]:'')+\n"
   "				    Math.max((argCfg.length>1)?parseInt(argCfg[0]):0,Math.min((argCfg.length>1)?parseInt(argCfg[1]):100,parseInt(val)))+((argCfg.length>4)?argCfg[4]:'');\n"
   "				break;\n"
   "			    case 3:	//Real\n"
   "				var argCfg = this.parentNode.cfg.split(':');\n"
   "				this.value = ((argCfg.length>3)?argCfg[3]:'')+Math.max((argCfg.length>1)?parseFloat(argCfg[0]):0,Math.min((argCfg.length>1)?parseFloat(argCfg[1]):100,parseFloat(val))).toFixed((argCfg.length>5)?parseInt(argCfg[5]):2)+((argCfg.length>4)?argCfg[4]:'');\n"
   "				break;\n"
   "			    case 4:	//Time\n"
   "				var rez = (this.parentNode.cfg.length) ? this.parentNode.cfg : 'hh:mm';\n"
   "				var v = (Math.floor(val/3600)%(ap?12:24)).toString(10); rez = rez.replace('hh',i2s(v,10,2)); rez = rez.replace('h',v);\n"
   "				v = (Math.floor(val/60)%60).toString(10); rez = rez.replace('mm',i2s(v,10,2)); rez = rez.replace('m',v);\n"
   "				v = (val%60).toString(10); rez = rez.replace('ss',i2s(v,10,2)); rez = rez.replace('s',v);\n"
   "				if(rez.indexOf('ap') >= 0) { rez = rez.replace('ap',(val>=43200)?'pm':'am'); var ap = true; }\n"
   "				if(rez.indexOf('AP') >= 0) { rez = rez.replace('AP',(val>=43200)?'PM':'AM'); var ap = true; }\n"
   "				this.value = rez;\n"
   "				break;\n"
   "			    case 5:	//Date\n"
   "				var rez = (this.parentNode.cfg.length) ? this.parentNode.cfg : 'dd.MM.yy';\n"
   "				var dt = new Date(parseInt(val)*1000);\n"
   "				var v = dt.getDate().toString(10); rez = rez.replace('dddd',i2s(v,10,2)); rez = rez.replace('ddd',i2s(v,10,2)); rez = rez.replace('dd',i2s(v,10,2)); rez = rez.replace('d',v);\n"
   "				v = (dt.getMonth()+1).toString(10); rez = rez.replace('MMMM',i2s(v,10,2)); rez = rez.replace('MMM',i2s(v,10,2)); rez = rez.replace('MM',i2s(v,10,2)); rez = rez.replace('M',v);\n"
   "				v = dt.getFullYear().toString(10); rez = rez.replace('yyyy',i2s(v,10,4)); rez = rez.replace('yy',i2s(v.substr(2,2),10,2));\n"
   "				this.value = rez;\n"
   "				break;\n"
   "			    case 6:	//Date and time\n"
   "				var rez = (this.parentNode.cfg.length) ? this.parentNode.cfg : 'dd.MM.yy hh:mm';\n"
   "				var dt = new Date(parseInt(val)*1000);\n"
   "				var v = dt.getDate().toString(10); rez = rez.replace('dddd',i2s(v,10,2)); rez = rez.replace('ddd',i2s(v,10,2)); rez = rez.replace('dd',i2s(v,10,2)); rez = rez.replace('d',v);\n"
   "				v = (dt.getMonth()+1).toString(10); rez = rez.replace('MMMM',i2s(v,10,2)); rez = rez.replace('MMM',i2s(v,10,2)); rez = rez.replace('MM',i2s(v,10,2)); rez = rez.replace('M',v);\n"
   "				v = dt.getFullYear().toString(10); rez = rez.replace('yyyy',i2s(v,10,4)); rez = rez.replace('yy',i2s(v.substr(2,2),10,2));\n"
   "				v = dt.getHours().toString(10); rez = rez.replace('hh',i2s(v,10,2)); rez = rez.replace('h',v);\n"
   "				v = dt.getMinutes().toString(10); rez = rez.replace('mm',i2s(v,10,2)); rez = rez.replace('m',v);\n"
   "				v = dt.getSeconds().toString(10); rez = rez.replace('ss',(v.length==1)?'0'+v:v); rez = rez.replace('s',v);\n"
   "				if(rez.indexOf('ap') >= 0)	{ rez = rez.replace('ap',(val>=43200)?'pm':'am'); var ap = true; }\n"
   "				if(rez.indexOf('AP') >= 0)	{ rez = rez.replace('AP',(val>=43200)?'PM':'AM'); var ap = true; }\n"
   "				this.value = rez;\n"
   "				break;\n"
   "			}\n"
   "			this.saveVal = this.value;\n"
   "			this.srcVal = val;\n"
   "		    }\n"
   "		    formObj.valGet = function( ) {\n"
   "			switch(this.parentNode.view) {\n"
   "			    case 0: case 1: return this.value;\n"
   "			    case 2:\n"
   "				var rez = this.value;\n"
   "				var argCfg = this.parentNode.cfg.split(':');\n"
   "				var tmp = (argCfg&&argCfg.length>3) ? noSpace(argCfg[3]) : '';\n"
   "				if(tmp.length && rez.indexOf(tmp) >= 0) rez = rez.substring(rez.indexOf(tmp)+tmp.length);\n"
   "				tmp = (argCfg&&argCfg.length>4) ? noSpace(argCfg[4]) : '';\n"
   "				if(tmp.length && rez.indexOf(tmp) >= 0) rez = rez.substring(0,rez.indexOf(tmp));\n"
   "				return parseInt(rez);\n"
   "			    case 3:\n"
   "				var rez = this.value;\n"
   "				var argCfg = this.parentNode.cfg.split(':');\n"
   "				var tmp = (argCfg&&argCfg.length>3) ? noSpace(argCfg[3]) : '';\n"
   "				if(tmp.length && rez.indexOf(tmp) >= 0) rez = rez.substring(rez.indexOf(tmp)+tmp.length);\n"
   "				tmp = (argCfg&&argCfg.length>4) ? noSpace(argCfg[4]) : '';\n"
   "				if(tmp.length && rez.indexOf(tmp) >= 0) rez = rez.substring(0,rez.indexOf(tmp));\n"
   "				return parseFloat(rez);\n"
   "			    case 4:\n"
   "				var cfg = (this.parentNode.cfg.length) ? this.parentNode.cfg : 'hh:mm';\n"
   "				var rez = this.value;\n"
   "				if(cfg.indexOf('ap') >= 0 || cfg.indexOf('AP') >= 0) {\n"
   "				    cfg = cfg.replace('ap','');\n"
   "				    cfg = cfg.replace('AP','');\n"
   "				    rez = rez.replace('am','');\n"
   "				    rez = rez.replace('AM','');\n"
   "				    rez = rez.replace('pm','');\n"
   "				    rez = rez.replace('PM','');\n"
   "				}\n"
   "				var hour = Math.floor(this.srcVal/3600);\n"
   "				var min  = Math.floor(this.srcVal/60)%60;\n"
   "				var sec  = this.srcVal%60;\n"
   "				var i = 0; var lstS = ''; var lenS = 0;\n"
   "				while(true) {\n"
   "				    if(i >= cfg.length || cfg.charAt(i) == 'h' || cfg.charAt(i) == 'm' || cfg.charAt(i) == 's') {\n"
   "					var space = lenS ? noSpace(cfg.substr(i-lenS,lenS)) : '';\n"
   "					if(lenS && !space.length) space = ' ';\n"
   "					if((space.length && lstS != '') || i >= cfg.length) {\n"
   "					    if(space.length && rez.indexOf(space) == -1) return 0;\n"
   "					    var val = parseInt(space.length?rez.substr(0,rez.indexOf(space)):rez,10);\n"
   "					    rez = rez.substr(rez.indexOf(space));\n"
   "					    if(lstS == 'h')	hour = val;\n"
   "					    else if(lstS == 'm')min = val;\n"
   "					    else if(lstS == 's')sec = val;\n"
   "					    if(i >= cfg.length) break;\n"
   "					}\n"
   "					if(space.length) {\n"
   "					    if(rez.indexOf(space) == -1) return 0;\n"
   "					    rez = rez.substr(rez.indexOf(space)+space.length);\n"
   "					}\n"
   "					lstS = cfg.charAt(i); lenS = 0;\n"
   "					i++;\n"
   "					continue;\n"
   "				    }\n"
   "				    lenS++; i++;\n"
   "				}\n"
   "				if(this.value.indexOf('pm') >= 0 || this.value.indexOf('PM') >= 0) hour += 12;\n"
   "				return (hour%24)*3600+(min%60)*60+(sec%60);\n"
   "			    case 5:\n"
   "				var cfg = (this.parentNode.cfg.length) ? this.parentNode.cfg : 'd.MM.yy';\n"
   "				var rez  = this.value;\n"
   "				var dt = new Date(this.srcVal*1000);\n"
   "				var i = 0; var lstS = ''; var lenS = 0;\n"
   "				while(true) {\n"
   "				    if(i >= cfg.length || cfg.charAt(i) == 'd' || cfg.charAt(i) == 'M' || cfg.charAt(i) == 'y') {\n"
   "					var space = lenS ? noSpace(cfg.substr(i-lenS,lenS)) : '';\n"
   "					if(lenS && !space.length) space = ' ';\n"
   "					if((space.length && lstS != '') || i >= cfg.length) {\n"
   "					    if(space.length && rez.indexOf(space) == -1) return 0;\n"
   "					    var val = parseInt(space.length?rez.substr(0,rez.indexOf(space)):rez,10);\n"
   "					    rez = rez.substr(rez.indexOf(space));\n"
   "					    if(lstS == 'd')	dt.setDate(val);\n"
   "					    else if(lstS == 'M')dt.setMonth(val-1);\n"
   "					    else if(lstS == 'y')dt.setFullYear((val<100)?2000+val:val);\n"
   "					    if(i >= cfg.length) break;\n"
   "					}\n"
   "					if(space.length) {\n"
   "					    if(rez.indexOf(space) == -1) return 0;\n"
   "					    rez = rez.substr(rez.indexOf(space)+space.length);\n"
   "					}\n"
   "					lstS = cfg.charAt(i); lenS = 0;\n"
   "					i++;\n"
   "					continue;\n"
   "				    }\n"
   "				    lenS++; i++;\n"
   "				}\n"
   "				rez = dt.getTime()/1000;\n"
   "				return rez;\n"
   "			    case 6:\n"
   "				var cfg = (this.parentNode.cfg.length) ? this.parentNode.cfg : 'dd.MM.yy hh:mm';\n"
   "				var rez  = this.value;\n"
   "				if(cfg.indexOf('ap') >= 0 || cfg.indexOf('AP') >= 0) {\n"
   "				    cfg = cfg.replace('ap','');\n"
   "				    cfg = cfg.replace('AP','');\n"
   "				    rez = rez.replace('am','');\n"
   "				    rez = rez.replace('AM','');\n"
   "				    rez = rez.replace('pm','');\n"
   "				    rez = rez.replace('PM','');\n"
   "				}\n"
   "				var dt = new Date(this.srcVal*1000);\n"
   "				var i = 0; var lstS = ''; var lenS = 0;\n"
   "				while(true) {\n"
   "				    if(i >= cfg.length || cfg.charAt(i) == 'd' || cfg.charAt(i) == 'M' || cfg.charAt(i) == 'y' ||\n"
   "					cfg.charAt(i) == 'h' || cfg.charAt(i) == 'm' || cfg.charAt(i) == 's')\n"
   "				    {\n"
   "					var space = lenS ? noSpace(cfg.substr(i-lenS,lenS)) : '';\n"
   "					if(lenS && !space.length) space = ' ';\n"
   "					if((space.length && lstS != '') || i >= cfg.length) {\n"
   "					    if(space.length && rez.indexOf(space) == -1) return 0;\n"
   "					    var val = parseInt(space.length?rez.substr(0,rez.indexOf(space)):rez,10);\n"
   "					    rez = rez.substr(rez.indexOf(space));\n"
   "					    if(lstS == 'd')	dt.setDate(val);\n"
   "					    else if(lstS == 'M')dt.setMonth(val-1);\n"
   "					    else if(lstS == 'y')dt.setFullYear((val<100)?2000+val:val);\n"
   "					    else if(lstS == 'h')dt.setHours(val);\n"
   "					    else if(lstS == 'm')dt.setMinutes(val);\n"
   "					    else if(lstS == 's')dt.setSeconds(val);\n"
   "					    if(i >= cfg.length) break;\n"
   "					}\n"
   "					if(space.length) {\n"
   "					    if(rez.indexOf(space) == -1) return 0;\n"
   "					    rez = rez.substr(rez.indexOf(space)+space.length);\n"
   "					}\n"
   "					lstS = cfg.charAt(i); lenS = 0; i++; continue;\n"
   "				    }\n"
   "				    lenS++; i++;\n"
   "				}\n"
   "				if(this.value.indexOf('pm') >= 0 || this.value.indexOf('PM') >= 0) dt.setHours(dt.getHours()+12);\n"
   "				rez = dt.getTime()/1000;\n"
   "				return rez;\n"
   "			}\n"
   "			return '';\n"
   "		    }\n"
   "		    formObj.chApply = function( ) {\n"
   "			var val = this.valGet();\n"
   "			this.valSet(val);\n"
   "			this.setModify(false);\n"
   "			var attrs = new Object(); attrs.value = val; attrs.event = 'ws_LnAccept';\n"
   "			setWAttrs(this.wdgLnk.addr,attrs);\n"
   "		    }\n"
   "		    formObj.chEscape = function( ) {\n"
   "			this.value = this.saveVal;\n"
   "			this.setModify(false);\n"
   "		    }\n"
   "		    var okImg = this.place.ownerDocument.createElement('img');\n"
   "		    okImg.className = \"ok\";\n"
   "		    okImg.src = '/'+MOD_ID+'/img_button_ok';\n"
   "		    okImg.style.cssText = 'left: '+(geomW-16)+'px; top: '+((geomH-16)/2)+'px;';\n"
   "		    okImg.onclick = function() { this.parentNode.childNodes[0].chApply(); return false; };\n"
   "		    this.place.appendChild(okImg);\n"
   "		    formObj.valSet(this.attrs['value']);\n"
   "		    break;\n"
   "		case 1:	//Text edit\n"
   "		    var toInit = !this.place.childNodes.length;\n"
   "		    var formObj = toInit ? this.place.ownerDocument.createElement('textarea') : this.place.childNodes[0];\n"
   "		    if(toInit || this.attrsMdf['geomZ']) formObj.tabIndex = parseInt(this.attrs['geomZ'])+1;\n"
   "		    if(toInit || this.attrsMdf['geomW'] || this.attrsMdf['geomH'] || this.attrsMdf['font'])\n"
   "			formObj.style.cssText = 'width: '+(geomW-5)+'px; height: '+(geomH-5)+'px; font: '+this.place.fontCfg+'; ';\n"
   "		    if(this.attrsMdf['value']) formObj.saveVal = formObj.value = this.attrs['value'];\n"
   "		    if(!toInit) break;\n"
   "		    formObj.disabled = !elWr;\n"
   "		    formObj.wdgLnk = this;\n"
   "		    formObj.appendChild(this.place.ownerDocument.createTextNode(this.attrs['value']));\n"
   "		    formObj.onkeyup = function( ) { if(this.saveVal != this.value) this.setModify(true); };\n"
   "		    formObj.modify = function( ) { return (this.parentNode.childNodes[1].style.visibility == 'visible'); }\n"
   "		    formObj.setModify = function(on) {\n"
   "			if(this.modify() == on) return;\n"
   "			if(on) {\n"
   "			    this.style.height = (parseInt(this.style.height)-16)+'px';\n"
   "			    this.parentNode.childNodes[1].style.visibility = this.parentNode.childNodes[2].style.visibility = 'visible';\n"
   "			}\n"
   "			else {\n"
   "			    this.style.height = (parseInt(this.style.height)+16)+'px';\n"
   "			    this.parentNode.childNodes[1].style.visibility = this.parentNode.childNodes[2].style.visibility = 'hidden';\n"
   "			}\n"
   "		    }\n"
   "		    var okImg = this.place.ownerDocument.createElement('img');\n"
   "		    okImg.src = '/'+MOD_ID+'/img_button_ok';\n"
   "		    okImg.style.cssText = 'visibility: hidden; position: absolute; left: '+(geomW-35)+'px; '+\n"
   "					  'top: '+(geomH-16)+'px; width: 16px; height: 16px; cursor: pointer;';\n"
   "		    okImg.onclick = function( ) {\n"
   "			var attrs = new Object();\n"
   "			attrs.value = this.parentNode.childNodes[0].value; attrs.event = 'ws_TxtAccept';\n"
   "			setWAttrs(this.parentNode.childNodes[0].wdgLnk.addr,attrs);\n"
   "			this.parentNode.childNodes[0].setModify(false);\n"
   "			return false;\n"
   "		    };\n"
   "		    var cancelImg = this.place.ownerDocument.createElement('img');\n"
   "		    cancelImg.src = '/'+MOD_ID+'/img_button_cancel';\n"
   "		    cancelImg.style.cssText = 'visibility: hidden; position: absolute; left: '+(geomW-16)+'px; top: '+(geomH-16)+'px; width: 16px; height: 16px; cursor: pointer;';\n"
   "		    cancelImg.onclick = function( ) {\n"
   "			this.parentNode.childNodes[0].value = this.parentNode.childNodes[0].saveVal;\n"
   "			this.parentNode.childNodes[0].setModify(false);\n"
   "			return false;\n"
   "		    };\n"
   "		    this.place.appendChild(formObj);\n"
   "		    this.place.appendChild(okImg);\n"
   "		    this.place.appendChild(cancelImg);\n"
   "		    break;\n"
   "		case 2:	//Chek box\n"
   "		    var toInit = !this.place.childNodes.length;\n"
   "		    var tblCell = toInit ? this.place.ownerDocument.createElement('div') : this.place.childNodes[0];\n"
   "		    if(toInit || this.attrsMdf['geomH'] || this.attrsMdf['geomW'] || this.attrsMdf['font'])\n"
   "			tblCell.style.cssText = 'position: absolute; top: '+((geomH-15)/2)+'px; width: '+geomW+'px; '+\n"
   "					    'height: '+Math.min(geomH,15)+'px; text-align: left; font: '+this.place.fontCfg+'; ';\n"
   "		    var formObj = tblCell.childNodes.length ? tblCell.childNodes[0] : this.place.ownerDocument.createElement('input');\n"
   "		    if(toInit || this.attrsMdf['geomZ']) formObj.tabIndex = parseInt(this.attrs['geomZ'])+1;\n"
   "		    if(toInit || this.attrsMdf['value']) formObj.checked = parseInt(this.attrs['value']);\n"
   "		    if(toInit) {\n"
   "			formObj.type = 'checkbox';\n"
   "			formObj.disabled = !elWr;\n"
   "			formObj.wdgLnk = this;\n"
   "			formObj.onclick = function( ) {\n"
   "			    //console.log(this.addr+\": TEST 00: ChkChange=\"+this.checked);\n"
   "			    var attrs = new Object();\n"
   "			    attrs.value = this.checked ? '1' : '0';	attrs.event = 'ws_ChkChange';\n"
   "			    setWAttrs(this.wdgLnk.addr,attrs);\n"
   "			    return true;\n"
   "			}\n"
   "			tblCell.appendChild(formObj);\n"
   "			tblCell.appendChild(this.place.ownerDocument.createTextNode(this.attrs['name']));\n"
   "			this.place.appendChild(tblCell);\n"
   "		    }\n"
   "		    if(this.attrsMdf['name'])	tblCell.childNodes[1].textContent = this.attrs['name'];\n"
   "		    break;\n"
   "		case 3:	//Button\n"
   "		    var formObj;\n"
   "		    var iconImg = this.attrs['img'];\n"
   "		    this.place.checkable = (parseInt(this.attrs['mode']) == 1);\n"
   "		    this.place.isMenu = (parseInt(this.attrs['mode']) == 2);\n"
   "		    this.place.isLoad = (parseInt(this.attrs['mode']) == 3);\n"
   "		    this.place.isSave = (parseInt(this.attrs['mode']) == 4);\n"
   "		    var custBut = (iconImg || this.place.checkable);\n"
   "		    if(custBut != this.place.custBut || this.attrsMdf['mode'])\n"
   "			while(this.place.childNodes.length) this.place.removeChild(this.place.childNodes[0]);\n"
   "		    this.place.custBut = custBut;\n"
   "		    var toInit = !this.place.childNodes.length;\n"
   "		    if(custBut && !this.place.isLoad) {\n"
   "			formObj =  toInit ? this.place.ownerDocument.createElement('div') : this.place.childNodes[0];\n"
   "			// Container widget style\n"
   "			elStyle += 'border-style: '+((this.place.checkable && parseInt(this.attrs['value']))?'inset; ':'outset; ')+\n"
   "						    (elWr?'cursor: pointer; ':'')+'border-width: 2px; ';\n"
   "			if(this.attrs['colorText'])\n"
   "			    elStyle += 'color: '+(elWr ? getColor(this.attrs['colorText']) : 'silver')+'; ';\n"
   "			if(elWr && this.attrs['color']) elStyle += 'background-color: '+getColor(this.attrs['color'])+'; ';\n"
   "			else elStyle += 'background-color: snow; ';\n"
   "\n"
   "			if(toInit || this.attrsMdf['font']) formObj.style.font = this.place.fontCfg;\n"
   "			var imgObj = formObj.childNodes.length ? formObj.childNodes[0] : this.place.ownerDocument.createElement('img');\n"
   "			var spanObj = formObj.childNodes.length ? formObj.childNodes[1] : this.place.ownerDocument.createElement('span');\n"
   "\n"
   "			spanObj.style.cssText = \"display: table-cell; height: \"+geomH+\"px; line-height: 1; text-align: center; white-space: pre-line; word-break: break-word; width: \"+geomW+\"px; \";\n"
   "			if(toInit || this.attrsMdf['name']) {\n"
   "			    spanObj.disabled = !this.attrs['name'].length;\n"
   "			    spanObj.innerText = this.attrs['name'].replace('\\\\n','\\n') + (this.place.isMenu?\" ▾\":\"\");\n"
   "			}\n"
   "			if(toInit || this.attrsMdf['img'] || this.attrsMdf['name']) {\n"
   "			    imgObj.hidden = !this.attrs['img'].length;\n"
   "			    if(!imgObj.hidden) {\n"
   "				imgObj.className = elWr ? 'active' : 'inactive';\n"
   "				imgObj.src = \"/\"+MOD_ID+this.addr+\"?com=res&val=\"+this.attrs['img']+\"&size=\"+Math.min(geomW,geomH);//+(!elWr?\"&filtr=unact\":\"\");\n"
   "				//imgObj.width = Math.min(geomW, geomH);\n"
   "				imgObj.height = Math.min(geomW, geomH);\n"
   "				imgObj.style.float = spanObj.disabled ? null : 'left';\n"
   "				imgObj.style.marginRight = this.attrs['name'].length ? \"2px\" : \"0px\";\n"
   "			    }\n"
   "			}\n"
   "			geomW -= 4; geomH -= 4;\n"
   "\n"
   "			if(elWr) {\n"
   "			    this.mouseup[this.mouseup.length] = function(e,el) {\n"
   "				if(el.checkable) return;\n"
   "				el.style.borderStyle = 'outset'; setWAttrs(el.wdgLnk.addr,'event','ws_BtRelease');\n"
   "			    };\n"
   "			    this.mousedown[this.mousedown.length] = function(e,el) {\n"
   "				if(el.checkable) return;\n"
   "				el.style.borderStyle = \"inset\"; setWAttrs(el.wdgLnk.addr,'event','ws_BtPress');\n"
   "			    };\n"
   "			}\n"
   "\n"
   "			if(toInit) {\n"
   "			    formObj.className = 'vertalign';\n"
   "			    //Disable drag mostly for FireFox\n"
   "			    imgObj.onmousedown = function(e) { e = e?e:window.event; if(e.preventDefault) e.preventDefault(); }\n"
   "			    if(elWr) {\n"
   "				this.place.onmouseout = function( ) {\n"
   "				    if(this.checkable || this.style.borderStyle == 'outset') return false;\n"
   "				    this.style.borderStyle = 'outset'; setWAttrs(this.wdgLnk.addr,'event','ws_BtRelease');\n"
   "				    return false;\n"
   "				};\n"
   "				this.place.onclick = function( ) {\n"
   "				    if(!this.checkable) return false;\n"
   "				    var attrs = new Object();\n"
   "				    if(this.style.borderLeftStyle == 'outset')\n"
   "				    { attrs.value = '1'; this.style.borderStyle = 'inset'; setWAttrs(this.wdgLnk.addr,'event','ws_BtPress'); }\n"
   "				    else { attrs.value = '0'; this.style.borderStyle = 'outset'; setWAttrs(this.wdgLnk.addr,'event','ws_BtRelease'); }\n"
   "				    setWAttrs(this.wdgLnk.addr,'event','ws_BtToggleChange');\n"
   "				    setWAttrs(this.wdgLnk.addr,'value',attrs.value);\n"
   "				    return false;\n"
   "				};\n"
   "				this.place.wdgLnk = this;\n"
   "			    }\n"
   "			    formObj.appendChild(imgObj);\n"
   "			    formObj.appendChild(spanObj);\n"
   "\n"
   "			    formObj.style.position = \"absolute\";\n"
   "			    formObj.style.top = \"-2px\"; formObj.style.left = \"-2px\";\n"
   "			    formObj.style.width = (geomW+4)+'px'; formObj.style.height = (geomH+4)+'px';\n"
   "			    formObj.style.overflow = \"hidden\";\n"
   "			    this.place.appendChild(formObj);\n"
   "			}\n"
   "		    }\n"
   "		    else {\n"
   "			formObj = toInit ? this.place.ownerDocument.createElement('button') : this.place.childNodes[0];\n"
   "			if(toInit || this.attrsMdf['geomZ'])	formObj.tabIndex = parseInt(this.attrs['geomZ'])+1;\n"
   "			if(toInit || this.attrsMdf['font'])	formObj.style.font = this.place.fontCfg;\n"
   "			if(toInit || this.attrsMdf['name'])	formObj.innerText = this.attrs['name'].replace('\\\\n','\\n') + (this.place.isMenu?\" ▾\":\"\");\n"
   "			if(toInit || this.attrsMdf['color'])	formObj.style.backgroundColor = getColor(this.attrs['color']);\n"
   "			if(toInit || this.attrsMdf['colorText'])formObj.style.color = getColor(this.attrs['colorText']);\n"
   "			this.mouseup[this.mouseup.length] = function(e,el)	{ setWAttrs(el.wdgLnk.addr,'event','ws_BtRelease'); };\n"
   "			this.mousedown[this.mousedown.length] = function(e,el)	{ setWAttrs(el.wdgLnk.addr,'event','ws_BtPress'); };\n"
   "			if(toInit) {\n"
   "			    formObj.style.cursor = elWr ? 'pointer' : '';\n"
   "			    formObj.disabled = !elWr;\n"
   "			    formObj.wdgLnk = this;\n"
   "			    formObj.style.width = geomW+'px'; formObj.style.height = geomH+'px';\n"
   "			    formObj.style.padding = \"0\";\n"
   "			    this.place.appendChild(formObj);\n"
   "			}\n"
   "		    }\n"
   "\n"
   "		    if(this.place.isMenu)\n"
   "			formObj.onclick = function( ) {\n"
   "			    var menuWin = this.ownerDocument.getElementById('menuwin');\n"
   "			    if(!menuWin) {\n"
   "				menuWin = this.ownerDocument.createElement('div');\n"
   "				menuWin.id = 'menuwin';\n"
   "				menuWin.className = \"ItemsTree active\";\n"
   "				menuWin.treeFont = 'font:'+this.wdgLnk.place.fontCfg+';';\n"
   "				if(getFont(this.wdgLnk.attrs['font'],Math.min(this.wdgLnk.xScale(true),this.wdgLnk.yScale(true)),2) > 14)\n"
   "				    menuWin.treeFont += \"font-size: 14px;\"\n"
   "				menuWin.close = function( ) { this.style.visibility = 'hidden'; this.style.top = \"-100px\"; }\n"
   "				menuWin.setList = function(list) {\n"
   "				    if(!this.children.length) this.appendChild(getTree());\n"
   "				    this.children[0].style.cssText = this.treeFont;\n"
   "				    this.children[0].select = function(ipath) {\n"
   "					if(!ipath.length) return;\n"
   "					attrs = new Object();\n"
   "					attrs.event = 'ws_BtMenu='+ipath;\n"
   "					//console.log(\"Event=\"+attrs.event);\n"
   "					setWAttrs(this.parentNode.formObj.wdgLnk.addr, attrs);\n"
   "					this.parentNode.close();\n"
   "				    }\n"
   "				    this.children[0].setList(list);\n"
   "				}\n"
   "				this.ownerDocument.body.appendChild(menuWin);\n"
   "			    }\n"
   "			    menuWin.style.cssText = 'left: '+posGetX(this,true)+'px; top: '+(posGetY(this,true)+this.offsetHeight)+'px; ';\n"
   "			    menuWin.onmouseleave = menuWin.close;\n"
   "			    menuWin.formObj = this;\n"
   "			    menuWin.setList(this.wdgLnk.attrs['value']);\n"
   "			}\n"
   "		    else if(this.place.isLoad && toInit) {\n"
   "			iformObj = this.place.ownerDocument.createElement('form');\n"
   "			iformObj.method = 'post';\n"
   "			iformObj.action = \"/\"+MOD_ID+this.addr+\"?com=obj\"\n"
   "			iformObj.enctype = \"multipart/form-data\";\n"
   "			fHeader = this.attrs['value'].split(\"\\n\",1)[0].split(\"|\");\n"
   "			iformObj.innerHTML = \"<input type='file' style='display: none' name='File' accept='\"+fHeader[3]+\"' defaultValue='\"+fHeader[2]+\"'/>\";\n"
   "			formObj.iformObj = iformObj;\n"
   "			formObj.onclick = function( ) { this.iformObj.children[0].click(); }\n"
   "			iformObj.children[0].wdgLnk = this;\n"
   "			iformObj.children[0].onchange = function( ) { if(this.value.length) this.form.submit(); }\n"
   "			this.place.appendChild(iformObj);\n"
   "		    }\n"
   "		    else if(this.place.isSave) {\n"
   "			if(this.attrs['value'].length && this.attrs['value'] != this.valuePrev)\n"
   "			    window.open('/'+MOD_ID+this.addr+\"/\"+this.attrs['value'].split(\"\\n\",1)[0].split(\"|\")[2]+'?com=obj');\n"
   "			this.valuePrev = this.attrs['value'];\n"
   "		    }\n"
   "		    break;\n"
   "		case 4: case 5:	//Combo box, List\n"
   "		    var toInit = !this.place.childNodes.length;\n"
   "		    var formObj = toInit ? this.place.ownerDocument.createElement('select') : this.place.childNodes[0];\n"
   "		    if(toInit || this.attrsMdf['geomZ']) formObj.tabIndex = parseInt(this.attrs['geomZ'])+1;\n"
   "		    if(toInit || this.attrsMdf['geomW'] || this.attrsMdf['geomH'] || this.attrsMdf['font'])\n"
   "			formObj.style.cssText = 'top: '+((elTp==4)?(geomH-fntSz)/2:0)+'px; '+\n"
   "					    'height: '+((elTp==4)?fntSz:(geomH-4))+'px; width: '+geomW+'px; '+\n"
   "					    'font: '+this.place.fontCfg+'; ';\n"
   "		    formObj.multiple = parseInt(this.attrs['mult']) ? true : null;\n"
   "		    if(this.attrsMdf['items'] || this.attrsMdf['value']) {\n"
   "			while(formObj.childNodes.length) formObj.removeChild(formObj.childNodes[0]);\n"
   "			var selVal = this.attrs['value'].split('\\n');\n"
   "			var elLst = this.attrs['items'].split('\\n');\n"
   "			for(var i = 0; i < elLst.length; i++) {\n"
   "			    var optEl = this.place.ownerDocument.createElement('option');\n"
   "			    optEl.appendChild(this.place.ownerDocument.createTextNode(elLst[i]));\n"
   "			    if((selId=selVal.indexOf(elLst[i])) >= 0) {\n"
   "				optEl.defaultSelected = optEl.selected = true;\n"
   "				selVal.splice(selId,1);\n"
   "			    }\n"
   "			    formObj.appendChild(optEl);\n"
   "			}\n"
   "			for(i = 0; i < selVal.length; i++) {\n"
   "			    var optEl = this.place.ownerDocument.createElement('option');\n"
   "			    optEl.textContent = selVal[i];\n"
   "			    optEl.selected = optEl.defaultSelected = true;\n"
   "			    formObj.appendChild(optEl);\n"
   "			}\n"
   "		    }\n"
   "		    if(!toInit) break;\n"
   "		    formObj.disabled = !elWr;\n"
   "		    formObj.wdgLnk = this;\n"
   "		    if(elTp == 4)\n"
   "			formObj.onchange = function( ) {\n"
   "			    var attrs = new Object();\n"
   "			    attrs.value = this.options[this.selectedIndex].value; attrs.event = 'ws_CombChange';\n"
   "			    setWAttrs(this.wdgLnk.addr,attrs);\n"
   "			}\n"
   "		    else {\n"
   "			formObj.size = 100;\n"
   "			formObj.onclick = function( ) {\n"
   "			    var attrs = new Object();\n"
   "			    if(this.selectedIndex) attrs.value = this.options[this.selectedIndex].value;\n"
   "			    else {\n"
   "				attrs.value = \"\";\n"
   "				for(iO = 0; iO < this.options.length; iO++)\n"
   "				    if(this.options[iO].selected) attrs.value += (attrs.value.length?\"\\n\":\"\") + this.options[iO].value;\n"
   "			    }\n"
   "			    attrs.event = 'ws_ListChange';\n"
   "			    setWAttrs(this.wdgLnk.addr, attrs);\n"
   "			}\n"
   "		    }\n"
   "		    this.place.appendChild(formObj);\n"
   "		    break;\n"
   "		case 6: case 7:	//Slider and Scroll bar\n"
   "		    isProgr = false;	//(elTp == 7);\n"
   "		    var toInit = !this.place.children.length;\n"
   "		    var formObj = toInit ? this.place.ownerDocument.createElement('input') : this.place.children[0];\n"
   "		    if(toInit || this.attrsMdf['geomZ']) formObj.tabIndex = parseInt(this.attrs['geomZ'])+1;\n"
   "		    if(toInit || this.attrsMdf['value']) formObj.value = parseInt(this.attrs['value']);\n"
   "		    formObj.vOr = false;\n"
   "		    if(toInit || this.attrsMdf['cfg']) {\n"
   "			cfgLst = this.attrs['cfg'].split(':');\n"
   "			formObj.vOr = (cfgLst.length && parseInt(cfgLst[0]));\n"
   "			formObj.setAttribute(\"orient\", formObj.vOr?\"vertical\":\"\");\n"
   "			formObj.setAttribute(\"min\", (cfgLst.length > 1)?parseInt(cfgLst[1]):0);\n"
   "			formObj.setAttribute(\"max\", (cfgLst.length > 2)?parseInt(cfgLst[2]):100);\n"
   "			formObj.setAttribute(\"step\", (cfgLst.length > 3)?parseInt(cfgLst[3]):1);\n"
   "		    }\n"
   "		    if(!toInit) break;\n"
   "		    formObj.type = 'range';\n"
   "		    formObj.disabled = !elWr;\n"
   "		    formObj.wdgLnk = this;\n"
   "		    formObj.style.cssText = \"width: \"+(formObj.vOr?16:(isProgr?geomW-2*16:geomW))+\"px; \"+\n"
   "			\"height: \"+(formObj.vOr?(isProgr?geomH-2*16:geomH):16)+\"px; \";\n"
   "		    formObj.onclick = formObj.onkeyup = function( ) {\n"
   "			if(this.value == parseInt(this.wdgLnk.attrs['value']))	return;\n"
   "			var attrs = new Object();\n"
   "			attrs.value = this.value; attrs.event = 'ws_SliderChange';\n"
   "			setWAttrs(this.wdgLnk.addr, attrs);\n"
   "			this.defaultValue = this.value;\n"
   "			//return true;\n"
   "		    }\n"
   "		    this.place.appendChild(formObj);\n"
   "		    break;\n"
   "		case 8:	//Tree\n"
   "		    this.place.className += \" ItemsTree\";\n"
   "		    if(elWr) this.place.className += \" active\";\n"
   "		    var toInit = !this.place.children.length;\n"
   "		    var formObj = toInit ? getTree() : this.place.children[0];\n"
   "		    formObj.wdgLnk = this;\n"
   "		    formObj.elWr = elWr;\n"
   "		    if(toInit || this.attrsMdf['geomZ']) formObj.tabIndex = parseInt(this.attrs['geomZ'])+1;\n"
   "		    if(toInit || this.attrsMdf['font']) {\n"
   "			formObj.style.cssText = 'font: '+this.place.fontCfg+';';\n"
   "			if(getFont(this.attrs['font'],Math.min(xSc,ySc),2) > 14) formObj.style.cssText += \"font-size: 14px;\"\n"
   "		    }\n"
   "		    //Events and the processings init\n"
   "		    if(toInit)\n"
   "			formObj.select = function(ipath) {\n"
   "			    if(!ipath.length) return;\n"
   "			    attrs = new Object();\n"
   "			    attrs.value = ipath;\n"
   "			    attrs.event = 'ws_TreeChange';\n"
   "			    setWAttrs(this.wdgLnk.addr, attrs);\n"
   "			}\n"
   "		    //Processing for fill and changes\n"
   "		    if(toInit || this.attrsMdf['items']) formObj.setList(this.attrs['items']);\n"
   "		    if(toInit || this.attrsMdf['value'] || this.attrsMdf['items']) formObj.selIt(this.attrs['value']);\n"
   "		    if(toInit) this.place.appendChild(formObj);\n"
   "		    break;\n"
   "		case 9:	//Table\n"
   "		    this.place.className += \" Table\";\n"
   "		    if(elWr) this.place.className += \" active\";\n"
   "		    var toInit = !this.place.children.length;\n"
   "		    var formObj = toInit ? this.place.ownerDocument.createElement('table') : this.place.children[0];\n"
   "		    formObj.wdgLnk = this;\n"
   "		    formObj.elWr = elWr;\n"
   "		    //Events and the processings init\n"
   "		    if(toInit) {\n"
   "			formObj.onclick = function( ) {\n"
   "			    if(this.nodeName == \"TABLE\" || !(elTbl=this.offsetParent) || !elTbl.elWr) return true;\n"
   "			    attrs = null;\n"
   "			    if(elTbl.oSel == \"row\" && this.parentNode.rowIndex > 0) {\n"
   "				elTbl.selIt(this.parentNode.rowIndex);\n"
   "				attrs = new Object();\n"
   "				attrs.value = elTbl.getVal(this.parentNode.rowIndex-1, elTbl.oKeyID);\n"
   "				if(this.parentNode.cells[elTbl.oKeyID+1].outTp == \"b\")\n"
   "				    attrs.value = (attrs.value == \"true\") ? 1 : 0;\n"
   "			    }\n"
   "			    else if(elTbl.oSel == \"col\" && this.cellIndex > 0) {\n"
   "				elTbl.selIt(null, this.cellIndex);\n"
   "				attrs = new Object();\n"
   "				attrs.value = elTbl.getVal(elTbl.oKeyID, this.cellIndex-1);\n"
   "				if(elTbl.tBodies[0].rows[elTbl.oKeyID].cells[this.cellIndex].outTp == \"b\")\n"
   "				    attrs.value = (attrs.value == \"true\") ? 1 : 0;\n"
   "			    }\n"
   "			    else if(this.parentNode.rowIndex > 0 && this.cellIndex > 0) {\n"
   "				elTbl.selIt(this.parentNode.rowIndex, this.cellIndex);\n"
   "				attrs = new Object();\n"
   "				if(elTbl.oSel == \"cell\") {\n"
   "				    attrs.value = elTbl.getVal(this.parentNode.rowIndex-1, this.cellIndex-1);\n"
   "				    if(this.outTp == \"b\") attrs.value = (attrs.value == \"true\") ? 1 : 0;\n"
   "				} else attrs.value = (this.parentNode.rowIndex-1) + \":\" + (this.cellIndex-1);\n"
   "			    }\n"
   "			    if(attrs) { attrs.event = 'ws_TableChangeSel'; setWAttrs(elTbl.wdgLnk.addr, attrs); }\n"
   "			}\n"
   "			formObj.ondblclick = function( ) {\n"
   "			    if(this.nodeName == \"TABLE\" || !(elTbl=this.offsetParent) || !elTbl.elWr || !this.isEdit) return true;\n"
   "			    if(this.isEnter) {\n"
   "				this.innerHTML = this.svInnerHTML;\n"
   "				this.isEnter = false; elTbl.edIt = null;\n"
   "			    }\n"
   "			    else {\n"
   "				if(elTbl.edIt) { elTbl.edIt.innerHTML = elTbl.edIt.svInnerHTML; elTbl.edIt.isEnter = false; }\n"
   "				this.isEnter = true; elTbl.edIt = this;\n"
   "				this.svInnerHTML = this.innerHTML;\n"
   "\n"
   "				if(this.outTp == \"b\") {\n"
   "				    tVl = (elTbl.getVal(this.parentNode.rowIndex-1,this.cellIndex-1) == \"true\");\n"
   "				    this.innerHTML = \"<input type='checkbox'/>\";\n"
   "				    this.firstChild.checked = tVl;\n"
   "				    this.firstChild.onclick = function( ) {\n"
   "					this.parentNode.offsetParent.setVal((this.checked?1:0),\n"
   "					    this.parentNode.parentNode.rowIndex-1, this.parentNode.cellIndex-1);\n"
   "				    }\n"
   "				}\n"
   "				else if(this.outTp == \"i\" || this.outTp == \"r\" || this.outTp == \"s\") {\n"
   "				    tVl = elTbl.getVal(this.parentNode.rowIndex-1, this.cellIndex-1);\n"
   "				    this.innerHTML = \"<input/>\";\n"
   "				    this.firstChild.value = tVl;\n"
   "				    this.firstChild.onkeyup = function(e) {\n"
   "					e = e ? e : window.event;\n"
   "					if(e.keyCode == 13)\n"
   "					    this.parentNode.offsetParent.setVal(this.value, this.parentNode.parentNode.rowIndex-1, this.parentNode.cellIndex-1);\n"
   "					if(e.keyCode == 27) {\n"
   "					    this.parentNode.isEnter = false; this.parentNode.offsetParent.edIt = null;\n"
   "					    this.parentNode.innerHTML = this.parentNode.svInnerHTML;\n"
   "					}\n"
   "					return true;\n"
   "				    }\n"
   "				} else { this.isEnter = false; elTbl.edIt = null; }\n"
   "			    }\n"
   "			    //   Prevent for wrong selection\n"
   "			    if(window.getSelection) window.getSelection().removeAllRanges();\n"
   "			    else if(document.selection) document.selection.empty();\n"
   "			    return false;\n"
   "			}\n"
   "			formObj.selIt = function( row, col ) {\n"
   "			    //Restore saved\n"
   "			    if(this.svRow || this.svCol) {\n"
   "				if(!this.svRow)\n"
   "				    this.tHead.rows[0].cells[this.svCol].style.backgroundColor =\n"
   "						this.tHead.rows[0].cells[this.svCol].svBackgroundColor;\n"
   "				for(iR = (this.svRow?this.svRow-1:0); iR <= (this.svRow?this.svRow-1:this.tBodies[0].rows.length-1); iR++)\n"
   "				    for(iC = (this.svCol?this.svCol:0); iC <= (this.svCol?this.svCol:(this.tBodies[0].rows[iR].cells.length-1)); iC++)\n"
   "					this.tBodies[0].rows[iR].cells[iC].style.backgroundColor =\n"
   "						this.tBodies[0].rows[iR].cells[iC].svBackgroundColor;\n"
   "			    }\n"
   "			    //Set new\n"
   "			    if(row || col) {\n"
   "				if(!row) {\n"
   "				    this.tHead.rows[0].cells[col].svBackgroundColor = this.tHead.rows[0].cells[col].style.backgroundColor;\n"
   "				    this.tHead.rows[0].cells[col].style.backgroundColor = \"LightBlue\";\n"
   "				}\n"
   "				for(iR = (row?row-1:0); iR <= (row?row-1:this.tBodies[0].rows.length-1); iR++)\n"
   "				    for(iC = (col?col:0); iC <= (col?col:this.tBodies[0].rows[iR].cells.length-1); iC++) {\n"
   "					this.tBodies[0].rows[iR].cells[iC].svBackgroundColor = this.tBodies[0].rows[iR].cells[iC].style.backgroundColor;\n"
   "					this.tBodies[0].rows[iR].cells[iC].style.backgroundColor = \"LightBlue\";\n"
   "				    }\n"
   "			    }\n"
   "			    this.svRow = row; this.svCol = col;\n"
   "			}\n"
   "			formObj.getVal = function( row, col ) {\n"
   "			    tit = this.tBodies[0].rows[row].cells[col+1];\n"
   "			    return tit.children.length ? tit.innerText.slice(1) : tit.innerText;\n"
   "			}\n"
   "			formObj.setVal = function( val, row, col ) {\n"
   "			    tit = this.tBodies[0].rows[row].cells[col+1];\n"
   "			    if(tit.isEnter) {\n"
   "				tit.innerHTML = tit.svInnerHTML;\n"
   "				attrs = new Object(); attrs.set = val; attrs.event = \"ws_TableEdit_\"+col+\"_\"+row;\n"
   "				setWAttrs(this.wdgLnk.addr, attrs);\n"
   "				tit.isEnter = false; this.edIt = null;\n"
   "			    }\n"
   "			    else {\n"
   "				switch(tit.outTp) {\n"
   "				    case 'b': val = parseInt(val) ? \"true\" : \"false\";	break;\n"
   "				    case 'i': val = parseInt(val);	break;\n"
   "				    case 'r': val = parseFloat(val);	break;\n"
   "				}\n"
   "				tit.innerText = val;\n"
   "			    }\n"
   "			}\n"
   "		    }\n"
   "		    if(toInit || this.attrsMdf['geomZ']) formObj.tabIndex = parseInt(this.attrs['geomZ'])+1;\n"
   "		    if(toInit || this.attrsMdf['font'])  formObj.style.cssText = 'font: '+this.place.fontCfg+'; ';\n"
   "		    // Processing for fill and changes\n"
   "		    if(toInit || this.attrsMdf['items']) {\n"
   "			hdrPresent = false, maxCols = 0, maxRows = 0;\n"
   "			items = (new DOMParser()).parseFromString(this.attrs['items'], \"text/xml\");\n"
   "			if(!items.children.length || (tX=items.children[0]).nodeName != \"tbl\") formObj.innerHTML = \"\";\n"
   "			else {\n"
   "			    if(toInit || !formObj.children.length) formObj.innerHTML = \"<THEAD><TR/></THEAD><TBODY/>\";\n"
   "			    rClr = null, rClrTxt = null, rFnt = null;\n"
   "			    for(iR = 0, iRR = 0, iCh = 0; iCh < tX.children.length || iR < formObj.tBodies[0].rows.length; iCh++) {\n"
   "				tR = (iCh < items.children[0].children.length) ? items.children[0].children[iCh] : null;\n"
   "				isH = false, hit = null, tit = null;\n"
   "				if(tR && !((isH=(tR.nodeName==\"h\")) || tR.nodeName == \"r\")) continue;\n"
   "				if(!isH && iR >= formObj.tBodies[0].rows.length)\n"
   "				    formObj.tBodies[0].appendChild(this.place.ownerDocument.createElement('tr'));\n"
   "				if(!isH && tR) { rClr = tR.getAttribute(\"color\"); rClrTxt = tR.getAttribute(\"colorText\"); rFnt = tR.getAttribute(\"font\"); }\n"
   "				for(iC = 0, iCR = 0, iCh1 = 0; (tR && iCh1 < tR.children.length) || iC < formObj.tHead.children.length; ) {\n"
   "				    tC = (tR && iCh1 < tR.children.length) ? tR.children[iCh1] : null;\n"
   "				    if(iC >= formObj.tHead.rows[0].cells.length)\n"
   "					formObj.tHead.rows[0].appendChild(this.place.ownerDocument.createElement('th'));\n"
   "				    hit = formObj.tHead.rows[0].cells[iC];\n"
   "				    hit.onclick = formObj.onclick;\n"
   "				    if(isH) {	//Header process\n"
   "					if(iC == 0) { hit.innerText = '*'; iC++; continue; }\n"
   "					hit.innerText = tC ? tC.textContent : \"\";\n"
   "					if(tC) {\n"
   "					    if(!(wVl=tC.getAttribute(\"width\"))) hit.style.width = \"\"\n"
   "					    else if(wVl.indexOf(\"%\") >= 0)	hit.style.width = parseInt(wVl) + \"%\";\n"
   "					    else hit.style.width = (parseInt(wVl)*xSc) + \"px\";\n"
   "					    hit.outEdit = parseInt(tC.getAttribute(\"edit\"));\n"
   "					    hit.outColor = tC.getAttribute(\"color\");\n"
   "					    hit.outColorText = tC.getAttribute(\"colorText\");\n"
   "					    hit.outFont = tC.getAttribute(\"font\");\n"
   "					    hit.style.display = (hit.style.width.length && !parseInt(hit.style.width)) ? \"none\" : \"\";\n"
   "					    //if((wVl=tC.getAttribute(\"sort\")))	{ sortCol = i_c+1; if(!parseInt(wVl)) sortCol *= -1; }\n"
   "					}\n"
   "				    }\n"
   "				    else {	//Rows content process\n"
   "					if(iC >= formObj.tBodies[0].rows[iR].cells.length)\n"
   "					    formObj.tBodies[0].rows[iR].appendChild(this.place.ownerDocument.createElement(iC==0?'th':'td'));\n"
   "					tit = formObj.tBodies[0].rows[iR].cells[iC];\n"
   "					tit.onclick = formObj.onclick;\n"
   "					if(iC == 0) { tit.innerText = iR+1; iC++; continue; }\n"
   "					else tit.ondblclick = formObj.ondblclick;\n"
   "					// Value\n"
   "					if(tC) { tit.outTp = tC.nodeName; formObj.setVal(tC.textContent, iR, iC-1); }\n"
   "					// Visibility\n"
   "					tit.style.display = (hit.style.width.length && !parseInt(hit.style.width)) ? \"none\" : \"\";\n"
   "					// Back color\n"
   "					if((tC && (wVl=tC.getAttribute(\"color\"))) || (wVl=hit.outColor) || (wVl=rClr))\n"
   "					    tit.style.backgroundColor = getColor(wVl);\n"
   "					else tit.style.backgroundColor = null;\n"
   "					// Text font and color\n"
   "					if((tC && (wVl=tC.getAttribute(\"colorText\"))) || (wVl=hit.outColorText) || (wVl=rClrTxt))\n"
   "					    tit.style.color = getColor(wVl);\n"
   "					else tit.style.color = null;\n"
   "					if((tC && (wVl=tC.getAttribute(\"font\"))) || (wVl=hit.outFont) || (wVl=rFnt))\n"
   "					    tit.style.font = getFontCond(wVl, Math.min(xSc,ySc));\n"
   "					else tit.style.font = null;\n"
   "					// Cell image\n"
   "					if(tC && (wVl=tC.getAttribute(\"img\")))\n"
   "					    tit.innerHTML = \"<img src='/\"+MOD_ID+this.addr+\"?com=res&val=\"+wVl+\"'/> \" + tit.innerText;\n"
   "					// Modify set\n"
   "					if(hit.outEdit || (tC && (wVl=tC.getAttribute(\"edit\")) && parseInt(wVl))) tit.isEdit = true;\n"
   "					else tit.isEdit = false;\n"
   "				    }\n"
   "				    if(tC)	{ ++iCR; maxCols = Math.max(maxCols, iCR); }\n"
   "				    iC++; iCh1++;\n"
   "				}\n"
   "				if(!isH) {\n"
   "				    if(tR)	{ ++iRR; maxRows = Math.max(maxRows, iRR); }\n"
   "				    iR++;\n"
   "				} else hdrPresent = true;\n"
   "			    }\n"
   "			    // Generic properties set\n"
   "			    formObj.oKeyID = (wVl=tX.getAttribute(\"keyID\")) ? parseInt(wVl) : 0;\n"
   "			    formObj.oSel = tX.getAttribute(\"sel\");\n"
   "			    if(formObj.oSel == \"row\" && formObj.oKeyID)		formObj.oKeyID = Math.min(formObj.oKeyID, maxCols-1);\n"
   "			    else if(formObj.oSel == \"col\" && formObj.oKeyID)	formObj.oKeyID = Math.min(formObj.oKeyID, maxRows-1);\n"
   "\n"
   "			    // Remove spare rows and columns; Headers visibility process\n"
   "			    formObj.tHead.rows[0].style.display =\n"
   "				(!(wVl=tX.getAttribute(\"hHdrVis\")) || !wVl.length || parseInt(wVl)) ? \"\" : \"none\";\n"
   "			    while(formObj.tHead.rows[0].cells.length > (maxCols+1))\n"
   "				formObj.tHead.rows[0].removeChild(formObj.tHead.rows[0].lastChild);\n"
   "			    wVl = (wVl=tX.getAttribute(\"vHdrVis\")) ? parseInt(wVl) : false;\n"
   "			    formObj.tHead.rows[0].cells[0].style.display = wVl ? \"\" : \"none\";\n"
   "			    for(iR = 0; iR < formObj.tBodies[0].rows.length; iR++) {\n"
   "				tR = formObj.tBodies[0].rows[iR];\n"
   "				if(tR.cells.length) tR.cells[0].style.display = wVl ? \"\" : \"none\";\n"
   "				while(tR.cells.length > (maxCols+1)) tR.removeChild(tR.lastChild);\n"
   "			    }\n"
   "			    while(formObj.tBodies[0].rows.length > maxRows)\n"
   "				formObj.tBodies[0].removeChild(formObj.tBodies[0].lastChild);\n"
   "\n"
   "			    formObj.style.width = ((wVl=tX.getAttribute(\"colsWdthFit\")) && parseInt(wVl)) ? \"100%\" : \"\";\n"
   "			}\n"
   "		    }\n"
   "		    if(toInit) this.place.appendChild(formObj);\n"
   "		    // Set the value\n"
   "		    if((toInit || this.attrsMdf['value'] || this.attrsMdf['items']) && formObj.innerHTML.length) {\n"
   "			val = this.attrs['value'];\n"
   "			if(formObj.oSel == \"row\" || formObj.oSel == \"col\" || formObj.oSel == \"cell\") {\n"
   "			    findOK = false;\n"
   "			    for(iR = ((formObj.oSel==\"col\")?formObj.oKeyID:0);\n"
   "				    !findOK && iR <= ((formObj.oSel==\"col\")?formObj.oKeyID:formObj.tBodies[0].rows.length-1); iR++)\n"
   "				for(iC = ((formObj.oSel==\"row\")?formObj.oKeyID+1:1);\n"
   "					!findOK && iC <= ((formObj.oSel==\"row\")?formObj.oKeyID+1:(formObj.tBodies[0].rows[iR].cells.length-1)); iC++) {\n"
   "				    cO = formObj.tBodies[0].rows[iR].cells[iC];\n"
   "				    valc = formObj.getVal(iR, iC-1); if(cO.outTp == \"b\") valc = (valc==\"true\") ? 1 : 0;\n"
   "				    if((findOK=(valc==val))) formObj.selIt(((formObj.oSel==\"col\")?null:iR+1), ((formObj.oSel==\"row\")?null:iC));\n"
   "				}\n"
   "			    if(!findOK) formObj.selIt();\n"
   "			} else if((sepPos=val.indexOf(\":\")) > 0) formObj.selIt(parseInt(val.slice(0,sepPos))+1, parseInt(val.slice(sepPos+1))+1);\n"
   "		    }\n"
   "		    break;\n"
   "	    }\n"
   "	}\n"
   "	else if(this.attrs['root'] == 'Diagram') {\n"
   "	    elStyle += 'border-style: solid; border-width: '+this.attrs['bordWidth']+'px; ';\n"
   "	    var anchObj = this.place.childNodes[0];\n"
   "	    if(!anchObj) {\n"
   "		anchObj = this.place.ownerDocument.createElement('a');\n"
   "		anchObj.wdgLnk = this;\n"
   "		var dgrObj = this.place.ownerDocument.createElement('img');\n"
   "		dgrObj.border = 0;\n"
   "		anchObj.appendChild(dgrObj); this.place.appendChild(anchObj);\n"
   "	    }\n"
   "	    anchObj.isActive = elWr;\n"
   "	    anchObj.href = '#';\n"
   "	    anchObj.tabIndex = parseInt(this.attrs['geomZ'])+1;\n"
   "	    anchObj.onfocus = function( ) { if(this.isActive) setFocus(this.wdgLnk.addr); }\n"
   "	    anchObj.onkeydown = function(e) { if(this.isActive) setWAttrs(this.wdgLnk.addr,'event','key_pres'+evKeyGet(e?e:window.event)); }\n"
   "	    anchObj.onkeyup = function(e) { if(this.isActive) setWAttrs(this.wdgLnk.addr,'event','key_rels'+evKeyGet(e?e:window.even)); }\n"
   "	    anchObj.onclick = function(e) {\n"
   "		if(!this.isActive) return false;\n"
   "		if(!e) e = window.event;\n"
   "		servSet(this.wdgLnk.addr,'com=obj&sub=point&x='+(e.offsetX?e.offsetX:(e.clientX-posGetX(this)))+\n"
   "							  '&y='+(e.offsetY?e.offsetY:(e.clientY-posGetY(this)))+\n"
   "							  '&key='+evMouseGet(e),'');\n"
   "		setFocus(this.wdgLnk.addr);\n"
   "		return false;\n"
   "	    }\n"
   "	    var dgrObj = anchObj.childNodes[0];\n"
   "	    dgrObj.isLoad = false;\n"
   "	    dgrObj.onload = function( )	{ this.isLoad = true; }\n"
   "	    dgrObj.src = '/'+MOD_ID+this.addr+'?com=obj&tm='+tmCnt+'&xSc='+xSc.toFixed(3)+'&ySc='+ySc.toFixed(3);\n"
   "	    //Disable drag mostly for FireFox\n"
   "	    dgrObj.onmousedown = function(e) { e = e?e:window.event; if(e.preventDefault) e.preventDefault(); }\n"
   "	    this.perUpdtEn(this.isEnabled() && parseInt(this.attrs['trcPer']));\n"
   "	}\n"
   "	else if(this.attrs['root'] == 'Protocol') {\n"
   "	    if(!this.attrs['backColor'] || !getColor(this.attrs['backColor'],true)) elStyle += 'background-color: white; ';\n"
   "	    elStyle += 'border: 1px solid black; overflow: auto; padding: 2px; text-align: left; ';\n"
   "	    geomW -= 6; geomH -= 6;\n"
   "\n"
   "	    this.wFont = getFont(this.attrs['font'],Math.min(xSc,ySc));\n"
   "\n"
   "	    if(!this.place.firstChild) {\n"
   "		this.place.appendChild(document.createElement('table'));\n"
   "		this.place.firstChild.setAttribute('width','100%');\n"
   "		this.place.firstChild.wdgLnk = this;\n"
   "		this.place.firstChild.isActive = elWr;\n"
   "		this.place.firstChild.onclick = function(e) {\n"
   "		    if(this.isActive) setFocus(this.wdgLnk.addr);\n"
   "		    return false;\n"
   "		}\n"
   "		this.place.firstChild.className='prot';\n"
   "		this.loadData = function( ) {\n"
   "		    if(!this.tmPrev) this.tmPrev = 0;\n"
   "		    if(!this.tmGrndPrev) this.tmGrndPrev = 0;\n"
   "\n"
   "		    var tblB = this.place.firstChild;\n"
   "\n"
   "		    //Get archive parameters\n"
   "		    var tTime = parseInt(this.attrs['time']);\n"
   "		    var tTimeCurent = false;\n"
   "		    if(!tTime) {\n"
   "			tTimeCurent = true;\n"
   "			tTime = (new Date()).getTime()/1000;\n"
   "		    }\n"
   "		    var srcTime = tTime;\n"
   "		    var tTimeGrnd = tTime - parseInt(this.attrs['tSize']);\n"
   "\n"
   "		    if(this.curCols != this.attrs['col'] || this.curArch != this.attrs['arch'] || this.curTmpl != this.attrs['tmpl'] ||\n"
   "			this.curLev != this.attrs['lev'] || this.headVis != this.attrs['headVis'])\n"
   "		    {\n"
   "			this.arhBeg = this.arhEnd = 0;\n"
   "			this.messList = new Array();\n"
   "\n"
   "			this['col_pos'] = this['col_tm'] = this['col_utm'] = this['col_lev'] = this['col_cat'] = this['col_mess'] = -1;\n"
   "			this.curCols = this.attrs['col'];\n"
   "			this.curArch = this.attrs['arch'];\n"
   "			this.curTmpl = this.attrs['tmpl'];\n"
   "			this.curLev = this.attrs['lev'];\n"
   "			this.headVis = this.attrs['headVis'];\n"
   "			while(tblB.childNodes.length) tblB.removeChild(tblB.lastChild);\n"
   "			var rowEl = document.createElement('tr');\n"
   "			tblB.appendChild(rowEl);\n"
   "			var colCfg = '';\n"
   "			var clm = this.curCols.split(';');\n"
   "			for(var c_off = 0; c_off < clm.length; c_off++) {\n"
   "			    if(!parseInt(this.attrs['headVis'])) colCfg += \"<th style='display: none' />\";\n"
   "			    else colCfg += \"<th ind='\"+clm[c_off]+\"' \"+\n"
   "						\"style='\"+this.wFont+\"'>\"+((clm[c_off]=='pos') ? '#' :\n"
   "						    (clm[c_off]=='tm') ? '###Date and time###' :\n"
   "						    (clm[c_off]=='utm') ? '###mcsec###' :\n"
   "						    (clm[c_off]=='lev') ? '###Level###' :\n"
   "						    (clm[c_off]=='cat') ? '###Category###' :\n"
   "						    (clm[c_off]=='mess') ? '###Message###' : '')+\"</th>\";\n"
   "			    this['col_'+clm[c_off]] = c_off;\n"
   "			}\n"
   "			rowEl.innerHTML = colCfg;\n"
   "		    }\n"
   "\n"
   "		    if(parseInt(this.curLev) < 0) this.messList = new Array();\n"
   "		    else {\n"
   "			if(!this.arhBeg || !this.arhEnd || !tTime || tTime > this.arhEnd || tTimeCurent) {\n"
   "			    var rez = servSet('/Archive/%2fserv%2fmess','com=com',\"<info arch='\"+this.curArch+\"'/>\",true);\n"
   "			    if(!rez || parseInt(rez.getAttribute('rez')) != 0)	this.arhBeg = this.arhEnd = 0;\n"
   "			    else {\n"
   "				this.arhBeg = parseInt(rez.getAttribute('beg'));\n"
   "				this.arhEnd = parseInt(rez.getAttribute('end'));\n"
   "				if(!tTime) { tTime = this.arhEnd; tTimeGrnd += tTime; }\n"
   "			    }\n"
   "			}\n"
   "			if(!this.arhBeg || !this.arhEnd) return;\n"
   "\n"
   "			//Correct request to archive border\n"
   "			tTime = tTimeCurent ? this.arhEnd : Math.min(tTime,this.arhEnd);\n"
   "			tTimeGrnd = Math.max(tTimeGrnd, this.arhBeg);\n"
   "		    }\n"
   "\n"
   "		    //Clear data at time error\n"
   "		    var valEnd = 0; var valBeg = 0;\n"
   "		    while(this.messList.length && (valEnd=this.messList[0][0]) > tTime) this.messList.shift();\n"
   "		    while(this.messList.length && (valBeg=this.messList[this.messList.length-1][0]) < tTimeGrnd) this.messList.pop();\n"
   "\n"
   "		    if(!this.messList.length) valEnd = valBeg = 0;\n"
   "\n"
   "		    if(tTime < tTimeGrnd || (tTime < valEnd && tTimeGrnd > valBeg)) {\n"
   "			this.messList = new Array();\n"
   "			while(tblB.childNodes.length > 1) tblB.removeChild(tblB.lastChild);\n"
   "			valEnd = valBeg = 0;\n"
   "			return;\n"
   "		    }\n"
   "\n"
   "		    //Correct request to present data\n"
   "		    var toUp = false, isDtChang = false;\n"
   "		    if(srcTime > this.tmPrev) { if(valEnd) tTimeGrnd = valEnd; toUp = true; }\n"
   "		    else if((srcTime-parseInt(this.attrs['tSize'])) < this.tmGrndPrev) { if(valBeg) tTime = valBeg-1; }\n"
   "		    else return;\n"
   "		    this.tmPrev = srcTime;\n"
   "		    this.tmGrndPrev = srcTime-parseInt(this.attrs['tSize']);\n"
   "\n"
   "		    var rez = servSet('/Archive/%2fserv%2fmess','com=com',\n"
   "			\"<get arch='\"+this.curArch+\"' tm='\"+tTime+\"' tm_grnd='\"+tTimeGrnd+\"' cat='\"+this.curTmpl+\"' lev='\"+this.curLev+\"' />\",true);\n"
   "		    if(!rez || parseInt(rez.getAttribute('rez')) != 0) return;\n"
   "\n"
   "		    if(toUp)\n"
   "			for(var i_req = 0; i_req < rez.childNodes.length; i_req++) {\n"
   "			    var rcd = rez.childNodes[i_req];\n"
   "			    var mess = new Array(parseInt(rcd.getAttribute('time')), parseInt(rcd.getAttribute('utime')),\n"
   "						    Math.abs(parseInt(rcd.getAttribute('lev'))), rcd.getAttribute('cat'), rcd.textContent);\n"
   "\n"
   "			    // Check for dublicates\n"
   "			    var isDbl = false;\n"
   "			    for(var i_p = 0; !isDbl && i_p < this.messList.length; i_p++) {\n"
   "				if(mess[0] > this.messList[0][0] && i_p) break;\n"
   "				if(this.messList[i_p][1] == mess[1] && this.messList[i_p][2] == mess[2] &&\n"
   "				    this.messList[i_p][3] == mess[3] && this.messList[i_p][4] == mess[4]) isDbl = true;\n"
   "			    }\n"
   "			    if(isDbl) continue;\n"
   "\n"
   "			    // Insert new row\n"
   "			    this.messList.unshift(mess);\n"
   "			    isDtChang = true;\n"
   "			}\n"
   "		    else\n"
   "			for(var i_req = rez.childNodes.length-1; i_req >= 0; i_req--) {\n"
   "			    var rcd = rez.childNodes[i_req];\n"
   "			    var mess = new Array(parseInt(rcd.getAttribute('time')), parseInt(rcd.getAttribute('utime')),\n"
   "						    Math.abs(parseInt(rcd.getAttribute('lev'))), rcd.getAttribute('cat'), rcd.textContent);\n"
   "\n"
   "			    // Check for dublicates\n"
   "			    var isDbl = false;\n"
   "			    for(var i_p = this.messList.length-1; !isDbl && i_p >= 0; i_p--) {\n"
   "				if(mess[0] < this.messList[this.messList.length-1][0] && i_p < (this.messList.length-1)) break;\n"
   "				if(this.messList[i_p][1] == mess[1] && this.messList[i_p][2] == mess[2] &&\n"
   "				    this.messList[i_p][3] == mess[3] && this.messList[i_p][4] == mess[4]) isDbl = true;\n"
   "			    }\n"
   "			    if(isDbl) continue;\n"
   "\n"
   "			    // Insert new row\n"
   "			    this.messList.push(mess);\n"
   "			    isDtChang = true;\n"
   "			}\n"
   "\n"
   "		    if((tblB.childNodes.length-1) == this.messList.length && !isDtChang) return;\n"
   "\n"
   "		    //Sort data\n"
   "		    var sortIts = new Array();\n"
   "		    switch(parseInt(this.attrs['viewOrd'])&0x3) {\n"
   "			case 0:\n"
   "			    for(var i_m = 0; i_m < this.messList.length; i_m++)\n"
   "				sortIts.push(this.messList[i_m][0]+' '+this.messList[i_m][1]+':'+i_m);\n"
   "			    break;\n"
   "			case 1:\n"
   "			    for(var i_m = 0; i_m < this.messList.length; i_m++)\n"
   "				sortIts.push(this.messList[i_m][2]+':'+i_m);\n"
   "			    break;\n"
   "			case 2:\n"
   "			    for(var i_m = 0; i_m < this.messList.length; i_m++)\n"
   "				sortIts.push(this.messList[i_m][3]+':'+i_m);\n"
   "			    break;\n"
   "			case 3:\n"
   "			    for(var i_m = 0; i_m < this.messList.length; i_m++)\n"
   "				sortIts.push_back(this.messList[i_m][4]+':'+i_m);\n"
   "			    break;\n"
   "		    }\n"
   "\n"
   "		    sortIts.sort();\n"
   "		    if(parseInt(this.attrs['viewOrd'])&0x4) sortIts.reverse();\n"
   "\n"
   "		    //Write to the table\n"
   "		    for(var i_m = 0; i_m < sortIts.length; i_m++) {\n"
   "			var rowEl = (i_m>=(tblB.childNodes.length-1)) ? document.createElement('tr') : tblB.childNodes[i_m+1];\n"
   "			var elPos = parseInt(sortIts[i_m].slice(sortIts[i_m].lastIndexOf(':')+1));\n"
   "\n"
   "			var rowFnt = this.wFont;\n"
   "			var rowColor = '';\n"
   "\n"
   "			// Check properties\n"
   "			for(var i_it = 0, lst_lev = -1; i_it < parseInt(this.attrs['itProp']); i_it++) {\n"
   "			    var prpLev = parseInt(this.attrs['it'+i_it+'lev']);\n"
   "			    if(this.messList[elPos][2] >= prpLev && prpLev > lst_lev &&\n"
   "				    chkPattern(this.messList[elPos][3],this.attrs['it'+i_it+'tmpl']))\n"
   "			    {\n"
   "				var tRowFnt = getFont(this.attrs['it'+i_it+'fnt'],Math.min(xSc,ySc));\n"
   "				if(tRowFnt.length) rowFnt = tRowFnt;\n"
   "				rowColor = 'background-color: '+getColor(this.attrs['it'+i_it+'color'])+'; ';\n"
   "				if(this.messList[elPos][2] == parseInt(this.attrs['it'+i_it+'lev'])) break;\n"
   "				lst_lev = prpLev;\n"
   "			    }\n"
   "			}\n"
   "			//if( rowColor.length ) fclr = ((0.3*clr.red()+0.59*clr.green()+0.11*clr.blue()) > 128) ? Qt::black : Qt::white;\n"
   "			rowEl.style.cssText = rowFnt+rowColor;\n"
   "\n"
   "			for(var i_cel = 0; i_cel < tblB.childNodes[0].childNodes.length; i_cel++) {\n"
   "			    var celEl = (i_cel>=rowEl.childNodes.length) ? document.createElement('td') : rowEl.childNodes[i_cel];\n"
   "			    if(this.col_pos == i_cel) { celEl.textContent = i_m; celEl.style.cssText += ' text-align: center; '; }\n"
   "			    else if(this.col_tm == i_cel) {\n"
   "				var dt = new Date(this.messList[elPos][0]*1000);\n"
   "				celEl.textContent = dt.getDate()+'.'+(dt.getMonth()+1)+'.'+dt.getFullYear()+' '+dt.getHours()+':'+\n"
   "				    ((dt.getMinutes()<10)?('0'+dt.getMinutes()):dt.getMinutes())+':'+((dt.getSeconds()<10)?('0'+dt.getSeconds()):dt.getSeconds());\n"
   "			    }\n"
   "			    else if(this.col_utm == i_cel)	celEl.textContent = this.messList[elPos][1];\n"
   "			    else if(this.col_lev == i_cel)	celEl.textContent = this.messList[elPos][2];\n"
   "			    else if(this.col_cat == i_cel)	celEl.textContent = this.messList[elPos][3];\n"
   "			    else if(this.col_mess == i_cel)	celEl.textContent = this.messList[elPos][4];\n"
   "			    if(i_cel >= rowEl.childNodes.length) rowEl.appendChild(celEl);\n"
   "			}\n"
   "			if(i_m >= (tblB.childNodes.length-1)) tblB.appendChild(rowEl);\n"
   "		    }\n"
   "		    while((tblB.childNodes.length-1) > sortIts.length) tblB.removeChild(tblB.lastChild);\n"
   "		}\n"
   "	    }\n"
   "\n"
   "	    if(this.isEnabled() && parseInt(this.attrs['trcPer'])) this.perUpdtEn(true);\n"
   "	    else { this.perUpdtEn(false); this.loadData(); }\n"
   "	}\n"
   "	else if(this.attrs['root'] == 'Document') {\n"
   "	    elStyle += 'background-color: white; ';\n"
   "\n"
   "	    if(this.attrsMdf[\"style\"] || this.attrsMdf[\"font\"] ||\n"
   "		(this.attrsMdf[\"doc\"] && this.attrs[\"doc\"].length) || (this.attrsMdf[\"tmpl\"] && !this.attrs[\"doc\"].length))\n"
   "	    {\n"
   "		this.wFont = getFont(this.attrs['font'],Math.min(xSc,ySc),1);\n"
   "\n"
   "		var ifrmObj = this.place.childNodes[0];\n"
   "		try {\n"
   "		    if(ifrmObj && (!ifrmObj.contentDocument || document.URL != ifrmObj.contentDocument.URL))\n"
   "		    { this.place.removeChild(ifrmObj); ifrmObj = null; }\n"
   "		}catch(e) { this.place.removeChild(ifrmObj); ifrmObj = null; }\n"
   "		if(!ifrmObj) {\n"
   "		    ifrmObj = this.place.ownerDocument.createElement('iframe');\n"
   "		    this.place.appendChild(ifrmObj);\n"
   "		}\n"
   "\n"
   "		ifrmObj.style.cssText = 'width: '+geomW+'px; height: '+geomH+'px; border-style: ridge; border-width: 0px; padding: 0px;';\n"
   "		//ifrmObj.style.cssText = 'width: '+(geomW-14)+'px; height: '+(geomH-14)+'px; border-style: ridge; border-width: 2px; padding: 5px;';\n"
   "		this.perUpdtEn(true);\n"
   "	    }\n"
   "	}\n"
   "	elStyle += 'width: ' + geomW + 'px; height: ' + geomH + 'px; z-index: ' + this.attrs['geomZ'] + '; margin: ' + elMargin + 'px; ';\n"
   "	//Scroll for the included containers correct\n"
   "	if(this.inclOpen) {\n"
   "	    var geomWpar = parseFloat(this.attrs['geomW'])*this.xScale(true);\n"
   "	    var geomHpar = parseFloat(this.attrs['geomH'])*this.yScale(true);\n"
   "	    var geomWch = parseFloat(this.pages[this.inclOpen].attrs['geomW'])*this.pages[this.inclOpen].xScale(true);\n"
   "	    var geomHch = parseFloat(this.pages[this.inclOpen].attrs['geomH'])*this.pages[this.inclOpen].yScale(true);\n"
   "	    elStyle += \"overflow: \"+((geomWch > geomWpar || geomHch > geomHpar) ? 'scroll' : 'hidden')+\"; \";\n"
   "	}\n"
   "	else if(isPrim) {\n"
   "	    // Border processing in generic\n"
   "	    if(this.attrs['bordColor']) elStyle += 'border-color: '+getColor(this.attrs['bordColor'])+'; ';\n"
   "	    switch(parseInt(this.attrs['bordStyle'])) {\n"
   "		case 1: elStyle += 'border-style: dotted; '; break;\n"
   "		case 2: elStyle += 'border-style: dashed; '; break;\n"
   "		case 3: elStyle += 'border-style: solid; ';  break;\n"
   "		case 4: elStyle += 'border-style: double; '; break;\n"
   "		case 5: elStyle += 'border-style: groove; '; break;\n"
   "		case 6: elStyle += 'border-style: ridge; ';  break;\n"
   "		case 7: elStyle += 'border-style: inset; ';  break;\n"
   "		case 8: elStyle += 'border-style: outset; '; break;\n"
   "	    }\n"
   "	    // Background processing in generic\n"
   "	    backStyle = \"\";\n"
   "	    if(this.attrs['backColor'] && (backOp=getColor(this.attrs['backColor'],true))) {\n"
   "		if(backOp == 1) {\n"
   "		    backStyle += 'background-color: '+getColor(this.attrs['backColor'])+'; ';\n"
   "		    if(this.placeTr) this.placeTr.style.cssText = elStyle;\n"
   "		}\n"
   "		else {\n"
   "		    if(!this.placeTr) {\n"
   "			this.placeTr = this.place.ownerDocument.createElement('div');\n"
   "			this.place.parentNode.appendChild(this.placeTr);\n"
   "		    }\n"
   "		    this.placeTr.style.cssText = elStyle + 'background-color: '+getColor(this.attrs['backColor'])+'; opacity: '+backOp+\"; z-index: \"+(parseInt(this.attrs['geomZ'])-1)+\"; \";\n"
   "		}\n"
   "	    }\n"
   "	    if(this.attrs['backImg'])	backStyle += 'background-image: url(\\'/'+MOD_ID+this.addr+'?com=res&val='+this.attrs['backImg']+'\\'); ';\n"
   "	    elStyle += backStyle;\n"
   "	    if(this == masterPage) document.body.style.cssText = parseInt(this.attrs['bordWidth']) ? '' : backStyle;\n"
   "	}\n"
   "\n"
   "	if(elStyle != this.place.style.cssText)	this.place.style.cssText = elStyle;\n"
   "\n"
   "	//Generic mouse events process\n"
   "	if(elWr) {\n"
   "	    //console.log(this.addr+\": TEST 03: mDownCnt=\"+this.mDownCnt);\n"
   "	    this.mousedown[this.mousedown.length] = function(e,el) {\n"
   "		if(!e) e = window.event;\n"
   "		setWAttrs(el.wdgLnk.addr,'event','key_mousePres'+evMouseGet(e));\n"
   "	    }\n"
   "	    this.mouseup[this.mouseup.length] = function(e,el) {\n"
   "		if(!e) e = window.event;\n"
   "		setWAttrs(el.wdgLnk.addr,'event','key_mouseRels'+evMouseGet(e));\n"
   "	    }\n"
   "	    this.place.ondblclick = function(e) { setWAttrs(this.wdgLnk.addr,'event','key_mouseDblClick'); return false; }\n"
   "	} else this.place.ondblclick = '';\n"
   "\n"
   "	//Context menu setup\n"
   "	if(elWr && this.attrs['contextMenu'].length) {\n"
   "	    var ctxEv = function(e,el) {\n"
   "		var cel = el ? el : this;\n"
   "		if(!e) e = window.event;\n"
   "		if((isKonq || isOpera) && evMouseGet(e) != 'Right') return true;\n"
   "		var popUpMenu = getPopup();\n"
   "		var optEl = '';\n"
   "		var cntxEls = cel.wdgLnk.attrs['contextMenu'].split('\\n');\n"
   "		for(var i_ce = 0; i_ce < cntxEls.length; i_ce++)\n"
   "		    optEl += \"<option sign='\"+cntxEls[i_ce].split(':')[1]+\"'>\"+cntxEls[i_ce].split(':')[0]+\"</option>\";\n"
   "		popUpMenu.childNodes[0].innerHTML = optEl;\n"
   "		if(popUpMenu.childNodes[0].childNodes.length) {\n"
   "		    popUpMenu.childNodes[0].wdgLnk = cel.wdgLnk;\n"
   "		    popUpMenu.childNodes[0].size = Math.max(3,popUpMenu.childNodes[0].childNodes.length);\n"
   "		    popUpMenu.style.cssText = 'visibility: visible; left: '+(e.clientX+window.pageXOffset)+'px; top: '+(e.clientY+window.pageYOffset)+'px;';\n"
   "		    popUpMenu.childNodes[0].selectedIndex = -1;\n"
   "		    popUpMenu.childNodes[0].onclick = function( ) {\n"
   "			this.parentNode.style.cssText = 'visibility: hidden; left: -200px; top: -200px;';\n"
   "			if(this.selectedIndex < 0) return false;\n"
   "			setWAttrs(this.wdgLnk.addr,'event','usr_'+this.options[this.selectedIndex].getAttribute('sign'));\n"
   "			return false;\n"
   "		    }\n"
   "		}\n"
   "		return false;\n"
   "	    }\n"
   "	    if(isKonq || isOpera) this.mousedown[this.mousedown.length] = ctxEv;\n"
   "	    else this.place.oncontextmenu = ctxEv;\n"
   "	}\n"
   "	else if(elWr) this.place.oncontextmenu = function(e) { return false; };\n"
   "	else this.place.oncontextmenu = null;\n"
   "\n"
   "	//Common mouse events process\n"
   "	if(this.mousedown.length)\n"
   "	    this.place.onmousedown = function(e) {\n"
   "		for(var i_on = 0; i_on < this.wdgLnk.mousedown.length; i_on++)\n"
   "		    this.wdgLnk.mousedown[i_on](e, this);\n"
   "		return true;\n"
   "	    }\n"
   "	else delete this.mousedown;\n"
   "	if(this.mouseup.length)\n"
   "	    this.place.onmouseup = function(e) {\n"
   "		for(var i_on = 0; i_on < this.wdgLnk.mouseup.length; i_on++)\n"
   "		    this.wdgLnk.mouseup[i_on](e,this);\n"
   "		return true;\n"
   "	    }\n"
   "	else delete this.mouseup;\n"
   "\n"
   "	this.place.elWr = elWr;\n"
   "    }\n"
   "    if(margBrdUpd || this.attrsMdf[\"geomXsc\"] || this.attrsMdf[\"geomYsc\"]) for(var i in this.wdgs) this.wdgs[i].makeEl();\n"
   "    this.place.setAttribute('title',this.attrs['tipTool']);\n"
   "    this.place.onmouseover = function(e) {\n"
   "	if(this.wdgLnk.attrs['tipStatus']) {\n"
   "	    setStatus(this.wdgLnk.attrs['tipStatus'], 10000);\n"
   "	    e.stopPropagation();\n"
   "	}\n"
   "    };\n"
   "\n"
   "    //Delete child widgets check\n"
   "    if(FullTree && pgBr)\n"
   "	for(var i in this.wdgs) {\n"
   "	    var j;\n"
   "	    for(j = 0; j < pgBr.childNodes.length; j++)\n"
   "		if(pgBr.childNodes[j].nodeName == 'w' && pgBr.childNodes[j].getAttribute('id') == i)\n"
   "		    break;\n"
   "	    if(j >= pgBr.childNodes.length) {\n"
   "		this.wdgs[i].place.parentNode.removeChild(this.wdgs[i].place);\n"
   "		delete this.wdgs[i];\n"
   "	    }\n"
   "	}\n"
   "\n"
   "    //Child widgets process\n"
   "    if(pgBr && !inclPg && parseInt(this.attrs['perm'])&SEC_RD)\n"
   "	for(var j = 0; j < pgBr.childNodes.length; j++) {\n"
   "	    if(pgBr.childNodes[j].nodeName != 'w') continue;\n"
   "	    var chEl = pgBr.childNodes[j].getAttribute('id');\n"
   "	    if(this.wdgs[chEl]) this.wdgs[chEl].makeEl(pgBr.childNodes[j], false, full, FullTree);\n"
   "	    else {\n"
   "		var wdgO = new pwDescr(this.addr+'/wdg_'+chEl, false, this);\n"
   "		wdgO.place = this.place.ownerDocument.createElement('div');\n"
   "		this.place.appendChild(wdgO.place);\n"
   "		this.wdgs[chEl] = wdgO;\n"
   "		wdgO.makeEl(full?pgBr.childNodes[j]:servGet(wdgO.addr,'com=attrsBr'));\n"
   "		//wdgO.makeEl(pgBr.childNodes[j]);		//!!!! Need full\n"
   "	    }\n"
   "	}\n"
   "}\n"
   "\n"
   "function pwClean( )\n"
   "{\n"
   "    //Periodic update disable\n"
   "    this.perUpdtEn(false);\n"
   "    //Pages recursively clean\n"
   "    for(var i in this.pages) this.pages[i].pwClean();\n"
   "    this.pages = new Object();\n"
   "    //Widgets recursively clean\n"
   "    for(var i in this.wdgs) this.wdgs[i].pwClean();\n"
   "    this.wdgs = new Object();\n"
   "}\n"
   "\n"
   "function perUpdtEn( en )\n"
   "{\n"
   "    if(this.attrs['root'] == 'Diagram' || this.attrs['root'] == 'Protocol') {\n"
   "	if(en && this.isEnabled() && !perUpdtWdgs[this.addr] && parseInt(this.attrs['trcPer']))	perUpdtWdgs[this.addr] = this;\n"
   "	if(!en && perUpdtWdgs[this.addr]) delete perUpdtWdgs[this.addr];\n"
   "    }\n"
   "    else if(this.attrs['root'] == 'Document' || this.attrs['root'] == 'FormEl') {\n"
   "	if(en) perUpdtWdgs[this.addr] = this;\n"
   "	else delete perUpdtWdgs[this.addr];\n"
   "    }\n"
   "    for(var i in this.wdgs) this.wdgs[i].perUpdtEn(en);\n"
   "}\n"
   "\n"
   "function perUpdt( )\n"
   "{\n"
   "    if(this.attrs['root'] == 'FormEl' && this.place.childNodes.length && this.place.childNodes[0].clearTm &&\n"
   "	    (this.place.childNodes[0].clearTm-=prcTm) <= 0)\n"
   "	this.place.childNodes[0].chEscape();\n"
   "    else if(this.attrs['root'] == 'Diagram' && (this.updCntr-=prcTm) <= 0) {\n"
   "	this.updCntr = parseInt(this.attrs['trcPer']);\n"
   "	var dgrObj = this.place.childNodes[0].childNodes[0];\n"
   "	if(!dgrObj.stLoadTm) dgrObj.stLoadTm = (new Date()).getTime();\n"
   "	if(dgrObj && (dgrObj.isLoad || ((new Date()).getTime()-dgrObj.stLoadTm) > this.updCntr*3000)) {\n"
   "	    dgrObj.isLoad = false;\n"
   "	    dgrObj.src = '/'+MOD_ID+this.addr+'?com=obj&tm='+tmCnt+'&xSc='+this.xScale(true).toFixed(3)+'&ySc='+this.yScale(true).toFixed(3);\n"
   "	    dgrObj.stLoadTm = (new Date()).getTime();\n"
   "	}\n"
   "    }\n"
   "    else if(this.attrs['root'] == 'Protocol' && (this.updCntr-=prcTm) <= 0) {\n"
   "	this.updCntr = parseInt(this.attrs['trcPer']);\n"
   "	this.loadData();\n"
   "    }\n"
   "    else if(this.attrs['root'] == 'Document') {\n"
   "	var frDoc = this.place.childNodes[0].contentDocument || this.place.childNodes[0].contentWindow || this.place.childNodes[0].document;\n"
   "	frDoc.open();\n"
   "	frDoc.write(\"<html><head>\\n\"+\n"
   "		\"<style type='text/css'>\\n\"+\n"
   "		\" * { \"+this.wFont+\" }\\n\"+\n"
   "		\" big { font-size: 120%; }\\n\"+\n"
   "		\" small { font-size: 90%; }\\n\"+\n"
   "		\" h1 { font-size: 200%; }\\n\"+\n"
   "		\" h2 { font-size: 150%; }\\n\"+\n"
   "		\" h3 { font-size: 120%; }\\n\"+\n"
   "		\" h4 { font-size: 105%; }\\n\"+\n"
   "		\" h5 { font-size: 95%; }\\n\"+\n"
   "		\" h6 { font-size: 70%; }\\n\"+\n"
   "		\" u,b,i { font-size : inherit; }\\n\"+\n"
   "		\" sup,sub { font-size: 80%; }\\n\"+\n"
   "		\" th { font-weight: bold; }\\n\"+\n"
   "		this.attrs['style']+\"</style>\"+\n"
   "		\"</head>\"+(this.attrs['doc']?this.attrs['doc']:this.attrs['tmpl'])+\"</html>\");\n"
   "	frDoc.close();\n"
   "	frDoc.body.wdgLnk = this;\n"
   "	frDoc.body.isActive = (parseInt(this.attrs['active']) && parseInt(this.attrs['perm'])&SEC_WR);\n"
   "	frDoc.body.onclick = function(e) {\n"
   "	    if(this.isActive) setFocus(this.wdgLnk.addr);\n"
   "	    return true;\n"
   "	}\n"
   "	this.perUpdtEn( false );\n"
   "    }\n"
   "}\n"
   "\n"
   "function xScale( full )\n"
   "{\n"
   "    var rez = parseFloat(this.attrs['geomXsc'])\n"
   "    if(!full) return rez;\n"
   "    if(!this.pg) return rez*this.parent.xScale(full);\n"
   "    return rez * wx_scale;\n"
   "}\n"
   "\n"
   "function yScale( full )\n"
   "{\n"
   "    var rez = parseFloat(this.attrs['geomYsc'])\n"
   "    if(!full) return rez;\n"
   "    if(!this.pg) return rez*this.parent.yScale(full);\n"
   "    return rez * wy_scale;\n"
   "}\n"
   "\n"
   "function isEnabled( )\n"
   "{\n"
   "    var rez = parseInt(this.attrs['en']);\n"
   "    if(!rez || this.pg) return rez;\n"
   "    return this.parent.isEnabled();\n"
   "}\n"
   "\n"
   "/***************************************************\n"
   " * pwDescr - Page/widget descriptor object         *\n"
   " ***************************************************/\n"
   "function pwDescr( pgAddr, pg, parent )\n"
   "{\n"
   "    this.addr = pgAddr;\n"
   "    this.pages = new Object();\n"
   "    this.wdgs = new Object();\n"
   "    this.attrs = new Object();\n"
   "    this.attrsMdf = new Object();\n"
   "    this.pg = pg;\n"
   "    this.parent = parent;\n"
   "    this.window = null;\n"
   "    this.windowExt = false;\n"
   "    this.place = null;\n"
   "    this.callPage = callPage;\n"
   "    this.findOpenPage = findOpenPage;\n"
   "    this.makeEl = makeEl;\n"
   "    this.pwClean = pwClean;\n"
   "    this.perUpdtEn = perUpdtEn;\n"
   "    this.perUpdt = perUpdt;\n"
   "    this.xScale = xScale;\n"
   "    this.yScale = yScale;\n"
   "    this.isEnabled = isEnabled;\n"
   "    this.updCntr = 0;\n"
   "}\n"
   "/***************************************************\n"
   " * makeUI                                          *\n"
   " ***************************************************/\n"
   "function makeUI( callBackRez )\n"
   "{\n"
   "    if(!callBackRez) {\n"
   "	prcCnt++;\n"
   "	stTmMain = new Date();\n"
   "    }\n"
   "\n"
   "    //Get open pages list\n"
   "    // Synchronous\n"
   "    //var pgNode = servGet('/'+sessId,'com=pgOpenList&tm='+tmCnt);\n"
   "    // Asynchronous\n"
   "    var pgNode = null;\n"
   "    if(callBackRez) pgNode = (callBackRez == -1) ? null : callBackRez;\n"
   "    else { servGet('/'+sessId,'com=pgOpenList&tm='+tmCnt,makeUI); return; }\n"
   "    if(pgNode) {\n"
   "	modelPer = parseInt(pgNode.getAttribute(\"per\"));\n"
   "	// Check for delete pages\n"
   "	for(var i_p = 0; i_p < pgList.length; i_p++) {\n"
   "	    var opPg; var i_ch;\n"
   "	    for(i_ch = 0; i_ch < pgNode.childNodes.length; i_ch++)\n"
   "		if(pgNode.childNodes[i_ch].nodeName == 'pg' && pgNode.childNodes[i_ch].textContent == pgList[i_p])\n"
   "		    break;\n"
   "	    if(i_ch < pgNode.childNodes.length || !(opPg=masterPage.findOpenPage(pgList[i_p]))) continue;\n"
   "	    if(opPg.window) {\n"
   "		if(opPg.windowExt) opPg.window.close();\n"
   "		else if(opPg != masterPage) document.getElementById('mainCntr').removeChild(opPg.window);\n"
   "		else {\n"
   "		    document.body.removeChild(opPg.window);\n"
   "		    masterPage = new pwDescr('', true)\n"
   "		}\n"
   "		if(opPg.parent)	delete opPg.parent.pages[pgList[i_p]];\n"
   "	    }\n"
   "	    else if(opPg.parent && opPg.parent.inclOpen && opPg.parent.inclOpen == pgList[i_p])\n"
   "	    { opPg.parent.attrs['pgOpenSrc'] = ''; opPg.parent.makeEl(null, true); }\n"
   "	}\n"
   "	// Process opened pages\n"
   "	pgList = new Array();\n"
   "	for(var i = 0; i < pgNode.childNodes.length; i++)\n"
   "	    if(pgNode.childNodes[i].nodeName == 'pg') {\n"
   "	        var prPath = pgNode.childNodes[i].textContent;\n"
   "		//  Check for closed window\n"
   "		var opPg = masterPage.findOpenPage(prPath);\n"
   "		if(opPg && opPg.window && opPg.windowExt && opPg.window.closed) {\n"
   "		    servSet(prPath,'com=pgClose','');\n"
   "		    opPg.pwClean();\n"
   "		    delete opPg.parent.pages[prPath];\n"
   "		    continue;\n"
   "		}\n"
   "		//  Call page\n"
   "		pgList.push(prPath);\n"
   "		masterPage.callPage(prPath,parseInt(pgNode.childNodes[i].getAttribute('updWdg')));\n"
   "	    }\n"
   "	tmCnt = parseInt(pgNode.getAttribute('tm'));\n"
   "    }\n"
   "    //Update some widgets\n"
   "    for(var i in perUpdtWdgs) perUpdtWdgs[i].perUpdt();\n"
   "\n"
   "    //Elapsed time get and adjust for plane update period depends from the network speed\n"
   "    var elTm = 1e-3*((new Date()).getTime()-stTmMain.getTime());\n"
   "    if(!planePer) planePer = 1e-3*modelPer;\n"
   "    planePer += (Math.max(1e-3*modelPer,elTm*3)-planePer)/100;\n"
   "    var sleepTm = Math.max(0, planePer-elTm);\n"
   "    prcTm = elTm + sleepTm;\n"
   "    //console.log(\"sleepTm: \"+sleepTm+\"s; prcTm: \"+prcTm+\"s; elTm: \"+elTm+\"s; planePer: \"+planePer+\"s.\");\n"
   "    setTimeout(makeUI, sleepTm*1e3);\n"
   "    //if(mainTmId) clearTimeout(mainTmId);\n"
   "    //mainTmId = setTimeout(makeUI, 1000);\n"
   "\n"
   "    //prcTm = Math.max(modelPer*1e-3,Math.min(60,3e-3*((new Date()).getTime() - stTmMain.getTime())));\n"
   "    //setTimeout(makeUI,prcTm*1e3);\n"
   "\n"
   "    //Execution performance test\n"
   "    /*var startChkTm = (new Date()).getTime();\n"
   "    for(var i_cnt = 0; i_cnt < 1000000; i_cnt++)\n"
   "	var trez = Math.sin(Math.PI);\n"
   "    var stopChkTm = (new Date()).getTime();\n"
   "    console.log(\"sin(PI): \"+(stopChkTm-startChkTm)+\"ms; trez: \"+trez);*/\n"
   "}\n"
   "\n"
   "/***************************************************\n"
   " * setStatus - Setup status message.               *\n"
   " ***************************************************/\n"
   "function setStatus( mess, tm )\n"
   "{\n"
   "    if(!mess) mess = '';\n"
   "    if(masterPage && masterPage.status && (stb=document.getElementById('StatusBar'))) stb.innerText = mess;\n"
   "    else window.status = mess;\n"
   "    if(!mess) return;\n"
   "    if(stTmID) clearTimeout(stTmID);\n"
   "    if(!tm || tm > 0) stTmID = setTimeout('setStatus(null)', tm?tm:1000);\n"
   "}\n"
   "\n"
   "/**************************************************\n"
   " * getPopup - Get popup menu.                     *\n"
   " **************************************************/\n"
   "function getPopup( )\n"
   "{\n"
   "    var popUpMenu = document.getElementById('popupmenu');\n"
   "    if(!popUpMenu) {\n"
   "	popUpMenu = document.createElement('div'); popUpMenu.id = 'popupmenu';\n"
   "	popUpMenu.appendChild(document.createElement('select'));\n"
   "	document.body.appendChild(popUpMenu);\n"
   "	popUpMenu.style.visibility = 'hidden';\n"
   "    }\n"
   "    return popUpMenu;\n"
   "}\n"
   "\n"
   "/**************************************************\n"
   " * getTree - Get the items tree                   *\n"
   " **************************************************/\n"
   "function getTree( )\n"
   "{\n"
   "    var formObj = document.createElement('ul');\n"
   "    formObj.style.cssText += 'font-style: italic;';\n"
   "    formObj.finish = function(lit, selIt) {\n"
   "	if(selIt && !selIt.length) return false;\n"
   "	var cnt = lit ? lit.children[2] : this;\n"
   "	for(var iIt = cnt.children.length-1; iIt >= 0; iIt--) {\n"
   "	    var oIt = cnt.children[iIt];\n"
   "	    if(selIt) {\n"
   "		if(selIt == oIt.itPath) { oIt.classList.add(\"select\"); this.mSelIt = oIt; return true; }\n"
   "		if(this.finish(oIt,selIt)) oIt.itExp = true;\n"
   "	    }\n"
   "	    else {\n"
   "		if(oIt.itMdf != this.itMdf) { cnt.removeChild(oIt); continue; }\n"
   "		this.finish(oIt);\n"
   "		oIt.children[2].style.backgroundImage = (oIt!=cnt.lastChild?\"url(/\"+MOD_ID+\"/img_treeLine)\":\"\");\n"
   "	    }\n"
   "	    isExpandable = oIt.children[2].children.length;\n"
   "	    oIt.children[0].src = \"/\"+MOD_ID+\"/img_tree\"+\n"
   "		(isExpandable?(oIt.itExp?\"Minus\":\"Plus\"):\"\")+\n"
   "		\"Up\"+(oIt!=cnt.lastChild?\"Down\":\"\");\n"
   "	    if(isExpandable) oIt.children[2].style.display = oIt.itExp ? \"\" : \"none\";\n"
   "	    if(isExpandable) oIt.classList.add(\"expandable\"); else oIt.classList.remove(\"expandable\");\n"
   "	    if(selIt && this.mSelIt) return true;\n"
   "	}\n"
   "	return false;\n"
   "    }\n"
   "    formObj.expand = function(lit) {\n"
   "	if(!lit || !lit.children[2].children.length) return;\n"
   "	lit.itExp = !lit.itExp;\n"
   "	lit.children[2].style.display = lit.itExp ? \"\" : \"none\";\n"
   "	lit.children[0].src = \"/\"+MOD_ID+\"/img_tree\"+(lit.itExp?\"Minus\":\"Plus\")+\"Up\"+(lit!=lit.parentNode.lastChild?\"Down\":\"\");\n"
   "    }\n"
   "    formObj.selIt = function(ipath, sendEv) {\n"
   "	if(sendEv) this.select(ipath);\n"
   "	if(this.mSelIt) { this.mSelIt.classList.remove(\"select\"); this.mSelIt = null; }\n"
   "	this.finish(null, ipath);\n"
   "    }\n"
   "    formObj.setList = function(items) {\n"
   "	while(this.children.length) this.removeChild(this.children[0]);\n"
   "	formObj.itMdf = formObj.itMdf ? (formObj.itMdf+1) : 1;\n"
   "	elLst = items.split('\\n');\n"
   "	cur_it = null;\n"
   "	for(iEl = 0; iEl < elLst.length; iEl++) {\n"
   "	    ipath = elLst[iEl];\n"
   "	    for(lev = 0, pathLev.off = 0; (item=pathLev(ipath,0,true)).length; lev++) {\n"
   "		if(lev == 0) {\n"
   "		    for(cur_it = null, iR = 0; !cur_it && iR < formObj.children.length; iR++)\n"
   "			if(formObj.children[iR].children[1].innerText == item) cur_it = formObj.children[iR];\n"
   "		    if(!cur_it) formObj.appendChild((cur_it=this.ownerDocument.createElement('li')));\n"
   "		    cur_it.itMdf = formObj.itMdf;\n"
   "		}\n"
   "		else {\n"
   "		    for(t_it = null, iR = 0; !t_it && iR < cur_it.children[2].children.length; iR++)\n"
   "			if(cur_it.children[2].children[iR].children[1].innerText == item) t_it = cur_it.children[2].children[iR];\n"
   "		    if(!t_it) cur_it.children[2].appendChild((t_it=this.ownerDocument.createElement('li')));\n"
   "		    cur_it = t_it;\n"
   "		    cur_it.itMdf = formObj.itMdf;\n"
   "		}\n"
   "		if(!cur_it.children.length) {\n"
   "		    cur_it.innerHTML = \"<img onclick='this.parentNode.formObj.expand(this.parentNode)'/>\"+\n"
   "				       \"<span onclick='this.parentNode.formObj.selIt(this.parentNode.itPath,true)'>\"+item+\"</span><ul\\>\";\n"
   "		    cur_it.formObj = formObj;\n"
   "		}\n"
   "	    }\n"
   "	    cur_it.classList.add(\"selectable\");\n"
   "	    cur_it.itPath = ipath;\n"
   "	}\n"
   "	formObj.finish();\n"
   "    }\n"
   "\n"
   "    return formObj;\n"
   "}\n"
   "\n"
   "/***************************************************\n"
   " * Main start code                                 *\n"
   " ***************************************************/\n"
   "var SEC_XT = 0x01;	//Extended\n"
   "var SEC_WR = 0x02;	//Write access\n"
   "var SEC_RD = 0x04;	//Read access\n"
   "\n"
   "//Call session identifier\n"
   "var sessId = location.pathname.split('/');\n"
   "for(var i_el = sessId.length-1; i_el >= 0; i_el--)\n"
   "    if( sessId[i_el].length )\n"
   "    { sessId = sessId[i_el]; break; }\n"
   "\n"
   "document.body.onmouseup = function(e)\n"
   "{\n"
   "    if(!e) e = window.event;\n"
   "    if(evMouseGet(e) != 'Left') return true;\n"
   "    var popUpMenu = document.getElementById('popupmenu');\n"
   "    if(popUpMenu) popUpMenu.style.visibility = 'hidden';\n"
   "    //return false;	//!!!! It's buggy on <input type=range> for Chrome\n"
   "}\n"
   "\n"
   "window.onresize = function( ) {\n"
   "    if(stTmReload) clearTimeout(stTmReload);\n"
   "    if(window.innerHeight > document.body.clientHeight ||\n"
   "	((document.body.clientHeight-window.innerHeight)/document.body.clientHeight > 0.5 && wy_scale > 1))\n"
   "	    stTmReload = setTimeout('window.location.reload()', 1000);\n"
   "}\n"
   "\n"
   "var modelPer = 0;			//Model proc period\n"
   "var prcCnt = 0;				//Process counter\n"
   "var prcTm = 0;				//Process time\n"
   "var planePer = 0;			//Planed update period\n"
   "var tmCnt = 0;				//Call counter\n"
   "var pgList = new Array();		//Opened pages list\n"
   "var pgCache = new Object();		//Cached pages' data\n"
   "var perUpdtWdgs = new Object();		//Periodic updated widgets register\n"
   "var masterPage = new pwDescr('', true);	//Master page create\n"
   "var stTmID = null;			//Status line timer identifier\n"
   "var stTmMain = null;			//Main cycle start time\n"
   "var stTmReload = null;			//Main reload timeout at the main window resize\n"
   "var wx_scale = 1;			//Main window scale for fit, X axis\n"
   "var wy_scale = 1;			//Main window scale for fit, Y axis\n"
   "var clearTm = 10;			//Clear time of line edit fields, seconds\n"
   "\n"
   "mainTmId = setTimeout(makeUI, 100);	//First call init\n";
