#ifndef _TOW_BOOT_ENV_H
#define _TOW_BOOT_ENV_H

#ifdef CONFIG_CMD_POWEROFF
#define TOW_BOOT_MAYBE_POWEROFF "tb_menu add 'Shutdown' 'Powers off the device' 'poweroff';"
#else
#define TOW_BOOT_MAYBE_POWEROFF
#endif

#ifdef CONFIG_CMD_USB
#define TOW_BOOT_MAYBE_USB "tb_menu add 'Rescan USB' 'Look for new USB devices' \"usb reset; $menucmd\";"
#else
#define TOW_BOOT_MAYBE_USB
#endif

#define TOW_BOOT_ENV \
	/* Used internally to check updater runs on the right board. */ \
	"board_identifier=pine64-pinephoneA64\0" \
	\
	/* By default, no setup for LEDs */ \
	"setup_leds=led led-2 on ; led led-1 on ; led led-0 off\0" \
	"bootcmd=led led-2 on ; led led-1 off ; led led-0 off ; vibrator vibrator timed 200 ; sleep 0.1 ; vibrator vibrator timed 200 ; if button 'Volume Up'; then ;   led led-2 off ;   led led-1 off ;   led led-0 on ;   ums 0 mmc 1 ;   sleep 1 ; led led-2 off ; led led-1 off ; led led-0 off ; for i in 0 1 2 3; do ;   vibrator vibrator timed 250 ;   led led-2 off ;   sleep 0.25 ;   led led-2 on ; done ; fi ; if button 'Volume Down'; then ;   led led-2 off ;   led led-1 on ;   led led-0 on ;   run bootcmd_mmc0 ;   sleep 1 ; led led-2 off ; led led-1 off ; led led-0 off ; for i in 0 1 2 3; do ;   vibrator vibrator timed 250 ;   led led-2 off ;   sleep 0.25 ;   led led-2 on ; done ; fi ; run setup_leds ; run distro_bootcmd ; echo ; echo ERROR: Could not boot anything from distro_bootcmd. ; echo ; sleep 1 ; led led-2 off ; led led-1 off ; led led-0 off ; for i in 0 1 2 3 4 5 6 7 8 9; do ;   vibrator vibrator timed 250 ;   led led-2 off ;   sleep 0.25 ;   led led-2 on ; done ; sleep 0.25 ; poweroff\0" \
	"target_name_mmc0=" CONFIG_TOW_BOOT_MMC0_NAME "\0" \
	"target_name_mmc1=" CONFIG_TOW_BOOT_MMC1_NAME "\0" \
	"target_name_mmc2=" CONFIG_TOW_BOOT_MMC2_NAME "\0" \
	"target_name_usb0=USB\0" \
	"target_name_nvme0=NVME\0" \
	"target_name_pxe=PXE\0" \
	"target_name_dhcp=DHCP\0" \
	\
	\
	"towboot_menu=" \
	/* Builds the boot options in the same order distro_bootcmd uses. */ \
	"tb_menu new;" \
	"for target in ${boot_targets}; do" \
	/*   # Skip fel as it has no value for end-users */ \
	"    if test \"$target\" != fel; then" \
	"        env indirect target_name target_name_${target} \"(${target})\";" \
	"        tb_menu add \"Boot from ${target_name}\" '' \"run bootcmd_${target}; echo ${target_name} Boot failed.; pause; $menucmd\" ;" \
	"    fi;" \
	"done;" \
	\
	"tb_menu separator;" \
	TOW_BOOT_MAYBE_USB \
	/* In the future, this would be "Firmware Options". */ \
	"tb_menu add 'Firmware Console' 'Go to the console' 'cls; echo; echo \"Use `run menucmd` to return to the menu.\" ; echo' ;" \
	"tb_menu separator;" \
	/* `reset` is universal. Power off is optional */ \
	"tb_menu add 'Reboot' 'Reboots the device' 'reset';" \
	TOW_BOOT_MAYBE_POWEROFF \
	/* Show this menu! */ \
	"tb_menu show" \
	"\0" \
	\
	\
	"menucmd=run towboot_menu\0" \

#endif
