$! INSTALL.COM -- Installs the files in a given directory tree
$!
$! Author: Richard Levitte <richard@levitte.org>
$! Time of creation: 22-MAY-1998 10:13
$!
$! P1	root of the directory tree
$!
$	DEF_ORIG = F$ENVIRONMENT( "DEFAULT")
$	ON ERROR THEN GOTO TIDY
$	ON CONTROL_C THEN GOTO TIDY
$
$	IF P1 .EQS. ""
$	THEN
$	    WRITE SYS$OUTPUT "First argument missing."
$	    WRITE SYS$OUTPUT -
		  "It Should be the directory where you want things installed."
$	    EXIT
$	ENDIF
$
$	IF (F$GETSYI("CPU").LT.128)
$	THEN
$	    ARCH := VAX
$	ELSE
$	    ARCH = F$EDIT( F$GETSYI( "ARCH_NAME"), "UPCASE")
$	    IF (ARCH .EQS. "") THEN ARCH = "UNK"
$	ENDIF
$
$	ROOT = F$PARSE(P1,"[]A.;0",,,"SYNTAX_ONLY,NO_CONCEAL") - "A.;0"
$	ROOT_DEV = F$PARSE(ROOT,,,"DEVICE","SYNTAX_ONLY")
$	ROOT_DIR = F$PARSE(ROOT,,,"DIRECTORY","SYNTAX_ONLY") -
		   - ".][000000" - "[000000." - "][" - "[" - "]"
$	ROOT = ROOT_DEV + "[" + ROOT_DIR
$
$	DEFINE/NOLOG WRK_SSLROOT 'ROOT'.] /TRANS=CONC
$	DEFINE/NOLOG WRK_SSLXLIB WRK_SSLROOT:['ARCH'_LIB]
$	DEFINE/NOLOG WRK_SSLLIB WRK_SSLROOT:[LIB]
$	DEFINE/NOLOG WRK_SSLINCLUDE WRK_SSLROOT:[INCLUDE]
$	DEFINE/NOLOG WRK_SSLXEXE WRK_SSLROOT:['ARCH'_EXE]
$	DEFINE/NOLOG WRK_SSLCERTS WRK_SSLROOT:[CERTS]
$	DEFINE/NOLOG WRK_SSLPRIVATE WRK_SSLROOT:[PRIVATE]
$
$!
$! Exhibit the destination directory.
$!
$	WRITE SYS$OUTPUT "   Installing to (WRK_SSLROOT) ="
$	WRITE SYS$OUTPUT "    ''f$trnlnm( "WRK_SSLROOT")'"
$	WRITE SYS$OUTPUT ""
$
$	IF F$PARSE("WRK_SSLROOT:[000000]") .EQS. "" THEN -
	   CREATE/DIR/LOG WRK_SSLROOT:[000000]
$	IF F$PARSE("WRK_SSLXEXE:") .EQS. "" THEN -
	   CREATE/DIR/LOG WRK_SSLXEXE:
$	IF F$PARSE("WRK_SSLXLIB:") .EQS. "" THEN -
	   CREATE/DIR/LOG WRK_SSLXLIB:
$	IF F$PARSE("WRK_SSLLIB:") .EQS. "" THEN -
	   CREATE/DIR/LOG WRK_SSLLIB:
$	IF F$PARSE("WRK_SSLINCLUDE:") .EQS. "" THEN -
	   CREATE/DIR/LOG WRK_SSLINCLUDE:
$	IF F$PARSE("WRK_SSLCERTS:") .EQS. "" THEN -
	   CREATE/DIR/LOG WRK_SSLCERTS:
$	IF F$PARSE("WRK_SSLPRIVATE:") .EQS. "" THEN -
	   CREATE/DIR/LOG WRK_SSLPRIVATE:
$	IF F$PARSE("WRK_SSLROOT:[VMS]") .EQS. "" THEN -
	   CREATE/DIR/LOG WRK_SSLROOT:[VMS]
$
$	SDIRS := CRYPTO,SSL,APPS,VMS!,RSAREF,TEST,TOOLS
$	EXHEADER := e_os2.h
$
$	COPY 'EXHEADER' WRK_SSLINCLUDE: /LOG
$	SET FILE/PROT=WORLD:RE WRK_SSLINCLUDE:'EXHEADER'
$
$	I = 0
$ LOOP_SDIRS: 
$	D = F$ELEMENT(I, ",", SDIRS)
$	I = I + 1
$	IF D .EQS. "," THEN GOTO LOOP_SDIRS_END
$	WRITE SYS$OUTPUT "Installing ",D," files."
$	SET DEFAULT [.'D']
$	@INSTALL 'ROOT']
$	SET DEFAULT [-]
$	GOTO LOOP_SDIRS
$ LOOP_SDIRS_END:
$
$	WRITE SYS$OUTPUT ""
$	WRITE SYS$OUTPUT "	Installation done!"
$	WRITE SYS$OUTPUT ""
$	WRITE SYS$OUTPUT "	You might want to purge ",ROOT,"...]"
$	WRITE SYS$OUTPUT ""
$
$ TIDY:
$	SET DEFAULT 'DEF_ORIG'
$
$	DEASSIGN WRK_SSLROOT
$	DEASSIGN WRK_SSLXLIB
$	DEASSIGN WRK_SSLLIB
$	DEASSIGN WRK_SSLINCLUDE
$	DEASSIGN WRK_SSLXEXE
$	DEASSIGN WRK_SSLCERTS
$	DEASSIGN WRK_SSLPRIVATE
$
$	EXIT
