#!/bin/sh
#
# Copyright (c) 2004, 2005 Darren Tucker
#
# Permission to use, copy, modify, and distribute this software for any
# purpose with or without fee is hereby granted, provided that the above
# copyright notice and this permission notice appear in all copies.
#
# THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
# WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
# ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
# WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
# ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
# OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

host="arm-xscale-linux-gnueabi"
AWK="gawk"
CC="arm-xscale-linux-gnueabi-gcc"
CPP="arm-xscale-linux-gnueabi-cpp"
CFLAGS="-g -O2 -Wall -Wpointer-arith -Wuninitialized -Wsign-compare -Wformat-security -Wno-pointer-sign -Wno-unused-result -fno-strict-aliasing -fno-builtin-memset -fstack-protector-all "
CPPFLAGS="-I/opt/OSELAS.BSP/PTX/OSELAS.BSP-PTX-Generic-2011.01.0/platform-versatilepb-2011.01.0/sysroot-target/include -isystem /opt/OSELAS.BSP/PTX/OSELAS.BSP-PTX-Generic-2011.01.0/platform-versatilepb-2011.01.0/sysroot-target/include -isystem /opt/OSELAS.BSP/PTX/OSELAS.BSP-PTX-Generic-2011.01.0/platform-versatilepb-2011.01.0/sysroot-target/usr/include"
LDFLAGS="-L/opt/OSELAS.BSP/PTX/OSELAS.BSP-PTX-Generic-2011.01.0/platform-versatilepb-2011.01.0/sysroot-target/lib -L/opt/OSELAS.BSP/PTX/OSELAS.BSP-PTX-Generic-2011.01.0/platform-versatilepb-2011.01.0/sysroot-target/lib -L/opt/OSELAS.BSP/PTX/OSELAS.BSP-PTX-Generic-2011.01.0/platform-versatilepb-2011.01.0/sysroot-target/usr/lib -Wl,-rpath-link -Wl,/opt/OSELAS.BSP/PTX/OSELAS.BSP-PTX-Generic-2011.01.0/platform-versatilepb-2011.01.0/sysroot-target/lib -Wl,-rpath-link -Wl,/opt/OSELAS.BSP/PTX/OSELAS.BSP-PTX-Generic-2011.01.0/platform-versatilepb-2011.01.0/sysroot-target/usr/lib -fstack-protector-all"
LIBS="-lcrypto -ldl -lutil -lz -lnsl  -lcrypt -lresolv"

# Note format:
# identifier: [data] CRCR

echo "openssh-survey-version: 1"
echo
echo "openssh-version: `./ssh -V 2>&1`"
echo
configinv=`$AWK '/^  \\\$.*configure/' config.log | sed 's/^  \\\$ //g'`
echo "configure-invocation: $configinv"
echo
echo "host: $host"
echo
echo "uname: `uname`"
echo
echo "uname-r: `uname -r`"
echo
echo "uname-m: `uname -m`"
echo
echo "uname-p: `uname -p`"
echo
echo "oslevel: `oslevel 2>/dev/null`"
echo
echo "oslevel-r: `oslevel -r 2>/dev/null`"
echo
echo "cc: $CC"
echo
echo "cflags: $CFLAGS"
echo
echo "cppflags: $CPPFLAGS"
echo
echo "ldflags: $LDFLAGS"
echo
echo "libs: $LIBS"
echo
echo "ccver-v: `$CC -v 2>&1 | sed '/^[ \t]*$/d'`"
echo
echo "ccver-V: `$CC -V 2>&1 | sed '/^[ \t]*$/d'`"
echo
echo "cppdefines:"
${CPP} -dM - </dev/null
echo
echo "config.h:"
egrep '#define|#undef' config.h
echo
