#
# We provide this package
#
PACKAGES-$(PTXCONF_OPENSCADA) += openscada

#
# Paths and names
#
OPENSCADA_VERSION	:= 0.7.2
OPENSCADA_MD5		:= db95e8b6a09d9f5f2435f31f201a97cf
OPENSCADA		:= openscada-$(OPENSCADA_VERSION)
OPENSCADA_SUFFIX	:= tar.gz
OPENSCADA_URL		:= http://oscada.org/oscadaArch/0.7.2/$(OPENSCADA).$(OPENSCADA_SUFFIX)
OPENSCADA_SOURCE	:= $(SRCDIR)/$(OPENSCADA).$(OPENSCADA_SUFFIX)
OPENSCADA_DIR		:= $(BUILDDIR)/$(OPENSCADA)

# ----------------------------------------------------------------------------
# Get
# ----------------------------------------------------------------------------

$(OPENSCADA_SOURCE):
	@$(call targetinfo)
	@$(call get, OPENSCADA)

# ----------------------------------------------------------------------------
# Prepare
# ----------------------------------------------------------------------------

OPENSCADA_PATH	:= PATH=$(CROSS_PATH)
OPENSCADA_ENV 	:= $(CROSS_ENV)

#
# autoconf
#
OPENSCADA_AUTOCONF  := $(CROSS_AUTOCONF_USR) --disable-QTStarter --disable-QTCfg --disable-Vision --disable-MySQL --disable-FireBird --disable-PostgreSQL --disable-AMRDevs --disable-BFN --disable-SoundCard

# ----------------------------------------------------------------------------
# Target-Install
# ----------------------------------------------------------------------------

$(STATEDIR)/openscada.targetinstall:
	@$(call targetinfo)

	@$(call install_init, openscada)
	@$(call install_fixup, openscada,PRIORITY,optional)
	@$(call install_fixup, openscada,SECTION,base)
	@$(call install_fixup, openscada,AUTHOR,"Roman Savochenko <rom_as@oscada.org>")
	@$(call install_fixup, openscada,DESCRIPTION,missing)

#	@$(call install_lib, openscada, 0, 0, 0644, libgd)

	@$(call install_finish, openscada)

	@$(call touch)

# vim: syntax=make
