# -*-makefile-*-
#
# Copyright (C) 2012 by Roman Savochenko
#
# See CREDITS for details about who has contributed to this project.
#
# For further information about the PTXdist project and license conditions
# see the README file.
#

#
# We provide this package
#
PACKAGES-$(PTXCONF_OPENSCADA) += openscada

#
# Paths and names
#
OPENSCADA_VERSION	:= 0.7.2
OPENSCADA_MD5		:= 19fb6172d1d18dec0f2601fe656da0d5
OPENSCADA		:= openscada-$(OPENSCADA_VERSION)
OPENSCADA_SUFFIX	:= tar.gz
OPENSCADA_URL		:= http://oscada.org/oscadaArch/0.7.2/$(OPENSCADA).$(OPENSCADA_SUFFIX)
OPENSCADA_SOURCE	:= $(SRCDIR)/$(OPENSCADA).$(OPENSCADA_SUFFIX)
OPENSCADA_DIR		:= $(BUILDDIR)/$(OPENSCADA)
OPENSCADA_LICENSE	:= GPLv2

# ----------------------------------------------------------------------------
# Get
# ----------------------------------------------------------------------------

$(OPENSCADA_SOURCE):
	@$(call targetinfo)
	@$(call get, OPENSCADA)

# ----------------------------------------------------------------------------
# Prepare
# ----------------------------------------------------------------------------
OPENSCADA_PATH	:= PATH=$(CROSS_PATH)
OPENSCADA_ENV	:= $(CROSS_ENV)


# OPENSCADA_CONF_ENV	:= $(CROSS_ENV)

#
# autoconf
#
OPENSCADA_AUTOCONF  := $(CROSS_AUTOCONF_USR) --disable-QTStarter --disable-QTCfg --disable-Vision --disable-MySQL --disable-FireBird --disable-PostgreSQL --disable-AMRDevs --disable-BFN --disable-SoundCard
# OPENSCADA_CONF_TOOL	:= autoconf
# OPENSCADA_CONF_OPT	:= $(CROSS_AUTOCONF_USR) --disable-QTStarter --disable-QTCfg --disable-Vision --disable-MySQL --disable-FireBird --disable-PostgreSQL --disable-AMRDevs --disable-BFN --disable-SoundCard

#$(STATEDIR)/openscada.prepare:
#	@$(call targetinfo)
#	@$(call clean, $(OPENSCADA_DIR)/config.cache)
#	cd $(OPENSCADA_DIR) && \
#		$(OPENSCADA_PATH) $(OPENSCADA_ENV) echo "CFLAGS=$(CFLAGS); LDFLAGS=$(LDFLAGS)" \
#		./configure $(OPENSCADA_CONF_OPT)
#	@$(call touch)

# ----------------------------------------------------------------------------
# Compile
# ----------------------------------------------------------------------------

#$(STATEDIR)/openscada.compile:
#	@$(call targetinfo)
#	@$(call world/compile, OPENSCADA)
#	@$(call touch)

# ----------------------------------------------------------------------------
# Install
# ----------------------------------------------------------------------------

#$(STATEDIR)/openscada.install:
#	@$(call targetinfo)
#	echo "TEST"
#	@$(call world/install, OPENSCADA)
#	@$(call touch)

# ----------------------------------------------------------------------------
# Target-Install
# ----------------------------------------------------------------------------

$(STATEDIR)/openscada.targetinstall:
	@$(call targetinfo)

	@$(call install_init, openscada)
	@$(call install_fixup, openscada,PRIORITY,optional)
	@$(call install_fixup, openscada,SECTION,base)
	@$(call install_fixup, openscada,AUTHOR,"Roman Savochenko")
	@$(call install_fixup, openscada,DESCRIPTION,missing)

	@$(call install_copy, openscada, 0, 0, 0755, -, /usr/bin/openscada)
	@$(call install_lib, openscada, 0, 0, 0644, liboscada)
	@$(call install_copy, openscada, 0, 0, 0755, /usr/lib/openscada)
	@$(call install_tree, openscada, 0, 0, -, /usr/lib/openscada)

	@$(call install_finish, openscada)

	@$(call touch)

# ----------------------------------------------------------------------------
# Clean
# ----------------------------------------------------------------------------

#$(STATEDIR)/openscada.clean:
#	@$(call targetinfo)
#	@$(call clean_pkg, OPENSCADA)

# vim: syntax=make
