const char *WebCfgDVCA_js=
   "\n"
   "//OpenSCADA system module UI.WebCfgD file: VCA.js\n"
   "/***************************************************************************\n"
   " *   Copyright (C) 2008-2010 by Roman Savochenko                           *\n"
   " *   rom_as@oscada.org, rom_as@fromru.com                                  *\n"
   " *                                                                         *\n"
   " *   This program is free software; you can redistribute it and/or modify  *\n"
   " *   it under the terms of the GNU General Public License as published by  *\n"
   " *   the Free Software Foundation; version 2 of the License.               *\n"
   " *                                                                         *\n"
   " *   This program is distributed in the hope that it will be useful,       *\n"
   " *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *\n"
   " *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *\n"
   " *   GNU General Public License for more details.                          *\n"
   " *                                                                         *\n"
   " *   You should have received a copy of the GNU General Public License     *\n"
   " *   along with this program; if not, write to the                         *\n"
   " *   Free Software Foundation, Inc.,                                       *\n"
   " *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *\n"
   " ***************************************************************************/\n"
   "\n"
   "//> Global parameters init\n"
   "MOD_ID = 'WebCfgD';	//Module identifier\n"
   "stTmID = null;		//Status line timer identifier\n"
   "pgRefrTmID = null;	//Periodic current page update timer identifier\n"
   "dlgWin = null;		//Opened window dialog\n"
   "selPath = '';		//Selected node path\n"
   "queSZ = 20;		//Previous and next arrays queue size\n"
   "ndPrev = new Array();	//Previous nodes array\n"
   "ndNext = new Array();	//Next nodes array\n"
   "pgInfo = document.createElement('info');	//Curent page XML tree.\n"
   "root = document.createElement('oscada_cntr');	//Root page's node.\n"
   "selPath = '';		//Select item path\n"
   "SEC_XT = 0x01;		//Extended\n"
   "SEC_WR = 0x02;		//Write access\n"
   "SEC_RD = 0x04;		//Read access\n"
   "copyBuf = '0';		//Copy node address buffer\n"
   "genReqs = null;		//Generic request object\n"
   "//> Browser type detect\n"
   "var isNN = navigator.appName.indexOf('Netscape') != -1;\n"
   "var isIE = navigator.appName.indexOf('Microsoft') != -1;\n"
   "var isOpera = navigator.appName.indexOf('Opera') != -1;\n"
   "var isKonq = navigator.userAgent.indexOf('Konqueror') != -1;\n"
   "var isChrome = navigator.userAgent.indexOf('Chrome') != -1;\n"
   "/***************************************************\n"
   " * strEncode - String encoding.                    *\n"
   " ***************************************************/\n"
   "function strEncode( vl, tp )\n"
   "{\n"
   "  //if( !tp || tp == \"html\" ) return vl.replace(/&/g,'&amp;').replace(/>/g,'&gt;').replace(/</g,'&lt;').replace(/\"/g,'&quot;');\n"
   "  //return vl;\n"
   "  var encRez = '';\n"
   "  if(!tp || tp == \"html\")\n"
   "    for(var i_enc = 0; i_enc < vl.length; i_enc++)\n"
   "      switch(vl.charAt(i_enc))\n"
   "      {\n"
   "        case '&': encRez += '&amp;'; break;\n"
   "        case '>': encRez += '&gt;'; break;\n"
   "        case '<': encRez += '&lt;'; break;\n"
   "        case '\"': encRez += '&quot;'; break;\n"
   "        default:  encRez += vl.charAt(i_enc);\n"
   "      }\n"
   "  return encRez;\n"
   "}\n"
   "/***************************************************\n"
   " * pathLev - Path parsing function.                *\n"
   " ***************************************************/\n"
   "pathLev.off = 0;\n"
   "function pathLev( path, level, scan )\n"
   "{\n"
   "  var an_dir = scan ? pathLev.off : 0;\n"
   "  var t_lev = 0;\n"
   "  var t_dir;\n"
   "  while( an_dir < path.length && path.charAt(an_dir) == '/' ) an_dir++;\n"
   "  if( an_dir >= path.length ) return '';\n"
   "  while( true )\n"
   "  {\n"
   "    t_dir = path.indexOf('/',an_dir);\n"
   "    if( t_dir < 0 ) { pathLev.off=path.length; return (t_lev==level)?path.substr(an_dir):''; }\n"
   "    if( t_lev == level ) { pathLev.off=t_dir; return path.substr(an_dir,t_dir-an_dir); }\n"
   "    an_dir = t_dir;\n"
   "    t_lev++;\n"
   "    while( an_dir<path.length && path.charAt(an_dir)=='/' ) an_dir++;\n"
   "  }\n"
   "}\n"
   "/***************************************************\n"
   " * nodeText - Get DOM node text                    *\n"
   " ***************************************************/\n"
   "function nodeText( node )\n"
   "{\n"
   "  var rez = '';\n"
   "  if( node )\n"
   "    for( var i = 0; i < node.childNodes.length; i++ )\n"
   "      if( node.childNodes[i].nodeType == 3 ) rez += node.childNodes[i].data;\n"
   "  return rez;\n"
   "}\n"
   "/***************************************************\n"
   " * setNodeText - Set DOM node text                 *\n"
   " ***************************************************/\n"
   "function setNodeText( node, val )\n"
   "{\n"
   "  if( !node ) return;\n"
   "  for( var i = 0; i < node.childNodes.length; i++ )\n"
   "    if( node.childNodes[i].nodeType == 3 )\n"
   "    { node.childNodes[i].data = val; return; }\n"
   "  node.appendChild(node.ownerDocument.createTextNode(val));\n"
   "}\n"
   "/*****************************************************\n"
   " * nodeTextByTagId - Get DOM node by tag name and id *\n"
   " *****************************************************/\n"
   "function nodeTextByTagId( node, tag, avl )\n"
   "{\n"
   "  for( var i = 0; i < node.childNodes.length; i++ )\n"
   "    if( node.childNodes[i].nodeName == tag && node.childNodes[i].getAttribute('id') == avl )\n"
   "      return nodeText(node.childNodes[i]);\n"
   "  return null;\n"
   "}\n"
   "/***************************************************\n"
   " * posGetX - Get absolute position                 *\n"
   " ***************************************************/\n"
   "function posGetX(obj,noWScrl)\n"
   "{\n"
   "  var posX = 0;\n"
   "  //> Calc offset on blocks\n"
   "  for( var cObj = obj; cObj != null; cObj = cObj.offsetParent ) posX += cObj.offsetLeft;\n"
   "  //> Calc block's scroll\n"
   "  if( !isOpera )\n"
   "    for( var cObj = obj ; (cObj && cObj.nodeName!='BODY'); cObj = cObj.parentNode ) posX -= (cObj.scrollLeft?cObj.scrollLeft:0);\n"
   "  return posX+(!noWScrl?-window.pageXOffset:0)+(isNN?5:0);\n"
   "}\n"
   "/***************************************************\n"
   " * posGetY - Get absolute position                 *\n"
   " ***************************************************/\n"
   "function posGetY(obj,noWScrl)\n"
   "{\n"
   "  var posY = 0;\n"
   "  //> Calc offset on blocks\n"
   "  for( var cObj = obj; cObj != null; cObj = cObj.offsetParent ) posY += cObj.offsetTop;\n"
   "  //> Calc block's scroll\n"
   "  if( !isOpera )\n"
   "    for( var cObj = obj ; (cObj && cObj.nodeName!='BODY'); cObj = cObj.parentNode ) posY -= (cObj.scrollTop?cObj.scrollTop:0);\n"
   "  return posY+(!noWScrl?-window.pageYOffset:0)+(isNN?5:0);\n"
   "}\n"
   "/***************************************************\n"
   " * getXmlHttp - Check and return XMLHttpRequest for*\n"
   " *  various browsers.                              *\n"
   " ***************************************************/\n"
   "function getXmlHttp( )\n"
   "{\n"
   "  if( window.XMLHttpRequest ) return new XMLHttpRequest();\n"
   "  else if( window.ActiveXObject )\n"
   "  {\n"
   "    try { return new ActiveXObject('Msxml2.XMLHTTP'); }\n"
   "    catch(e) { return new ActiveXObject('Microsoft.XMLHTTP'); }\n"
   "  }\n"
   "  return null;\n"
   "}\n"
   "/***************************************************\n"
   " * crDoc - Create new XML document object for      *\n"
   " *  various browsers.                              *\n"
   " ***************************************************/\n"
   "function crDoc()\n"
   "{\n"
   "    var doc;\n"
   "    if(document.implementation && document.implementation.createDocument)\n"
   "        doc = document.implementation.createDocument(\"\", \"\", null);\n"
   "    else if(window.ActiveXObject)\n"
   "    {\n"
   "        for(var i = 0; i < MSXML.length; i++)\n"
   "            try { doc = new ActiveXObject(MSXML[i]); } catch (e) { }\n"
   "        if(!doc) { alert(\"Cannot create XMLDocument object\"); return false; }\n"
   "    }\n"
   "    return doc;\n"
   "}\n"
   "/***************************************************\n"
   " * realRound - Real numbers round                  *\n"
   " ***************************************************/\n"
   "function realRound( val, dig, toInt )\n"
   "{\n"
   "  rez = Math.floor(val*Math.pow(10,dig?dig:0)+0.5)/Math.pow(10,dig?dig:0);\n"
   "  if( toInt ) return Math.floor(rez+0.5);\n"
   "  return rez;\n"
   "}\n"
   "/***************************************************\n"
   " * servGet - XML get request to server             *\n"
   " ***************************************************/\n"
   "function servGet( adr, prm )\n"
   "{\n"
   "  if(genReqs)\n"
   "  {\n"
   "    var rCom = prm.slice(4);\n"
   "    if(genReqs.childNodes[0].getAttribute('fillMode') == '1')\n"
   "    {\n"
   "	var tEl = genReqs.createElement(rCom);\n"
   "	tEl.setAttribute('path',adr);\n"
   "	genReqs.childNodes[0].appendChild(tEl);\n"
   "	return null;\n"
   "    }\n"
   "    else\n"
   "    {\n"
   "	var sNd = null;\n"
   "        var c_pos = genReqs.childNodes[0].getAttribute(\"curPos\");\n"
   "        if(!c_pos) c_pos = 0;\n"
   "        for( ; c_pos < genReqs.childNodes[0].childNodes.length && !sNd; c_pos++)\n"
   "        {\n"
   "            var wNd = genReqs.childNodes[0].childNodes[c_pos];\n"
   "            if(wNd.getAttribute('path') == adr && wNd.tagName == rCom) sNd = wNd;\n"
   "        }\n"
   "        if(!sNd && c_pos)\n"
   "            for(c_pos = 0; c_pos < genReqs.childNodes[0].childNodes.length && !sNd; c_pos++)\n"
   "            {\n"
   "        	var wNd = genReqs.childNodes[0].childNodes[c_pos];\n"
   "                if(wNd.getAttribute('path') == adr && wNd.tagName == rCom) sNd = wNd;\n"
   "            }\n"
   "\n"
   "        if(sNd)\n"
   "        {\n"
   "    	    genReqs.childNodes[0].setAttribute('curPos',c_pos+1);\n"
   "	    return sNd;\n"
   "        }\n"
   "        adr = genReqs.childNodes[0].getAttribute('path')+'/'+adr;\n"
   "    }\n"
   "  }\n"
   "\n"
   "  var req = getXmlHttp();\n"
   "  req.open('GET',encodeURI('/'+MOD_ID+adr+'?'+prm),false);\n"
   "//  req.setRequestHeader('Content-Type','text/xml; charset=utf-8');\n"
   "  try\n"
   "  { req.send(null);\n"
   "    if( req.status == 200 && req.responseXML.childNodes.length )\n"
   "      return req.responseXML.childNodes[0];\n"
   "  } catch( e ) { window.location='/'; }\n"
   "  return null;\n"
   "}\n"
   "/***************************************************\n"
   " * servSet - XML set request to server             *\n"
   " ***************************************************/\n"
   "function servSet( adr, prm, body, waitRez )\n"
   "{\n"
   "  var req = getXmlHttp();\n"
   "  req.open('POST',encodeURI('/'+MOD_ID+adr+'?'+prm),!waitRez);\n"
   "  try\n"
   "  { req.send(body);\n"
   "    if( waitRez && req.status == 200 && req.responseXML.childNodes.length )\n"
   "      return req.responseXML.childNodes[0];\n"
   "  } catch( e ) { window.location='/'; }\n"
   "  return null;\n"
   "}\n"
   "/***************************************************\n"
   " * servReq - XML generic request to server         *\n"
   " *  body - XML document body                       *\n"
   " ***************************************************/\n"
   "function servReq( body )\n"
   "{\n"
   "  var req = getXmlHttp();\n"
   "  req.open('POST',encodeURI('/'+MOD_ID+'/?com=req'),false);\n"
   "  req.setRequestHeader(\"Content-Type\", \"application/xml;charset=UTF-8\");\n"
   "  try {\n"
   "    req.send(body);\n"
   "    if(req.status == 200) return req.responseXML;\n"
   "  } catch(e) { window.location='/'; }\n"
   "  return null;\n"
   "}\n"
   "\n"
   "/***************************************************\n"
   " * setStatus - Setup status message.               *\n"
   " ***************************************************/\n"
   "function setStatus( mess, tm )\n"
   "{\n"
   "  setNodeText(document.getElementById('status'),mess?mess:'###Ready###');\n"
   "  if( !mess ) return;\n"
   "  if( stTmID ) clearTimeout(stTmID);\n"
   "  if( !tm || tm > 0 ) stTmID = setTimeout('setStatus(null)',tm?tm:1000);\n"
   "}\n"
   "/***************************************************\n"
   " * expand - Expand/roll select subtree.            *\n"
   " ***************************************************/\n"
   "function expand( el, val, upTree )\n"
   "{\n"
   "  if( !val )\n"
   "  {\n"
   "    for( var i = 0; i < el.childNodes.length; i++ )\n"
   "      if( el.childNodes[i].nodeName == 'UL' )\n"
   "      { el.removeChild(el.childNodes[i]); break; }\n"
   "  }\n"
   "  else\n"
   "  {\n"
   "    var cUL = null;\n"
   "    for( var i = 0; i < el.childNodes.length; i++ )\n"
   "      if( el.childNodes[i].nodeName == 'UL' )\n"
   "      { cUL = el.childNodes[i]; break; }\n"
   "    if( !cUL )\n"
   "    {\n"
   "      cUL = document.createElement('ul');\n"
   "      if( el.parentNode.lastChild!=el ) cUL.style.backgroundImage = 'url(img_treeLine)';\n"
   "      el.appendChild(cUL);\n"
   "    }\n"
   "    if( el.grps.length > 1 )\n"
   "    {\n"
   "      //> Add and update present\n"
   "      for( var i_g = 0; i_g < el.grps.length; i_g++ )\n"
   "      {\n"
   "	var liN = null;\n"
   "	//> Search present item\n"
   "	if( upTree )\n"
   "	  for( var i_it = 0; i_it < cUL.childNodes.length; i_it++ )\n"
   "	    if( cUL.childNodes[i_it].grps[0].getAttribute('id') == el.grps[i_g].getAttribute('id') )\n"
   "	    { liN = cUL.childNodes[i_it]; break; }\n"
   "	if( !liN )\n"
   "	{\n"
   "	  liN = document.createElement('li');\n"
   "	  if( i_g >= cUL.childNodes.length ) cUL.appendChild(liN);\n"
   "	  else cUL.insertBefore(liN,cUL.childNodes[i_g]);\n"
   "	  liN.isExpand = false;\n"
   "	}\n"
   "	liN.setAttribute('id',el.getAttribute('id'));\n"
   "	//> Set group\n"
   "	liN.grps = new Array(); liN.grps.push(el.grps[i_g]);\n"
   "	//> Init links\n"
   "	var isUsable = parseInt(liN.grps[0].getAttribute('chPresent'));\n"
   "	var treeIco = '/'+MOD_ID+'/img_tree'+(isUsable?(liN.isExpand?'Minus':'Plus'):'')+'Up'+((i_g!=(el.grps.length-1))?'Down':'');\n"
   "	var liCont = isUsable?\"<a class='pm' onclick='expand(this.parentNode,!this.parentNode.isExpand); return false;'>\":\"\";\n"
   "	liCont += \"<img src='\"+treeIco+\"'/></a>\";\n"
   "	liCont += \"<span style='font-style: italic;'>\"+strEncode(el.grps[i_g].getAttribute('dscr'))+\":</span>\";\n"
   "	//>> Next node for update\n"
   "	if( upTree && liN.isExpand )\n"
   "	{\n"
   "	  var liNUL = null;\n"
   "	  for( var i = 0; i < liN.childNodes.length; i++ ) if( liN.childNodes[i].nodeName == 'UL' ) { liNUL = liN.childNodes[i]; break; }\n"
   "	  liN.innerHTML = liCont;\n"
   "	  if( liNUL ) liN.appendChild(liNUL);\n"
   "	  expand(liN,val,upTree);\n"
   "	}\n"
   "	else liN.innerHTML = liCont;\n"
   "      }\n"
   "      //> Delete no present\n"
   "      if( upTree )\n"
   "	for( var i_it = 0; i_it < cUL.childNodes.length; i_it++ )\n"
   "	{\n"
   "	  var i_g;\n"
   "	  for( i_g = 0; i_g < el.grps.length; i_g++ )\n"
   "	    if( cUL.childNodes[i_it].grps[0].getAttribute('id') == el.grps[i_g].getAttribute('id') )\n"
   "	      break;\n"
   "	  if( i_g >= el.grps.length ) { cUL.removeChild(cUL.childNodes[i_it]); i_it--; }\n"
   "	}\n"
   "    }\n"
   "    else\n"
   "    {\n"
   "      var grpId = el.grps[0].getAttribute('id');\n"
   "      var hostN = servGet(el.getAttribute('id'),'com=chlds&grp='+grpId);\n"
   "      if( hostN && parseInt(hostN.getAttribute('rez'))==0 )\n"
   "      {\n"
   "	//> Add and update present\n"
   "	for( var i_e = 0; i_e < hostN.childNodes.length; i_e++ )\n"
   "	{\n"
   "	  var tmpNdId = el.getAttribute('id')+'/'+(grpId+(hostN.childNodes[i_e].getAttribute('id')?hostN.childNodes[i_e].getAttribute('id'):nodeText(hostN.childNodes[i_e])));\n"
   "	  var liN = null;\n"
   "	  //>> Find item\n"
   "	  if( upTree )\n"
   "	    for( var i_it = 0; i_it < cUL.childNodes.length; i_it++ )\n"
   "	      if( cUL.childNodes[i_it].getAttribute('id') == tmpNdId )\n"
   "	      { liN = cUL.childNodes[i_it]; break; }\n"
   "	  if( !liN )\n"
   "	  {\n"
   "	    liN = document.createElement('li');\n"
   "	    if( i_e >= cUL.childNodes.length ) cUL.appendChild(liN);\n"
   "	    else cUL.insertBefore(liN,cUL.childNodes[i_e]);\n"
   "	    liN.isExpand = false;\n"
   "	  }\n"
   "	  liN.setAttribute('id',tmpNdId);\n"
   "	  //> Load groups\n"
   "	  liN.grps = new Array();\n"
   "	  for( var i_grp = 0; i_grp < hostN.childNodes[i_e].childNodes.length; i_grp++ )\n"
   "	    if( hostN.childNodes[i_e].childNodes[i_grp].nodeName == 'grp' )\n"
   "	      liN.grps.push(hostN.childNodes[i_e].childNodes[i_grp]);\n"
   "	  //> Init links\n"
   "	  var isUsable = (liN.grps.length>1)||(liN.grps.length&&parseInt(liN.grps[0].getAttribute('chPresent')));\n"
   "	  var treeIco = '/'+MOD_ID+'/img_tree'+(isUsable?(liN.isExpand?'Minus':'Plus'):'')+'Up'+((i_e!=(hostN.childNodes.length-1))?'Down':'');\n"
   "	  var liCont = isUsable?\"<a class='pm' onclick='expand(this.parentNode,!this.parentNode.isExpand); return false;'>\":\"\";\n"
   "	  liCont += \"<img src='\"+treeIco+\"'/></a>\";\n"
   "	  if( parseInt(hostN.childNodes[i_e].getAttribute('icoSize')) )\n"
   " 	    liCont += \"<span><img src='/\"+MOD_ID+liN.getAttribute('id')+\"?com=ico&size=16'/></span>\"; \n"
   "	    //liCont += \"<span><img height='16px' src='/\"+MOD_ID+liN.getAttribute('id')+\"?com=ico'/></span>\";\n"
   "	  liCont += \"<span><a onclick='selectPage(this.parentNode.parentNode.getAttribute(\\\"id\\\")); return false;' \"+\n"
   "	    \"onmouseover='setStatus(this.parentNode.parentNode.getAttribute(\\\"id\\\"),10000);' href='#'>\"+strEncode(nodeText(hostN.childNodes[i_e]))+\"</a></span>\";\n"
   "	  //>> Next node for update\n"
   "	  if( upTree && liN.isExpand )\n"
   "	  {\n"
   "	    var liNUL = null;\n"
   "	    for( var i_eu = 0; i_eu < liN.childNodes.length; i_eu++ ) if( liN.childNodes[i_eu].nodeName == 'UL' ) { liNUL = liN.childNodes[i_eu]; break; }\n"
   "	    liN.innerHTML = liCont;\n"
   "	    if( liNUL ) liN.appendChild(liNUL);\n"
   "	    expand(liN,val,upTree);\n"
   "	  }\n"
   "	  else liN.innerHTML = liCont;\n"
   "	}\n"
   "	//> Delete no present\n"
   "	if( upTree )\n"
   "	  for( var i_it = 0; i_it < cUL.childNodes.length; i_it++ )\n"
   "	  {\n"
   "	    var i_e;\n"
   "	    for( i_e = 0; i_e < hostN.childNodes.length; i_e++ )\n"
   "	    {\n"
   "	      var grpId = el.grps[0].getAttribute('id');\n"
   "	      var tmpNdId = el.getAttribute('id')+'/'+(grpId+(hostN.childNodes[i_e].getAttribute('id')?hostN.childNodes[i_e].getAttribute('id'):nodeText(hostN.childNodes[i_e])));\n"
   "	      if( cUL.childNodes[i_it].getAttribute('id') == tmpNdId ) break;\n"
   "	    }\n"
   "	    if( i_e >= hostN.childNodes.length ) { cUL.removeChild(cUL.childNodes[i_it]); i_it--; }\n"
   "	  }\n"
   "      }\n"
   "    }\n"
   "  }\n"
   "\n"
   "  if( el.isExpand != val )\n"
   "  {\n"
   "    //> Change tree icon\n"
   "    el.childNodes[0].childNodes[0].src = val ? el.childNodes[0].childNodes[0].src.replace('Plus','Minus') :\n"
   "					       el.childNodes[0].childNodes[0].src.replace('Minus','Plus');\n"
   "    el.isExpand = val;\n"
   "  }\n"
   "}\n"
   "/***************************************************\n"
   " * selectPage - Select node by user.               *\n"
   " ***************************************************/\n"
   "function selectPage( path )\n"
   "{\n"
   "  if( !path ) return;\n"
   "\n"
   "  //> Prev and next\n"
   "  if( selPath.length ) ndPrev.push(selPath);\n"
   "  while( ndPrev.length >= queSZ ) ndPrev.shift();\n"
   "  ndNext = new Array();\n"
   "\n"
   "  //> Page display\n"
   "  pageDisplay(path);\n"
   "}\n"
   "/***************************************************\n"
   " * pageDisplay - Display selected page.            *\n"
   " ***************************************************/\n"
   "function pageDisplay( path )\n"
   "{\n"
   "  if( !path ) return;\n"
   "\n"
   "  //> Chek Up\n"
   "  actEnable('actUp',path.lastIndexOf('/') != -1 && path.lastIndexOf('/') != 0);\n"
   "\n"
   "  //> Check Prev and Next\n"
   "  actEnable('actPrevious',ndPrev.length);\n"
   "  actEnable('actNext',ndNext.length);\n"
   "\n"
   "  if( path != pgInfo.getAttribute('path') )\n"
   "  {\n"
   "    //> Stop refresh\n"
   "    pageCyclRefrStop();\n"
   "\n"
   "    if( selPath.length && document.getElementById(selPath) ) document.getElementById(selPath).className = '';\n"
   "    selPath = path;\n"
   "    if( selPath.length && document.getElementById(selPath) ) document.getElementById(selPath).className = 'select';\n"
   "    setNodeText(document.getElementById('selPath'),selPath);\n"
   "\n"
   "    pgInfo = servGet(selPath,'com=info');\n"
   "    if( parseInt(pgInfo.getAttribute('rez'))!=0 ) { alert(nodeText(pgInfo)); return; }\n"
   "    pgInfo.setAttribute('path',selPath);\n"
   "    root = pgInfo.childNodes[0];\n"
   "  }\n"
   "  else\n"
   "  {\n"
   "    //>> Check the new node structure and the old node\n"
   "    var iTree = servGet(selPath,'com=info');\n"
   "    if( parseInt(iTree.getAttribute('rez'))!=0 ) { alert(nodeText(iTree)); return; }\n"
   "    if( chkStruct(root,iTree.childNodes[0]) )\n"
   "    { pgInfo = iTree; pgInfo.setAttribute('path',selPath); root = pgInfo.childNodes[0]; }\n"
   "  }\n"
   "\n"
   "  //> Complex request form and it result use\n"
   "  genReqs = crDoc();\n"
   "  genReqs.appendChild(genReqs.createElement('CntrReqs'));\n"
   "  genReqs.childNodes[0].setAttribute('path',selPath);\n"
   "  genReqs.childNodes[0].setAttribute('fillMode','1');\n"
   "  for(var genReqPrc = 0; genReqPrc < 2; genReqPrc++)\n"
   "  {\n"
   "    selectChildRecArea(root,'/',null);\n"
   "\n"
   "    //> Load and Save allow check\n"
   "    var reqModif = servGet('/%2fobj','com=modify');\n"
   "    actEnable('actLoad',parseInt(nodeText(reqModif)));\n"
   "    actEnable('actSave',parseInt(nodeText(reqModif)));\n"
   "\n"
   "    //> Send prepared generic request\n"
   "    if(genReqPrc == 0)\n"
   "    {\n"
   "	genReqs.childNodes[0].setAttribute('fillMode','0');\n"
   "	genReqs = servReq(genReqs);\n"
   "    }\n"
   "  }\n"
   "  genReqs = null;\n"
   "\n"
   "  //> The add and the delete access allow check\n"
   "  actEnable('actAddIt',false);\n"
   "  for( var i_ch = 0; i_ch < root.childNodes.length; i_ch++ )\n"
   "    if( root.childNodes[i_ch].getAttribute('id') == 'br' )\n"
   "    {\n"
   "      for( var i_g = 0; i_g < root.childNodes[i_ch].childNodes.length; i_g++ )\n"
   "        if( parseInt(root.childNodes[i_ch].childNodes[i_g].getAttribute('acs'))&SEC_WR )\n"
   "        { actEnable('actAddIt',true); break; }\n"
   "      break;\n"
   "    }\n"
   "  actEnable('actDelIt',parseInt(root.getAttribute('acs'))&SEC_WR)\n"
   "\n"
   "  //> Edit tools update\n"
   "  editToolUpdate( );\n"
   "}\n"
   "/***************************************************\n"
   " * editToolUpdate - Edit action state update.      *\n"
   " ***************************************************/\n"
   "function editToolUpdate( )\n"
   "{\n"
   "  actEnable('actCut',(selPath.length&&parseInt(root.getAttribute('acs'))&SEC_WR));\n"
   "  actEnable('actCopy',selPath.length);\n"
   "  actEnable('actPaste',false);\n"
   "\n"
   "  //> Src and destination elements calc\n"
   "  if( copyBuf.length <= 1 || copyBuf.substr(1) == selPath || pathLev(copyBuf.substr(1),0) != pathLev(selPath,0) ) return;\n"
   "  var s_elp; var s_el; var t_el;\n"
   "  pathLev.off = 0;\n"
   "  while( (t_el=pathLev(copyBuf.substr(1),0,true)).length )\n"
   "  { s_elp += ('/'+s_el); s_el = t_el; }\n"
   "\n"
   "  for( var i_ch = 0; i_ch < root.childNodes.length; i_ch++ )\n"
   "    if( root.childNodes[i_ch].getAttribute('id') == 'br' )\n"
   "    {\n"
   "      for( var i_g = 0; i_g < root.childNodes[i_ch].childNodes.length; i_g++ )\n"
   "        if( parseInt(root.childNodes[i_ch].childNodes[i_g].getAttribute('acs'))&SEC_WR )\n"
   "        { actEnable('actPaste',true); break; }\n"
   "      break;\n"
   "    }\n"
   "  if( parseInt(root.getAttribute('acs'))&SEC_WR ) actEnable('actPaste',true);\n"
   "}\n"
   "/***************************************************\n"
   " * selectChildRecArea - Make page content          *\n"
   " ***************************************************/\n"
   "function selectChildRecArea( node, aPath, cBlk )\n"
   "{\n"
   "  var i_area = 0;\n"
   "  //> View title name\n"
   "  if( aPath == \"/\" )\n"
   "  {\n"
   "    //>> Set node icon\n"
   "    if( nodeTextByTagId(node,'img','ico') != null )\n"
   "    {\n"
   "	document.getElementById('pgIco').src = '/'+MOD_ID+selPath+'?com=ico&size=32';\n"
   "	document.getElementById('pgIco').style.visibility = 'visible';\n"
   "    }\n"
   "    else document.getElementById('pgIco').style.visibility = 'hidden';\n"
   "    //>> Set title\n"
   "    setNodeText(document.getElementById('pgTitle'),node.getAttribute('dscr'));\n"
   "    //>> Delete tabs of deleted areas\n"
   "    var activeTab = null;\n"
   "    var tabs = document.getElementById('pgTabs');\n"
   "    for( var i_tbs = 0; i_tbs < tabs.childNodes.length; i_tbs++ )\n"
   "    {\n"
   "      var i_cf;\n"
   "      for( i_cf = 0; i_cf < node.childNodes.length; i_cf++ )\n"
   "	if( node.childNodes[i_cf].nodeName.toLowerCase() == 'area' && nodeText(tabs.childNodes[i_tbs]) == node.childNodes[i_cf].getAttribute('dscr') )\n"
   "	  break;\n"
   "      if( i_cf >= node.childNodes.length )\n"
   "      {\n"
   "	tabs.removeChild(tabs.childNodes[i_tbs]);\n"
   "	i_tbs--;\n"
   "      }\n"
   "      else if( tabs.childNodes[i_tbs].className == 'active' ) activeTab = tabs.childNodes[i_tbs];\n"
   "    }\n"
   "    //>> Add new tabs\n"
   "    for( var i_cf = 0; i_cf < node.childNodes.length; i_cf++ )\n"
   "    {\n"
   "      if( node.childNodes[i_cf].nodeName.toLowerCase() != 'area' ) continue;\n"
   "      var i_tbs;\n"
   "      for( i_tbs = 0; i_tbs < tabs.childNodes.length; i_tbs++ )\n"
   "	if( nodeText(tabs.childNodes[i_tbs]) == node.childNodes[i_cf].getAttribute('dscr') )\n"
   "	  break;\n"
   "      if( i_tbs >= tabs.childNodes.length )\n"
   "      {\n"
   "	 var itab = document.createElement('span');\n"
   "	 setNodeText(itab,node.childNodes[i_cf].getAttribute('dscr'));\n"
   "	 itab.onclick = function( ) { tabSelect(this); return false; }\n"
   "	 if( i_area >= tabs.childNodes.length ) tabs.appendChild(itab);\n"
   "	 else tabs.insertBefore(itab,tabs.childNodes[i_area]);\n"
   "	 node.childNodes[i_cf].setAttribute('qview','0');\n"
   "      }\n"
   "      i_area++;\n"
   "    }\n"
   "    if( !activeTab && tabs.childNodes.length ) { activeTab = tabs.childNodes[0]; activeTab.className = 'active'; }\n"
   "    //>> Prepare active tab\n"
   "    for( var i_cf = 0; i_cf < node.childNodes.length; i_cf++ )\n"
   "      if( node.childNodes[i_cf].nodeName.toLowerCase() == 'area' && nodeText(activeTab) == node.childNodes[i_cf].getAttribute('dscr') )\n"
   "      {\n"
   "	var refresh = parseInt(node.childNodes[i_cf].getAttribute('qview'));\n"
   "	var cPg = document.getElementById('pgCont');\n"
   "	if( !refresh )\n"
   "	{\n"
   "	  while( cPg.childNodes.length ) cPg.removeChild(cPg.childNodes[0]);\n"
   "	  selectChildRecArea(node.childNodes[i_cf],aPath+node.childNodes[i_cf].getAttribute('id')+'/',cPg);\n"
   "	  //>>> Mark last drawed tabs\n"
   "	  node.childNodes[i_cf].setAttribute('qview','1');\n"
   "	}\n"
   "	else selectChildRecArea(node.childNodes[i_cf],aPath+node.childNodes[i_cf].getAttribute('id')+'/',null);\n"
   "      }\n"
   "    return;\n"
   "  }\n"
   "  else for( var i_cf = 0; i_cf < node.childNodes.length; i_cf++ )\n"
   "  {\n"
   "    var t_s = node.childNodes[i_cf];\n"
   "\n"
   "    //>> Check access to node\n"
   "    var wr = parseInt(t_s.getAttribute('acs'))&SEC_WR;\n"
   "\n"
   "    //>> View areas\n"
   "    if( t_s.nodeName.toLowerCase() == 'area' )\n"
   "    {\n"
   "      var cntBlk = cBlk;\n"
   "      if( cntBlk )\n"
   "      {\n"
   "        var cntBlk = document.createElement('fieldset');\n"
   "        cntBlk.className = 'elem';\n"
   "        cntBlk.appendChild(document.createElement('legend'));\n"
   "        cntBlk.childNodes[0].appendChild(document.createTextNode(t_s.getAttribute('dscr')));\n"
   "        cBlk.appendChild(cntBlk);\n"
   "      }\n"
   "      selectChildRecArea(t_s,aPath+t_s.getAttribute('id')+'/',cntBlk);\n"
   "    }\n"
   "    //>> View list elements\n"
   "    else if( t_s.nodeName.toLowerCase() == 'list' )\n"
   "    {\n"
   "      var brPath = (aPath+t_s.getAttribute('id')).replace(/%/g,'%25').replace(/\\//g,'%2f');\n"
   "      var lab = null; var val = null;\n"
   "\n"
   "      if( cBlk )\n"
   "      {\n"
   "	var dBlk = document.createElement('div'); dBlk.className = 'elem';\n"
   "	lab = document.createElement('span'); lab.className = 'label';\n"
   "	dBlk.appendChild(lab);\n"
   "	dBlk.appendChild(document.createElement('br'));\n"
   "	val = document.createElement('select'); val.className = 'list';\n"
   "	val.size = 10;\n"
   "	val.srcNode = t_s;\n"
   "	val.itPath = selPath+'/'+brPath;\n"
   "	val.onmouseover = function() { setStatus(this.itPath,10000); }\n"
   "	val.onclick = function(e)\n"
   "	{\n"
   "	  if( !e ) e = window.event;\n"
   "	  var popUpMenu = getPopup();\n"
   "	  var optEl = '';\n"
   "	  if( this.srcNode.getAttribute('tp') == 'br' && this.selectedIndex >= 0 )\n"
   "	    optEl += \"<option posId='go'>###Go###</option><option disabled='true'>------------</option>\";\n"
   "	  if( (parseInt(this.srcNode.getAttribute('acs'))&SEC_WR) && this.srcNode.getAttribute('s_com') )\n"
   "	  {\n"
   "	    if( this.srcNode.getAttribute('s_com').search('add') != -1 ) optEl += \"<option posId='add'>###Add###</option>\";\n"
   "	    if( this.srcNode.getAttribute('s_com').search('ins') != -1 && this.selectedIndex >= 0 ) optEl += \"<option posId='ins'>###Insert###</option>\";\n"
   "	    if( this.srcNode.getAttribute('s_com').search('edit') != -1 && this.selectedIndex >= 0 ) optEl += \"<option posId='edit'>###Edit###</option>\";\n"
   "	    if( this.srcNode.getAttribute('s_com').search('del') != -1 && this.selectedIndex >= 0 ) optEl += \"<option posId='del'>###Delete###</option>\";\n"
   "	    if( this.srcNode.getAttribute('s_com').search('move') != -1 && this.selectedIndex >= 0 )\n"
   "	      optEl += \"<option disabled='true'>------------</option><option posId='up'>###Item up###</option><option posId='down'>###Item down###</option>\";\n"
   "	  }\n"
   "	  popUpMenu.childNodes[0].innerHTML = optEl;\n"
   "	  if( popUpMenu.childNodes[0].childNodes.length )\n"
   "	  {\n"
   "	    popUpMenu.srcNode = this.srcNode;\n"
   "	    popUpMenu.itPath = this.itPath;\n"
   "	    if( this.selectedIndex >= 0 )\n"
   "	    {\n"
   "	      popUpMenu.lsId = this.options[this.selectedIndex].lsId;\n"
   "	      popUpMenu.lsText = this.options[this.selectedIndex].value;\n"
   "	      if( !popUpMenu.lsId ) popUpMenu.lsId = popUpMenu.lsText;\n"
   "	    }\n"
   "	    popUpMenu.childNodes[0].size = Math.max(3,popUpMenu.childNodes[0].childNodes.length);\n"
   "	    popUpMenu.style.cssText = 'visibility: visible; left: '+(e.clientX+window.pageXOffset)+'px; top: '+(e.clientY+window.pageYOffset)+'px;';\n"
   "	    popUpMenu.childNodes[0].focus();\n"
   "	    popUpMenu.childNodes[0].selectedIndex = -1;\n"
   "	    popUpMenu.childNodes[0].onclick = function()\n"
   "	    {\n"
   "	      this.parentNode.style.cssText = 'visibility: hidden; left: -200px; top: -200px;';\n"
   "	      if( this.selectedIndex < 0 || !this.options[this.selectedIndex].getAttribute('posId') ) return;\n"
   "	      var idm = parseInt(this.parentNode.srcNode.getAttribute('idm'));\n"
   "	      var posId = this.options[this.selectedIndex].getAttribute('posId');\n"
   "	      if( posId == 'go' )\n"
   "	        selectPage(selPath+'/'+(this.parentNode.srcNode.getAttribute('br_pref')+this.parentNode.lsId).replace(/%/g,'%25').replace(/\\//g,'%2f'));\n"
   "	      else if( posId == 'add' || posId == 'ins' || posId == 'edit' )\n"
   "	      {\n"
   "		dlgWin = ReqIdNameDlg('/'+MOD_ID+'/ico');\n"
   "		setNodeText(dlgWin.document.getElementById('wDlgHeader'),'###Item name set###');\n"
   "		var fIdVal = dlgWin.document.getElementById('wDlgId').childNodes[1].childNodes[0];\n"
   "		fIdVal.maxLength = this.parentNode.srcNode.getAttribute('idSz');\n"
   "		if( !fIdVal.maxLength ) fIdVal.maxLength = 1000;\n"
   "		dlgWin.document.getElementById('wDlgType').style.display = 'none';\n"
   "		dlgWin.document.getElementById('wDlgName').style.display = idm?'':'none';\n"
   "		var actOkFld = dlgWin.document.getElementById('wDlgActOk');\n"
   "		actOkFld.itPath = this.parentNode.itPath;\n"
   "		actOkFld.srcNode = this.parentNode.srcNode;\n"
   "		actOkFld.selectedIndex = this.selectedIndex;\n"
   "		actOkFld.lsId = this.parentNode.lsId;\n"
   "		actOkFld.lsText = this.parentNode.lsText;\n"
   "		if( posId == 'add' )\n"
   "		{\n"
   "		  setNodeText(dlgWin.document.getElementById('wDlgTitle').childNodes[1],'###Add new element.###');\n"
   "		  actOkFld.onclick = function()\n"
   "		  {\n"
   "		    var idm = dlgWin.document.getElementById('wDlgName').style.display!='none';\n"
   "		    var inpId = dlgWin.document.getElementById('wDlgId').childNodes[1].childNodes[0].value;\n"
   "		    var inpName = idm ? dlgWin.document.getElementById('wDlgName').childNodes[1].childNodes[0].value : inpId;\n"
   "		    var rez = servSet(this.itPath,'com=com',\"<add \"+(idm?(\"id='\"+inpId+\"'\"):\"\")+\">\"+inpName+\"</add>\",true);\n"
   "		    if( rez && parseInt(rez.getAttribute('rez')) != 0 ) alert(nodeText(rez));\n"
   "		    if( this.srcNode.getAttribute('tp') == 'br' ) treeUpdate();\n"
   "		    pageRefresh();\n"
   "		    document.body.dlgWin.close();\n"
   "		    return false;\n"
   "		  }\n"
   "		}\n"
   "		else if( posId == 'ins' )\n"
   "		{\n"
   "		  setNodeText(dlgWin.document.getElementById('wDlgTitle').childNodes[1],'###Insert new element.###');\n"
   "		  actOkFld.onclick = function()\n"
   "		  {\n"
   "		    var idm = dlgWin.document.getElementById('wDlgName').style.display!='none';\n"
   "		    var inpId = dlgWin.document.getElementById('wDlgId').childNodes[1].childNodes[0].value;\n"
   "		    var inpName = idm ? dlgWin.document.getElementById('wDlgName').childNodes[1].childNodes[0].value : inpId;\n"
   "		    var com = \"<ins \"+(idm?(\"id='\"+inpId+\"' \"):\"\")+\" pos='\"+this.selectedIndex+\"' p_id='\"+this.lsId+\"'>\"+inpName+\"</ins>\";\n"
   "		    var rez = servSet(this.itPath,'com=com',com,true);\n"
   "		    if( rez && parseInt(rez.getAttribute('rez')) != 0 ) alert(nodeText(rez));\n"
   "		    if( this.srcNode.getAttribute('tp') == 'br' ) treeUpdate();\n"
   "		    pageRefresh();\n"
   "		    document.body.dlgWin.close();\n"
   "		    return false;\n"
   "		  }\n"
   "		}\n"
   "		else if( posId == 'edit' )\n"
   "		{\n"
   "		  setNodeText(dlgWin.document.getElementById('wDlgTitle').childNodes[1],'###Rename element.###');\n"
   "		  dlgWin.document.getElementById('wDlgId').childNodes[1].childNodes[0].value = idm ? this.parentNode.lsId : this.parentNode.lsText;\n"
   "		  if( idm ) dlgWin.document.getElementById('wDlgName').childNodes[1].childNodes[0].value = this.parentNode.lsText;\n"
   "		  actOkFld.onclick = function()\n"
   "		  {\n"
   "		    var idm = dlgWin.document.getElementById('wDlgName').style.display!='none';\n"
   "		    var inpId = dlgWin.document.getElementById('wDlgId').childNodes[1].childNodes[0].value;\n"
   "		    var inpName = idm ? dlgWin.document.getElementById('wDlgName').childNodes[1].childNodes[0].value : inpId;\n"
   "		    var com = \"<edit \"+(idm?(\"id='\"+inpId+\"' \"):\"\")+\" pos='\"+this.selectedIndex+\"' p_id='\"+this.lsId+\"'>\"+inpName+\"</edit>\";\n"
   "		    var rez = servSet(this.itPath,'com=com',com,true);\n"
   "		    if( rez && parseInt(rez.getAttribute('rez')) != 0 ) alert(nodeText(rez));\n"
   "		    if( this.srcNode.getAttribute('tp') == 'br' ) treeUpdate();\n"
   "		    pageRefresh();\n"
   "		    document.body.dlgWin.close();\n"
   "		    return false;\n"
   "		  }\n"
   "		}\n"
   "	      }\n"
   "	      else if( posId == 'up' || posId == 'down' )\n"
   "	      {\n"
   "		var c_new = (posId == 'down') ? c_new = this.selectedIndex+1 : this.selectedIndex-1;\n"
   "		var rez = servSet(this.parentNode.itPath,'com=com',\"<move pos='\"+this.selectedIndex+\"' to='\"+c_new+\"'/>\",true);\n"
   "		if( rez && parseInt(rez.getAttribute('rez')) != 0 ) alert(nodeText(rez));\n"
   "		pageRefresh();\n"
   "	      }\n"
   "	      else if( posId == 'del' )\n"
   "	      {\n"
   "		var com = idm ? (\"<del pos='\"+this.selectedIndex+\"' id='\"+this.parentNode.lsId+\"'/>\") :\n"
   "				(\"<del pos='\"+this.selectedIndex+\"'>\"+this.parentNode.lsText+\"</del>\");\n"
   "		var rez = servSet(this.parentNode.itPath,'com=com',com,true);\n"
   "		if( rez && parseInt(rez.getAttribute('rez')) != 0 ) alert(nodeText(rez));\n"
   "		if( this.parentNode.srcNode.getAttribute('tp') == 'br' ) treeUpdate();\n"
   "		pageRefresh();\n"
   "	      }\n"
   "	      return false;\n"
   "	    }\n"
   "	  }\n"
   "	  return false;\n"
   "	}\n"
   "	dBlk.appendChild(val);\n"
   "	cBlk.appendChild(dBlk);\n"
   "\n"
   "	t_s.addr_lab = lab; t_s.addr_val = val;\n"
   "      }\n"
   "      else { lab = t_s.addr_lab; val = t_s.addr_val; }\n"
   "      //>>> Fill list\n"
   "      setNodeText(lab,t_s.getAttribute('dscr')+': ');\n"
   "      val.title = t_s.getAttribute('help');\n"
   "\n"
   "      while(val.childNodes.length) val.removeChild(val.childNodes[0]);\n"
   "      var dataReq = servGet(brPath,'com=get');\n"
   "      if(!dataReq) continue;\n"
   "      if(parseInt(dataReq.getAttribute('rez'))!=0) { alert(nodeText(dataReq)); continue; }\n"
   "      for(var i_el = 0; i_el < dataReq.childNodes.length; i_el++)\n"
   "	if(dataReq.childNodes[i_el].nodeName.toLowerCase() == 'el')\n"
   "	{\n"
   "	  var opt = document.createElement('option');\n"
   "	  opt.lsId = dataReq.childNodes[i_el].getAttribute('id');\n"
   "	  setNodeText(opt,nodeText(dataReq.childNodes[i_el]));\n"
   "	  val.appendChild(opt);\n"
   "	}\n"
   "      while(val.childNodes.length < 4) { var opt = document.createElement('option'); opt.disabled = true; val.appendChild(opt); }\n"
   "      val.size = Math.min(10,Math.max(4,val.childNodes.length));\n"
   "    }\n"
   "    //>> View images\n"
   "    else if( t_s.nodeName.toLowerCase() == \"img\" )\n"
   "    {\n"
   "      var brPath = (aPath+t_s.getAttribute('id')).replace(/%/g,'%25').replace(/\\//g,'%2f').replace(/%/g,'%25');\n"
   "      var lab = null; var val = null;\n"
   "\n"
   "      if( cBlk )\n"
   "      {\n"
   "	var dBlk = document.createElement('div'); dBlk.className = 'elem';\n"
   "	lab = document.createElement('span'); lab.className = 'label';\n"
   "	dBlk.appendChild(lab);\n"
   "	if( !t_s.getAttribute(\"v_sz\") || parseInt(t_s.getAttribute(\"v_sz\")) > 70 ) dBlk.appendChild(document.createElement('br'));\n"
   "	val = document.createElement('img'); val.className = 'picture';\n"
   "	if( t_s.getAttribute('h_sz') ) val.style.width = t_s.getAttribute('h_sz')+'px';\n"
   "	if( t_s.getAttribute(\"v_sz\") ) val.style.height = t_s.getAttribute(\"v_sz\")+'px';\n"
   "	val.itPath = selPath+'/'+brPath;\n"
   "	val.onmouseover = function() { setStatus(this.itPath,10000); }\n"
   "	if( wr )\n"
   "	{\n"
   "	  val.style.cursor = 'pointer';\n"
   "	  val.onclick = function( )\n"
   "	  {\n"
   "	    dlgWin = ReqIdNameDlg('/'+MOD_ID+'/img_save','###Select image file for download to picture field.###','/'+MOD_ID+this.itPath+'?com=img',true);\n"
   "	    setNodeText(dlgWin.document.getElementById('wDlgHeader'),'###Image set###');\n"
   "	    dlgWin.document.getElementById('wDlgType').style.display = 'none';\n"
   "	    dlgWin.document.getElementById('wDlgId').style.display = 'none';\n"
   "	    dlgWin.document.getElementById('wDlgName').style.display = '';\n"
   "	    dlgWin.document.getElementById('wDlgActOk').type = 'submit';\n"
   "	    if( !isKonq ) dlgWin.document.getElementById('wDlgFormBlk').onsubmit = function( ) { setTimeout('document.body.dlgWin.close(); pageRefresh();',200); }\n"
   "	    else dlgWin.document.getElementById('wDlgActCancel').onclick = function( ) { setTimeout('document.body.dlgWin.close(); pageRefresh();',200); }\n"
   "	    return false;\n"
   "	  }\n"
   "	}\n"
   "	dBlk.appendChild(val);\n"
   "	cBlk.appendChild(dBlk);\n"
   "\n"
   "	t_s.addr_lab = lab; t_s.addr_val = val;\n"
   "      }\n"
   "      else { lab = t_s.addr_lab; val = t_s.addr_val; }\n"
   "      //>>> Set image\n"
   "      if( lab ) setNodeText(lab,t_s.getAttribute('dscr')+':');\n"
   "      if( val )\n"
   "      {\n"
   "	val.title = t_s.getAttribute('help');\n"
   "	val.src = '/'+MOD_ID+selPath+'/'+brPath+'?com=img&rnd='+Math.floor(Math.random()*1000);\n"
   "      }\n"
   "    }\n"
   "    else if( t_s.nodeName.toLowerCase() == 'table' )\n"
   "    {\n"
   "      var brPath = (aPath+t_s.getAttribute('id')).replace(/%/g,'%25').replace(/\\//g,'%2f');\n"
   "      var lab = null; var table = null;\n"
   "      if( cBlk )\n"
   "      {\n"
   "	var dBlk = document.createElement('div'); dBlk.className = 'elem';\n"
   "	lab = document.createElement('span'); lab.className = 'label';\n"
   "	dBlk.appendChild(lab);\n"
   "	dBlk.appendChild(document.createElement('div')); dBlk.childNodes[1].className = 'table';\n"
   "	table = document.createElement('table'); table.className = 'elem'; table.cellPadding = 2; table.cellSpacing = 0;\n"
   "	table.itPath = selPath+'/'+brPath;\n"
   "	table.onmouseover = function() { setStatus(this.itPath,10000); }\n"
   "	if( wr )\n"
   "	{\n"
   "	  table.srcNode = t_s;\n"
   "	  table.comSet = function(row,col,val)\n"
   "	  {\n"
   "	    var com = \"<set col='\"+this.srcNode.childNodes[col].getAttribute('id')+\"' \";\n"
   "	    if( !this.srcNode.getAttribute('key') ) com += \"row='\"+row+\"' \";\n"
   "	    else\n"
   "	    {\n"
   "	      var keys = this.srcNode.getAttribute('key').split(',');\n"
   "	      for( var i_off = 0; i_off < keys.length; i_off++ )\n"
   "		for( var i_el = 0; i_el < this.srcNode.childNodes.length; i_el++ )\n"
   "		  if( this.srcNode.childNodes[i_el].getAttribute('id') == keys[i_off] )\n"
   "		  { com += \"key_\"+keys[i_off]+\"='\"+nodeText(this.srcNode.childNodes[i_el].childNodes[row])+\"' \"; break; }\n"
   "	     }\n"
   "	     com += \">\"+strEncode(val)+\"</set>\";\n"
   "\n"
   "	     var rez = servSet(this.itPath,'com=com',com,true);\n"
   "	     if( rez && parseInt(rez.getAttribute('rez')) != 0 ) alert(nodeText(rez));\n"
   "	     setTimeout('pageRefresh()',500);\n"
   "	  }\n"
   "	}\n"
   "	dBlk.childNodes[1].appendChild(table);\n"
   "	cBlk.appendChild(dBlk);\n"
   "\n"
   "	t_s.addr_lab = lab; t_s.addr_tbl = table;\n"
   "      }else { table = t_s.addr_tbl; lab = t_s.addr_lab; }\n"
   "      //>>> Fill table\n"
   "\n"
   "      if( lab ) setNodeText(lab,t_s.getAttribute('dscr')+':');\n"
   "      if( table )\n"
   "      {\n"
   "	table.title = t_s.getAttribute('help');\n"
   "\n"
   "	var dataReq = servGet(brPath,'com=get');\n"
   "	if(dataReq && parseInt(dataReq.getAttribute('rez'))!=0) { alert(nodeText(dataReq)); continue; }\n"
   "\n"
   "	//>>>> Copy values to info tree\n"
   "	for( var i_cl = 0; dataReq && i_cl < dataReq.childNodes.length; i_cl++ )\n"
   "	{\n"
   "	  var i_cli;\n"
   "	  for( i_cli = 0; i_cli < t_s.childNodes.length; i_cli++ )\n"
   "	    if( dataReq.childNodes[i_cl].getAttribute('id') == t_s.childNodes[i_cli].getAttribute('id') ) break;\n"
   "	  if( i_cli == t_s.childNodes.length )\n"
   "	  {\n"
   "	    var el = t_s.ownerDocument.createElement(dataReq.childNodes[i_cl].nodeName);\n"
   "	    for( var i_a = 0; i_a < dataReq.childNodes[i_cl].attributes.length; i_a++ )\n"
   "		el.setAttribute(dataReq.childNodes[i_cl].attributes[i_a].name,dataReq.childNodes[i_cl].attributes[i_a].value);\n"
   "	    t_s.appendChild(el);\n"
   "	  }\n"
   "	  while( t_s.childNodes[i_cli].lastChild ) t_s.childNodes[i_cli].removeChild(t_s.childNodes[i_cli].lastChild);\n"
   "	  for( var i_rw = 0; i_rw < dataReq.childNodes[i_cl].childNodes.length; i_rw++ )\n"
   "	  {\n"
   "	    var el = t_s.ownerDocument.createElement(dataReq.childNodes[i_cl].childNodes[i_rw].nodeName);\n"
   "	    setNodeText(el,nodeText(dataReq.childNodes[i_cl].childNodes[i_rw]))\n"
   "	    t_s.childNodes[i_cli].appendChild(el);\n"
   "	  }\n"
   "	}\n"
   "	//>>>> Calc rows and columns\n"
   "	var n_col = t_s.childNodes.length;\n"
   "	var n_row = n_col ? t_s.childNodes[0].childNodes.length : 0;\n"
   "\n"
   "	//>>>> Update table structure\n"
   "	while( table.childNodes.length > (n_row+1) ) table.removeChild(table.lastChild);\n"
   "	while( table.childNodes.length < (n_row+1) ) table.appendChild(document.createElement('tr'));\n"
   "\n"
   "	for( var i_rw = 0; i_rw < table.childNodes.length; i_rw++ )\n"
   "	{\n"
   "	  while( table.childNodes[i_rw].childNodes.length > (n_col+1) ) table.childNodes[i_rw].removeChild(table.childNodes[i_rw].lastChild);\n"
   "	  while( table.childNodes[i_rw].childNodes.length < (n_col+1) )\n"
   "	  {\n"
   "	    var cCell = document.createElement(i_rw?'td':'th');\n"
   "	    if( !table.childNodes[i_rw].childNodes.length )\n"
   "	    {\n"
   "	      if( i_rw ) cCell.className = 'hd';\n"
   "	      if( wr && t_s.getAttribute('s_com') )\n"
   "	      {\n"
   "		cCell.style.cursor = 'pointer';\n"
   "		cCell.srcNode = t_s;\n"
   "		cCell.onclick = function( e )\n"
   "		{\n"
   "		  var rowP = parseInt(nodeText(this));\n"
   "		  if( !e ) e = window.event;\n"
   "		  var popUpMenu = getPopup();\n"
   "		  var optEl = '';\n"
   "		  if( this.srcNode.getAttribute('s_com').search('add') != -1 ) optEl += \"<option posId='add'>###Add row###</option>\";\n"
   "		  if( this.srcNode.getAttribute('s_com').search('ins') != -1 && rowP ) optEl += \"<option posId='ins'>###Insert row###</option>\";\n"
   "		  if( this.srcNode.getAttribute('s_com').search('del') != -1 && rowP ) optEl += \"<option posId='del'>###Delete row###</option>\";\n"
   "		  if( this.srcNode.getAttribute('s_com').search('move') != -1 && rowP )\n"
   "		    optEl += \"<option disabled='true'>--------------</option><option posId='up'>###Up row###</option><option posId='down'>###Down row###</option>\";\n"
   "		  popUpMenu.childNodes[0].innerHTML = optEl;\n"
   "\n"
   "		  if( popUpMenu.childNodes[0].childNodes.length )\n"
   "		  {\n"
   "		    popUpMenu.childNodes[0].srcNode = this.srcNode;\n"
   "		    popUpMenu.childNodes[0].itPath = this.parentNode.parentNode.itPath;\n"
   "		    popUpMenu.childNodes[0].rowP = rowP-1;\n"
   "		    popUpMenu.childNodes[0].size = Math.max(3,popUpMenu.childNodes[0].childNodes.length);\n"
   "		    popUpMenu.style.cssText = 'visibility: visible; left: '+(e.clientX+window.pageXOffset)+'px; top: '+(e.clientY+window.pageYOffset)+'px;';\n"
   "		    popUpMenu.childNodes[0].focus();\n"
   "		    popUpMenu.childNodes[0].selectedIndex = -1;\n"
   "		    popUpMenu.childNodes[0].onclick = function()\n"
   "		    {\n"
   "		      this.parentNode.style.cssText = 'visibility: hidden; left: -200px; top: -200px;';\n"
   "		      if( this.selectedIndex < 0 || !this.options[this.selectedIndex].getAttribute('posId') ) return;\n"
   "		      var posId = this.options[this.selectedIndex].getAttribute('posId');\n"
   "		      var com = '';\n"
   "		      if( posId == 'add' ) com = \"<add/>\";\n"
   "		      else if( posId == 'ins' ) com = \"<ins row='\"+this.rowP+\"'/>\";\n"
   "		      else if( posId == 'up' ) com = \"<move row='\"+this.rowP+\"' to='\"+(this.rowP-1)+\"'/>\";\n"
   "		      else if( posId == 'down' ) com = \"<move row='\"+this.rowP+\"' to='\"+(this.rowP+1)+\"'/>\";\n"
   "		      else if( posId == 'del' )\n"
   "		      {\n"
   "			var com = \"<del \";\n"
   "			if( !this.srcNode.getAttribute('key') ) com += \"row='\"+this.rowP+\"' \";\n"
   "			else\n"
   "			{\n"
   "			  var keys = this.srcNode.getAttribute('key').split(',');\n"
   "			  for( var i_off = 0; i_off < keys.length; i_off++ )\n"
   "			    for( var i_el = 0; i_el < this.srcNode.childNodes.length; i_el++ )\n"
   "			      if( this.srcNode.childNodes[i_el].getAttribute('id') == keys[i_off] )\n"
   "			      { com += \"key_\"+keys[i_off]+\"='\"+nodeText(this.srcNode.childNodes[i_el].childNodes[this.rowP])+\"' \"; break; }\n"
   "			}\n"
   "			com += \"/>\";\n"
   "		      }\n"
   "		      if( com.length )\n"
   "		      {\n"
   "			var rez = servSet(this.itPath,'com=com',com,true);\n"
   "			if( rez && parseInt(rez.getAttribute('rez')) != 0 ) alert(nodeText(rez));\n"
   "			setTimeout('pageRefresh()',200);\n"
   "		      }\n"
   "		      return false;\n"
   "		    }\n"
   "		  }\n"
   "		  return false;\n"
   "		}\n"
   "	      }\n"
   "	    }\n"
   "	    else if( i_rw && wr && parseInt(t_s.childNodes[table.childNodes[i_rw].childNodes.length-1].getAttribute('acs'))&SEC_WR )\n"
   "	      cCell.ondblclick = function( )\n"
   "	      {\n"
   "		this.isEnter = true;\n"
   "		var cTbl = this.parentNode.parentNode;\n"
   "		var prcCol = cTbl.srcNode.childNodes[this.cCol];\n"
   "		var cval = nodeText(prcCol.childNodes[this.cRow]);\n"
   "\n"
   "		if( prcCol.getAttribute('tp') == 'bool' )\n"
   "		{\n"
   "		  this.innerHTML = \"<input type='checkbox'/>\";\n"
   "		  this.firstChild.checked = parseInt(cval);\n"
   "		  this.firstChild.onclick = function( )\n"
   "		  { this.parentNode.parentNode.parentNode.comSet(this.parentNode.cRow,this.parentNode.cCol,this.checked?'1':'0'); }\n"
   "		}\n"
   "		else if( prcCol.getAttribute('dest') == 'select' )\n"
   "		{\n"
   "		  this.innerHTML = \"<select/>\";\n"
   "		  this.firstChild.onchange = function( )\n"
   "		  {\n"
   "		    if( this.selectedIndex < 0 ) return;\n"
   "		    var selId = this.options[this.selectedIndex].getAttribute('vid');\n"
   "		    var selVal = nodeText(this.options[this.selectedIndex]);\n"
   "		    this.parentNode.parentNode.parentNode.comSet(this.parentNode.cRow,this.parentNode.cCol,selId?selId:selVal);\n"
   "		    return false;\n"
   "		  }\n"
   "		  var valWCfg = ''; var sel_ok = false;\n"
   "		  for( var i_el = 0; i_el < prcCol.val_ls.length; i_el++ )\n"
   "		  {\n"
   "		    valWCfg += \"<option \"+\n"
   "		      (prcCol.ind_ls.length ? (\"vid='\"+strEncode(prcCol.ind_ls[i_el])+\"' \"+((prcCol.ind_ls[i_el]==cval)?\"selected='true'\":\"\"))\n"
   "					    : ((prcCol.val_ls[i_el]==cval)?\"selected='true'\":\"\"))+\">\"+strEncode(prcCol.val_ls[i_el])+\"</option>\";\n"
   "		    if( (prcCol.ind_ls.length && prcCol.ind_ls[i_el] == cval) || (!prcCol.ind_ls.length && prcCol.val_ls[i_el] == cval) )\n"
   "		      sel_ok = true;\n"
   "		  }\n"
   "		  if( !sel_ok ) valWCfg += \"<option selected='true'>\"+strEncode(cval)+\"</option>\";\n"
   "		  this.firstChild.innerHTML = valWCfg;\n"
   "		}\n"
   "		else if( prcCol.getAttribute('tp') == 'time' )\n"
   "		{\n"
   "		  var dt = new Date(parseInt(cval)*1000);\n"
   "		  this.innerHTML = \"<input size='2'/><input size='2'/><input size='4'/>&nbsp;<input size='2'/><input size='2'/><input size='2'/>\";\n"
   "		  this.childNodes[0].onkeyup = this.childNodes[1].onkeyup = this.childNodes[2].onkeyup =\n"
   "		  this.childNodes[4].onkeyup = this.childNodes[5].onkeyup = this.childNodes[6].onkeyup = function(e)\n"
   "		  {\n"
   "		    if( !e ) e = window.event;\n"
   "		    if( this.parentNode.isEdited && e.keyCode == 13 ) { this.parentNode.childNodes[7].onclick(); return true; }\n"
   "		    if( this.parentNode.isEdited && e.keyCode == 27 )\n"
   "		    {\n"
   "		      var val_w = this.parentNode;\n"
   "		      for( var i_ch = 0; i_ch < val_w.childNodes.length; i_ch++ )\n"
   "			if( val_w.childNodes[i_ch].defaultValue )\n"
   "			  val_w.childNodes[i_ch].value = val_w.childNodes[i_ch].defaultValue;\n"
   "		      val_w.removeChild(this.parentNode.childNodes[7]);\n"
   "		      val_w.isEdited = false;\n"
   "		      return true;\n"
   "		    }\n"
   "		    if( this.parentNode.isEdited || this.value == this.defaultValue ) return true;\n"
   "		    var btOk = document.createElement('img'); btOk.src = '/'+MOD_ID+'/img_button_ok';\n"
   "		    btOk.onclick = function( )\n"
   "		    {\n"
   "		      var val_w = this.parentNode;\n"
   "		      var dt = new Date(0);\n"
   "		      dt.setDate(parseInt(val_w.childNodes[0].value)); dt.setMonth(parseInt(val_w.childNodes[1].value)-1); dt.setFullYear(parseInt(val_w.childNodes[2].value));\n"
   "		      dt.setHours(parseInt(val_w.childNodes[4].value)); dt.setMinutes(parseInt(val_w.childNodes[5].value)); dt.setSeconds(parseInt(val_w.childNodes[6].value));\n"
   "		      val_w.parentNode.parentNode.comSet(val_w.cRow,val_w.cCol,Math.floor(dt.getTime()/1000));\n"
   "		      val_w.removeChild(this);\n"
   "		      val_w.isEdited = false;\n"
   "		      return false;\n"
   "		    }\n"
   "		    this.parentNode.appendChild(btOk);\n"
   "		    this.parentNode.isEdited = true;\n"
   "		    return true;\n"
   "		  }\n"
   "		  this.childNodes[0].value = this.childNodes[0].defaultValue = dt.getDate();\n"
   "		  this.childNodes[1].value = this.childNodes[1].defaultValue = dt.getMonth()+1;\n"
   "		  this.childNodes[2].value = this.childNodes[2].defaultValue = dt.getFullYear();\n"
   "		  this.childNodes[4].value = this.childNodes[4].defaultValue = dt.getHours();\n"
   "		  this.childNodes[5].value = this.childNodes[5].defaultValue = dt.getMinutes();\n"
   "		  this.childNodes[6].value = this.childNodes[6].defaultValue = dt.getSeconds();\n"
   "		  this.isEdited = false;\n"
   "		}\n"
   "		else\n"
   "		{\n"
   "		  if( prcCol.getAttribute('tp') == 'hex' ) cval = '0x'+parseInt(cval).toString(16);\n"
   "		  else if( prcCol.getAttribute('tp') == 'oct' ) cval = '0'+parseInt(cval).toString(8);\n"
   "		  this.innerHTML = \"<input/>\";\n"
   "		  var tp = prcCol.getAttribute('tp');\n"
   "		  if( prcCol.getAttribute('dest') == 'sel_ed' )\n"
   "		  {\n"
   "		    this.childNodes[0].size = 20;\n"
   "		    var cmbImg = document.createElement('img'); cmbImg.src = '/'+MOD_ID+'/img_combar';\n"
   "		    cmbImg.onclick = function( )\n"
   "		    {\n"
   "		      if( !this.parentNode.val_ls || !this.parentNode.val_ls.length ) return false;\n"
   "		      var combMenu = getCombo();\n"
   "		      var optHTML = '';\n"
   "		      for( var i_l = 0; i_l < this.parentNode.val_ls.length; i_l++ )\n"
   "			optHTML += '<option>'+this.parentNode.val_ls[i_l]+'</option>';\n"
   "		      var edFld = this.parentNode.childNodes[0];\n"
   "		      combMenu.childNodes[0].edFld = edFld;\n"
   "		      combMenu.childNodes[0].innerHTML = optHTML;\n"
   "		      combMenu.childNodes[0].size = Math.max(3,this.parentNode.val_ls.length);\n"
   "		      combMenu.style.cssText = 'visibility: visible; left: '+posGetX(edFld,true)+'px; '+\n"
   "						'top: '+(posGetY(edFld,true)+edFld.offsetHeight)+'px; '+\n"
   "						'width: '+edFld.offsetWidth+'px';\n"
   "		      combMenu.childNodes[0].focus();\n"
   "		      combMenu.childNodes[0].onclick = function()\n"
   "		      {\n"
   "			this.parentNode.style.cssText = 'visibility: hidden; left: -200px; top: -200px;';\n"
   "			if( this.selectedIndex < 0 ) return;\n"
   "			this.edFld.value = nodeText(this.options[this.selectedIndex]);\n"
   "			this.edFld.parentNode.parentNode.parentNode.comSet(this.edFld.parentNode.cRow,this.edFld.parentNode.cCol,this.edFld.value);\n"
   "			return false;\n"
   "		      }\n"
   "		      return false;\n"
   "		    }\n"
   "		    tblCell.appendChild(cmbImg);\n"
   "		  }\n"
   "		  else if( tp == 'dec' )\n"
   "		  {\n"
   "		    this.className += ' number'; this.childNodes[0].size = 7;\n"
   "		    var spinImg = document.createElement('img'); spinImg.src = '/'+MOD_ID+'/img_spinar';\n"
   "		    spinImg.onclick = function(e)\n"
   "		    {\n"
   "		      if(!e) e = window.event;\n"
   "		      var val_w = this.parentNode.childNodes[0];\n"
   "		      val_w.value = parseInt(val_w.value)+(((e.clientY-posGetY(this))<10)?1:-1);\n"
   "		      val_w.onkeyup();\n"
   "		      return false;\n"
   "		    }\n"
   "		    val_w.appendChild(spinImg);\n"
   "		  }\n"
   "		  else if( tp == 'hex' || tp == 'oct' || tp == 'real' ) { this.className += ' number'; this.childNodes[0].size = 7; }\n"
   "		  else\n"
   "		  {\n"
   "		    this.childNodes[0].size = 30;\n"
   "		    this.childNodes[0].maxLength = prcCol.getAttribute('len');\n"
   "		    if( !this.childNodes[0].maxLength ) this.childNodes[0].maxLength = 1000;\n"
   "		  }\n"
   "		  this.prcCol = prcCol;\n"
   "		  this.childNodes[0].onkeyup = function(e)\n"
   "		  {\n"
   "		    if( !e ) e = window.event;\n"
   "		    if( this.parentNode.isEdited && e.keyCode == 13 ) { this.parentNode.lastChild.onclick(); return true; }\n"
   "		    if( this.parentNode.isEdited && e.keyCode == 27 )\n"
   "		    {\n"
   "		      this.value = this.defaultValue;\n"
   "		      this.parentNode.isEdited = false;\n"
   "		      this.parentNode.removeChild(this.parentNode.lastChild);\n"
   "		      return true;\n"
   "		    }\n"
   "		    if( this.parentNode.isEdited || this.value == this.defaultValue ) return true;\n"
   "		    var btOk = document.createElement('img'); btOk.src = '/'+MOD_ID+'/img_button_ok';\n"
   "		    btOk.onclick = function( )\n"
   "		    {\n"
   "		      var curVal = this.parentNode.childNodes[0].value;\n"
   "		      if( this.parentNode.prcCol.getAttribute('tp') == 'hex' ) curVal = parseInt(curVal,16);\n"
   "		      else if( this.parentNode.prcCol.getAttribute('tp') == 'oct' ) curVal = parseInt(curVal,8);\n"
   "		      this.parentNode.parentNode.parentNode.comSet(this.parentNode.cRow,this.parentNode.cCol,curVal);\n"
   "		      this.parentNode.isEdited = false;\n"
   "		      this.parentNode.removeChild(this);\n"
   "		      return false;\n"
   "		    }\n"
   "		    this.parentNode.appendChild(btOk);\n"
   "		    this.parentNode.isEdited = true;\n"
   "		    return true;\n"
   "		  }\n"
   "		  this.firstChild.value = cval;\n"
   "		  this.isEdited = false;\n"
   "		}\n"
   "	      }\n"
   "	    table.childNodes[i_rw].appendChild(cCell);\n"
   "	  }\n"
   "	  if( table.childNodes[i_rw].childNodes.length ) setNodeText(table.childNodes[i_rw].childNodes[0],i_rw?i_rw:'#');\n"
   "	}\n"
   "	//>>>> Set elements\n"
   "	for( var i_col = 0; i_col < t_s.childNodes.length; i_col++ )\n"
   "	{\n"
   "	  var prcCol = t_s.childNodes[i_col];\n"
   "	  setNodeText(table.childNodes[0].childNodes[i_col+1],prcCol.getAttribute('dscr'));\n"
   "\n"
   "	  //>>>> Load selected list\n"
   "	  if( prcCol.getAttribute('dest') == 'select' || prcCol.getAttribute('dest') == 'sel_ed' )\n"
   "	  {\n"
   "	    prcCol.ind_ls = new Array();\n"
   "	    prcCol.val_ls = new Array();\n"
   "	    if( !prcCol.getAttribute('select') )\n"
   "	    {\n"
   "	      if( prcCol.getAttribute('sel_id') ) prcCol.ind_ls = prcCol.getAttribute('sel_id').split(';');\n"
   "	      prcCol.val_ls = prcCol.getAttribute('sel_list').split(';');\n"
   "	    }\n"
   "	    else\n"
   "	    {\n"
   "	      var x_lst = servGet(prcCol.getAttribute('select').replace(/%/g,'%25').replace(/\\//g,'%2f'),'com=get');\n"
   "	      if(x_lst)\n"
   "	        for(var i_el = 0; i_el < x_lst.childNodes.length; i_el++)\n"
   "	        {\n"
   "	          if(x_lst.childNodes[i_el].nodeName.toLowerCase() != 'el') continue;\n"
   "	          if(x_lst.childNodes[i_el].getAttribute('id')) prcCol.ind_ls.push(x_lst.childNodes[i_el].getAttribute('id'));\n"
   "	          prcCol.val_ls.push(nodeText(x_lst.childNodes[i_el]));\n"
   "	        }\n"
   "	    }\n"
   "	  }\n"
   "\n"
   "	  for( var i_row = 0; i_row < prcCol.childNodes.length; i_row++ )\n"
   "	  {\n"
   "	    var tblCell = table.childNodes[i_row+1].childNodes[i_col+1];\n"
   "	    var cval = nodeText(prcCol.childNodes[i_row]);\n"
   "	    tblCell.isEdited = false; tblCell.cRow = i_row; tblCell.cCol = i_col;\n"
   "	    if( tblCell.isEnter ) while( tblCell.childNodes.length ) tblCell.removeChild(tblCell.lastChild);\n"
   "	    tblCell.isEnter = false;\n"
   "	    if( prcCol.getAttribute('tp') == 'bool' )\n"
   "	    {\n"
   "	      setNodeText(tblCell,parseInt(cval)?'On':'Off');\n"
   "	      tblCell.style.fontWeight = parseInt(cval)?'bold':'normal';\n"
   "	      tblCell.style.textAlign = 'center';\n"
   "	    }\n"
   "	    else if( prcCol.getAttribute('dest') == 'select' )\n"
   "	    {\n"
   "	      setNodeText(tblCell,cval);\n"
   "	      for( var i_el = 0; i_el < prcCol.val_ls.length; i_el++ )\n"
   "		if( (prcCol.ind_ls.length && prcCol.ind_ls[i_el] == cval) || (!prcCol.ind_ls.length && prcCol.val_ls[i_el] == cval) )\n"
   "		  setNodeText(tblCell,prcCol.val_ls[i_el]);\n"
   "	    }\n"
   "	    else if( prcCol.getAttribute('tp') == 'time' )\n"
   "	    {\n"
   "	      var dt = new Date(parseInt(cval)*1000);\n"
   "	      setNodeText(tblCell,dt.getDate()+'.'+(dt.getMonth()+1)+'.'+dt.getFullYear()+' '+dt.getHours()+':'+\n"
   "				  ((dt.getMinutes()<10)?('0'+dt.getMinutes()):dt.getMinutes())+':'+((dt.getSeconds()<10)?('0'+dt.getSeconds()):dt.getSeconds()));\n"
   "	    }\n"
   "	    else\n"
   "	    {\n"
   "	      if( prcCol.getAttribute('tp') == 'hex' ) cval = '0x'+parseInt(cval).toString(16);\n"
   "	      else if( prcCol.getAttribute('tp') == 'oct' ) cval = '0'+parseInt(cval).toString(8);\n"
   "	      setNodeText(tblCell,cval);\n"
   "	    }\n"
   "	  }\n"
   "	}\n"
   "	table.parentNode.style.height = Math.min(300,Math.max(100,table.clientHeight))+'px';\n"
   "      }\n"
   "    }\n"
   "    //>> View standard fields\n"
   "    else if( t_s.nodeName.toLowerCase() == 'fld' ) basicFields(t_s,aPath,cBlk,wr);\n"
   "    else if( t_s.nodeName.toLowerCase() == 'comm' )\n"
   "    {\n"
   "      var brPath = (aPath+t_s.getAttribute('id')).replace(/%/g,'%25').replace(/\\//g,'%2f');\n"
   "      var dBlk = null; var button = null;\n"
   "      if( cBlk )\n"
   "      {\n"
   "	if( t_s.childNodes.length )\n"
   "	{\n"
   "	  dBlk = document.createElement('fieldset');\n"
   "	  dBlk.appendChild(document.createElement('legend'));\n"
   "	  dBlk.childNodes[0].appendChild(document.createTextNode(t_s.getAttribute('dscr')));\n"
   "	}else dBlk = document.createElement('div');\n"
   "	dBlk.className = 'elem';\n"
   "	button = document.createElement('input'); button.type = 'button';\n"
   "	button.srcNode = t_s;\n"
   "	button.brPath = brPath;\n"
   "	button.onclick = function( )\n"
   "	{\n"
   "	  //> Check link\n"
   "	  if( this.srcNode.getAttribute('tp') == 'lnk' )\n"
   "	  {\n"
   "	    var dataReq = servGet(selPath+'/'+this.brPath,'com=get');\n"
   "	    if(!dataReq) return false;\n"
   "	    else if( parseInt(dataReq.getAttribute('rez'))!=0 ) { alert(nodeText(dataReq)); return false; }\n"
   "	    selectPage('/'+pathLev(selPath,0)+nodeText(dataReq));\n"
   "	  }\n"
   "	  else\n"
   "	  {\n"
   "	    var com = '<set>';\n"
   "	    for( var f_com = 0; f_com < this.srcNode.childNodes.length; f_com++ )\n"
   "	      com += \"<\"+this.srcNode.childNodes[f_com].nodeName+\" id='\"+this.srcNode.childNodes[f_com].getAttribute('id')+\"'>\"+\n"
   "			nodeText(this.srcNode.childNodes[f_com])+\"</\"+this.srcNode.childNodes[f_com].nodeName+\">\";\n"
   "	    com += '</set>';\n"
   "	    var rez = servSet(selPath+'/'+this.brPath,'com=com',com,true);\n"
   "	    if( rez && parseInt(rez.getAttribute('rez')) != 0 ) alert(nodeText(rez));\n"
   "	    pageRefresh();\n"
   "	  }\n"
   "	  return false;\n"
   "	}\n"
   "	dBlk.appendChild(button);\n"
   "	cBlk.appendChild(dBlk);\n"
   "	t_s.addr_butt = button;\n"
   "      }\n"
   "      else button = t_s.addr_butt;\n"
   "\n"
   "      //>>> Update or create parameters\n"
   "      for( var f_com = 0; f_com < t_s.childNodes.length; f_com++ )\n"
   "	if( t_s.childNodes[f_com].nodeName.toLowerCase() == 'fld' )\n"
   "	  basicFields(t_s.childNodes[f_com],aPath+t_s.getAttribute('id')+'/',dBlk,true,true);\n"
   "\n"
   "      //>>> Fill command\n"
   "      button.value = t_s.getAttribute('dscr');\n"
   "      button.title = t_s.getAttribute('help');\n"
   "    }\n"
   "  }\n"
   "}\n"
   "/***************************************************\n"
   " * basicFields - Prepare basic fields view         *\n"
   " ***************************************************/\n"
   "function basicFields( t_s, aPath, cBlk, wr, comm )\n"
   "{\n"
   "  var brPath = (aPath+t_s.getAttribute('id')).replace(/%/g,'%25').replace(/\\//g,'%2f');\n"
   "\n"
   "  var dataReq = document.createElement('get');\n"
   "  if(!comm)\n"
   "  {\n"
   "    dataReq = servGet(brPath,'com=get');\n"
   "    if(!dataReq) dataReq = document.createElement('get');\n"
   "    else if(parseInt(dataReq.getAttribute('rez'))!=0) { alert(nodeText(dataReq)); setNodeText(dataReq,''); }\n"
   "  }\n"
   "\n"
   "  //> View select fields\n"
   "  if( t_s.getAttribute('dest') == 'select' )\n"
   "  {\n"
   "    var lab = null; var val_r = null; var val_w = null;\n"
   "    if( cBlk )\n"
   "    {\n"
   "      //>> View info\n"
   "      if( !wr )\n"
   "      {\n"
   "	val_r = document.createElement('span'); val_r.className = 'const';\n"
   "	val_r.StatusTip = selPath+'/'+brPath; val_r.onmouseover = function() { setStatus(this.StatusTip,10000); }\n"
   "      }\n"
   "      //>> View edit\n"
   "      else\n"
   "      {\n"
   "	val_w = document.createElement('span');	val_w.className = 'line';\n"
   "	val_w.appendChild(document.createElement('select'));\n"
   "	val_w.childNodes[0].itPath = selPath+'/'+brPath;\n"
   "	val_w.childNodes[0].srcNode = t_s;\n"
   "	val_w.childNodes[0].itComm = comm;\n"
   "	val_w.childNodes[0].onchange = function( )\n"
   "	{\n"
   "	  if( this.selectedIndex < 0 ) return;\n"
   "	  var selId = this.options[this.selectedIndex].getAttribute('vid');\n"
   "	  var selVal = nodeText(this.options[this.selectedIndex]);\n"
   "	  if( this.itComm ) setNodeText(this.srcNode,(selId?selId:selVal));\n"
   "	  else\n"
   "	  {\n"
   "	    var rez = servSet(this.itPath,'com=com','<set>'+strEncode(selId?selId:selVal)+'</set>',true);\n"
   "	    if( rez && parseInt(rez.getAttribute('rez')) != 0 ) alert(nodeText(rez));\n"
   "	    setTimeout('pageRefresh()',500);\n"
   "	  }\n"
   "	  return false;\n"
   "	}\n"
   "	val_w.StatusTip = selPath+'/'+brPath; val_w.onmouseover = function() { setStatus(this.StatusTip,10000); }\n"
   "      }\n"
   "      //>> Check use label\n"
   "      if( t_s.getAttribute('dscr') )\n"
   "      {\n"
   "	lab = document.createElement('span'); lab.className = 'label';\n"
   "	cBlk.dBlk = document.createElement('div'); cBlk.dBlk.className = 'elem'; cBlk.dBlk.appendChild(lab);\n"
   "	if( val_w ) cBlk.dBlk.appendChild(val_w);\n"
   "	if( val_r ) cBlk.dBlk.appendChild(val_r);\n"
   "	cBlk.appendChild(cBlk.dBlk);\n"
   "      }\n"
   "      else\n"
   "      {\n"
   "	if( val_w ) { if( cBlk.dBlk ) cBlk.dBlk.appendChild(val_w); else { delete val_w; val_w = null; } }\n"
   "	if( val_r ) { if( cBlk.dBlk ) cBlk.dBlk.appendChild(val_r); else { delete val_r; val_r = null; } }\n"
   "      }\n"
   "      t_s.addr_lab = lab; t_s.addr_val_r = val_r; t_s.addr_val_w = val_w;\n"
   "    }\n"
   "    else { lab = t_s.addr_lab; val_r = t_s.addr_val_r; val_w = t_s.addr_val_w; }\n"
   "    //>> Fill combo\n"
   "    if( lab ) setNodeText(lab,t_s.getAttribute('dscr')+':');\n"
   "    if( val_w || val_r )\n"
   "    {\n"
   "      (val_r||val_w).title = t_s.getAttribute('help');\n"
   "      var sel_ok = false, c_el = 0;\n"
   "      if( !t_s.getAttribute('select') )\n"
   "      {\n"
   "	var ind_ls = t_s.getAttribute('sel_id') ? t_s.getAttribute('sel_id').split(';') : new Array();\n"
   "	var val_ls = t_s.getAttribute('sel_list').split(';');\n"
   "	var valWCfg = '';\n"
   "	for( var ls_i = 0; ls_i < val_ls.length; ls_i++ )\n"
   "	{\n"
   "	  if(val_w) valWCfg+=\"<option \"+\n"
   "		(ind_ls.length ? (\"vid='\"+strEncode(ind_ls[ls_i])+\"' \"+((ind_ls[ls_i]==nodeText(dataReq))?\"selected='true'\":\"\"))\n"
   "			       : ((val_ls[ls_i]==nodeText(dataReq))?\"selected='true'\":\"\"))+\">\"+strEncode(val_ls[ls_i])+\"</option>\";\n"
   "	  if( (ind_ls.length && ind_ls[ls_i] == nodeText(dataReq) ) || (!ind_ls.length && val_ls[ls_i] == nodeText(dataReq)) )\n"
   "	  { sel_ok = true; if(val_r) setNodeText(val_r,val_ls[ls_i]); }\n"
   "	}\n"
   "      }\n"
   "      else\n"
   "      {\n"
   "	var x_lst = servGet(t_s.getAttribute('select').replace(/%/g,'%25').replace(/\\//g,'%2f'),'com=get');\n"
   "	if(x_lst)\n"
   "	{\n"
   "	  for(var i_el = 0; i_el < x_lst.childNodes.length; i_el++)\n"
   "	  {\n"
   "	    if( x_lst.childNodes[i_el].nodeName.toLowerCase() != 'el' ) continue;\n"
   "	    var curElId = x_lst.childNodes[i_el].getAttribute('id');\n"
   "	    var curElVl = nodeText(x_lst.childNodes[i_el]);\n"
   "	    if( val_w ) valWCfg+=\"<option \"+\n"
   "		(curElId ? (\"vid='\"+strEncode(curElId)+\"' \"+((curElId==nodeText(dataReq))?\"selected='true'\":\"\"))\n"
   "			 : ((curElVl==nodeText(dataReq))?\"selected='true'\":\"\"))+\">\"+strEncode(curElVl)+\"</option>\";\n"
   "	    if( (curElId && curElId == nodeText(dataReq)) || (!curElId && curElVl == nodeText(dataReq)) )\n"
   "	    { sel_ok = true; if(val_r) setNodeText(val_r,curElVl); }\n"
   "	  }\n"
   "	}\n"
   "      }\n"
   "      ///>>> Insert empty field if none selected\n"
   "      if( !sel_ok )\n"
   "      {\n"
   "	if(val_w) valWCfg+=\"<option selected='true'>\"+nodeText(dataReq)+\"</option>\";\n"
   "	if(val_r) setNodeText(val_r,nodeText(dataReq));\n"
   "      }\n"
   "      if( val_w ) val_w.childNodes[0].innerHTML = valWCfg;\n"
   "    }\n"
   "  }\n"
   "  else\n"
   "  {\n"
   "    //> View Boolean fields\n"
   "    if( t_s.getAttribute('tp') == 'bool' )\n"
   "    {\n"
   "      var lab = null; var val_r = null; var val_w = null;\n"
   "      if( cBlk )\n"
   "      {\n"
   "	//>> View info\n"
   "	if( !wr )\n"
   "	{\n"
   "	  val_r = document.createElement('span'); val_r.className = 'const';\n"
   "	  val_r.StatusTip = selPath+'/'+brPath; val_r.onmouseover = function() { setStatus(this.StatusTip,10000); }\n"
   "	}\n"
   "	//>> View edit\n"
   "	else\n"
   "	{\n"
   "	  val_w = document.createElement('span'); val_w.className = 'line';\n"
   "	  val_w.appendChild(document.createElement('input'));\n"
   "	  val_w.childNodes[0].type = 'checkbox';\n"
   "	  val_w.childNodes[0].itPath = selPath+'/'+brPath;\n"
   "	  val_w.childNodes[0].srcNode = t_s;\n"
   "	  val_w.childNodes[0].itComm = comm;\n"
   "	  val_w.childNodes[0].onclick = function( )\n"
   "	  {\n"
   "	    if( this.itComm ) setNodeText(this.srcNode,(this.checked?'1':'0'));\n"
   "	    else\n"
   "	    {\n"
   "	      var rez = servSet(this.itPath,'com=com','<set>'+(this.checked?'1':'0')+'</set>',true);\n"
   "	      if( rez && parseInt(rez.getAttribute('rez')) != 0 ) alert(nodeText(rez));\n"
   "	      setTimeout('pageRefresh()',500);\n"
   "	    }\n"
   "	    return false;\n"
   "	  }\n"
   "	  val_w.StatusTip = selPath+'/'+brPath; val_w.onmouseover = function() { setStatus(this.StatusTip,10000); }\n"
   "	}\n"
   "	//>> Check use label\n"
   "	if( t_s.getAttribute('dscr') )\n"
   "	{\n"
   "	  lab = document.createElement('span'); lab.className = 'label';\n"
   "	  cBlk.dBlk = document.createElement('div'); cBlk.dBlk.className = 'elem'; cBlk.dBlk.appendChild(lab);\n"
   "	  if( val_w ) cBlk.dBlk.appendChild(val_w);\n"
   "	  if( val_r ) cBlk.dBlk.appendChild(val_r);\n"
   "	  cBlk.appendChild(cBlk.dBlk);\n"
   "	}\n"
   "	else\n"
   "	{\n"
   "	  if( val_w ) { if( cBlk.dBlk ) cBlk.dBlk.appendChild(val_w); else { delete val_w; val_w = null; } }\n"
   "	  if( val_r ) { if( cBlk.dBlk ) cBlk.dBlk.appendChild(val_r); else { delete val_r; val_r = null; } }\n"
   "	}\n"
   "	t_s.addr_lab = lab; t_s.addr_val_r = val_r; t_s.addr_val_w = val_w;\n"
   "      }\n"
   "      else { lab = t_s.addr_lab; val_r = t_s.addr_val_r; val_w = t_s.addr_val_w; }\n"
   "      //>> Fill CheckBox\n"
   "      if( lab ) setNodeText(lab,t_s.getAttribute('dscr')+':');\n"
   "      if( val_w )\n"
   "      {\n"
   "	val_w.title = t_s.getAttribute('help');\n"
   "	val_w.childNodes[0].checked = parseInt(nodeText(dataReq));\n"
   "      }\n"
   "      if( val_r )\n"
   "      {\n"
   "	val_r.title = t_s.getAttribute('help');\n"
   "	setNodeText(val_r,nodeText(dataReq)=='<EVAL>'?'<EVAL>':(parseInt(nodeText(dataReq))?'On':'Off'));\n"
   "      }\n"
   "    }\n"
   "    //> View edit fields\n"
   "    else if( t_s.getAttribute('tp') == 'str' && (t_s.getAttribute('rows') || t_s.getAttribute('cols')) )\n"
   "    {\n"
   "      var lab = null; var edit = null;\n"
   "      if( cBlk )\n"
   "      {\n"
   "	dBlk = document.createElement('div'); dBlk.className = 'elem';\n"
   "	lab = document.createElement('span'); lab.className = 'label';\n"
   "	edit = document.createElement('textarea');\n"
   "	edit.itPath = selPath+'/'+brPath;\n"
   "	edit.srcNode = t_s;\n"
   "	edit.itComm = comm;\n"
   "	edit.readOnly = !wr;\n"
   "	if( t_s.getAttribute('cols') ) edit.setAttribute('cols',parseInt(t_s.getAttribute('cols')));\n"
   "	else edit.setAttribute('wrap','off');\n"
   "	edit.setAttribute('rows',parseInt(t_s.getAttribute('rows')) ? parseInt(t_s.getAttribute('rows')):5);\n"
   "	edit.onkeyup = function()\n"
   "	{\n"
   "	  if( this.itComm ) setNodeText(this.srcNode,this.value);\n"
   "	  else if( !this.isChanged && this.value != this.defaultValue )\n"
   "	  {\n"
   "	    var btBlk = document.createElement('div'); btBlk.style.textAlign = 'right';\n"
   "	    var btApply = document.createElement('input'); btApply.type = 'button'; btApply.value = 'Apply';\n"
   "	    btApply.onclick = function()\n"
   "	    {\n"
   "	      var wEl = this.parentNode.parentNode;\n"
   "	      var rez = servSet(wEl.childNodes[2].itPath,'com=com','<set>'+strEncode(wEl.childNodes[2].value,'html')+'</set>',true);\n"
   "	      if( rez && parseInt(rez.getAttribute('rez')) != 0 ) alert(nodeText(rez));\n"
   "	      setTimeout('pageRefresh()',500);\n"
   "	      wEl.removeChild(this.parentNode);\n"
   "	      wEl.childNodes[2].isChanged = false;\n"
   "	      return false;\n"
   "	    }\n"
   "	    var btCancel = document.createElement('input'); btCancel.type = 'button'; btCancel.value = 'Cancel';\n"
   "	    btCancel.onclick = function()\n"
   "	    {\n"
   "	      var wEl = this.parentNode.parentNode;\n"
   "	      wEl.childNodes[2].value = wEl.childNodes[2].defaultValue;\n"
   "	      wEl.removeChild(this.parentNode);\n"
   "	      wEl.childNodes[2].isChanged = false;\n"
   "	      return false;\n"
   "	    }\n"
   "	    btBlk.appendChild(btApply); btBlk.appendChild(btCancel); this.parentNode.appendChild(btBlk);\n"
   "	    this.isChanged = true;\n"
   "	  }\n"
   "	  else if( this.isChanged && this.value == this.defaultValue && this.parentNode.childNodes[3] )\n"
   "	  { this.parentNode.removeChild(this.parentNode.childNodes[3]); this.isChanged = false; }\n"
   "	  return true;\n"
   "	}\n"
   "	edit.StatusTip = selPath+'/'+brPath;\n"
   "	edit.onmouseover = function() { setStatus(this.StatusTip,10000); }\n"
   "	dBlk.appendChild(lab); dBlk.appendChild(document.createElement('br')); dBlk.appendChild(edit); cBlk.appendChild(dBlk);\n"
   "	t_s.addr_lab = lab; t_s.addr_edit = edit;\n"
   "      }\n"
   "      else { lab = t_s.addr_lab; edit = t_s.addr_edit; }\n"
   "      //>> Fill Edit\n"
   "      if( lab ) setNodeText(lab,t_s.getAttribute('dscr')+':');\n"
   "      if( edit && !edit.isChanged )\n"
   "      {\n"
   "	edit.title = t_s.getAttribute('help');\n"
   "	edit.value = edit.defaultValue = nodeText(dataReq);\n"
   "      }\n"
   "    }\n"
   "    //> View Data-Time fields\n"
   "    else if( t_s.getAttribute('tp') == 'time' )\n"
   "    {\n"
   "      var lab = null; var val_r = null; var val_w = null;\n"
   "      if( cBlk )\n"
   "      {\n"
   "	//>> View info\n"
   "	if( !wr )\n"
   "	{\n"
   "	  val_r = document.createElement('span'); val_r.className = 'const';\n"
   "	  val_r.StatusTip = selPath+'/'+brPath; val_r.onmouseover = function() { setStatus(this.StatusTip,10000); }\n"
   "	}\n"
   "	//>> View edit\n"
   "	else\n"
   "	{\n"
   "	  val_w = document.createElement('span'); val_w.className = 'line number';\n"
   "	  val_w.itPath = selPath+'/'+brPath;\n"
   "	  val_w.srcNode = t_s;\n"
   "	  val_w.itComm = comm;\n"
   "	  val_w.innerHTML = \"<input size='2' style='width: 30px;'/><input size='2' style='width: 30px;'/><input size='4' style='width: 60px;'/>\"+\n"
   "			    \"&nbsp;<input size='2' style='width: 30px;'/><input size='2' style='width: 30px;'/><input size='2' style='width: 30px;'/>\";\n"
   "	  val_w.childNodes[0].onkeyup = val_w.childNodes[1].onkeyup = val_w.childNodes[2].onkeyup =\n"
   "		val_w.childNodes[4].onkeyup = val_w.childNodes[5].onkeyup = val_w.childNodes[6].onkeyup = function(e)\n"
   "	  {\n"
   "	    if( this.parentNode.itComm )\n"
   "	    {\n"
   "	      var val_w = this.parentNode;\n"
   "	      var dt = new Date(0);\n"
   "	      dt.setDate(parseInt(val_w.childNodes[0].value)); dt.setMonth(parseInt(val_w.childNodes[1].value)-1); dt.setFullYear(parseInt(val_w.childNodes[2].value));\n"
   "	      dt.setHours(parseInt(val_w.childNodes[4].value)); dt.setMinutes(parseInt(val_w.childNodes[5].value)); dt.setSeconds(parseInt(val_w.childNodes[6].value));\n"
   "	      setNodeText(val_w.srcNode,Math.floor(dt.getTime()/1000));\n"
   "	      return true;\n"
   "	    }\n"
   "	    if( !e ) e = window.event;\n"
   "	    if( this.parentNode.isEdited && e.keyCode == 13 ) { this.parentNode.childNodes[7].onclick(); return true; }\n"
   "	    if( this.parentNode.isEdited && e.keyCode == 27 )\n"
   "	    {\n"
   "	      var val_w = this.parentNode;\n"
   "	      for( var i_ch = 0; i_ch < val_w.childNodes.length; i_ch++ )\n"
   "	        if( val_w.childNodes[i_ch].defaultValue )\n"
   "	          val_w.childNodes[i_ch].value = val_w.childNodes[i_ch].defaultValue;\n"
   "	      val_w.removeChild(this.parentNode.childNodes[7]);\n"
   "	      val_w.isEdited = false;\n"
   "	      return true;\n"
   "	    }\n"
   "	    if( this.parentNode.isEdited || this.value == this.defaultValue ) return true;\n"
   "	    var btOk = document.createElement('img'); btOk.src = '/'+MOD_ID+'/img_button_ok';\n"
   "	    btOk.onclick = function( )\n"
   "	    {\n"
   "	      var val_w = this.parentNode;\n"
   "	      var dt = new Date(0);\n"
   "	      dt.setDate(parseInt(val_w.childNodes[0].value)); dt.setMonth(parseInt(val_w.childNodes[1].value)-1); dt.setFullYear(parseInt(val_w.childNodes[2].value));\n"
   "	      dt.setHours(parseInt(val_w.childNodes[4].value)); dt.setMinutes(parseInt(val_w.childNodes[5].value)); dt.setSeconds(parseInt(val_w.childNodes[6].value));\n"
   "	      var rez = servSet(val_w.itPath,'com=com','<set>'+Math.floor(dt.getTime()/1000)+'</set>',true);\n"
   "	      if( rez && parseInt(rez.getAttribute('rez')) != 0 ) alert(nodeText(rez));\n"
   "	      setTimeout('pageRefresh()',500);\n"
   "	      val_w.removeChild(this);\n"
   "	      val_w.isEdited = false;\n"
   "	      return false;\n"
   "	    }\n"
   "	    this.parentNode.appendChild(btOk);\n"
   "	    this.parentNode.isEdited = true;\n"
   "	    return true;\n"
   "	  }\n"
   "	  val_w.StatusTip = selPath+'/'+brPath; val_w.onmouseover = function() { setStatus(this.StatusTip,10000); }\n"
   "	}\n"
   "	//>> Check use label\n"
   "	if( t_s.getAttribute('dscr') )\n"
   "	{\n"
   "	  lab = document.createElement('span'); lab.className = 'label';\n"
   "	  cBlk.dBlk = document.createElement('div'); cBlk.dBlk.className = 'elem'; cBlk.dBlk.appendChild(lab);\n"
   "	  if( val_w ) cBlk.dBlk.appendChild(val_w);\n"
   "	  if( val_r ) cBlk.dBlk.appendChild(val_r);\n"
   "	  cBlk.appendChild(cBlk.dBlk);\n"
   "	}\n"
   "	else\n"
   "	{\n"
   "	  if( val_w ) { if( cBlk.dBlk ) cBlk.dBlk.appendChild(val_w); else { delete val_w; val_w = null; } }\n"
   "	  if( val_r ) { if( cBlk.dBlk ) cBlk.dBlk.appendChild(val_r); else { delete val_r; val_r = null; } }\n"
   "	}\n"
   "	t_s.addr_lab = lab; t_s.addr_val_r = val_r; t_s.addr_val_w = val_w;\n"
   "      }\n"
   "      else { lab = t_s.addr_lab; val_r = t_s.addr_val_r; val_w = t_s.addr_val_w; }\n"
   "      //>> Fill data\n"
   "      if( lab ) setNodeText(lab,t_s.getAttribute('dscr')+':');\n"
   "      if( val_w && !val_w.isEdited )\n"
   "      {\n"
   "	val_w.title = t_s.getAttribute('help');\n"
   "	var dt_time_t = parseInt(nodeText(dataReq));\n"
   "	var dt = new Date(dt_time_t?(dt_time_t*1000):0);\n"
   "	val_w.childNodes[0].value = val_w.childNodes[0].defaultValue = dt.getDate();\n"
   "	val_w.childNodes[1].value = val_w.childNodes[1].defaultValue = dt.getMonth()+1;\n"
   "	val_w.childNodes[2].value = val_w.childNodes[2].defaultValue = dt.getFullYear();\n"
   "	val_w.childNodes[4].value = val_w.childNodes[4].defaultValue = dt.getHours();\n"
   "	val_w.childNodes[5].value = val_w.childNodes[5].defaultValue = dt.getMinutes();\n"
   "	val_w.childNodes[6].value = val_w.childNodes[6].defaultValue = dt.getSeconds();\n"
   "      }\n"
   "      if( val_r )\n"
   "      {\n"
   "	val_r.title = t_s.getAttribute('help');\n"
   "	var dt = new Date(parseInt(nodeText(dataReq))*1000);\n"
   "	setNodeText(val_r,dt.getDate()+'.'+(dt.getMonth()+1)+'.'+dt.getFullYear()+' '+dt.getHours()+':'+\n"
   "			  ((dt.getMinutes()<10)?('0'+dt.getMinutes()):dt.getMinutes())+':'+((dt.getSeconds()<10)?('0'+dt.getSeconds()):dt.getSeconds()));\n"
   "      }\n"
   "    }\n"
   "    //> View other string and numberic fields\n"
   "    else\n"
   "    {\n"
   "      var lab = null; var val_r = null; var val_w = null;\n"
   "      if( cBlk )\n"
   "      {\n"
   "	//>> View info\n"
   "	if( !wr )\n"
   "	{\n"
   "	  val_r = document.createElement('span'); val_r.className = 'const';\n"
   "	  val_r.StatusTip = selPath+'/'+brPath; val_r.onmouseover = function() { setStatus(this.StatusTip,10000); }\n"
   "	}\n"
   "	//>> View edit\n"
   "	else\n"
   "	{\n"
   "	  val_w = document.createElement('span'); val_w.className = 'line';\n"
   "	  val_w.itPath = selPath+'/'+brPath;\n"
   "	  val_w.srcNode = t_s;\n"
   "	  val_w.itComm = comm;\n"
   "	  val_w.appendChild(document.createElement('input')); val_w.childNodes[0].type = 'text';\n"
   "	  val_w.StatusTip = selPath+'/'+brPath; val_w.onmouseover = function() { setStatus(this.StatusTip,10000); }\n"
   "\n"
   "	  var tp = t_s.getAttribute('tp');\n"
   "	  if( t_s.getAttribute('dest') == 'sel_ed' )\n"
   "	  {\n"
   "	    val_w.childNodes[0].size = 20;\n"
   "	    var cmbImg = document.createElement('img'); cmbImg.src = '/'+MOD_ID+'/img_combar';\n"
   "	    cmbImg.onclick = function( )\n"
   "	    {\n"
   "	      if( !this.parentNode.sel_list || !this.parentNode.sel_list.length ) return false;\n"
   "	      var combMenu = getCombo();\n"
   "	      var optHTML = '';\n"
   "	      for( var i_l = 0; i_l < this.parentNode.sel_list.length; i_l++ )\n"
   "		optHTML += '<option>'+this.parentNode.sel_list[i_l]+'</option>';\n"
   "	      var edFld = this.parentNode.childNodes[0];\n"
   "	      combMenu.childNodes[0].edFld = edFld;\n"
   "	      combMenu.childNodes[0].innerHTML = optHTML;\n"
   "	      combMenu.childNodes[0].size = Math.max(3,this.parentNode.sel_list.length);\n"
   "	      combMenu.style.cssText = 'visibility: visible; left: '+posGetX(edFld,true)+'px; '+\n"
   "				       'top: '+(posGetY(edFld,true)+edFld.offsetHeight)+'px; '+\n"
   "				       'width: '+edFld.offsetWidth+'px';\n"
   "	      combMenu.childNodes[0].focus();\n"
   "	      combMenu.childNodes[0].onclick = function()\n"
   "	      {\n"
   "		this.parentNode.style.cssText = 'visibility: hidden; left: -200px; top: -200px;';\n"
   "		if( this.selectedIndex < 0 ) return;\n"
   "		this.edFld.value = nodeText(this.options[this.selectedIndex]);\n"
   "		if( this.edFld.parentNode.itComm ) setNodeText(this.edFld.parentNode.srcNode,this.edFld.value);\n"
   "		else\n"
   "		{\n"
   "		  var rez = servSet(this.edFld.parentNode.itPath,'com=com','<set>'+this.edFld.value+'</set>',true);\n"
   "		  if( rez && parseInt(rez.getAttribute('rez')) != 0 ) alert(nodeText(rez));\n"
   "		  setTimeout('pageRefresh()',500);\n"
   "		}\n"
   "		return false;\n"
   "	      }\n"
   "	      return false;\n"
   "	    }\n"
   "	    val_w.appendChild(cmbImg);\n"
   "	  }\n"
   "	  else if( tp == 'dec' )\n"
   "	  {\n"
   "	    val_w.className += ' number';\n"
   "	    val_w.childNodes[0].size = 7;\n"
   "	    var spinImg = document.createElement('img'); spinImg.src = '/'+MOD_ID+'/img_spinar';\n"
   "	    spinImg.onclick = function(e)\n"
   "	    {\n"
   "	      if(!e) e = window.event;\n"
   "	      var val_w = this.parentNode.childNodes[0];\n"
   "	      val_w.value = parseInt(val_w.value)+(((e.clientY-posGetY(this))<10)?1:-1);\n"
   "	      val_w.onkeyup();\n"
   "	      return false;\n"
   "	    }\n"
   "	    val_w.appendChild(spinImg);\n"
   "	  }\n"
   "	  else if( tp == 'hex' || tp == 'oct' || tp == 'real' ) { val_w.className += ' number'; val_w.childNodes[0].size = 10; }\n"
   "	  else\n"
   "	  {\n"
   "	    val_w.childNodes[0].size = 30;\n"
   "	    val_w.childNodes[0].maxLength = t_s.getAttribute('len');\n"
   "	    if( !val_w.childNodes[0].maxLength ) val_w.childNodes[0].maxLength = 1000;\n"
   "	  }\n"
   "\n"
   "	  val_w.childNodes[0].onkeyup = function(e)\n"
   "	  {\n"
   "	    if( this.parentNode.itComm )\n"
   "	    {\n"
   "	      var curVal = this.value;\n"
   "	      if( this.parentNode.srcNode.getAttribute('tp') == 'hex' ) curVal = parseInt(curVal,16);\n"
   "	      else if( this.parentNode.srcNode.getAttribute('tp') == 'oct' ) curVal = parseInt(curVal,8);\n"
   "	      setNodeText(this.parentNode.srcNode,curVal);\n"
   "	      return true;\n"
   "	    }\n"
   "	    if( !e ) e = window.event;\n"
   "	    if( this.parentNode.isEdited && e.keyCode == 13 ) { this.parentNode.lastChild.onclick(); return true; }\n"
   "	    if( this.parentNode.isEdited && e.keyCode == 27 )\n"
   "	    {\n"
   "	      this.value = this.defaultValue;\n"
   "	      this.parentNode.isEdited = false;\n"
   "	      this.parentNode.removeChild(this.parentNode.lastChild);\n"
   "	      return true;\n"
   "	    }\n"
   "	    if( this.parentNode.isEdited || this.value == this.defaultValue ) return true;\n"
   "	    var btOk = document.createElement('img'); btOk.src = '/'+MOD_ID+'/img_button_ok';\n"
   "	    btOk.onclick = function( )\n"
   "	    {\n"
   "	      var curVal = this.parentNode.childNodes[0].value;\n"
   "	      if( this.parentNode.srcNode.getAttribute('tp') == 'hex' ) curVal = parseInt(curVal,16);\n"
   "	      else if( this.parentNode.srcNode.getAttribute('tp') == 'oct' ) curVal = parseInt(curVal,8);\n"
   "	      var rez = servSet(this.parentNode.itPath,'com=com','<set>'+curVal+'</set>',true);\n"
   "	      if( rez && parseInt(rez.getAttribute('rez')) != 0 ) alert(nodeText(rez));\n"
   "	      setTimeout('pageRefresh()',500);\n"
   "	      this.parentNode.isEdited = false;\n"
   "	      this.parentNode.removeChild(this);\n"
   "	      return false;\n"
   "	    }\n"
   "	    this.parentNode.appendChild(btOk);\n"
   "	    this.parentNode.isEdited = true;\n"
   "	    return true;\n"
   "	  }\n"
   "	}\n"
   "	//>> Check use label\n"
   "	if( t_s.getAttribute('dscr') )\n"
   "	{\n"
   "	  lab = document.createElement('span'); lab.className = 'label';\n"
   "	  cBlk.dBlk = document.createElement('div'); cBlk.dBlk.className = 'elem'; cBlk.dBlk.appendChild(lab);\n"
   "	  if( val_w ) cBlk.dBlk.appendChild(val_w);\n"
   "	  if( val_r ) cBlk.dBlk.appendChild(val_r);\n"
   "	  cBlk.appendChild(cBlk.dBlk);\n"
   "	}\n"
   "	else\n"
   "	{\n"
   "	  if( val_w ) { if(cBlk.dBlk) cBlk.dBlk.appendChild(val_w); else { delete val_w; val_w = null; } }\n"
   "	  if( val_r ) { if(cBlk.dBlk) cBlk.dBlk.appendChild(val_r); else { delete val_r; val_r = null; } }\n"
   "	}\n"
   "	t_s.addr_lab = lab; t_s.addr_val_r = val_r; t_s.addr_val_w = val_w;\n"
   "      }\n"
   "      else { lab = t_s.addr_lab; val_r = t_s.addr_val_r; val_w = t_s.addr_val_w; }\n"
   "      //>> Fill line\n"
   "      var sval = nodeText(dataReq);\n"
   "      if( t_s.getAttribute('tp') == 'hex' ) sval = '0x'+parseInt(sval).toString(16);\n"
   "      else if( t_s.getAttribute('tp') == 'oct' ) sval = '0'+parseInt(sval).toString(8);\n"
   "\n"
   "      if( lab ) setNodeText(lab,t_s.getAttribute('dscr')+':');\n"
   "      if( val_r )\n"
   "      {\n"
   "	val_r.title = t_s.getAttribute('help');\n"
   "	setNodeText(val_r,sval);\n"
   "      }\n"
   "      if( val_w && !val_w.isEdited )\n"
   "      {\n"
   "	val_w.title = t_s.getAttribute('help');\n"
   "	val_w.childNodes[0].value = val_w.childNodes[0].defaultValue = sval;\n"
   "	//>> Load combo list\n"
   "	if( t_s.getAttribute('dest') == 'sel_ed' )\n"
   "	{\n"
   "	  if( !t_s.getAttribute('select') ) val_w.sel_list = t_s.getAttribute('sel_list').split(';');\n"
   "	  else\n"
   "	  {\n"
   "	    val_w.sel_list = new Array();\n"
   "	    var x_lst = servGet(t_s.getAttribute('select').replace(/%/g,'%25').replace(/\\//g,'%2f'),'com=get');\n"
   "	    if(x_lst)\n"
   "	      for(var i_el = 0; i_el < x_lst.childNodes.length; i_el++)\n"
   "		if(x_lst.childNodes[i_el].nodeName.toLowerCase() == 'el')\n"
   "		  val_w.sel_list.push(nodeText(x_lst.childNodes[i_el]));\n"
   "	  }\n"
   "	}\n"
   "      }\n"
   "    }\n"
   "  }\n"
   "}\n"
   "/***************************************************\n"
   " * actEnable - Actions enable.                     *\n"
   " ***************************************************/\n"
   "function actEnable( act, vl )\n"
   "{\n"
   "  var actEl = document.getElementById(act);\n"
   "  if( !actEl ) return;\n"
   "  actEl.className = vl?'active':'inactive';\n"
   "  actEl.childNodes[0].src = vl ? actEl.childNodes[0].src.replace('filtr=unact','filtr=none') :\n"
   "				 actEl.childNodes[0].src.replace('filtr=none','filtr=unact');\n"
   "}\n"
   "/***************************************************\n"
   " * chkStruct - Info page tree check structure.     *\n"
   " ***************************************************/\n"
   "function chkStruct( w_nd, n_nd )\n"
   "{\n"
   "  //> Check access\n"
   "  if( w_nd.getAttribute('acs') != n_nd.getAttribute('acs') ) return true;\n"
   "\n"
   "  //> Scan deleted nodes\n"
   "  for( var i_w = 0; i_w < w_nd.childNodes.length; i_w++ )\n"
   "  {\n"
   "    var i_n;\n"
   "    for( i_n = 0; i_n < n_nd.childNodes.length; i_n++ )\n"
   "      if( w_nd.childNodes[i_w].nodeName.toLowerCase() == n_nd.childNodes[i_n].nodeName.toLowerCase() &&\n"
   "	    w_nd.childNodes[i_w].getAttribute('id') == n_nd.childNodes[i_n].getAttribute('id') )\n"
   "	break;\n"
   "    if( i_n >= n_nd.childNodes.length && w_nd.nodeName.toLowerCase() != 'table' && w_nd.nodeName.toLowerCase() != 'list' )\n"
   "	return true;\n"
   "  }\n"
   "\n"
   "  //> Scan for new nodes and check present nodes\n"
   "  for( var i_n = 0; i_n < n_nd.childNodes.length; i_n++ )\n"
   "  {\n"
   "    var i_w;\n"
   "    for( i_w = 0; i_w < w_nd.childNodes.length; i_w++ )\n"
   "      if( w_nd.childNodes[i_w].nodeName.toLowerCase() == n_nd.childNodes[i_n].nodeName.toLowerCase() &&\n"
   "	    w_nd.childNodes[i_w].getAttribute('id') == n_nd.childNodes[i_n].getAttribute('id') )\n"
   "	break;\n"
   "    if( i_w >= w_nd.childNodes.length ) return true;\n"
   "    else if( chkStruct(w_nd.childNodes[i_w],n_nd.childNodes[i_n]) ) return true;\n"
   "\n"
   "    //> Check of the description present\n"
   "    if( (w_nd.childNodes[i_w].getAttribute('dscr') && !n_nd.childNodes[i_n].getAttribute('dscr')) ||\n"
   "	(!w_nd.childNodes[i_w].getAttribute('dscr') && n_nd.childNodes[i_n].getAttribute('dscr')) )\n"
   "      return true;\n"
   "\n"
   "    //> Check base fields destination change\n"
   "    if( w_nd.childNodes[i_w].nodeName.toLowerCase() == 'fld' &&\n"
   "	(w_nd.childNodes[i_w].getAttribute('dest') != n_nd.childNodes[i_n].getAttribute('dest') ||\n"
   "	w_nd.childNodes[i_w].getAttribute('tp') != n_nd.childNodes[i_n].getAttribute('tp')) )\n"
   "      return true;\n"
   "  }\n"
   "\n"
   "  return false;\n"
   "}\n"
   "/***************************************************\n"
   " * tabSelect - Select page tab                     *\n"
   " ***************************************************/\n"
   "function tabSelect( tab )\n"
   "{\n"
   "  if( !tab || tab.className == 'active' ) return;\n"
   "  for( var i_t = 0; i_t < tab.parentNode.childNodes.length; i_t++ )\n"
   "    if( tab.parentNode.childNodes[i_t].className == 'active' )\n"
   "      tab.parentNode.childNodes[i_t].className = '';\n"
   "  tab.className = 'active';\n"
   "\n"
   "  for( var i_cf = 0; i_cf < root.childNodes.length; i_cf++ )\n"
   "    if( root.childNodes[i_cf].nodeName.toLowerCase() == 'area' && nodeText(tab) == root.childNodes[i_cf].getAttribute('dscr') )\n"
   "    { root.childNodes[i_cf].setAttribute('qview','0'); break; }\n"
   "\n"
   "  pageCyclRefrStop();\n"
   "  pageDisplay(selPath);\n"
   "}\n"
   "/***************************************************\n"
   " * hostsUpdate - Init/update tree hosts.           *\n"
   " ***************************************************/\n"
   "function hostsUpdate( )\n"
   "{\n"
   "  var treeRoot = document.getElementById('treeRoot');\n"
   "  //> Make hosts\n"
   "  var hostN = servGet('/','com=chlds');\n"
   "  if( hostN )\n"
   "  {\n"
   "    //> Remove no present hosts\n"
   "    for( var i_top = 0; i_top < treeRoot.childNodes.length; i_top++ )\n"
   "    {\n"
   "      var i_h;\n"
   "      for( i_h = 0; i_h < hostN.childNodes.length; i_h++ )\n"
   "	if( treeRoot.childNodes[i_top].getAttribute('id') == ('/'+hostN.childNodes[i_h].getAttribute('id')) )\n"
   "	  break;\n"
   "      if( i_h >= hostN.childNodes.length ) { treeRoot.removeChild(treeRoot.childNodes[i_top]); i_top--; }\n"
   "    }\n"
   "    //> Add/update hosts\n"
   "    var emptyTree = treeRoot.childNodes.length;\n"
   "    for( var i = 0; i < hostN.childNodes.length; i++ )\n"
   "    {\n"
   "      var liN = null;\n"
   "      if( !emptyTree )\n"
   "        for( var i_top = 0; i_top < treeRoot.childNodes.length; i_top++ )\n"
   "        {\n"
   "	  if( treeRoot.childNodes[i_top].getAttribute('id') == ('/'+hostN.childNodes[i].getAttribute('id')) )\n"
   "	  { liN = treeRoot.childNodes[i_top]; break; }\n"
   "        }\n"
   "      if( !liN ) { liN = document.createElement('li'); treeRoot.appendChild(liN); liN.isExpand = false; }\n"
   "      liN.setAttribute('id','/'+hostN.childNodes[i].getAttribute('id'));\n"
   "      //> Load groups\n"
   "      liN.grps = new Array();\n"
   "      for( var i_grp = 0; i_grp < hostN.childNodes[i].childNodes.length; i_grp++ )\n"
   "	if( hostN.childNodes[i].childNodes[i_grp].nodeName.toLowerCase() == 'grp' )\n"
   "	  liN.grps.push(hostN.childNodes[i].childNodes[i_grp]);\n"
   "      //> Init links\n"
   "      var treeIco = '/'+MOD_ID+'/img_tree'+(liN.isExpand?'Minus':'Plus')+((i!=0)?'Up':'')+((i!=(hostN.childNodes.length-1))?'Down':'');\n"
   "      var liCont = \"<a class='pm' onclick='expand(this.parentNode,!this.parentNode.isExpand); return false;'><img src='\"+treeIco+\"'/></a>\";\n"
   "      if( parseInt(hostN.childNodes[i].getAttribute('icoSize')) )\n"
   "	liCont += \"<span><img src='/\"+MOD_ID+liN.getAttribute('id')+\"?com=ico&size=16'/></span>\";\n"
   " 	//liCont += \"<span><img height='16px' src='/\"+MOD_ID+liN.getAttribute('id')+\"?com=ico'/></span>\"; \n"
   "      liCont += \"<span><a onclick='selectPage(this.parentNode.parentNode.getAttribute(\\\"id\\\")); return false;' \"+\n"
   "	\"onmouseover='setStatus(this.parentNode.parentNode.getAttribute(\\\"id\\\"),10000);' href='#'>\"+nodeText(hostN.childNodes[i])+\"</a></span>\";\n"
   "      liN.innerHTML = liCont;\n"
   "    }\n"
   "    if( hostN.childNodes.length ) return '/'+hostN.childNodes[0].getAttribute('id');\n"
   "  }\n"
   "}\n"
   "/**************************************************\n"
   " * treeUpdate - Update tree expanded elements.    *\n"
   " **************************************************/\n"
   "function treeUpdate( )\n"
   "{\n"
   "  var treeRoot = document.getElementById('treeRoot');\n"
   "  for( var i_t = 0; i_t < treeRoot.childNodes.length; i_t++ )\n"
   "    if( treeRoot.childNodes[i_t].isExpand )\n"
   "      expand(treeRoot.childNodes[i_t],true,true);\n"
   "}\n"
   "/**************************************************\n"
   " * getPopup - Get popup menu.                     *\n"
   " **************************************************/\n"
   "function getPopup( )\n"
   "{\n"
   "  var popUpMenu = document.getElementById('popupmenu');\n"
   "  if( !popUpMenu )\n"
   "  {\n"
   "    popUpMenu = document.createElement('div'); popUpMenu.id = 'popupmenu';\n"
   "    popUpMenu.appendChild(document.createElement('select'));\n"
   "    popUpMenu.childNodes[0].onblur = function() { this.parentNode.style.visibility = 'hidden'; }\n"
   "    document.body.appendChild(popUpMenu);\n"
   "    popUpMenu.style.visibility = 'hidden';\n"
   "  }\n"
   "  return popUpMenu;\n"
   "}\n"
   "/**************************************************\n"
   " * getCombo - Get combo menu.                     *\n"
   " **************************************************/\n"
   "function getCombo( )\n"
   "{\n"
   "  var comboMenu = document.getElementById('combomenu');\n"
   "  if( !comboMenu )\n"
   "  {\n"
   "    comboMenu = document.createElement('div'); comboMenu.id = 'combomenu';\n"
   "    comboMenu.appendChild(document.createElement('select'));\n"
   "    comboMenu.childNodes[0].onblur = function() { this.parentNode.style.visibility = 'hidden'; }\n"
   "    document.body.appendChild(comboMenu);\n"
   "    comboMenu.style.visibility = 'hidden';\n"
   "  }\n"
   "  return comboMenu;\n"
   "}\n"
   "/**************************************************\n"
   " * pageRefresh - Curent page refrash call.        *\n"
   " **************************************************/\n"
   "function pageRefresh( )\n"
   "{\n"
   "  pageDisplay(selPath);\n"
   "  if( pgRefrTmID ) pgRefrTmID = setTimeout('pageRefresh();',5000);\n"
   "}\n"
   "/********************************************************\n"
   " * pageCyclRefrStart - Start current page cyclic refrash.*\n"
   " ********************************************************/\n"
   "function pageCyclRefrStart( )\n"
   "{\n"
   "  if( !pgRefrTmID ) pgRefrTmID = setTimeout('pageRefresh();',5000);\n"
   "  actEnable('actUpdate',false); actEnable('actStart',false); actEnable('actStop',true);\n"
   "}\n"
   "/********************************************************\n"
   " * pageCyclRefrStop - Stop current page cyclic refrash.  *\n"
   " ********************************************************/\n"
   "function pageCyclRefrStop( )\n"
   "{\n"
   "  if( pgRefrTmID ) { clearTimeout(pgRefrTmID); pgRefrTmID = null; }\n"
   "  actEnable('actUpdate',true); actEnable('actStart',true); actEnable('actStop',false);\n"
   "}\n"
   "/**************************************************\n"
   " * itDBLoad - Load current page from DB.           *\n"
   " **************************************************/\n"
   "function itDBLoad( )\n"
   "{\n"
   "  var rez = servSet(selPath+'/%2fobj','com=com','<load/>',true);\n"
   "  if( rez && parseInt(rez.getAttribute('rez')) != 0 ) alert(nodeText(rez));\n"
   "  else setTimeout('pageRefresh()',500);\n"
   "}\n"
   "/**************************************************\n"
   " * itDBSave - Save current page to DB.             *\n"
   " **************************************************/\n"
   "function itDBSave( )\n"
   "{\n"
   "  var rez = servSet(selPath+'/%2fobj','com=com','<save/>',true);\n"
   "  if( rez && parseInt(rez.getAttribute('rez')) != 0 ) alert(nodeText(rez));\n"
   "  else setTimeout('pageRefresh()',500);\n"
   "}\n"
   "/**************************************************\n"
   " * pageUp - Select up page.                       *\n"
   " **************************************************/\n"
   "function pageUp( )\n"
   "{\n"
   "  var i_l = selPath.length-1;\n"
   "  while(true)\n"
   "  {\n"
   "    var i_l = selPath.lastIndexOf('/',i_l);\n"
   "    if( i_l == -1 || i_l == 0 ) return;\n"
   "    if( (selPath.length-i_l) > 1 ) break;\n"
   "    i_l--;\n"
   "  }\n"
   "  selectPage(selPath.substr(0,i_l));\n"
   "}\n"
   "/**************************************************\n"
   " * pagePrev - Get previous page.                  *\n"
   " **************************************************/\n"
   "function pagePrev( )\n"
   "{\n"
   "  if( !ndPrev.length ) return;\n"
   "  ndNext.push(selPath);\n"
   "  pageDisplay(ndPrev.pop());\n"
   "}\n"
   "/**************************************************\n"
   " * pageNext - Get next page.                      *\n"
   " **************************************************/\n"
   "function pageNext( )\n"
   "{\n"
   "  if( !ndNext.length ) return;\n"
   "  ndPrev.push(selPath);\n"
   "  pageDisplay(ndNext.pop());\n"
   "}\n"
   "/**************************************************\n"
   " * itAdd - Add new item action process.           *\n"
   " **************************************************/\n"
   "function itAdd( )\n"
   "{\n"
   "  if( !selPath.length ) return;\n"
   "  var branchS = null;\n"
   "  for( var i_ch = 0; i_ch < root.childNodes.length; i_ch++ )\n"
   "    if( root.childNodes[i_ch].nodeName.toLowerCase() == 'branches' && root.childNodes[i_ch].getAttribute('id') == 'br' )\n"
   "      branchS =  root.childNodes[i_ch];\n"
   "  if( !branchS ) return;\n"
   "\n"
   "  //> Load branches list\n"
   "  var typeCfg = '';\n"
   "  for( var i_b = 0; i_b < branchS.childNodes.length; i_b++ )\n"
   "    if( parseInt(branchS.childNodes[i_b].getAttribute('acs'))&SEC_WR )\n"
   "      typeCfg+=\"<option idSz='\"+branchS.childNodes[i_b].getAttribute('idSz')+\n"
   "		     \"' gid='\"+branchS.childNodes[i_b].getAttribute('id')+\n"
   "		     \"' idm='\"+(parseInt(branchS.childNodes[i_b].getAttribute('idm'))?\"1\":\"0\")+\"'>\"+\n"
   "		branchS.childNodes[i_b].getAttribute('dscr')+\"</option>\";\n"
   "  if( !typeCfg.length ) { alert('###No one editable container present.###'); return; }\n"
   "\n"
   "  dlgWin = ReqIdNameDlg(document.getElementById('actAddIt').childNodes[0].src,(\"###Add item to node '%1'.###\").replace('%1',selPath));\n"
   "  setNodeText(dlgWin.document.getElementById('wDlgHeader'),'###Add node###');\n"
   "  dlgWin.document.getElementById('wDlgType').style.display = '';\n"
   "  dlgWin.document.getElementById('wDlgType').childNodes[1].childNodes[0].innerHTML = typeCfg;\n"
   "  dlgWin.document.getElementById('wDlgType').childNodes[1].childNodes[0].onchange = function( )\n"
   "  {\n"
   "    if( this.selectedIndex < 0 ) return;\n"
   "    var fIdVal = dlgWin.document.getElementById('wDlgId').childNodes[1].childNodes[0];\n"
   "    fIdVal.maxLength = this.options[this.selectedIndex].getAttribute('idSz');\n"
   "    if( !fIdVal.maxLength ) fIdVal.maxLength = 1000;\n"
   "    dlgWin.document.getElementById('wDlgName').style.display = parseInt(this.options[this.selectedIndex].getAttribute('idm'))?'':'none';\n"
   "  }\n"
   "  dlgWin.document.getElementById('wDlgType').childNodes[1].childNodes[0].onchange();\n"
   "  dlgWin.document.getElementById('wDlgActOk').onclick = function()\n"
   "  {\n"
   "    var tpSel = dlgWin.document.getElementById('wDlgType').childNodes[1].childNodes[0];\n"
   "    if( !tpSel || tpSel.selectedIndex < 0 ) { document.body.dlgWin.close(); return false; }\n"
   "    var idm = parseInt(tpSel.options[tpSel.selectedIndex].getAttribute('idm'));\n"
   "    var gbrId = tpSel.options[tpSel.selectedIndex].getAttribute('gid');\n"
   "    var inpId = dlgWin.document.getElementById('wDlgId').childNodes[1].childNodes[0].value;\n"
   "    var inpName = idm ? dlgWin.document.getElementById('wDlgName').childNodes[1].childNodes[0].value : inpId;\n"
   "\n"
   "    //> Check for already present node\n"
   "    var req = servSet(selPath+'/%2fbr%2f'+gbrId,'com=com','<get/>',true);\n"
   "    if( !req || parseInt(req.getAttribute('rez')) != 0 ) { if(req) alert(nodeText(req)); document.body.dlgWin.close(); return false; }\n"
   "    for( var i_lel = 0; i_lel < req.childNodes.length; i_lel++ )\n"
   "      if( (req.childNodes[i_lel].getAttribute('id') && req.childNodes[i_lel].getAttribute('id') == inpId) ||\n"
   "	(!req.childNodes[i_lel].getAttribute('id') && nodeText(req.childNodes[i_lel]) == inpId) )\n"
   "      { alert((\"###Item '%1' already present.###\").replace('%1',inpId)); document.body.dlgWin.close(); return; }\n"
   "\n"
   "    //> Send command\n"
   "    var rez = servSet(selPath+'/%2fbr%2f'+gbrId,'com=com',\"<add \"+(idm?(\"id='\"+inpId+\"'\"):\"\")+\">\"+inpName+\"</add>\",true);\n"
   "    if( !rez || parseInt(rez.getAttribute('rez')) != 0 ) { if(rez) alert(nodeText(rez)); document.body.dlgWin.close(); return false; }\n"
   "    document.body.dlgWin.close();\n"
   "    treeUpdate(); pageRefresh();\n"
   "    return false;\n"
   "  }\n"
   "}\n"
   "/**************************************************\n"
   " * itDel - Delete new item action process.        *\n"
   " **************************************************/\n"
   "function itDel( iit )\n"
   "{\n"
   "  var rmit = iit ? iit : selPath;\n"
   "  if( !rmit || !rmit.length ) return;\n"
   "\n"
   "  if( !iit && !confirm((\"###You sure for delete node '%1'?###\").replace('%1',rmit)) ) return;\n"
   "\n"
   "  var t_el, sel_own = '', sel_el;\n"
   "  var n_obj = 0;\n"
   "  for( pathLev.off = 0; (t_el=pathLev(rmit,0,true)).length; n_obj++ )\n"
   "  { if( n_obj ) sel_own += ('/'+sel_el); sel_el = t_el; }\n"
   "  if( n_obj > 2 )\n"
   "  {\n"
   "    var req = servGet(sel_own+'/%2fbr','com=info');\n"
   "    if( parseInt(req.getAttribute('rez'))!=0 ) { alert(nodeText(req)); return; }\n"
   "    if( !req.childNodes[0] ) return;\n"
   "\n"
   "    var branch = req.childNodes[0];\n"
   "    for( var i_b = 0; i_b < branch.childNodes.length; i_b++ )\n"
   "    {\n"
   "      var b_id = branch.childNodes[i_b].getAttribute('id');\n"
   "      if( b_id == sel_el.substr(0,b_id.length) && parseInt(branch.childNodes[i_b].getAttribute('acs'))&SEC_WR )\n"
   "      {\n"
   "	var idm = parseInt(branch.childNodes[i_b].getAttribute('idm'));\n"
   "	var com = idm ? (\"<del id='\"+sel_el.substr(b_id.length)+\"'/>\") :\n"
   "	                (\"<del>\"+sel_el.substr(b_id.length)+\"</del>\");\n"
   "	var rez = servSet(sel_own+'/%2fbr%2f'+b_id,'com=com',com,true);\n"
   "	if( rez && parseInt(rez.getAttribute('rez')) != 0 ) alert(nodeText(rez));\n"
   "	else { treeUpdate(); if(!iit) { selPath = sel_own; pageDisplay(selPath); } }\n"
   "	break;\n"
   "      }\n"
   "    }\n"
   "  }\n"
   "}\n"
   "/**************************************************\n"
   " * itCut - Cut selected item.                     *\n"
   " **************************************************/\n"
   "function itCut( )\n"
   "{\n"
   "  copyBuf = '1'+selPath;\n"
   "  editToolUpdate();\n"
   "}\n"
   "/**************************************************\n"
   " * itCopy - Copy selected item.                   *\n"
   " **************************************************/\n"
   "function itCopy( )\n"
   "{\n"
   "  copyBuf = '0'+selPath;\n"
   "  editToolUpdate();\n"
   "}\n"
   "/**************************************************\n"
   " * itPaste - Paste copy or cut item.              *\n"
   " **************************************************/\n"
   "function itPaste( )\n"
   "{\n"
   "  var typeCfg = '';\n"
   "  var itCnt = 0, defIt = 0;\n"
   "  var s_el, s_elp = '', t_el, b_grp = '';\n"
   "  var branchS = null;\n"
   "\n"
   "  //> Src elements calc\n"
   "  var n_sel = 0;\n"
   "  for( pathLev.off = 0; (t_el=pathLev(copyBuf.substr(1),0,true)).length; n_sel++ )\n"
   "  { if(n_sel) s_elp += ('/'+s_el); s_el = t_el; }\n"
   "\n"
   "  if( pathLev(copyBuf.substr(1),0) != pathLev(selPath,0) ) { alert('###Copy is impossible.###'); return; }\n"
   "\n"
   "  if( parseInt(root.getAttribute('acs'))&SEC_WR ) { typeCfg+=\"<option idSz='-1' gid=''>###Selected###</option>\"; itCnt++; }\n"
   "  for( var i_ch = 0; i_ch < root.childNodes.length; i_ch++ )\n"
   "    if( root.childNodes[i_ch].nodeName.toLowerCase() == 'branches' && root.childNodes[i_ch].getAttribute('id') == 'br' )\n"
   "      branchS =  root.childNodes[i_ch];\n"
   "  if( branchS )\n"
   "    for( var i_b = 0; i_b < branchS.childNodes.length; i_b++, itCnt++ )\n"
   "      if( parseInt(branchS.childNodes[i_b].getAttribute('acs'))&SEC_WR )\n"
   "      {\n"
   "	var gbrId = branchS.childNodes[i_b].getAttribute('id');\n"
   "	typeCfg+=\"<option idSz='\"+branchS.childNodes[i_b].getAttribute('idSz')+\"' gid='\"+gbrId+\"'>\"+branchS.childNodes[i_b].getAttribute('dscr')+\"</option>\";\n"
   "	if( s_el.substr(0,gbrId.length) == gbrId ) { defIt = itCnt; b_grp = gbrId; }\n"
   "      }\n"
   "\n"
   "  //> Make request dialog\n"
   "  dlgWin = ReqIdNameDlg('/'+MOD_ID+'/img_it_add');\n"
   "  setNodeText(dlgWin.document.getElementById('wDlgHeader'),'###Move or copy node###');\n"
   "  if( copyBuf.charAt(0) == '1' )\n"
   "    setNodeText(dlgWin.document.getElementById('wDlgTitle').childNodes[1],(\"###Move node '%1' to '%2'.###\").replace('%1',copyBuf.substr(1)).replace('%2',selPath));\n"
   "  else setNodeText(dlgWin.document.getElementById('wDlgTitle').childNodes[1],(\"###Copy node '%1' to '%2'.###\").replace('%1',copyBuf.substr(1)).replace('%2',selPath));\n"
   "  if( b_grp.length ) dlgWin.document.getElementById('wDlgId').childNodes[1].childNodes[0].value = s_el.substr(b_grp.length);\n"
   "  dlgWin.document.getElementById('wDlgName').style.display = 'none';\n"
   "  dlgWin.document.getElementById('wDlgType').style.display = '';\n"
   "  dlgWin.document.getElementById('wDlgType').childNodes[1].childNodes[0].innerHTML = typeCfg;\n"
   "  dlgWin.document.getElementById('wDlgType').childNodes[1].childNodes[0].onchange = function( )\n"
   "  {\n"
   "    if( this.selectedIndex < 0 ) return;\n"
   "    var idSz = parseInt(this.options[this.selectedIndex].getAttribute('idSz'));\n"
   "    if( idSz < 0 ) dlgWin.document.getElementById('wDlgId').style.display = 'none';\n"
   "    else\n"
   "    {\n"
   "      dlgWin.document.getElementById('wDlgId').style.display = '';\n"
   "      var fIdVal = dlgWin.document.getElementById('wDlgId').childNodes[1].childNodes[0];\n"
   "      fIdVal.maxLength = idSz; if( !fIdVal.maxLength ) fIdVal.maxLength = 1000;\n"
   "    }\n"
   "  }\n"
   "  dlgWin.document.getElementById('wDlgType').childNodes[1].childNodes[0].selectedIndex = defIt;\n"
   "  dlgWin.document.getElementById('wDlgType').childNodes[1].childNodes[0].onchange();\n"
   "  dlgWin.document.getElementById('wDlgActOk').onclick = function()\n"
   "  {\n"
   "    var tpSel = dlgWin.document.getElementById('wDlgType').childNodes[1].childNodes[0];\n"
   "    if( !tpSel || tpSel.selectedIndex < 0 ) { document.body.dlgWin.close(); return false; }\n"
   "    var idSz = parseInt(tpSel.options[tpSel.selectedIndex].getAttribute('idSz'));\n"
   "    var gbrId = tpSel.options[tpSel.selectedIndex].getAttribute('gid');\n"
   "    var inpId = dlgWin.document.getElementById('wDlgId').childNodes[1].childNodes[0].value;\n"
   "\n"
   "    var statNm, srcNm;\n"
   "    pathLev.off = 1; statNm = pathLev(copyBuf,0,true); srcNm = copyBuf.substr(pathLev.off);\n"
   "    pathLev.off = 0; statNm = pathLev(selPath,0,true); dstNm = selPath.substr(pathLev.off);\n"
   "\n"
   "    if( idSz >= 0 )\n"
   "    {\n"
   "      dstNm+='/'+gbrId+inpId;\n"
   "      //> Check for already present node\n"
   "      var req = servSet(selPath+'/%2fbr%2f'+gbrId,'com=com','<get/>',true);\n"
   "      if( !req || parseInt(req.getAttribute('rez')) != 0 ) { if(req) alert(nodeText(req)); document.body.dlgWin.close(); return false; }\n"
   "      for( var i_lel = 0; i_lel < req.childNodes.length; i_lel++ )\n"
   "	if( (req.childNodes[i_lel].getAttribute('id') && req.childNodes[i_lel].getAttribute('id') == inpId) ||\n"
   "	    (!req.childNodes[i_lel].getAttribute('id') && nodeText(req.childNodes[i_lel]) == inpId) )\n"
   "	{\n"
   "	  if( confirm((\"###Node '%1' already present. Continue?###\").replace('%1',dstNm)) ) break;\n"
   "	  document.body.dlgWin.close(); return;\n"
   "	}\n"
   "    }\n"
   "    //> Copy visual item\n"
   "    var rez = servSet('/'+statNm+'/%2fobj','com=com',\"<copy src='\"+srcNm+\"' dst='\"+dstNm+\"'/>\",true);\n"
   "    if( !rez || parseInt(rez.getAttribute('rez')) != 0 ) { if(rez) alert(nodeText(rez)); document.dlgWin.close(); return false; }\n"
   "\n"
   "    //> Remove source widget\n"
   "    if( copyBuf.charAt(0) == '1' ) { itDel(copyBuf.substr(1)); copyBuf = '0'; }\n"
   "    treeUpdate( ); pageRefresh( );\n"
   "    document.body.dlgWin.close(); return false;\n"
   "  }\n"
   "}\n"
   "/**********************************************************\n"
   " * ReqIdNameDlg - Get identifier and name request dialog. *\n"
   " **********************************************************/\n"
   "function ReqIdNameDlg( ico, mess, actPath, nmFile )\n"
   "{\n"
   "    var dlgWin = document.body.dlgWin;\n"
   "    if(!dlgWin)\n"
   "    {\n"
   "	dlgWin = document.createElement('table');\n"
   "	document.body.dlgWin = dlgWin;\n"
   "	dlgWin.close = function( ) { document.body.removeChild(this); this.isLoad = null; }\n"
   "	dlgWin.setAttribute('cellpadding','2');\n"
   "	dlgWin.setAttribute('cellspacing','0');\n"
   "	dlgWin.setAttribute('border','0');\n"
   "	dlgWin.setAttribute('style','position: absolute; font-size: 12px; z-index: 9999; background-color: #8FA9FF; border: 1px solid darkblue; '+\n"
   "	    'left: '+((window.innerWidth-400-5)/2)+'px; top: '+((this.window.innerHeight-200-18)/2)+'px; ');\n"
   "    }\n"
   "    if(dlgWin.isLoad) document.body.removeChild(this);\n"
   "\n"
   "    dlgWin.innerHTML =\n"
   "	\"<tr style='cursor: move;' onmousedown='this.clX = event.clientX; this.clY = event.clientY; return false;' \\n\"+\n"
   "	\"   onmouseup='this.clX = this.clY = null; return false;' \\n\"+\n"
   "	\"   onmouseout='this.clX = this.clY = null; return false;' \\n\"+\n"
   "	\"   onmousemove='if(this.clX != null) { \"+\n"
   "	\"     document.body.dlgWin.style.left = (parseInt(document.body.dlgWin.style.left)+event.clientX-this.clX)+\\\"px\\\"; \"+\n"
   "	\"     document.body.dlgWin.style.top  = (parseInt(document.body.dlgWin.style.top)+event.clientY-this.clY)+\\\"px\\\"; \"+\n"
   "	\"     this.clX = event.clientX; this.clY = event.clientY; }'>\"+\n"
   "	\" <td id='wDlgHeader' style='padding-left: 5px; max-width: \"+(400-10)+\"px; width: \"+(400-10)+\"px; overflow: hidden; white-space: nowrap;'>###Node id and/or name select###</td>\\n\"+\n"
   "	\" <td style='color: red; cursor: pointer; text-align: right;' onclick='document.body.dlgWin.close();'>X</td>\\n\"+\n"
   "	\"</tr>\\n\"+\n"
   "	\"<tr><td style='max-width: 400px;' colspan='2' align='center'>\\n\"+\n"
   "	\" <center>\\n\"+\n"
   "	\"  <form id='wDlgFormBlk' action='\"+actPath+\"' method='post' enctype='multipart/form-data'>\\n\"+\n"
   "	\"   <table border='0' cellspacing='3px' class='dlg'>\\n\"+\n"
   "	\"    <tr><td id='wDlgTitle' colspan='2'><img src='' style='height: 32px; float: left;'/><span/></td></tr>\\n\"+\n"
   "	\"    <tr id='wDlgType'><td>###Element type:###</td><td><select name='type'/></td></tr>\\n\"+\n"
   "	\"    <tr id='wDlgId'><td>###ID:###</td><td><input name='id'/></td></tr>\\n\"+\n"
   "	\"    <tr id='wDlgName'><td>###Name:###</td><td><input name='name' type='\"+(nmFile?'file':'text')+\"'/></td></tr>\\n\"+\n"
   "	\"    <tr><td colspan='2' style='text-align: right; border-top: 1px solid black; padding-top: 10px;'>\\n\"+\n"
   "	\"      <input id='wDlgActOk' name='actOk' type='button' value='###Ok###'/> <input id='wDlgActCancel' name='actCancel' type='button' value='###Close###' onclick='document.body.dlgWin.close(); return false;'/>\\n\"+\n"
   "	\"    </td></tr>\\n\"+\n"
   "	\"   </table>\\n\"+\n"
   "	\"  </form>\\n\"+\n"
   "	\" </center>\\n\"+\n"
   "	\"</td></tr>\";\n"
   "    document.body.appendChild(dlgWin);\n"
   "    dlgWin.isLoad = true;\n"
   "\n"
   "    if(ico) document.getElementById('wDlgTitle').childNodes[0].src = ico;\n"
   "    if(mess) setNodeText(document.getElementById('wDlgTitle').childNodes[1],mess);\n"
   "\n"
   "    return window;\n"
   "}\n"
   "\n"
   "//> First start data init\n"
   "//>> Tool bar init\n"
   "//>>> Update actions\n"
   "var actUpdate = document.getElementById('actUpdate');\n"
   "if( actUpdate ) actUpdate.onclick = function() { if( this.className=='active' ) { treeUpdate(); pageRefresh(); } return false; }\n"
   "var actStart = document.getElementById('actStart');\n"
   "if( actStart ) actStart.onclick = function() { if( this.className=='active' ) pageCyclRefrStart(); return false; }\n"
   "var actStop = document.getElementById('actStop');\n"
   "if( actStop ) actStop.onclick = function() { if( this.className=='active' ) pageCyclRefrStop(); return false; }\n"
   "//>>> DB actions\n"
   "var actLoad = document.getElementById('actLoad');\n"
   "if( actLoad ) actLoad.onclick = function() { if( this.className=='active' ) itDBLoad(); return false; }\n"
   "var actSave = document.getElementById('actSave');\n"
   "if( actSave ) actSave.onclick = function() { if( this.className=='active' ) itDBSave(); return false; }\n"
   "//>>> Navigate actions\n"
   "var actUp = document.getElementById('actUp');\n"
   "if( actUp ) actUp.onclick = function() { if( this.className=='active' ) pageUp(); return false; }\n"
   "var actPrevious = document.getElementById('actPrevious');\n"
   "if( actPrevious ) actPrevious.onclick = function() { if( this.className=='active' ) pagePrev(); return false; }\n"
   "var actNext = document.getElementById('actNext');\n"
   "if( actNext ) actNext.onclick = function() { if( this.className=='active' ) pageNext(); return false; }\n"
   "//>>> Create/delete actions\n"
   "var actAddIt = document.getElementById('actAddIt');\n"
   "if( actAddIt ) actAddIt.onclick = function() { if( this.className=='active' ) itAdd(); return false; }\n"
   "var actDelIt = document.getElementById('actDelIt');\n"
   "if( actDelIt ) actDelIt.onclick = function() { if( this.className=='active' ) itDel(); return false; }\n"
   "//>>> Copy actions\n"
   "var actCopy = document.getElementById('actCopy');\n"
   "if( actCopy ) actCopy.onclick = function() { if( this.className=='active' ) itCopy(); return false; }\n"
   "var actCut = document.getElementById('actCut');\n"
   "if( actCut ) actCut.onclick = function() { if( this.className=='active' ) itCut(); return false; }\n"
   "var actPaste = document.getElementById('actPaste');\n"
   "if( actPaste ) actPaste.onclick = function() { if( this.className=='active' ) itPaste(); return false; }\n"
   "\n"
   "pageDisplay(hostsUpdate());\n"
   "\n"
   "setStatus('###Page loaded.###',5000);\n";
