#############################################################
#
# libgd (Portable Network Graphic library)
#
#############################################################
GD_VERSION = 2.0.35
GD_SITE = http://www.chipsnbytes.net/downloads
GD_SOURCE = gd-$(GD_VERSION).tar.gz
GD_DIR = $(BUILD_DIR)/gd-$(GD_VERSION)
GD_BINARY = libgd.so
GD_TARGET_DIR = usr/lib
GD_TARGET_BINARY = $(GD_TARGET_DIR)/$(GD_BINARY)
GD_TARGET_CFLAGS = $(TARGET_CFLAGS) -D_GNU_SOURCE

$(DL_DIR)/$(GD_SOURCE):
	$(WGET) -P $(DL_DIR) $(GD_SITE)/$(GD_SOURCE)

$(GD_DIR)/.source: $(DL_DIR)/$(GD_SOURCE)
	$(ZCAT) $(DL_DIR)/$(GD_SOURCE) | tar -C $(BUILD_DIR) $(TAR_OPTIONS) -
	@echo STAGING_DIR = $(STAGING_DIR)
	toolchain/patch-kernel.sh $(GD_DIR) package/libgd/ libgd-\*.patch
	$(CONFIG_UPDATE) $(GD_DIR)
	touch $@

$(GD_DIR)/.configured: $(GD_DIR)/.source
	(cd $(GD_DIR); rm -rf config.cach; \
		$(TARGET_CONFIGURE_OPTS) \
		CFLAGS="$(GD_TARGET_CFLAGS)" \
		CPPFLAGS="-I$(STAGING_DIR)/usr/include" \
		LDFLAGS="-L$(STAGING_DIR)/usr/lib" \
		LIBPNG12_CONFIG="$(STAGING_DIR)/usr/bin/libpng12-config" \
		sys_lib_dlsearch_path_spec="$(STAGING_DIR)/lib $(STAGING_DIR)/usr/lib" \
		sys_lib_search_path_spec="$(STAGING_DIR)/lib $(STAGING_DIR)/usr/lib" \
		$(TARGET_CONFIGURE_ARGS) \
		./configure \
		--target=$(GNU_TARGET_NAME) \
		--host=$(GNU_TARGET_NAME) \
		--build=$(GNU_HOST_NAME) \
		--disable-rpath \
		--prefix=$(STAGING_DIR) \
		--exec-prefix=$(STAGING_DIR)/usr \
		--with-png=$(STAGING_DIR)/usr \
		--without-x \
	)
	touch $@

$(GD_DIR)/$(GD_BINARY): $(GD_DIR)/.configured
	$(MAKE) CC=$(TARGET_CC) -C $(GD_DIR)

$(STAGING_DIR)/$(GD_TARGET_BINARY): $(GD_DIR)/$(GD_BINARY)
	$(MAKE) prefix=$(STAGING_DIR)/usr -C $(GD_DIR) install

$(TARGET_DIR)/$(GD_TARGET_BINARY): $(STAGING_DIR)/$(GD_TARGET_BINARY)
	cp -dpf $(STAGING_DIR)/$(GD_TARGET_BINARY)* $(TARGET_DIR)/$(GD_TARGET_DIR)/
	-$(STRIPCMD) $(STRIP_STRIP_UNNEEDED) $(TARGET_DIR)/$(GD_TARGET_BINARY)

libgd: uclibc libpng $(TARGET_DIR)/$(GD_TARGET_BINARY)

libgd-source: $(DL_DIR)/$(GD_SOURCE)

libgd-clean:
	$(MAKE) prefix=$(TARGET_DIR)/usr -C $(GD_DIR) uninstall
	$(MAKE) -C $(GD_DIR) clean

libgd-dirclean:
	rm -rf $(GD_DIR)

#############################################################
#
# Toplevel Makefile options
#
#############################################################
ifeq ($(strip $(BR2_PACKAGE_LIBGD)),y)
TARGETS+=libgd
endif
