# Qwt

QWT_VERSION = 5.1.2
QWT_SOURCE = qwt-$(QWT_VERSION).tar.bz2
QWT_SITE = http://downloads.sourceforge.net/project/qwt/qwt/$(QWT_VERSION)

QWT_LIBTOOL_PATCH = NO

QWT_INSTALL_STAGING = YES
QWT_INSTALL_STAGING_OPT = INSTALL_ROOT=$(STAGING_DIR) install
QWT_UNINSTALL_STAGING_OPT = INSTALL_ROOT=$(STAGING_DIR) uninstall

# Install to target by QWT_HOOK_POST_INSTALL
QWT_INSTALL_TARGET = NO

# Install Qwt libs, docs and headers here with INSTALL_ROOT prefix
QWT_INSTALL_DIR = /usr
QWT_INSTALL_EXAMPLES_DIR = /home/qwt-examples

QWT_DEPENDENCIES = qt

$(eval $(call AUTOTARGETS,package,qwt))


$(QWT_HOOK_POST_EXTRACT):
	$(SED) "s:INSTALLBASE.*=.*:INSTALLBASE = $(QWT_INSTALL_DIR):" $(QWT_DIR)/qwtconfig.pri
ifeq ($(BR2_PACKAGE_QT_SVG),y)
	$(SED) "s:.*CONFIG.*QwtSVGItem.*:CONFIG += QwtSVGItem:" $(QWT_DIR)/qwtconfig.pri
endif
	(cd $(QWT_DIR) && \
		PATH=$(TARGET_PATH) qmake && \
		touch configure && \
		chmod a+x configure \
	)
	touch $@

$(QWT_HOOK_POST_INSTALL):
	cp -dpf $(STAGING_DIR)/$(QWT_INSTALL_DIR)/lib/libqwt* $(TARGET_DIR)/$(QWT_INSTALL_DIR)/lib
#ifneq ($(BR2_ENABLE_DEBUG),y)
#	-$(TARGET_STRIP) --strip-unneeded $(TARGET_DIR)/$(QWT_INSTALL_DIR)/lib/libqwt*
#endif
ifeq ($(BR2_PACKAGE_QWT_EXAMPLES),y)
	$(call MESSAGE,"Building Qwt examples")
ifneq ($(BR2_PACKAGE_QT_SVG),y)
	$(SED) 's/.*bode.*/\\/' $(QWT_DIR)/examples/examples.pro
endif
	(cd $(QWT_DIR)/examples && \
		PATH=$(TARGET_PATH) qmake && \
		PATH=$(TARGET_PATH) $(MAKE) \
	)
	$(call MESSAGE,"Installing Qwt examples")
	cp -rf $(QWT_DIR)/examples/bin $(TARGET_DIR)/$(QWT_INSTALL_EXAMPLES_DIR)
#ifneq ($(BR2_ENABLE_DEBUG),y)
#	-$(TARGET_STRIP) --strip-unneeded $(TARGET_DIR)/$(QWT_INSTALL_EXAMPLES_DIR)
#endif
endif
	touch $@

