# must correspond to existing profile/*/ for image parts
#EVERYTHING=contrib install2 main live rescue kernel-pae
EVERYTHING=install2 main live rescue plc #kernel-pae
COMPONENTS=$(EVERYTHING) ltsp addon #live-lite

# All existing stages
STAGES = $(EVERYTHING) ltsp addon

# Autogenerated config.
# Holds neccessary parameters and directions to build the image.
AUTOCFG = profiles/autocfg.mk

# Set standard name for autogenerated stage configs
STAGECFG=stage-autocfg.mk

# This directory holds empty files marking finished targets
DONEDIR = finished.targets

# Search for finished targets here
VPATH = $(DONEDIR)

# Function "scfg" - "stage config"
# returns autogenerated stage config name
scfg = profiles/$(1)/$(STAGECFG)

# Function to signal that target has been successfully run already
# usage: $(call done,target_name)
done = $(and $(1),$(done_body))
define done_body
@echo "Mark target $(1) as done:";
mkdir -p $(DONEDIR);
touch $(DONEDIR)/$(1)
endef

# Function to set a parameter to its value in file
# usage: $(call set,name,value,file)
set = $(and $(1),$(2),$(3),$(set_body))
define set_body
@echo "Set $(1) to $(2) in file $(3):";
test -f "$(3)" && sed -i '/^[[:space:]]*$(1)[[:space:]]*=/d' -- "$(3)";
printf '%s\n' "$(1) = $(2)" >> "$(3)"
endef

$(AUTOCFG):
	@echo "Creating new toplevel configuration file $@..."
	@echo -e "\
	####################################################\n\
	# This file is autogenerated by toplevel Makefile. #\n\
	# Don't edit it manually, might get overwritten.   #\n\
	####################################################\n" > $@

# components to include
$(COMPONENTS): | $(AUTOCFG)
	echo SUBDIRS+=$@ >> $(AUTOCFG)
	$(call done,$@)
